/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.renderer.xy.XYBarPainter;
import ai.org.jfree.chart.renderer.xy.XYBarRenderer;
import ai.org.jfree.ui.RectangleEdge;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;

public class GradientXYBarPainter
implements XYBarPainter,
Serializable {
    private double g1;
    private double g2;
    private double g3;

    public GradientXYBarPainter() {
        this(0.1, 0.2, 0.8);
    }

    public GradientXYBarPainter(double d, double d2, double d3) {
        this.g1 = d;
        this.g2 = d2;
        this.g3 = d3;
    }

    public void paintBar(Graphics2D graphics2D, XYBarRenderer xYBarRenderer, int n, int n2, RectangularShape rectangularShape, RectangleEdge rectangleEdge) {
        Paint paint;
        Object object;
        Color color;
        Color color2;
        Paint paint2 = xYBarRenderer.getItemPaint(n, n2);
        if (paint2 instanceof Color) {
            color2 = (Color)paint2;
            color = color2.brighter();
        } else if (paint2 instanceof GradientPaint) {
            object = (Rectangle2D[])paint2;
            color2 = object.getColor1();
            color = object.getColor2();
        } else {
            color2 = Color.blue;
            color = Color.blue.brighter();
        }
        if (color2.getAlpha() == 0) {
            return;
        }
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            object = this.splitVerticalBar(rectangularShape, this.g1, this.g2, this.g3);
            paint = new GradientPaint((float)object[0].getMinX(), 0.0f, color2, (float)object[0].getMaxX(), 0.0f, Color.white);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[0]);
            paint = new GradientPaint((float)object[1].getMinX(), 0.0f, Color.white, (float)object[1].getMaxX(), 0.0f, color2);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[1]);
            paint = new GradientPaint((float)object[2].getMinX(), 0.0f, color2, (float)object[2].getMaxX(), 0.0f, color);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[2]);
            paint = new GradientPaint((float)object[3].getMinX(), 0.0f, color, (float)object[3].getMaxX(), 0.0f, color2);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[3]);
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            object = this.splitHorizontalBar(rectangularShape, this.g1, this.g2, this.g3);
            paint = new GradientPaint(0.0f, (float)object[0].getMinY(), color2, 0.0f, (float)object[0].getMaxX(), Color.white);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[0]);
            paint = new GradientPaint(0.0f, (float)object[1].getMinY(), Color.white, 0.0f, (float)object[1].getMaxY(), color2);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[1]);
            paint = new GradientPaint(0.0f, (float)object[2].getMinY(), color2, 0.0f, (float)object[2].getMaxY(), color);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[2]);
            paint = new GradientPaint(0.0f, (float)object[3].getMinY(), color, 0.0f, (float)object[3].getMaxY(), color2);
            graphics2D.setPaint(paint);
            graphics2D.fill(object[3]);
        }
        if (xYBarRenderer.isDrawBarOutline()) {
            object = xYBarRenderer.getItemOutlineStroke(n, n2);
            paint = xYBarRenderer.getItemOutlinePaint(n, n2);
            if (object != null && paint != null) {
                graphics2D.setStroke((Stroke)object);
                graphics2D.setPaint(paint);
                graphics2D.draw(rectangularShape);
            }
        }
    }

    public void paintBarShadow(Graphics2D graphics2D, XYBarRenderer xYBarRenderer, int n, int n2, RectangularShape rectangularShape, RectangleEdge rectangleEdge, boolean bl) {
        Object object;
        Paint paint = xYBarRenderer.getItemPaint(n, n2);
        if (paint instanceof Color && ((Color)(object = (Color)paint)).getAlpha() == 0) {
            return;
        }
        object = this.createShadow(rectangularShape, xYBarRenderer.getShadowXOffset(), xYBarRenderer.getShadowYOffset(), rectangleEdge, bl);
        graphics2D.setPaint(Color.gray);
        graphics2D.fill((Shape)object);
    }

    private Rectangle2D createShadow(RectangularShape rectangularShape, double d, double d2, RectangleEdge rectangleEdge, boolean bl) {
        double d3 = rectangularShape.getMinX();
        double d4 = rectangularShape.getMaxX();
        double d5 = rectangularShape.getMinY();
        double d6 = rectangularShape.getMaxY();
        if (rectangleEdge == RectangleEdge.TOP) {
            d3 += d;
            d4 += d;
            if (!bl) {
                d5 += d2;
            }
            d6 += d2;
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            d3 += d;
            d4 += d;
            d5 += d2;
            if (!bl) {
                d6 += d2;
            }
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            if (!bl) {
                d3 += d;
            }
            d4 += d;
            d5 += d2;
            d6 += d2;
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            d3 += d;
            if (!bl) {
                d4 += d;
            }
            d5 += d2;
            d6 += d2;
        }
        return new Rectangle2D.Double(d3, d5, d4 - d3, d6 - d5);
    }

    private Rectangle2D[] splitVerticalBar(RectangularShape rectangularShape, double d, double d2, double d3) {
        Rectangle2D[] rectangle2DArray = new Rectangle2D[4];
        double d4 = rectangularShape.getMinX();
        double d5 = Math.rint(d4 + rectangularShape.getWidth() * d);
        double d6 = Math.rint(d4 + rectangularShape.getWidth() * d2);
        double d7 = Math.rint(d4 + rectangularShape.getWidth() * d3);
        rectangle2DArray[0] = new Rectangle2D.Double(rectangularShape.getMinX(), rectangularShape.getMinY(), d5 - d4, rectangularShape.getHeight());
        rectangle2DArray[1] = new Rectangle2D.Double(d5, rectangularShape.getMinY(), d6 - d5, rectangularShape.getHeight());
        rectangle2DArray[2] = new Rectangle2D.Double(d6, rectangularShape.getMinY(), d7 - d6, rectangularShape.getHeight());
        rectangle2DArray[3] = new Rectangle2D.Double(d7, rectangularShape.getMinY(), rectangularShape.getMaxX() - d7, rectangularShape.getHeight());
        return rectangle2DArray;
    }

    private Rectangle2D[] splitHorizontalBar(RectangularShape rectangularShape, double d, double d2, double d3) {
        Rectangle2D[] rectangle2DArray = new Rectangle2D[4];
        double d4 = rectangularShape.getMinY();
        double d5 = Math.rint(d4 + rectangularShape.getHeight() * d);
        double d6 = Math.rint(d4 + rectangularShape.getHeight() * d2);
        double d7 = Math.rint(d4 + rectangularShape.getHeight() * d3);
        rectangle2DArray[0] = new Rectangle2D.Double(rectangularShape.getMinX(), rectangularShape.getMinY(), rectangularShape.getWidth(), d5 - d4);
        rectangle2DArray[1] = new Rectangle2D.Double(rectangularShape.getMinX(), d5, rectangularShape.getWidth(), d6 - d5);
        rectangle2DArray[2] = new Rectangle2D.Double(rectangularShape.getMinX(), d6, rectangularShape.getWidth(), d7 - d6);
        rectangle2DArray[3] = new Rectangle2D.Double(rectangularShape.getMinX(), d7, rectangularShape.getWidth(), rectangularShape.getMaxY() - d7);
        return rectangle2DArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GradientXYBarPainter)) {
            return false;
        }
        GradientXYBarPainter gradientXYBarPainter = (GradientXYBarPainter)object;
        if (this.g1 != gradientXYBarPainter.g1) {
            return false;
        }
        if (this.g2 != gradientXYBarPainter.g2) {
            return false;
        }
        return this.g3 == gradientXYBarPainter.g3;
    }

    public int hashCode() {
        int n = 37;
        n = HashUtilities.hashCode(n, this.g1);
        n = HashUtilities.hashCode(n, this.g2);
        n = HashUtilities.hashCode(n, this.g3);
        return n;
    }
}

