/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.axis.CyclicNumberAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.labels.XYToolTipGenerator;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.chart.urls.XYURLGenerator;
import ai.org.jfree.data.DomainOrder;
import ai.org.jfree.data.general.DatasetChangeListener;
import ai.org.jfree.data.general.DatasetGroup;
import ai.org.jfree.data.xy.XYDataset;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class CyclicXYItemRenderer
extends StandardXYItemRenderer
implements Serializable {
    private static final long serialVersionUID = 4035912243303764892L;

    public CyclicXYItemRenderer() {
    }

    public CyclicXYItemRenderer(int n) {
        super(n);
    }

    public CyclicXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator) {
        super(n, xYToolTipGenerator);
    }

    public CyclicXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(n, xYToolTipGenerator, xYURLGenerator);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        double[] dArray;
        Object object;
        if (!this.getPlotLines() || !(valueAxis instanceof CyclicNumberAxis) && !(valueAxis2 instanceof CyclicNumberAxis) || n2 <= 0) {
            super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairState, n3);
            return;
        }
        double d = xYDataset.getXValue(n, n2 - 1);
        double d2 = xYDataset.getYValue(n, n2 - 1);
        if (Double.isNaN(d2)) {
            super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairState, n3);
            return;
        }
        Object object2 = new double[2];
        double[] dArray2 = new double[2];
        object2[0] = d;
        dArray2[0] = d2;
        d = xYDataset.getXValue(n, n2);
        d2 = xYDataset.getYValue(n, n2);
        if (Double.isNaN(d2)) {
            return;
        }
        object2[1] = d;
        dArray2[1] = d2;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        boolean bl = false;
        boolean bl2 = false;
        CyclicNumberAxis cyclicNumberAxis = null;
        CyclicNumberAxis cyclicNumberAxis2 = null;
        if (valueAxis instanceof CyclicNumberAxis) {
            cyclicNumberAxis = (CyclicNumberAxis)valueAxis;
            d3 = cyclicNumberAxis.getCycleBound();
            bl = cyclicNumberAxis.isBoundMappedToLastCycle();
            if (object2[0] != object2[1] && (d3 >= object2[0] && d3 <= object2[1] || d3 >= object2[1] && d3 <= object2[0])) {
                object = new double[3];
                dArray = new double[3];
                object[0] = object2[0];
                object[2] = object2[1];
                dArray[0] = dArray2[0];
                dArray[2] = dArray2[1];
                object[1] = d3;
                dArray[1] = (dArray2[1] - dArray2[0]) * (d3 - object2[0]) / (object2[1] - object2[0]) + dArray2[0];
                object2 = object;
                dArray2 = dArray;
            }
        }
        if (valueAxis2 instanceof CyclicNumberAxis) {
            cyclicNumberAxis2 = (CyclicNumberAxis)valueAxis2;
            d4 = cyclicNumberAxis2.getCycleBound();
            bl2 = cyclicNumberAxis2.isBoundMappedToLastCycle();
            if (dArray2[0] != dArray2[1] && (d4 >= dArray2[0] && d4 <= dArray2[1] || d4 >= dArray2[1] && d4 <= dArray2[0])) {
                object = new double[((double[])object2).length + 1];
                dArray = new double[dArray2.length + 1];
                object[0] = object2[0];
                object[2] = object2[1];
                dArray[0] = dArray2[0];
                dArray[2] = dArray2[1];
                dArray[1] = d4;
                object[1] = (object2[1] - object2[0]) * (d4 - dArray2[0]) / (dArray2[1] - dArray2[0]) + object2[0];
                if (((double[])object2).length == 3) {
                    object[3] = object2[2];
                    dArray[3] = dArray2[2];
                }
                object2 = object;
                dArray2 = dArray;
            } else if (((double[])object2).length == 3 && dArray2[1] != dArray2[2] && (d4 >= dArray2[1] && d4 <= dArray2[2] || d4 >= dArray2[2] && d4 <= dArray2[1])) {
                object = new double[4];
                dArray = new double[4];
                object[0] = object2[0];
                object[1] = object2[1];
                object[3] = object2[2];
                dArray[0] = dArray2[0];
                dArray[1] = dArray2[1];
                dArray[3] = dArray2[2];
                dArray[2] = d4;
                object[2] = (object2[2] - object2[1]) * (d4 - dArray2[1]) / (dArray2[2] - dArray2[1]) + object2[1];
                object2 = object;
                dArray2 = dArray;
            }
        }
        if (((double[])object2).length == 2) {
            super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairState, n3);
            return;
        }
        object = new OverwriteDataSet((double[])object2, dArray2, xYDataset);
        if (cyclicNumberAxis != null) {
            if (d3 == object2[0]) {
                cyclicNumberAxis.setBoundMappedToLastCycle(object2[1] <= d3);
            }
            if (d3 == object2[1]) {
                cyclicNumberAxis.setBoundMappedToLastCycle(object2[0] <= d3);
            }
        }
        if (cyclicNumberAxis2 != null) {
            if (d4 == dArray2[0]) {
                cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[1] <= d4);
            }
            if (d4 == dArray2[1]) {
                cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[0] <= d4);
            }
        }
        super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, (XYDataset)object, n, 1, crosshairState, n3);
        if (cyclicNumberAxis != null) {
            if (d3 == object2[1]) {
                cyclicNumberAxis.setBoundMappedToLastCycle(object2[2] <= d3);
            }
            if (d3 == object2[2]) {
                cyclicNumberAxis.setBoundMappedToLastCycle(object2[1] <= d3);
            }
        }
        if (cyclicNumberAxis2 != null) {
            if (d4 == dArray2[1]) {
                cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[2] <= d4);
            }
            if (d4 == dArray2[2]) {
                cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[1] <= d4);
            }
        }
        super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, (XYDataset)object, n, 2, crosshairState, n3);
        if (((double[])object2).length == 4) {
            if (cyclicNumberAxis != null) {
                if (d3 == object2[2]) {
                    cyclicNumberAxis.setBoundMappedToLastCycle(object2[3] <= d3);
                }
                if (d3 == object2[3]) {
                    cyclicNumberAxis.setBoundMappedToLastCycle(object2[2] <= d3);
                }
            }
            if (cyclicNumberAxis2 != null) {
                if (d4 == dArray2[2]) {
                    cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[3] <= d4);
                }
                if (d4 == dArray2[3]) {
                    cyclicNumberAxis2.setBoundMappedToLastCycle(dArray2[2] <= d4);
                }
            }
            super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, (XYDataset)object, n, 3, crosshairState, n3);
        }
        if (cyclicNumberAxis != null) {
            cyclicNumberAxis.setBoundMappedToLastCycle(bl);
        }
        if (cyclicNumberAxis2 != null) {
            cyclicNumberAxis2.setBoundMappedToLastCycle(bl2);
        }
    }

    protected static class OverwriteDataSet
    implements XYDataset {
        protected XYDataset delegateSet;
        Double[] x;
        Double[] y;

        public OverwriteDataSet(double[] dArray, double[] dArray2, XYDataset xYDataset) {
            this.delegateSet = xYDataset;
            this.x = new Double[dArray.length];
            this.y = new Double[dArray2.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.x[i] = new Double(dArray[i]);
                this.y[i] = new Double(dArray2[i]);
            }
        }

        public DomainOrder getDomainOrder() {
            return DomainOrder.NONE;
        }

        public int getItemCount(int n) {
            return this.x.length;
        }

        public Number getX(int n, int n2) {
            return this.x[n2];
        }

        public double getXValue(int n, int n2) {
            double d = Double.NaN;
            Number number = this.getX(n, n2);
            if (number != null) {
                d = number.doubleValue();
            }
            return d;
        }

        public Number getY(int n, int n2) {
            return this.y[n2];
        }

        public double getYValue(int n, int n2) {
            double d = Double.NaN;
            Number number = this.getY(n, n2);
            if (number != null) {
                d = number.doubleValue();
            }
            return d;
        }

        public int getSeriesCount() {
            return this.delegateSet.getSeriesCount();
        }

        public Comparable getSeriesKey(int n) {
            return this.delegateSet.getSeriesKey(n);
        }

        public int indexOf(Comparable comparable) {
            return this.delegateSet.indexOf(comparable);
        }

        public void addChangeListener(DatasetChangeListener datasetChangeListener) {
        }

        public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
        }

        public DatasetGroup getGroup() {
            return this.delegateSet.getGroup();
        }

        public void setGroup(DatasetGroup datasetGroup) {
        }
    }
}

