/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.XYItemLabelGenerator;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.XYBarRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class ClusteredXYBarRenderer
extends XYBarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 5864462149177133147L;
    private boolean centerBarAtStartValue;

    public ClusteredXYBarRenderer() {
        this(0.0, false);
    }

    public ClusteredXYBarRenderer(double d, boolean bl) {
        super(d);
        this.centerBarAtStartValue = bl;
    }

    public int getPassCount() {
        return 2;
    }

    public Range findDomainBounds(XYDataset xYDataset) {
        if (xYDataset == null) {
            return null;
        }
        if (this.centerBarAtStartValue) {
            return this.findDomainBoundsWithOffset((IntervalXYDataset)xYDataset);
        }
        return super.findDomainBounds(xYDataset);
    }

    protected Range findDomainBoundsWithOffset(IntervalXYDataset intervalXYDataset) {
        if (intervalXYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = intervalXYDataset.getSeriesCount();
        for (int i = 0; i < n; ++i) {
            int n2 = intervalXYDataset.getItemCount(i);
            for (int j = 0; j < n2; ++j) {
                double d3 = intervalXYDataset.getStartXValue(i, j);
                double d4 = intervalXYDataset.getEndXValue(i, j);
                double d5 = (d4 - d3) / 2.0;
                d = Math.min(d, d3 -= d5);
                d2 = Math.max(d2, d4 -= d5);
            }
        }
        if (d > d2) {
            return null;
        }
        return new Range(d, d2);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        if (this.getUseYInterval()) {
            d6 = intervalXYDataset.getStartYValue(n, n2);
            d5 = intervalXYDataset.getEndYValue(n, n2);
        } else {
            d6 = this.getBase();
            d5 = intervalXYDataset.getYValue(n, n2);
        }
        if (Double.isNaN(d6) || Double.isNaN(d5)) {
            return;
        }
        double d7 = valueAxis2.valueToJava2D(d6, rectangle2D, xYPlot.getRangeAxisEdge());
        double d8 = valueAxis2.valueToJava2D(d5, rectangle2D, xYPlot.getRangeAxisEdge());
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        double d9 = intervalXYDataset.getStartXValue(n, n2);
        double d10 = valueAxis.valueToJava2D(d9, rectangle2D, rectangleEdge);
        double d11 = intervalXYDataset.getEndXValue(n, n2);
        double d12 = valueAxis.valueToJava2D(d11, rectangle2D, rectangleEdge);
        double d13 = d12 - d10;
        double d14 = d10;
        if (this.centerBarAtStartValue) {
            d14 -= d13 / 2.0;
        }
        if ((d4 = this.getMargin()) > 0.0) {
            d3 = d13 * this.getMargin();
            d13 -= d3;
            d14 += d3 / 2.0;
        }
        d3 = Math.abs(d7 - d8);
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        int n4 = xYDataset.getSeriesCount();
        double d15 = d13 / (double)n4;
        Rectangle2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d2 = d14 + d15 * (double)n;
            d = d2 + d15;
            double d16 = Math.min(d7, d8);
            double d17 = d3;
            double d18 = Math.min(d2, d);
            double d19 = Math.abs(d - d2);
            double_ = new Rectangle2D.Double(d16, d18, d17, d19);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d2 = d14 + d15 * (double)n;
            d = d2 + d15;
            double d20 = Math.min(d2, d);
            double d21 = Math.abs(d - d2);
            double d22 = Math.min(d7, d8);
            double d23 = d3;
            double_ = new Rectangle2D.Double(d20, d22, d21, d23);
        }
        boolean bl = d5 > 0.0;
        boolean bl2 = valueAxis2.isInverted();
        RectangleEdge rectangleEdge2 = plotOrientation == PlotOrientation.HORIZONTAL ? (bl && bl2 || !bl && !bl2 ? RectangleEdge.RIGHT : RectangleEdge.LEFT) : (bl && !bl2 || !bl && bl2 ? RectangleEdge.BOTTOM : RectangleEdge.TOP);
        if (n3 == 0 && this.getShadowsVisible()) {
            this.getBarPainter().paintBarShadow(graphics2D, this, n, n2, double_, rectangleEdge2, !this.getUseYInterval());
        }
        if (n3 == 1) {
            Object object;
            this.getBarPainter().paintBar(graphics2D, this, n, n2, double_, rectangleEdge2);
            if (this.isItemLabelVisible(n, n2)) {
                object = this.getItemLabelGenerator(n, n2);
                this.drawItemLabel(graphics2D, xYDataset, n, n2, xYPlot, (XYItemLabelGenerator)object, double_, d5 < 0.0);
            }
            if (plotRenderingInfo != null && (object = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
                this.addEntity((EntityCollection)object, double_, xYDataset, n, n2, double_.getCenterX(), double_.getCenterY());
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ClusteredXYBarRenderer)) {
            return false;
        }
        ClusteredXYBarRenderer clusteredXYBarRenderer = (ClusteredXYBarRenderer)object;
        if (this.centerBarAtStartValue != clusteredXYBarRenderer.centerBarAtStartValue) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

