/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.LegendItemCollection;
import ai.org.jfree.chart.annotations.XYAnnotation;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.entity.XYItemEntity;
import ai.org.jfree.chart.event.AnnotationChangeEvent;
import ai.org.jfree.chart.event.AnnotationChangeListener;
import ai.org.jfree.chart.labels.ItemLabelPosition;
import ai.org.jfree.chart.labels.StandardXYSeriesLabelGenerator;
import ai.org.jfree.chart.labels.XYItemLabelGenerator;
import ai.org.jfree.chart.labels.XYSeriesLabelGenerator;
import ai.org.jfree.chart.labels.XYToolTipGenerator;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.DrawingSupplier;
import ai.org.jfree.chart.plot.IntervalMarker;
import ai.org.jfree.chart.plot.Marker;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.ValueMarker;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.AbstractRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.chart.urls.XYURLGenerator;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.Layer;
import ai.org.jfree.ui.LengthAdjustmentType;
import ai.org.jfree.ui.RectangleAnchor;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.util.ObjectList;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractXYItemRenderer
extends AbstractRenderer
implements XYItemRenderer,
AnnotationChangeListener,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8019124836026607990L;
    private XYPlot plot;
    private ObjectList itemLabelGeneratorList = new ObjectList();
    private XYItemLabelGenerator baseItemLabelGenerator;
    private ObjectList toolTipGeneratorList = new ObjectList();
    private XYToolTipGenerator baseToolTipGenerator;
    private XYURLGenerator urlGenerator = null;
    private List backgroundAnnotations = new ArrayList();
    private List foregroundAnnotations = new ArrayList();
    private XYSeriesLabelGenerator legendItemLabelGenerator = new StandardXYSeriesLabelGenerator("{0}");
    private XYSeriesLabelGenerator legendItemToolTipGenerator;
    private XYSeriesLabelGenerator legendItemURLGenerator;
    private XYItemLabelGenerator itemLabelGenerator = null;
    private XYToolTipGenerator toolTipGenerator = null;

    protected AbstractXYItemRenderer() {
    }

    public int getPassCount() {
        return 1;
    }

    public XYPlot getPlot() {
        return this.plot;
    }

    public void setPlot(XYPlot xYPlot) {
        this.plot = xYPlot;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYItemRendererState xYItemRendererState = new XYItemRendererState(plotRenderingInfo);
        return xYItemRendererState;
    }

    public XYItemLabelGenerator getItemLabelGenerator(int n, int n2) {
        if (this.itemLabelGenerator != null) {
            return this.itemLabelGenerator;
        }
        XYItemLabelGenerator xYItemLabelGenerator = (XYItemLabelGenerator)this.itemLabelGeneratorList.get(n);
        if (xYItemLabelGenerator == null) {
            xYItemLabelGenerator = this.baseItemLabelGenerator;
        }
        return xYItemLabelGenerator;
    }

    public XYItemLabelGenerator getSeriesItemLabelGenerator(int n) {
        return (XYItemLabelGenerator)this.itemLabelGeneratorList.get(n);
    }

    public void setSeriesItemLabelGenerator(int n, XYItemLabelGenerator xYItemLabelGenerator) {
        this.itemLabelGeneratorList.set(n, xYItemLabelGenerator);
        this.fireChangeEvent();
    }

    public XYItemLabelGenerator getBaseItemLabelGenerator() {
        return this.baseItemLabelGenerator;
    }

    public void setBaseItemLabelGenerator(XYItemLabelGenerator xYItemLabelGenerator) {
        this.baseItemLabelGenerator = xYItemLabelGenerator;
        this.fireChangeEvent();
    }

    public XYToolTipGenerator getToolTipGenerator(int n, int n2) {
        if (this.toolTipGenerator != null) {
            return this.toolTipGenerator;
        }
        XYToolTipGenerator xYToolTipGenerator = (XYToolTipGenerator)this.toolTipGeneratorList.get(n);
        if (xYToolTipGenerator == null) {
            xYToolTipGenerator = this.baseToolTipGenerator;
        }
        return xYToolTipGenerator;
    }

    public XYToolTipGenerator getSeriesToolTipGenerator(int n) {
        return (XYToolTipGenerator)this.toolTipGeneratorList.get(n);
    }

    public void setSeriesToolTipGenerator(int n, XYToolTipGenerator xYToolTipGenerator) {
        this.toolTipGeneratorList.set(n, xYToolTipGenerator);
        this.fireChangeEvent();
    }

    public XYToolTipGenerator getBaseToolTipGenerator() {
        return this.baseToolTipGenerator;
    }

    public void setBaseToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        this.baseToolTipGenerator = xYToolTipGenerator;
        this.fireChangeEvent();
    }

    public XYURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(XYURLGenerator xYURLGenerator) {
        this.urlGenerator = xYURLGenerator;
        this.fireChangeEvent();
    }

    public void addAnnotation(XYAnnotation xYAnnotation) {
        this.addAnnotation(xYAnnotation, Layer.FOREGROUND);
    }

    public void addAnnotation(XYAnnotation xYAnnotation, Layer layer) {
        if (xYAnnotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        if (layer.equals(Layer.FOREGROUND)) {
            this.foregroundAnnotations.add(xYAnnotation);
            xYAnnotation.addChangeListener(this);
            this.fireChangeEvent();
        } else if (layer.equals(Layer.BACKGROUND)) {
            this.backgroundAnnotations.add(xYAnnotation);
            xYAnnotation.addChangeListener(this);
            this.fireChangeEvent();
        } else {
            throw new RuntimeException("Unknown layer.");
        }
    }

    public boolean removeAnnotation(XYAnnotation xYAnnotation) {
        boolean bl = this.foregroundAnnotations.remove(xYAnnotation);
        xYAnnotation.removeChangeListener(this);
        this.fireChangeEvent();
        return bl &= this.backgroundAnnotations.remove(xYAnnotation);
    }

    public void removeAnnotations() {
        XYAnnotation xYAnnotation;
        int n;
        for (n = 0; n < this.foregroundAnnotations.size(); ++n) {
            xYAnnotation = (XYAnnotation)this.foregroundAnnotations.get(n);
            xYAnnotation.removeChangeListener(this);
        }
        for (n = 0; n < this.backgroundAnnotations.size(); ++n) {
            xYAnnotation = (XYAnnotation)this.backgroundAnnotations.get(n);
            xYAnnotation.removeChangeListener(this);
        }
        this.foregroundAnnotations.clear();
        this.backgroundAnnotations.clear();
        this.fireChangeEvent();
    }

    public void annotationChanged(AnnotationChangeEvent annotationChangeEvent) {
        this.fireChangeEvent();
    }

    public Collection getAnnotations() {
        ArrayList arrayList = new ArrayList(this.foregroundAnnotations);
        arrayList.addAll(this.backgroundAnnotations);
        return arrayList;
    }

    public XYSeriesLabelGenerator getLegendItemLabelGenerator() {
        return this.legendItemLabelGenerator;
    }

    public void setLegendItemLabelGenerator(XYSeriesLabelGenerator xYSeriesLabelGenerator) {
        if (xYSeriesLabelGenerator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.legendItemLabelGenerator = xYSeriesLabelGenerator;
        this.fireChangeEvent();
    }

    public XYSeriesLabelGenerator getLegendItemToolTipGenerator() {
        return this.legendItemToolTipGenerator;
    }

    public void setLegendItemToolTipGenerator(XYSeriesLabelGenerator xYSeriesLabelGenerator) {
        this.legendItemToolTipGenerator = xYSeriesLabelGenerator;
        this.fireChangeEvent();
    }

    public XYSeriesLabelGenerator getLegendItemURLGenerator() {
        return this.legendItemURLGenerator;
    }

    public void setLegendItemURLGenerator(XYSeriesLabelGenerator xYSeriesLabelGenerator) {
        this.legendItemURLGenerator = xYSeriesLabelGenerator;
        this.fireChangeEvent();
    }

    public Range findDomainBounds(XYDataset xYDataset) {
        return this.findDomainBounds(xYDataset, false);
    }

    protected Range findDomainBounds(XYDataset xYDataset, boolean bl) {
        if (xYDataset == null) {
            return null;
        }
        if (this.getDataBoundsIncludesVisibleSeriesOnly()) {
            ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
            int n = xYDataset.getSeriesCount();
            for (int i = 0; i < n; ++i) {
                if (!this.isSeriesVisible(i)) continue;
                arrayList.add(xYDataset.getSeriesKey(i));
            }
            return DatasetUtilities.findDomainBounds(xYDataset, arrayList, bl);
        }
        return DatasetUtilities.findDomainBounds(xYDataset, bl);
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        return this.findRangeBounds(xYDataset, false);
    }

    protected Range findRangeBounds(XYDataset xYDataset, boolean bl) {
        if (xYDataset == null) {
            return null;
        }
        if (this.getDataBoundsIncludesVisibleSeriesOnly()) {
            ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
            int n = xYDataset.getSeriesCount();
            for (int i = 0; i < n; ++i) {
                if (!this.isSeriesVisible(i)) continue;
                arrayList.add(xYDataset.getSeriesKey(i));
            }
            Range range = null;
            XYPlot xYPlot = this.getPlot();
            if (xYPlot != null) {
                ValueAxis valueAxis = null;
                int n2 = xYPlot.getIndexOf(this);
                if (n2 >= 0) {
                    valueAxis = this.plot.getDomainAxisForDataset(n2);
                }
                if (valueAxis != null) {
                    range = valueAxis.getRange();
                }
            }
            if (range == null) {
                range = new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            }
            return DatasetUtilities.findRangeBounds(xYDataset, arrayList, range, bl);
        }
        return DatasetUtilities.findRangeBounds(xYDataset, bl);
    }

    public LegendItemCollection getLegendItems() {
        if (this.plot == null) {
            return new LegendItemCollection();
        }
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        int n = this.plot.getIndexOf(this);
        XYDataset xYDataset = this.plot.getDataset(n);
        if (xYDataset != null) {
            int n2 = xYDataset.getSeriesCount();
            for (int i = 0; i < n2; ++i) {
                LegendItem legendItem;
                if (!this.isSeriesVisibleInLegend(i) || (legendItem = this.getLegendItem(n, i)) == null) continue;
                legendItemCollection.add(legendItem);
            }
        }
        return legendItemCollection;
    }

    public LegendItem getLegendItem(int n, int n2) {
        String string;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot == null) {
            return null;
        }
        XYDataset xYDataset = xYPlot.getDataset(n);
        if (xYDataset == null) {
            return null;
        }
        String string2 = string = this.legendItemLabelGenerator.generateLabel(xYDataset, n2);
        String string3 = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
        }
        String string4 = null;
        if (this.getLegendItemURLGenerator() != null) {
            string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
        }
        Shape shape = this.lookupLegendShape(n2);
        Paint paint = this.lookupSeriesPaint(n2);
        LegendItem legendItem = new LegendItem(string, paint);
        legendItem.setToolTipText(string3);
        legendItem.setURLText(string4);
        legendItem.setLabelFont(this.lookupLegendTextFont(n2));
        Paint paint2 = this.lookupLegendTextPaint(n2);
        if (paint2 != null) {
            legendItem.setLabelPaint(paint2);
        }
        legendItem.setSeriesKey(xYDataset.getSeriesKey(n2));
        legendItem.setSeriesIndex(n2);
        legendItem.setDataset(xYDataset);
        legendItem.setDatasetIndex(n);
        if (this.getTreatLegendShapeAsLine()) {
            legendItem.setLineVisible(true);
            legendItem.setLine(shape);
            legendItem.setLinePaint(paint);
            legendItem.setShapeVisible(false);
        } else {
            Paint paint3 = this.lookupSeriesOutlinePaint(n2);
            Stroke stroke = this.lookupSeriesOutlineStroke(n2);
            legendItem.setOutlinePaint(paint3);
            legendItem.setOutlineStroke(stroke);
        }
        return legendItem;
    }

    public void fillDomainGridBand(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d, double d2) {
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
        Rectangle2D.Double double_ = xYPlot.getOrientation() == PlotOrientation.VERTICAL ? new Rectangle2D.Double(Math.min(d3, d4), rectangle2D.getMinY(), Math.abs(d4 - d3), rectangle2D.getWidth()) : new Rectangle2D.Double(rectangle2D.getMinX(), Math.min(d3, d4), rectangle2D.getWidth(), Math.abs(d4 - d3));
        Paint paint = xYPlot.getDomainTickBandPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
        }
    }

    public void fillRangeGridBand(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d, double d2) {
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        Rectangle2D.Double double_ = xYPlot.getOrientation() == PlotOrientation.VERTICAL ? new Rectangle2D.Double(rectangle2D.getMinX(), Math.min(d3, d4), rectangle2D.getWidth(), Math.abs(d4 - d3)) : new Rectangle2D.Double(Math.min(d3, d4), rectangle2D.getMinY(), Math.abs(d4 - d3), rectangle2D.getHeight());
        Paint paint = xYPlot.getRangeTickBandPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
        }
    }

    public void drawDomainGridLine(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        }
        Paint paint = xYPlot.getDomainGridlinePaint();
        Stroke stroke = xYPlot.getDomainGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawDomainLine(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d, Paint paint, Stroke stroke) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Line2D.Double double_ = null;
        double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    public void drawRangeLine(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d, Paint paint, Stroke stroke) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Line2D.Double double_ = null;
        double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    public void drawDomainMarker(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        if (marker instanceof ValueMarker) {
            ValueMarker valueMarker = (ValueMarker)marker;
            double d = valueMarker.getValue();
            Range range = valueAxis.getRange();
            if (!range.contains(d)) {
                return;
            }
            double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            }
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, marker.getAlpha()));
            graphics2D.setPaint(marker.getPaint());
            graphics2D.setStroke(marker.getStroke());
            graphics2D.draw(double_);
            String string = marker.getLabel();
            RectangleAnchor rectangleAnchor = marker.getLabelAnchor();
            if (string != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateDomainMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_.getBounds2D(), marker.getLabelOffset(), LengthAdjustmentType.EXPAND, rectangleAnchor);
                TextUtilities.drawAlignedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), marker.getLabelTextAnchor());
            }
            graphics2D.setComposite(composite);
        } else if (marker instanceof IntervalMarker) {
            Object object;
            Object object2;
            IntervalMarker intervalMarker = (IntervalMarker)marker;
            double d = intervalMarker.getStartValue();
            double d3 = intervalMarker.getEndValue();
            Range range = valueAxis.getRange();
            if (!range.intersects(d, d3)) {
                return;
            }
            double d4 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
            double d5 = valueAxis.valueToJava2D(d3, rectangle2D, xYPlot.getDomainAxisEdge());
            double d6 = Math.min(d4, d5);
            double d7 = Math.max(d4, d5);
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Rectangle2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d6 = Math.max(d6, rectangle2D.getMinY());
                d7 = Math.min(d7, rectangle2D.getMaxY());
                double_ = new Rectangle2D.Double(rectangle2D.getMinX(), d6, rectangle2D.getWidth(), d7 - d6);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d6 = Math.max(d6, rectangle2D.getMinX());
                d7 = Math.min(d7, rectangle2D.getMaxX());
                double_ = new Rectangle2D.Double(d6, rectangle2D.getMinY(), d7 - d6, rectangle2D.getHeight());
            }
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, marker.getAlpha()));
            Paint paint = marker.getPaint();
            if (paint instanceof GradientPaint) {
                object2 = (GradientPaint)paint;
                object = intervalMarker.getGradientPaintTransformer();
                if (object != null) {
                    object2 = object.transform((GradientPaint)object2, double_);
                }
                graphics2D.setPaint((Paint)object2);
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(double_);
            if (intervalMarker.getOutlinePaint() != null && intervalMarker.getOutlineStroke() != null) {
                double d8;
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    object2 = new Line2D.Double();
                    double d9 = rectangle2D.getMinY();
                    d8 = rectangle2D.getMaxY();
                    graphics2D.setPaint(intervalMarker.getOutlinePaint());
                    graphics2D.setStroke(intervalMarker.getOutlineStroke());
                    if (range.contains(d)) {
                        ((Line2D)object2).setLine(d4, d9, d4, d8);
                        graphics2D.draw((Shape)object2);
                    }
                    if (range.contains(d3)) {
                        ((Line2D)object2).setLine(d5, d9, d5, d8);
                        graphics2D.draw((Shape)object2);
                    }
                } else {
                    object2 = new Line2D.Double();
                    double d10 = rectangle2D.getMinX();
                    d8 = rectangle2D.getMaxX();
                    graphics2D.setPaint(intervalMarker.getOutlinePaint());
                    graphics2D.setStroke(intervalMarker.getOutlineStroke());
                    if (range.contains(d)) {
                        ((Line2D)object2).setLine(d10, d4, d8, d4);
                        graphics2D.draw((Shape)object2);
                    }
                    if (range.contains(d3)) {
                        ((Line2D)object2).setLine(d10, d5, d8, d5);
                        graphics2D.draw((Shape)object2);
                    }
                }
            }
            object2 = marker.getLabel();
            object = marker.getLabelAnchor();
            if (object2 != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateDomainMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_, marker.getLabelOffset(), marker.getLabelOffsetType(), (RectangleAnchor)object);
                TextUtilities.drawAlignedString((String)object2, graphics2D, (float)point2D.getX(), (float)point2D.getY(), marker.getLabelTextAnchor());
            }
            graphics2D.setComposite(composite);
        }
    }

    protected Point2D calculateDomainMarkerTextAnchorPoint(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleInsets rectangleInsets, LengthAdjustmentType lengthAdjustmentType, RectangleAnchor rectangleAnchor) {
        Rectangle2D rectangle2D3 = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, LengthAdjustmentType.CONTRACT, lengthAdjustmentType);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, lengthAdjustmentType, LengthAdjustmentType.CONTRACT);
        }
        return RectangleAnchor.coordinates(rectangle2D3, rectangleAnchor);
    }

    public void drawRangeMarker(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        if (marker instanceof ValueMarker) {
            ValueMarker valueMarker = (ValueMarker)marker;
            double d = valueMarker.getValue();
            Range range = valueAxis.getRange();
            if (!range.contains(d)) {
                return;
            }
            double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
            } else {
                throw new IllegalStateException("Unknown orientation.");
            }
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, marker.getAlpha()));
            graphics2D.setPaint(marker.getPaint());
            graphics2D.setStroke(marker.getStroke());
            graphics2D.draw(double_);
            String string = marker.getLabel();
            RectangleAnchor rectangleAnchor = marker.getLabelAnchor();
            if (string != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateRangeMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_.getBounds2D(), marker.getLabelOffset(), LengthAdjustmentType.EXPAND, rectangleAnchor);
                TextUtilities.drawAlignedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), marker.getLabelTextAnchor());
            }
            graphics2D.setComposite(composite);
        } else if (marker instanceof IntervalMarker) {
            Object object;
            Object object2;
            IntervalMarker intervalMarker = (IntervalMarker)marker;
            double d = intervalMarker.getStartValue();
            double d3 = intervalMarker.getEndValue();
            Range range = valueAxis.getRange();
            if (!range.intersects(d, d3)) {
                return;
            }
            double d4 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
            double d5 = valueAxis.valueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
            double d6 = Math.min(d4, d5);
            double d7 = Math.max(d4, d5);
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Rectangle2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d6 = Math.max(d6, rectangle2D.getMinX());
                d7 = Math.min(d7, rectangle2D.getMaxX());
                double_ = new Rectangle2D.Double(d6, rectangle2D.getMinY(), d7 - d6, rectangle2D.getHeight());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d6 = Math.max(d6, rectangle2D.getMinY());
                d7 = Math.min(d7, rectangle2D.getMaxY());
                double_ = new Rectangle2D.Double(rectangle2D.getMinX(), d6, rectangle2D.getWidth(), d7 - d6);
            }
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, marker.getAlpha()));
            Paint paint = marker.getPaint();
            if (paint instanceof GradientPaint) {
                object2 = (GradientPaint)paint;
                object = intervalMarker.getGradientPaintTransformer();
                if (object != null) {
                    object2 = object.transform((GradientPaint)object2, double_);
                }
                graphics2D.setPaint((Paint)object2);
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(double_);
            if (intervalMarker.getOutlinePaint() != null && intervalMarker.getOutlineStroke() != null) {
                double d8;
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    object2 = new Line2D.Double();
                    double d9 = rectangle2D.getMinX();
                    d8 = rectangle2D.getMaxX();
                    graphics2D.setPaint(intervalMarker.getOutlinePaint());
                    graphics2D.setStroke(intervalMarker.getOutlineStroke());
                    if (range.contains(d)) {
                        ((Line2D)object2).setLine(d9, d4, d8, d4);
                        graphics2D.draw((Shape)object2);
                    }
                    if (range.contains(d3)) {
                        ((Line2D)object2).setLine(d9, d5, d8, d5);
                        graphics2D.draw((Shape)object2);
                    }
                } else {
                    object2 = new Line2D.Double();
                    double d10 = rectangle2D.getMinY();
                    d8 = rectangle2D.getMaxY();
                    graphics2D.setPaint(intervalMarker.getOutlinePaint());
                    graphics2D.setStroke(intervalMarker.getOutlineStroke());
                    if (range.contains(d)) {
                        ((Line2D)object2).setLine(d4, d10, d4, d8);
                        graphics2D.draw((Shape)object2);
                    }
                    if (range.contains(d3)) {
                        ((Line2D)object2).setLine(d5, d10, d5, d8);
                        graphics2D.draw((Shape)object2);
                    }
                }
            }
            object2 = marker.getLabel();
            object = marker.getLabelAnchor();
            if (object2 != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateRangeMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_, marker.getLabelOffset(), marker.getLabelOffsetType(), (RectangleAnchor)object);
                TextUtilities.drawAlignedString((String)object2, graphics2D, (float)point2D.getX(), (float)point2D.getY(), marker.getLabelTextAnchor());
            }
            graphics2D.setComposite(composite);
        }
    }

    private Point2D calculateRangeMarkerTextAnchorPoint(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleInsets rectangleInsets, LengthAdjustmentType lengthAdjustmentType, RectangleAnchor rectangleAnchor) {
        Rectangle2D rectangle2D3 = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, lengthAdjustmentType, LengthAdjustmentType.CONTRACT);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, LengthAdjustmentType.CONTRACT, lengthAdjustmentType);
        }
        return RectangleAnchor.coordinates(rectangle2D3, rectangleAnchor);
    }

    protected Object clone() throws CloneNotSupportedException {
        PublicCloneable publicCloneable;
        AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)super.clone();
        if (this.itemLabelGenerator != null && this.itemLabelGenerator instanceof PublicCloneable) {
            publicCloneable = (PublicCloneable)((Object)this.itemLabelGenerator);
            abstractXYItemRenderer.itemLabelGenerator = (XYItemLabelGenerator)publicCloneable.clone();
        }
        abstractXYItemRenderer.itemLabelGeneratorList = (ObjectList)this.itemLabelGeneratorList.clone();
        if (this.baseItemLabelGenerator != null && this.baseItemLabelGenerator instanceof PublicCloneable) {
            publicCloneable = (PublicCloneable)((Object)this.baseItemLabelGenerator);
            abstractXYItemRenderer.baseItemLabelGenerator = (XYItemLabelGenerator)publicCloneable.clone();
        }
        if (this.toolTipGenerator != null && this.toolTipGenerator instanceof PublicCloneable) {
            publicCloneable = (PublicCloneable)((Object)this.toolTipGenerator);
            abstractXYItemRenderer.toolTipGenerator = (XYToolTipGenerator)publicCloneable.clone();
        }
        abstractXYItemRenderer.toolTipGeneratorList = (ObjectList)this.toolTipGeneratorList.clone();
        if (this.baseToolTipGenerator != null && this.baseToolTipGenerator instanceof PublicCloneable) {
            publicCloneable = (PublicCloneable)((Object)this.baseToolTipGenerator);
            abstractXYItemRenderer.baseToolTipGenerator = (XYToolTipGenerator)publicCloneable.clone();
        }
        if (this.legendItemLabelGenerator instanceof PublicCloneable) {
            abstractXYItemRenderer.legendItemLabelGenerator = (XYSeriesLabelGenerator)ObjectUtilities.clone(this.legendItemLabelGenerator);
        }
        if (this.legendItemToolTipGenerator instanceof PublicCloneable) {
            abstractXYItemRenderer.legendItemToolTipGenerator = (XYSeriesLabelGenerator)ObjectUtilities.clone(this.legendItemToolTipGenerator);
        }
        if (this.legendItemURLGenerator instanceof PublicCloneable) {
            abstractXYItemRenderer.legendItemURLGenerator = (XYSeriesLabelGenerator)ObjectUtilities.clone(this.legendItemURLGenerator);
        }
        abstractXYItemRenderer.foregroundAnnotations = (List)ObjectUtilities.deepClone(this.foregroundAnnotations);
        abstractXYItemRenderer.backgroundAnnotations = (List)ObjectUtilities.deepClone(this.backgroundAnnotations);
        return abstractXYItemRenderer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractXYItemRenderer)) {
            return false;
        }
        AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)object;
        if (!ObjectUtilities.equal(this.itemLabelGenerator, abstractXYItemRenderer.itemLabelGenerator)) {
            return false;
        }
        if (!this.itemLabelGeneratorList.equals(abstractXYItemRenderer.itemLabelGeneratorList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseItemLabelGenerator, abstractXYItemRenderer.baseItemLabelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.toolTipGenerator, abstractXYItemRenderer.toolTipGenerator)) {
            return false;
        }
        if (!this.toolTipGeneratorList.equals(abstractXYItemRenderer.toolTipGeneratorList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseToolTipGenerator, abstractXYItemRenderer.baseToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.urlGenerator, abstractXYItemRenderer.urlGenerator)) {
            return false;
        }
        if (!this.foregroundAnnotations.equals(abstractXYItemRenderer.foregroundAnnotations)) {
            return false;
        }
        if (!this.backgroundAnnotations.equals(abstractXYItemRenderer.backgroundAnnotations)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemLabelGenerator, abstractXYItemRenderer.legendItemLabelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemToolTipGenerator, abstractXYItemRenderer.legendItemToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemURLGenerator, abstractXYItemRenderer.legendItemURLGenerator)) {
            return false;
        }
        return super.equals(object);
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null) {
            drawingSupplier = xYPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }

    protected void updateCrosshairValues(CrosshairState crosshairState, double d, double d2, int n, int n2, double d3, double d4, PlotOrientation plotOrientation) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        if (crosshairState != null) {
            if (this.plot.isDomainCrosshairLockedOnData()) {
                if (this.plot.isRangeCrosshairLockedOnData()) {
                    crosshairState.updateCrosshairPoint(d, d2, n, n2, d3, d4, plotOrientation);
                } else {
                    crosshairState.updateCrosshairX(d, n);
                }
            } else if (this.plot.isRangeCrosshairLockedOnData()) {
                crosshairState.updateCrosshairY(d2, n2);
            }
        }
    }

    protected void drawItemLabel(Graphics2D graphics2D, PlotOrientation plotOrientation, XYDataset xYDataset, int n, int n2, double d, double d2, boolean bl) {
        XYItemLabelGenerator xYItemLabelGenerator = this.getItemLabelGenerator(n, n2);
        if (xYItemLabelGenerator != null) {
            Font font = this.getItemLabelFont(n, n2);
            Paint paint = this.getItemLabelPaint(n, n2);
            graphics2D.setFont(font);
            graphics2D.setPaint(paint);
            String string = xYItemLabelGenerator.generateLabel(xYDataset, n, n2);
            ItemLabelPosition itemLabelPosition = null;
            itemLabelPosition = !bl ? this.getPositiveItemLabelPosition(n, n2) : this.getNegativeItemLabelPosition(n, n2);
            Point2D point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), d, d2, plotOrientation);
            TextUtilities.drawRotatedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getAngle(), itemLabelPosition.getRotationAnchor());
        }
    }

    public void drawAnnotations(Graphics2D graphics2D, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, Layer layer, PlotRenderingInfo plotRenderingInfo) {
        Iterator iterator = null;
        if (layer.equals(Layer.FOREGROUND)) {
            iterator = this.foregroundAnnotations.iterator();
        } else if (layer.equals(Layer.BACKGROUND)) {
            iterator = this.backgroundAnnotations.iterator();
        } else {
            throw new RuntimeException("Unknown layer.");
        }
        while (iterator.hasNext()) {
            XYAnnotation xYAnnotation = (XYAnnotation)iterator.next();
            int n = this.plot.getIndexOf(this);
            xYAnnotation.draw(graphics2D, this.plot, rectangle2D, valueAxis, valueAxis2, n, plotRenderingInfo);
        }
    }

    protected void addEntity(EntityCollection entityCollection, Shape shape, XYDataset xYDataset, int n, int n2, double d, double d2) {
        if (!this.getItemCreateEntity(n, n2)) {
            return;
        }
        Shape shape2 = shape;
        if (shape2 == null) {
            double d3 = this.getDefaultEntityRadius();
            double d4 = d3 * 2.0;
            shape2 = this.getPlot().getOrientation() == PlotOrientation.VERTICAL ? new Ellipse2D.Double(d - d3, d2 - d3, d4, d4) : new Ellipse2D.Double(d2 - d3, d - d3, d4, d4);
        }
        String string = null;
        XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
        if (xYToolTipGenerator != null) {
            string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
        }
        String string2 = null;
        if (this.getURLGenerator() != null) {
            string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
        }
        XYItemEntity xYItemEntity = new XYItemEntity(shape2, xYDataset, n, n2, string, string2);
        entityCollection.add(xYItemEntity);
    }

    public static boolean isPointInRect(Rectangle2D rectangle2D, double d, double d2) {
        return d >= rectangle2D.getMinX() && d <= rectangle2D.getMaxX() && d2 >= rectangle2D.getMinY() && d2 <= rectangle2D.getMaxY();
    }

    protected static void moveTo(GeneralPath generalPath, double d, double d2) {
        generalPath.moveTo((float)d, (float)d2);
    }

    protected static void lineTo(GeneralPath generalPath, double d, double d2) {
        generalPath.lineTo((float)d, (float)d2);
    }

    public XYItemLabelGenerator getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    public void setItemLabelGenerator(XYItemLabelGenerator xYItemLabelGenerator) {
        this.itemLabelGenerator = xYItemLabelGenerator;
        this.fireChangeEvent();
    }

    public XYToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        this.toolTipGenerator = xYToolTipGenerator;
        this.fireChangeEvent();
    }

    protected void updateCrosshairValues(CrosshairState crosshairState, double d, double d2, double d3, double d4, PlotOrientation plotOrientation) {
        this.updateCrosshairValues(crosshairState, d, d2, 0, 0, d3, d4, plotOrientation);
    }
}

