/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.chart.renderer.category.LineAndShapeRenderer;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.statistics.StatisticalCategoryDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class StatisticalLineAndShapeRenderer
extends LineAndShapeRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -3557517173697777579L;
    private transient Paint errorIndicatorPaint = null;
    private transient Stroke errorIndicatorStroke = null;

    public StatisticalLineAndShapeRenderer() {
        this(true, true);
    }

    public StatisticalLineAndShapeRenderer(boolean bl, boolean bl2) {
        super(bl, bl2);
    }

    public Paint getErrorIndicatorPaint() {
        return this.errorIndicatorPaint;
    }

    public void setErrorIndicatorPaint(Paint paint) {
        this.errorIndicatorPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getErrorIndicatorStroke() {
        return this.errorIndicatorStroke;
    }

    public void setErrorIndicatorStroke(Stroke stroke) {
        this.errorIndicatorStroke = stroke;
        this.fireChangeEvent();
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        return this.findRangeBounds(categoryDataset, true);
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        EntityCollection entityCollection;
        Number number;
        Object object;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        if (!(categoryDataset instanceof StatisticalCategoryDataset)) {
            super.drawItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2, n3);
            return;
        }
        int n4 = categoryItemRendererState.getVisibleSeriesIndex(n);
        if (n4 < 0) {
            return;
        }
        int n5 = categoryItemRendererState.getVisibleSeriesCount();
        StatisticalCategoryDataset statisticalCategoryDataset = (StatisticalCategoryDataset)categoryDataset;
        Number number2 = statisticalCategoryDataset.getMeanValue(n, n2);
        if (number2 == null) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d = this.getUseSeriesOffset() ? categoryAxis.getCategorySeriesMiddle(n2, categoryDataset.getColumnCount(), n4, n5, this.getItemMargin(), rectangle2D, categoryPlot.getDomainAxisEdge()) : categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d2 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, categoryPlot.getRangeAxisEdge());
        Number number3 = statisticalCategoryDataset.getStdDevValue(n, n2);
        if (n3 == 1 && number3 != null) {
            object = categoryPlot.getRangeAxisEdge();
            double d3 = number3.doubleValue();
            double d4 = number2.doubleValue() + d3 > valueAxis.getRange().getUpperBound() ? valueAxis.valueToJava2D(valueAxis.getRange().getUpperBound(), rectangle2D, (RectangleEdge)object) : valueAxis.valueToJava2D(number2.doubleValue() + d3, rectangle2D, (RectangleEdge)object);
            double d5 = number2.doubleValue() + d3 < valueAxis.getRange().getLowerBound() ? valueAxis.valueToJava2D(valueAxis.getRange().getLowerBound(), rectangle2D, (RectangleEdge)object) : valueAxis.valueToJava2D(number2.doubleValue() - d3, rectangle2D, (RectangleEdge)object);
            if (this.errorIndicatorPaint != null) {
                graphics2D.setPaint(this.errorIndicatorPaint);
            } else {
                graphics2D.setPaint(this.getItemPaint(n, n2));
            }
            if (this.errorIndicatorStroke != null) {
                graphics2D.setStroke(this.errorIndicatorStroke);
            } else {
                graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
            }
            Line2D.Double double_ = new Line2D.Double();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                ((Line2D)double_).setLine(d5, d, d4, d);
                graphics2D.draw(double_);
                ((Line2D)double_).setLine(d5, d - 5.0, d5, d + 5.0);
                graphics2D.draw(double_);
                ((Line2D)double_).setLine(d4, d - 5.0, d4, d + 5.0);
                graphics2D.draw(double_);
            } else {
                ((Line2D)double_).setLine(d, d5, d, d4);
                graphics2D.draw(double_);
                ((Line2D)double_).setLine(d - 5.0, d4, d + 5.0, d4);
                graphics2D.draw(double_);
                ((Line2D)double_).setLine(d - 5.0, d5, d + 5.0, d5);
                graphics2D.draw(double_);
            }
        }
        object = null;
        if (n3 == 1 && this.getItemShapeVisible(n, n2)) {
            Shape shape = this.getItemShape(n, n2);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d2, d);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d, d2);
            }
            object = shape;
            if (this.getItemShapeFilled(n, n2)) {
                if (this.getUseFillPaint()) {
                    graphics2D.setPaint(this.getItemFillPaint(n, n2));
                } else {
                    graphics2D.setPaint(this.getItemPaint(n, n2));
                }
                graphics2D.fill(shape);
            }
            if (this.getDrawOutlines()) {
                if (this.getUseOutlinePaint()) {
                    graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                } else {
                    graphics2D.setPaint(this.getItemPaint(n, n2));
                }
                graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
                graphics2D.draw(shape);
            }
            if (this.isItemLabelVisible(n, n2)) {
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, d2, d, number2.doubleValue() < 0.0);
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, d, d2, number2.doubleValue() < 0.0);
                }
            }
        }
        if (n3 == 0 && this.getItemLineVisible(n, n2) && n2 != 0 && (number = statisticalCategoryDataset.getValue(n, n2 - 1)) != null) {
            double d6 = number.doubleValue();
            double d7 = this.getUseSeriesOffset() ? categoryAxis.getCategorySeriesMiddle(n2 - 1, categoryDataset.getColumnCount(), n4, n5, this.getItemMargin(), rectangle2D, categoryPlot.getDomainAxisEdge()) : categoryAxis.getCategoryMiddle(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d8 = valueAxis.valueToJava2D(d6, rectangle2D, categoryPlot.getRangeAxisEdge());
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(d8, d7, d2, d);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(d7, d8, d, d2);
            }
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.draw(double_);
        }
        if (n3 == 1 && (entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            this.addEntity(entityCollection, (Shape)object, categoryDataset, n, n2, d, d2);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StatisticalLineAndShapeRenderer)) {
            return false;
        }
        StatisticalLineAndShapeRenderer statisticalLineAndShapeRenderer = (StatisticalLineAndShapeRenderer)object;
        if (!PaintUtilities.equal(this.errorIndicatorPaint, statisticalLineAndShapeRenderer.errorIndicatorPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.errorIndicatorStroke, statisticalLineAndShapeRenderer.errorIndicatorStroke)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = HashUtilities.hashCode(n, this.errorIndicatorPaint);
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.errorIndicatorPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.errorIndicatorStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.errorIndicatorPaint = SerialUtilities.readPaint(objectInputStream);
        this.errorIndicatorStroke = SerialUtilities.readStroke(objectInputStream);
    }
}

