/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.CategoryItemLabelGenerator;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.BarRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.statistics.StatisticalCategoryDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.GradientPaintTransformer;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class StatisticalBarRenderer
extends BarRenderer
implements CategoryItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -4986038395414039117L;
    private transient Paint errorIndicatorPaint = Color.gray;
    private transient Stroke errorIndicatorStroke = new BasicStroke(1.0f);

    public Paint getErrorIndicatorPaint() {
        return this.errorIndicatorPaint;
    }

    public void setErrorIndicatorPaint(Paint paint) {
        this.errorIndicatorPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getErrorIndicatorStroke() {
        return this.errorIndicatorStroke;
    }

    public void setErrorIndicatorStroke(Stroke stroke) {
        this.errorIndicatorStroke = stroke;
        this.fireChangeEvent();
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        return this.findRangeBounds(categoryDataset, true);
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        int n4 = categoryItemRendererState.getVisibleSeriesIndex(n);
        if (n4 < 0) {
            return;
        }
        if (!(categoryDataset instanceof StatisticalCategoryDataset)) {
            throw new IllegalArgumentException("Requires StatisticalCategoryDataset.");
        }
        StatisticalCategoryDataset statisticalCategoryDataset = (StatisticalCategoryDataset)categoryDataset;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, statisticalCategoryDataset, n4, n, n2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, statisticalCategoryDataset, n4, n, n2);
        }
    }

    protected void drawHorizontalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, StatisticalCategoryDataset statisticalCategoryDataset, int n, int n2, int n3) {
        EntityCollection entityCollection;
        Object object;
        Object object2;
        double d = this.calculateBarW0(categoryPlot, PlotOrientation.HORIZONTAL, rectangle2D, categoryAxis, categoryItemRendererState, n, n3);
        Number number = statisticalCategoryDataset.getMeanValue(n2, n3);
        if (number == null) {
            return;
        }
        double d2 = number.doubleValue();
        double d3 = 0.0;
        double d4 = this.getLowerClip();
        double d5 = this.getUpperClip();
        if (d5 <= 0.0) {
            if (d2 >= d5) {
                return;
            }
            d3 = d5;
            if (d2 <= d4) {
                d2 = d4;
            }
        } else if (d4 <= 0.0) {
            if (d2 >= d5) {
                d2 = d5;
            } else if (d2 <= d4) {
                d2 = d4;
            }
        } else {
            if (d2 <= d4) {
                return;
            }
            d3 = this.getLowerClip();
            if (d2 >= d5) {
                d2 = d5;
            }
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d6 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        double d7 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d8 = Math.min(d7, d6);
        double d9 = categoryItemRendererState.getBarWidth();
        double d10 = Math.abs(d7 - d6);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d8, d, d10, d9);
        Paint paint = this.getItemPaint(n2, n3);
        GradientPaintTransformer gradientPaintTransformer = this.getGradientPaintTransformer();
        if (gradientPaintTransformer != null && paint instanceof GradientPaint) {
            paint = gradientPaintTransformer.transform((GradientPaint)paint, double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(n2, n3);
            object = this.getItemOutlinePaint(n2, n3);
            if (object2 != null && object != null) {
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint((Paint)object);
                graphics2D.draw(double_);
            }
        }
        if ((object2 = statisticalCategoryDataset.getStdDevValue(n2, n3)) != null) {
            double d11 = ((Number)object2).doubleValue();
            double d12 = valueAxis.valueToJava2D(number.doubleValue() + d11, rectangle2D, rectangleEdge);
            double d13 = valueAxis.valueToJava2D(number.doubleValue() - d11, rectangle2D, rectangleEdge);
            if (this.errorIndicatorPaint != null) {
                graphics2D.setPaint(this.errorIndicatorPaint);
            } else {
                graphics2D.setPaint(this.getItemOutlinePaint(n2, n3));
            }
            if (this.errorIndicatorStroke != null) {
                graphics2D.setStroke(this.errorIndicatorStroke);
            } else {
                graphics2D.setStroke(this.getItemOutlineStroke(n2, n3));
            }
            Line2D.Double double_2 = null;
            double_2 = new Line2D.Double(d13, d + d9 / 2.0, d12, d + d9 / 2.0);
            graphics2D.draw(double_2);
            double_2 = new Line2D.Double(d12, d + d9 * 0.25, d12, d + d9 * 0.75);
            graphics2D.draw(double_2);
            double_2 = new Line2D.Double(d13, d + d9 * 0.25, d13, d + d9 * 0.75);
            graphics2D.draw(double_2);
        }
        if ((object = this.getItemLabelGenerator(n2, n3)) != null && this.isItemLabelVisible(n2, n3)) {
            this.drawItemLabel(graphics2D, statisticalCategoryDataset, n2, n3, categoryPlot, (CategoryItemLabelGenerator)object, double_, d2 < 0.0);
        }
        if ((entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            this.addItemEntity(entityCollection, statisticalCategoryDataset, n2, n3, double_);
        }
    }

    protected void drawVerticalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, StatisticalCategoryDataset statisticalCategoryDataset, int n, int n2, int n3) {
        EntityCollection entityCollection;
        Object object;
        Object object2;
        double d = this.calculateBarW0(categoryPlot, PlotOrientation.VERTICAL, rectangle2D, categoryAxis, categoryItemRendererState, n, n3);
        Number number = statisticalCategoryDataset.getMeanValue(n2, n3);
        if (number == null) {
            return;
        }
        double d2 = number.doubleValue();
        double d3 = 0.0;
        double d4 = this.getLowerClip();
        double d5 = this.getUpperClip();
        if (d5 <= 0.0) {
            if (d2 >= d5) {
                return;
            }
            d3 = d5;
            if (d2 <= d4) {
                d2 = d4;
            }
        } else if (d4 <= 0.0) {
            if (d2 >= d5) {
                d2 = d5;
            } else if (d2 <= d4) {
                d2 = d4;
            }
        } else {
            if (d2 <= d4) {
                return;
            }
            d3 = this.getLowerClip();
            if (d2 >= d5) {
                d2 = d5;
            }
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d6 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        double d7 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d8 = Math.min(d7, d6);
        double d9 = categoryItemRendererState.getBarWidth();
        double d10 = Math.abs(d7 - d6);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d8, d9, d10);
        Paint paint = this.getItemPaint(n2, n3);
        GradientPaintTransformer gradientPaintTransformer = this.getGradientPaintTransformer();
        if (gradientPaintTransformer != null && paint instanceof GradientPaint) {
            paint = gradientPaintTransformer.transform((GradientPaint)paint, double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(n2, n3);
            object = this.getItemOutlinePaint(n2, n3);
            if (object2 != null && object != null) {
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint((Paint)object);
                graphics2D.draw(double_);
            }
        }
        if ((object2 = statisticalCategoryDataset.getStdDevValue(n2, n3)) != null) {
            double d11 = ((Number)object2).doubleValue();
            double d12 = valueAxis.valueToJava2D(number.doubleValue() + d11, rectangle2D, rectangleEdge);
            double d13 = valueAxis.valueToJava2D(number.doubleValue() - d11, rectangle2D, rectangleEdge);
            if (this.errorIndicatorPaint != null) {
                graphics2D.setPaint(this.errorIndicatorPaint);
            } else {
                graphics2D.setPaint(this.getItemOutlinePaint(n2, n3));
            }
            if (this.errorIndicatorStroke != null) {
                graphics2D.setStroke(this.errorIndicatorStroke);
            } else {
                graphics2D.setStroke(this.getItemOutlineStroke(n2, n3));
            }
            Line2D.Double double_2 = null;
            double_2 = new Line2D.Double(d + d9 / 2.0, d13, d + d9 / 2.0, d12);
            graphics2D.draw(double_2);
            double_2 = new Line2D.Double(d + d9 / 2.0 - 5.0, d12, d + d9 / 2.0 + 5.0, d12);
            graphics2D.draw(double_2);
            double_2 = new Line2D.Double(d + d9 / 2.0 - 5.0, d13, d + d9 / 2.0 + 5.0, d13);
            graphics2D.draw(double_2);
        }
        if ((object = this.getItemLabelGenerator(n2, n3)) != null && this.isItemLabelVisible(n2, n3)) {
            this.drawItemLabel(graphics2D, statisticalCategoryDataset, n2, n3, categoryPlot, (CategoryItemLabelGenerator)object, double_, d2 < 0.0);
        }
        if ((entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            this.addItemEntity(entityCollection, statisticalCategoryDataset, n2, n3, double_);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StatisticalBarRenderer)) {
            return false;
        }
        StatisticalBarRenderer statisticalBarRenderer = (StatisticalBarRenderer)object;
        if (!PaintUtilities.equal(this.errorIndicatorPaint, statisticalBarRenderer.errorIndicatorPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.errorIndicatorStroke, statisticalBarRenderer.errorIndicatorStroke)) {
            return false;
        }
        return super.equals(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.errorIndicatorPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.errorIndicatorStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.errorIndicatorPaint = SerialUtilities.readPaint(objectInputStream);
        this.errorIndicatorStroke = SerialUtilities.readStroke(objectInputStream);
    }
}

