/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.renderer.category.BarPainter;
import ai.org.jfree.chart.renderer.category.BarRenderer;
import ai.org.jfree.ui.GradientPaintTransformer;
import ai.org.jfree.ui.RectangleEdge;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;

public class StandardBarPainter
implements BarPainter,
Serializable {
    public void paintBar(Graphics2D graphics2D, BarRenderer barRenderer, int n, int n2, RectangularShape rectangularShape, RectangleEdge rectangleEdge) {
        Paint paint = barRenderer.getItemPaint(n, n2);
        GradientPaintTransformer gradientPaintTransformer = barRenderer.getGradientPaintTransformer();
        if (gradientPaintTransformer != null && paint instanceof GradientPaint) {
            paint = gradientPaintTransformer.transform((GradientPaint)paint, rectangularShape);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(rectangularShape);
        if (barRenderer.isDrawBarOutline()) {
            Stroke stroke = barRenderer.getItemOutlineStroke(n, n2);
            Paint paint2 = barRenderer.getItemOutlinePaint(n, n2);
            if (stroke != null && paint2 != null) {
                graphics2D.setStroke(stroke);
                graphics2D.setPaint(paint2);
                graphics2D.draw(rectangularShape);
            }
        }
    }

    public void paintBarShadow(Graphics2D graphics2D, BarRenderer barRenderer, int n, int n2, RectangularShape rectangularShape, RectangleEdge rectangleEdge, boolean bl) {
        Object object;
        Paint paint = barRenderer.getItemPaint(n, n2);
        if (paint instanceof Color && ((Color)(object = (Color)paint)).getAlpha() == 0) {
            return;
        }
        object = this.createShadow(rectangularShape, barRenderer.getShadowXOffset(), barRenderer.getShadowYOffset(), rectangleEdge, bl);
        graphics2D.setPaint(barRenderer.getShadowPaint());
        graphics2D.fill((Shape)object);
    }

    private Rectangle2D createShadow(RectangularShape rectangularShape, double d, double d2, RectangleEdge rectangleEdge, boolean bl) {
        double d3 = rectangularShape.getMinX();
        double d4 = rectangularShape.getMaxX();
        double d5 = rectangularShape.getMinY();
        double d6 = rectangularShape.getMaxY();
        if (rectangleEdge == RectangleEdge.TOP) {
            d3 += d;
            d4 += d;
            if (!bl) {
                d5 += d2;
            }
            d6 += d2;
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            d3 += d;
            d4 += d;
            d5 += d2;
            if (!bl) {
                d6 += d2;
            }
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            if (!bl) {
                d3 += d;
            }
            d4 += d;
            d5 += d2;
            d6 += d2;
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            d3 += d;
            if (!bl) {
                d4 += d;
            }
            d5 += d2;
            d6 += d2;
        }
        return new Rectangle2D.Double(d3, d5, d4 - d3, d6 - d5);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof StandardBarPainter;
    }

    public int hashCode() {
        int n = 37;
        return n;
    }
}

