/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.CategoryItemLabelGenerator;
import ai.org.jfree.chart.labels.ItemLabelAnchor;
import ai.org.jfree.chart.labels.ItemLabelPosition;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.BarRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.data.DataUtilities;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.TextAnchor;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class StackedBarRenderer
extends BarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    static final long serialVersionUID = 6402943811500067531L;
    private boolean renderAsPercentages;

    public StackedBarRenderer() {
        this(false);
    }

    public StackedBarRenderer(boolean bl) {
        this.renderAsPercentages = bl;
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER);
        this.setBasePositiveItemLabelPosition(itemLabelPosition);
        this.setBaseNegativeItemLabelPosition(itemLabelPosition);
        this.setPositiveItemLabelPositionFallback(null);
        this.setNegativeItemLabelPositionFallback(null);
    }

    public boolean getRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean bl) {
        this.renderAsPercentages = bl;
        this.fireChangeEvent();
    }

    public int getPassCount() {
        return 3;
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            return null;
        }
        if (this.renderAsPercentages) {
            return new Range(0.0, 1.0);
        }
        return DatasetUtilities.findStackedRangeBounds(categoryDataset, this.getBase());
    }

    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, int n, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = categoryPlot.getDomainAxisForDataset(n);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        if (categoryDataset != null) {
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d = 0.0;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = d * this.getMaximumBarWidth();
            int n2 = categoryDataset.getColumnCount();
            double d3 = 0.0;
            if (n2 > 1) {
                d3 = categoryAxis.getCategoryMargin();
            }
            double d4 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d3);
            if (n2 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d4 / (double)n2, d2));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d4, d2));
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        double d;
        double d2;
        double d3;
        if (!this.isSeriesVisible(n)) {
            return;
        }
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d4 = number.doubleValue();
        double d5 = 0.0;
        if (this.renderAsPercentages) {
            d5 = DataUtilities.calculateColumnTotal(categoryDataset, n2, categoryItemRendererState.getVisibleSeriesArray());
            d4 /= d5;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d6 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        double d7 = d3 = this.getBase();
        for (int i = 0; i < n; ++i) {
            Number number2 = categoryDataset.getValue(i, n2);
            if (number2 == null || !this.isSeriesVisible(i)) continue;
            d2 = number2.doubleValue();
            if (this.renderAsPercentages) {
                d2 /= d5;
            }
            if (d2 > 0.0) {
                d3 += d2;
                continue;
            }
            d7 += d2;
        }
        boolean bl = d4 > 0.0;
        boolean bl2 = valueAxis.isInverted();
        RectangleEdge rectangleEdge = plotOrientation == PlotOrientation.HORIZONTAL ? (bl && bl2 || !bl && !bl2 ? RectangleEdge.RIGHT : RectangleEdge.LEFT) : (bl && !bl2 || !bl && bl2 ? RectangleEdge.BOTTOM : RectangleEdge.TOP);
        RectangleEdge rectangleEdge2 = categoryPlot.getRangeAxisEdge();
        if (bl) {
            d = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge2);
            d2 = valueAxis.valueToJava2D(d3 + d4, rectangle2D, rectangleEdge2);
        } else {
            d = valueAxis.valueToJava2D(d7, rectangle2D, rectangleEdge2);
            d2 = valueAxis.valueToJava2D(d7 + d4, rectangle2D, rectangleEdge2);
        }
        double d8 = Math.min(d, d2);
        double d9 = Math.max(Math.abs(d2 - d), this.getMinimumBarLength());
        Rectangle2D.Double double_ = null;
        double_ = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d8, d6, d9, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d6, d8, categoryItemRendererState.getBarWidth(), d9);
        if (n3 == 0) {
            if (this.getShadowsVisible()) {
                boolean bl3 = bl && d3 == this.getBase() || !bl && d7 == this.getBase();
                this.getBarPainter().paintBarShadow(graphics2D, this, n, n2, double_, rectangleEdge, bl3);
            }
        } else if (n3 == 1) {
            this.getBarPainter().paintBar(graphics2D, this, n, n2, double_, rectangleEdge);
            EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
            if (entityCollection != null) {
                this.addItemEntity(entityCollection, categoryDataset, n, n2, double_);
            }
        } else if (n3 == 2 && (categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, d4 < 0.0);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedBarRenderer)) {
            return false;
        }
        StackedBarRenderer stackedBarRenderer = (StackedBarRenderer)object;
        if (this.renderAsPercentages != stackedBarRenderer.renderAsPercentages) {
            return false;
        }
        return super.equals(object);
    }
}

