/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.renderer.category.AreaRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.data.DataUtilities;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class StackedAreaRenderer
extends AreaRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -3595635038460823663L;
    private boolean renderAsPercentages;

    public StackedAreaRenderer() {
        this(false);
    }

    public StackedAreaRenderer(boolean bl) {
        this.renderAsPercentages = bl;
    }

    public boolean getRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean bl) {
        this.renderAsPercentages = bl;
        this.fireChangeEvent();
    }

    public int getPassCount() {
        return 2;
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            return null;
        }
        if (this.renderAsPercentages) {
            return new Range(0.0, 1.0);
        }
        return DatasetUtilities.findStackedRangeBounds(categoryDataset);
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        float f;
        float f2;
        float f3;
        if (!this.isSeriesVisible(n)) {
            return;
        }
        GeneralPath generalPath = null;
        EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
        double d = 0.0;
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            d = number.doubleValue();
            if (this.renderAsPercentages) {
                double d2 = DataUtilities.calculateColumnTotal(categoryDataset, n2, categoryItemRendererState.getVisibleSeriesArray());
                d /= d2;
            }
        }
        double[] dArray = this.getStackValues(categoryDataset, n, n2, categoryItemRendererState.getVisibleSeriesArray());
        double d3 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d4 = 0.0;
        number = categoryDataset.getValue(n, Math.max(n2 - 1, 0));
        if (number != null) {
            d4 = number.doubleValue();
            if (this.renderAsPercentages) {
                double d5 = DataUtilities.calculateColumnTotal(categoryDataset, Math.max(n2 - 1, 0), categoryItemRendererState.getVisibleSeriesArray());
                d4 /= d5;
            }
        }
        double[] dArray2 = this.getStackValues(categoryDataset, n, Math.max(n2 - 1, 0), categoryItemRendererState.getVisibleSeriesArray());
        double d6 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        int n4 = categoryDataset.getColumnCount();
        double d7 = 0.0;
        number = categoryDataset.getValue(n, Math.min(n2 + 1, n4 - 1));
        if (number != null) {
            d7 = number.doubleValue();
            if (this.renderAsPercentages) {
                double d8 = DataUtilities.calculateColumnTotal(categoryDataset, Math.min(n2 + 1, n4 - 1), categoryItemRendererState.getVisibleSeriesArray());
                d7 /= d8;
            }
        }
        double[] dArray3 = this.getStackValues(categoryDataset, n, Math.min(n2 + 1, n4 - 1), categoryItemRendererState.getVisibleSeriesArray());
        double d9 = categoryAxis.getCategoryEnd(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d10 = d6;
        double d11 = d9;
        double[] dArray4 = this.averageStackValues(dArray2, dArray);
        double[] dArray5 = this.averageStackValues(dArray, dArray3);
        double[] dArray6 = this.adjustedStackValues(dArray2, dArray);
        double[] dArray7 = this.adjustedStackValues(dArray, dArray3);
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        GeneralPath generalPath2 = new GeneralPath();
        GeneralPath generalPath3 = new GeneralPath();
        if (d >= 0.0) {
            f3 = (float)valueAxis.valueToJava2D(d + dArray[1], rectangle2D, rectangleEdge);
            f2 = (float)valueAxis.valueToJava2D(dArray[1], rectangle2D, rectangleEdge);
            f = (float)valueAxis.valueToJava2D(dArray6[1], rectangle2D, rectangleEdge);
            if (d4 >= 0.0) {
                double d12 = (d4 + d) / 2.0 + dArray4[1];
                float f4 = (float)valueAxis.valueToJava2D(d12, rectangle2D, rectangleEdge);
                generalPath2.moveTo((float)d3, f3);
                generalPath2.lineTo((float)d3, f2);
                generalPath2.lineTo((float)d10, f);
                generalPath2.lineTo((float)d10, f4);
                generalPath2.closePath();
            } else {
                generalPath2.moveTo((float)d3, f2);
                generalPath2.lineTo((float)d3, f3);
                generalPath2.lineTo((float)d10, f);
                generalPath2.closePath();
            }
            float f5 = (float)valueAxis.valueToJava2D(dArray7[1], rectangle2D, rectangleEdge);
            if (d7 >= 0.0) {
                double d13 = (d + d7) / 2.0 + dArray5[1];
                float f6 = (float)valueAxis.valueToJava2D(d13, rectangle2D, rectangleEdge);
                generalPath3.moveTo((float)d3, f2);
                generalPath3.lineTo((float)d3, f3);
                generalPath3.lineTo((float)d11, f6);
                generalPath3.lineTo((float)d11, f5);
                generalPath3.closePath();
            } else {
                generalPath3.moveTo((float)d3, f2);
                generalPath3.lineTo((float)d3, f3);
                generalPath3.lineTo((float)d11, f5);
                generalPath3.closePath();
            }
        } else {
            f3 = (float)valueAxis.valueToJava2D(d + dArray[0], rectangle2D, rectangleEdge);
            f2 = (float)valueAxis.valueToJava2D(dArray[0], rectangle2D, rectangleEdge);
            f = (float)valueAxis.valueToJava2D(dArray6[0], rectangle2D, rectangleEdge);
            if (d4 >= 0.0) {
                generalPath2.moveTo((float)d3, f2);
                generalPath2.lineTo((float)d3, f3);
                generalPath2.lineTo((float)d10, f);
                generalPath2.clone();
            } else {
                double d14 = (d4 + d) / 2.0 + dArray4[0];
                float f7 = (float)valueAxis.valueToJava2D(d14, rectangle2D, rectangleEdge);
                generalPath2.moveTo((float)d3, f3);
                generalPath2.lineTo((float)d3, f2);
                generalPath2.lineTo((float)d10, f);
                generalPath2.lineTo((float)d10, f7);
                generalPath2.closePath();
            }
            float f8 = (float)valueAxis.valueToJava2D(dArray7[0], rectangle2D, rectangleEdge);
            if (d7 >= 0.0) {
                generalPath3.moveTo((float)d3, f2);
                generalPath3.lineTo((float)d3, f3);
                generalPath3.lineTo((float)d11, f8);
                generalPath3.closePath();
            } else {
                double d15 = (d + d7) / 2.0 + dArray5[0];
                float f9 = (float)valueAxis.valueToJava2D(d15, rectangle2D, rectangleEdge);
                generalPath3.moveTo((float)d3, f2);
                generalPath3.lineTo((float)d3, f3);
                generalPath3.lineTo((float)d11, f9);
                generalPath3.lineTo((float)d11, f8);
                generalPath3.closePath();
            }
        }
        if (n3 == 0) {
            Paint paint = this.getItemPaint(n, n2);
            graphics2D.setPaint(paint);
            graphics2D.fill(generalPath2);
            graphics2D.fill(generalPath3);
            if (entityCollection != null) {
                GeneralPath generalPath4 = new GeneralPath(generalPath2);
                generalPath4.append(generalPath3, false);
                generalPath = generalPath4;
                this.addItemEntity(entityCollection, categoryDataset, n, n2, generalPath);
            }
        } else if (n3 == 1) {
            this.drawItemLabel(graphics2D, categoryPlot.getOrientation(), categoryDataset, n, n2, d3, f3, d < 0.0);
        }
    }

    protected double[] getStackValues(CategoryDataset categoryDataset, int n, int n2, int[] nArray) {
        double[] dArray = new double[2];
        double d = 0.0;
        if (this.renderAsPercentages) {
            d = DataUtilities.calculateColumnTotal(categoryDataset, n2, nArray);
        }
        for (int i = 0; i < n; ++i) {
            if (!this.isSeriesVisible(i)) continue;
            double d2 = 0.0;
            Number number = categoryDataset.getValue(i, n2);
            if (number != null) {
                d2 = number.doubleValue();
                if (this.renderAsPercentages) {
                    d2 /= d;
                }
            }
            if (Double.isNaN(d2)) continue;
            if (d2 >= 0.0) {
                dArray[1] = dArray[1] + d2;
                continue;
            }
            dArray[0] = dArray[0] + d2;
        }
        return dArray;
    }

    private double[] averageStackValues(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{(dArray[0] + dArray2[0]) / 2.0, (dArray[1] + dArray2[1]) / 2.0};
        return dArray3;
    }

    private double[] adjustedStackValues(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[0] == 0.0 || dArray2[0] == 0.0 ? 0.0 : (dArray[0] + dArray2[0]) / 2.0, dArray[1] == 0.0 || dArray2[1] == 0.0 ? 0.0 : (dArray[1] + dArray2[1]) / 2.0};
        return dArray3;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedAreaRenderer)) {
            return false;
        }
        StackedAreaRenderer stackedAreaRenderer = (StackedAreaRenderer)object;
        if (this.renderAsPercentages != stackedAreaRenderer.renderAsPercentages) {
            return false;
        }
        return super.equals(object);
    }

    protected double getPreviousHeight(CategoryDataset categoryDataset, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        if (this.renderAsPercentages) {
            d2 = DataUtilities.calculateColumnTotal(categoryDataset, n2);
        }
        for (int i = 0; i < n; ++i) {
            Number number = categoryDataset.getValue(i, n2);
            if (number == null) continue;
            double d3 = number.doubleValue();
            if (this.renderAsPercentages) {
                d3 /= d2;
            }
            d += d3;
        }
        return d;
    }
}

