/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.renderer.Outlier;
import ai.org.jfree.chart.renderer.OutlierList;
import ai.org.jfree.chart.renderer.OutlierListCollection;
import ai.org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BoxAndWhiskerRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 632027470694481177L;
    private transient Paint artifactPaint = Color.black;
    private boolean fillBox = true;
    private double itemMargin = 0.2;
    private double maximumBarWidth = 1.0;
    private boolean medianVisible = true;
    private boolean meanVisible = true;
    private boolean useOutlinePaintForWhiskers = false;
    private double whiskerWidth = 1.0;

    public BoxAndWhiskerRenderer() {
        this.setBaseLegendShape(new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0));
    }

    public Paint getArtifactPaint() {
        return this.artifactPaint;
    }

    public void setArtifactPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.artifactPaint = paint;
        this.fireChangeEvent();
    }

    public boolean getFillBox() {
        return this.fillBox;
    }

    public void setFillBox(boolean bl) {
        this.fillBox = bl;
        this.fireChangeEvent();
    }

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double d) {
        this.itemMargin = d;
        this.fireChangeEvent();
    }

    public double getMaximumBarWidth() {
        return this.maximumBarWidth;
    }

    public void setMaximumBarWidth(double d) {
        this.maximumBarWidth = d;
        this.fireChangeEvent();
    }

    public boolean isMeanVisible() {
        return this.meanVisible;
    }

    public void setMeanVisible(boolean bl) {
        if (this.meanVisible == bl) {
            return;
        }
        this.meanVisible = bl;
        this.fireChangeEvent();
    }

    public boolean isMedianVisible() {
        return this.medianVisible;
    }

    public void setMedianVisible(boolean bl) {
        if (this.medianVisible == bl) {
            return;
        }
        this.medianVisible = bl;
        this.fireChangeEvent();
    }

    public boolean getUseOutlinePaintForWhiskers() {
        return this.useOutlinePaintForWhiskers;
    }

    public void setUseOutlinePaintForWhiskers(boolean bl) {
        if (this.useOutlinePaintForWhiskers == bl) {
            return;
        }
        this.useOutlinePaintForWhiskers = bl;
        this.fireChangeEvent();
    }

    public double getWhiskerWidth() {
        return this.whiskerWidth;
    }

    public void setWhiskerWidth(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Value for whisker width out of range");
        }
        if (d == this.whiskerWidth) {
            return;
        }
        this.whiskerWidth = d;
        this.fireChangeEvent();
    }

    public LegendItem getLegendItem(int n, int n2) {
        String string;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        if (!this.isSeriesVisible(n2) || !this.isSeriesVisibleInLegend(n2)) {
            return null;
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        String string2 = string = this.getLegendItemLabelGenerator().generateLabel(categoryDataset, n2);
        String string3 = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            string3 = this.getLegendItemToolTipGenerator().generateLabel(categoryDataset, n2);
        }
        String string4 = null;
        if (this.getLegendItemURLGenerator() != null) {
            string4 = this.getLegendItemURLGenerator().generateLabel(categoryDataset, n2);
        }
        Shape shape = this.lookupLegendShape(n2);
        Paint paint = this.lookupSeriesPaint(n2);
        Paint paint2 = this.lookupSeriesOutlinePaint(n2);
        Stroke stroke = this.lookupSeriesOutlineStroke(n2);
        LegendItem legendItem = new LegendItem(string, string2, string3, string4, shape, paint, stroke, paint2);
        legendItem.setLabelFont(this.lookupLegendTextFont(n2));
        Paint paint3 = this.lookupLegendTextPaint(n2);
        if (paint3 != null) {
            legendItem.setLabelPaint(paint3);
        }
        legendItem.setDataset(categoryDataset);
        legendItem.setDatasetIndex(n);
        legendItem.setSeriesKey(categoryDataset.getRowKey(n2));
        legendItem.setSeriesIndex(n2);
        return legendItem;
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        return super.findRangeBounds(categoryDataset, true);
    }

    public CategoryItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, int n, PlotRenderingInfo plotRenderingInfo) {
        CategoryItemRendererState categoryItemRendererState = super.initialise(graphics2D, rectangle2D, categoryPlot, n, plotRenderingInfo);
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        if (categoryDataset != null) {
            int n2 = categoryDataset.getColumnCount();
            int n3 = categoryDataset.getRowCount();
            double d = 0.0;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = d * this.getMaximumBarWidth();
            double d3 = 0.0;
            double d4 = 0.0;
            if (n2 > 1) {
                d3 = categoryAxis.getCategoryMargin();
            }
            if (n3 > 1) {
                d4 = this.getItemMargin();
            }
            double d5 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d3 - d4);
            if (n3 * n2 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d5 / (double)(categoryDataset.getColumnCount() * categoryDataset.getRowCount()), d2));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d5, d2));
            }
        }
        return categoryItemRendererState;
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        if (!(categoryDataset instanceof BoxAndWhiskerCategoryDataset)) {
            throw new IllegalArgumentException("BoxAndWhiskerRenderer.drawItem() : the data should be of type BoxAndWhiskerCategoryDataset only.");
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        }
    }

    public void drawHorizontalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        EntityCollection entityCollection;
        Number number;
        double d;
        Number number2;
        double d2;
        double d3;
        BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = (BoxAndWhiskerCategoryDataset)categoryDataset;
        double d4 = categoryAxis.getCategoryEnd(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d5 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d6 = Math.abs(d4 - d5);
        double d7 = d5;
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            d3 = rectangle2D.getHeight() * this.getItemMargin() / (double)(n4 * (n3 - 1));
            double d8 = categoryItemRendererState.getBarWidth() * (double)n3 + d3 * (double)(n3 - 1);
            double d9 = (d6 - d8) / 2.0;
            d7 = d7 + d9 + (double)n * (categoryItemRendererState.getBarWidth() + d3);
        } else {
            d3 = (d6 - categoryItemRendererState.getBarWidth()) / 2.0;
            d7 += d3;
        }
        graphics2D.setPaint(this.getItemPaint(n, n2));
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number3 = boxAndWhiskerCategoryDataset.getQ1Value(n, n2);
        Number number4 = boxAndWhiskerCategoryDataset.getQ3Value(n, n2);
        Number number5 = boxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2);
        Number number6 = boxAndWhiskerCategoryDataset.getMinRegularValue(n, n2);
        Rectangle2D.Double double_ = null;
        if (number3 != null && number4 != null && number5 != null && number6 != null) {
            d2 = valueAxis.valueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
            double d10 = valueAxis.valueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
            double d11 = valueAxis.valueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
            double d12 = valueAxis.valueToJava2D(number6.doubleValue(), rectangle2D, rectangleEdge);
            double d13 = d7 + categoryItemRendererState.getBarWidth() / 2.0;
            double d14 = categoryItemRendererState.getBarWidth() / 2.0 * this.whiskerWidth;
            double_ = new Rectangle2D.Double(Math.min(d2, d10), d7, Math.abs(d2 - d10), categoryItemRendererState.getBarWidth());
            if (this.fillBox) {
                graphics2D.fill(double_);
            }
            Paint paint = this.getItemOutlinePaint(n, n2);
            if (this.useOutlinePaintForWhiskers) {
                graphics2D.setPaint(paint);
            }
            graphics2D.draw(new Line2D.Double(d11, d13, d10, d13));
            graphics2D.draw(new Line2D.Double(d11, d13 - d14, d11, d13 + d14));
            graphics2D.draw(new Line2D.Double(d12, d13, d2, d13));
            graphics2D.draw(new Line2D.Double(d12, d13 - d14, d12, d7 + d14));
            graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
        graphics2D.setPaint(this.artifactPaint);
        d2 = 0.0;
        if (this.meanVisible && (number2 = boxAndWhiskerCategoryDataset.getMeanValue(n, n2)) != null) {
            d = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            d2 = categoryItemRendererState.getBarWidth() / 4.0;
            if (d > rectangle2D.getMinX() - d2 && d < rectangle2D.getMaxX() + d2) {
                Ellipse2D.Double double_2 = new Ellipse2D.Double(d - d2, d7 + d2, d2 * 2.0, d2 * 2.0);
                graphics2D.fill(double_2);
                graphics2D.draw(double_2);
            }
        }
        if (this.medianVisible && (number = boxAndWhiskerCategoryDataset.getMedianValue(n, n2)) != null) {
            d = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
            graphics2D.draw(new Line2D.Double(d, d7, d, d7 + categoryItemRendererState.getBarWidth()));
        }
        if (categoryItemRendererState.getInfo() != null && double_ != null && (entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            this.addItemEntity(entityCollection, categoryDataset, n, n2, double_);
        }
    }

    public void drawVerticalItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Object object;
        Number number;
        Number number2;
        Object object2;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = (BoxAndWhiskerCategoryDataset)categoryDataset;
        double d7 = categoryAxis.getCategoryEnd(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d8 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d9 = d7 - d8;
        double d10 = d8;
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            d6 = rectangle2D.getWidth() * this.getItemMargin() / (double)(n4 * (n3 - 1));
            d5 = categoryItemRendererState.getBarWidth() * (double)n3 + d6 * (double)(n3 - 1);
            double d11 = (d9 - d5) / 2.0;
            d10 = d10 + d11 + (double)n * (categoryItemRendererState.getBarWidth() + d6);
        } else {
            d6 = (d9 - categoryItemRendererState.getBarWidth()) / 2.0;
            d10 += d6;
        }
        d6 = 0.0;
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        double d12 = 0.0;
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number3 = boxAndWhiskerCategoryDataset.getQ1Value(n, n2);
        Number number4 = boxAndWhiskerCategoryDataset.getQ3Value(n, n2);
        Number number5 = boxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2);
        Number number6 = boxAndWhiskerCategoryDataset.getMinRegularValue(n, n2);
        Rectangle2D.Double double_ = null;
        if (number3 != null && number4 != null && number5 != null && number6 != null) {
            d4 = valueAxis.valueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
            d3 = valueAxis.valueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
            d2 = valueAxis.valueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
            double d13 = valueAxis.valueToJava2D(number6.doubleValue(), rectangle2D, rectangleEdge);
            double d14 = d10 + categoryItemRendererState.getBarWidth() / 2.0;
            d = categoryItemRendererState.getBarWidth() / 2.0 * this.whiskerWidth;
            double_ = new Rectangle2D.Double(d10, Math.min(d4, d3), categoryItemRendererState.getBarWidth(), Math.abs(d4 - d3));
            if (this.fillBox) {
                graphics2D.fill(double_);
            }
            object2 = this.getItemOutlinePaint(n, n2);
            if (this.useOutlinePaintForWhiskers) {
                graphics2D.setPaint((Paint)object2);
            }
            graphics2D.draw(new Line2D.Double(d14, d2, d14, d3));
            graphics2D.draw(new Line2D.Double(d14 - d, d2, d14 + d, d2));
            graphics2D.draw(new Line2D.Double(d14, d13, d14, d4));
            graphics2D.draw(new Line2D.Double(d14 - d, d13, d14 + d, d13));
            graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
            graphics2D.setPaint((Paint)object2);
            graphics2D.draw(double_);
        }
        graphics2D.setPaint(this.artifactPaint);
        if (this.meanVisible && (number2 = boxAndWhiskerCategoryDataset.getMeanValue(n, n2)) != null) {
            d6 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            d12 = categoryItemRendererState.getBarWidth() / 4.0;
            if (d6 > rectangle2D.getMinY() - d12 && d6 < rectangle2D.getMaxY() + d12) {
                Ellipse2D.Double double_2 = new Ellipse2D.Double(d10 + d12, d6 - d12, d12 * 2.0, d12 * 2.0);
                graphics2D.fill(double_2);
                graphics2D.draw(double_2);
            }
        }
        if (this.medianVisible && (number = boxAndWhiskerCategoryDataset.getMedianValue(n, n2)) != null) {
            double d15 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
            graphics2D.draw(new Line2D.Double(d10, d15, d10 + categoryItemRendererState.getBarWidth(), d15));
        }
        d4 = valueAxis.valueToJava2D(valueAxis.getUpperBound(), rectangle2D, rectangleEdge) + d12;
        d3 = valueAxis.valueToJava2D(valueAxis.getLowerBound(), rectangle2D, rectangleEdge) - d12;
        graphics2D.setPaint(paint);
        d2 = categoryItemRendererState.getBarWidth() / 3.0;
        ArrayList<Outlier> arrayList = new ArrayList<Outlier>();
        OutlierListCollection outlierListCollection = new OutlierListCollection();
        List list = boxAndWhiskerCategoryDataset.getOutliers(n, n2);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                d = ((Number)list.get(i)).doubleValue();
                object2 = boxAndWhiskerCategoryDataset.getMinOutlier(n, n2);
                Number number7 = boxAndWhiskerCategoryDataset.getMaxOutlier(n, n2);
                Number number8 = boxAndWhiskerCategoryDataset.getMinRegularValue(n, n2);
                Number number9 = boxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2);
                if (d > number7.doubleValue()) {
                    outlierListCollection.setHighFarOut(true);
                } else if (d < ((Number)object2).doubleValue()) {
                    outlierListCollection.setLowFarOut(true);
                } else if (d > number9.doubleValue()) {
                    d5 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
                    arrayList.add(new Outlier(d10 + categoryItemRendererState.getBarWidth() / 2.0, d5, d2));
                } else if (d < number8.doubleValue()) {
                    d5 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
                    arrayList.add(new Outlier(d10 + categoryItemRendererState.getBarWidth() / 2.0, d5, d2));
                }
                Collections.sort(arrayList);
            }
            for (Outlier outlier : arrayList) {
                outlierListCollection.add(outlier);
            }
            object = outlierListCollection.iterator();
            while (object.hasNext()) {
                OutlierList outlierList = (OutlierList)object.next();
                Outlier outlier = outlierList.getAveragedOutlier();
                object2 = outlier.getPoint();
                if (outlierList.isMultiple()) {
                    this.drawMultipleEllipse((Point2D)object2, categoryItemRendererState.getBarWidth(), d2, graphics2D);
                    continue;
                }
                this.drawEllipse((Point2D)object2, d2, graphics2D);
            }
            if (outlierListCollection.isHighFarOut()) {
                this.drawHighFarOut(d12 / 2.0, graphics2D, d10 + categoryItemRendererState.getBarWidth() / 2.0, d4);
            }
            if (outlierListCollection.isLowFarOut()) {
                this.drawLowFarOut(d12 / 2.0, graphics2D, d10 + categoryItemRendererState.getBarWidth() / 2.0, d3);
            }
        }
        if (categoryItemRendererState.getInfo() != null && double_ != null && (object = categoryItemRendererState.getEntityCollection()) != null) {
            this.addItemEntity((EntityCollection)object, categoryDataset, n, n2, double_);
        }
    }

    private void drawEllipse(Point2D point2D, double d, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() + d / 2.0, point2D.getY(), d, d);
        graphics2D.draw(double_);
    }

    private void drawMultipleEllipse(Point2D point2D, double d, double d2, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() - d / 2.0 + d2, point2D.getY(), d2, d2);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(point2D.getX() + d / 2.0, point2D.getY(), d2, d2);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    private void drawHighFarOut(double d, Graphics2D graphics2D, double d2, double d3) {
        double d4 = d * 2.0;
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2 + d4, d3 + d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2, d3));
        graphics2D.draw(new Line2D.Double(d2 + d4, d3 + d4, d2, d3));
    }

    private void drawLowFarOut(double d, Graphics2D graphics2D, double d2, double d3) {
        double d4 = d * 2.0;
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2 + d4, d3 - d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2, d3));
        graphics2D.draw(new Line2D.Double(d2 + d4, d3 - d4, d2, d3));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BoxAndWhiskerRenderer)) {
            return false;
        }
        BoxAndWhiskerRenderer boxAndWhiskerRenderer = (BoxAndWhiskerRenderer)object;
        if (this.fillBox != boxAndWhiskerRenderer.fillBox) {
            return false;
        }
        if (this.itemMargin != boxAndWhiskerRenderer.itemMargin) {
            return false;
        }
        if (this.maximumBarWidth != boxAndWhiskerRenderer.maximumBarWidth) {
            return false;
        }
        if (this.meanVisible != boxAndWhiskerRenderer.meanVisible) {
            return false;
        }
        if (this.medianVisible != boxAndWhiskerRenderer.medianVisible) {
            return false;
        }
        if (this.useOutlinePaintForWhiskers != boxAndWhiskerRenderer.useOutlinePaintForWhiskers) {
            return false;
        }
        if (this.whiskerWidth != boxAndWhiskerRenderer.whiskerWidth) {
            return false;
        }
        if (!PaintUtilities.equal(this.artifactPaint, boxAndWhiskerRenderer.artifactPaint)) {
            return false;
        }
        return super.equals(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.artifactPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.artifactPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

