/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.CategoryItemLabelGenerator;
import ai.org.jfree.chart.labels.ItemLabelAnchor;
import ai.org.jfree.chart.labels.ItemLabelPosition;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import ai.org.jfree.chart.renderer.category.BarPainter;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.chart.renderer.category.GradientBarPainter;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.GradientPaintTransformer;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.StandardGradientPaintTransformer;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BarRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 6000649414965887481L;
    public static final double DEFAULT_ITEM_MARGIN = 0.2;
    public static final double BAR_OUTLINE_WIDTH_THRESHOLD = 3.0;
    private static BarPainter defaultBarPainter = new GradientBarPainter();
    private static boolean defaultShadowsVisible = true;
    private double itemMargin = 0.2;
    private boolean drawBarOutline = false;
    private double maximumBarWidth = 1.0;
    private double minimumBarLength = 0.0;
    private GradientPaintTransformer gradientPaintTransformer = new StandardGradientPaintTransformer();
    private ItemLabelPosition positiveItemLabelPositionFallback = null;
    private ItemLabelPosition negativeItemLabelPositionFallback = null;
    private double upperClip;
    private double lowerClip;
    private double base = 0.0;
    private boolean includeBaseInRange = true;
    private BarPainter barPainter;
    private boolean shadowsVisible;
    private transient Paint shadowPaint;
    private double shadowXOffset;
    private double shadowYOffset;

    public static BarPainter getDefaultBarPainter() {
        return defaultBarPainter;
    }

    public static void setDefaultBarPainter(BarPainter barPainter) {
        if (barPainter == null) {
            throw new IllegalArgumentException("Null 'painter' argument.");
        }
        defaultBarPainter = barPainter;
    }

    public static boolean getDefaultShadowsVisible() {
        return defaultShadowsVisible;
    }

    public static void setDefaultShadowsVisible(boolean bl) {
        defaultShadowsVisible = bl;
    }

    public BarRenderer() {
        this.setBaseLegendShape(new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0));
        this.barPainter = BarRenderer.getDefaultBarPainter();
        this.shadowsVisible = BarRenderer.getDefaultShadowsVisible();
        this.shadowPaint = Color.gray;
        this.shadowXOffset = 4.0;
        this.shadowYOffset = 4.0;
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double d) {
        this.base = d;
        this.fireChangeEvent();
    }

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double d) {
        this.itemMargin = d;
        this.fireChangeEvent();
    }

    public boolean isDrawBarOutline() {
        return this.drawBarOutline;
    }

    public void setDrawBarOutline(boolean bl) {
        this.drawBarOutline = bl;
        this.fireChangeEvent();
    }

    public double getMaximumBarWidth() {
        return this.maximumBarWidth;
    }

    public void setMaximumBarWidth(double d) {
        this.maximumBarWidth = d;
        this.fireChangeEvent();
    }

    public double getMinimumBarLength() {
        return this.minimumBarLength;
    }

    public void setMinimumBarLength(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Requires 'min' >= 0.0");
        }
        this.minimumBarLength = d;
        this.fireChangeEvent();
    }

    public GradientPaintTransformer getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientPaintTransformer(GradientPaintTransformer gradientPaintTransformer) {
        this.gradientPaintTransformer = gradientPaintTransformer;
        this.fireChangeEvent();
    }

    public ItemLabelPosition getPositiveItemLabelPositionFallback() {
        return this.positiveItemLabelPositionFallback;
    }

    public void setPositiveItemLabelPositionFallback(ItemLabelPosition itemLabelPosition) {
        this.positiveItemLabelPositionFallback = itemLabelPosition;
        this.fireChangeEvent();
    }

    public ItemLabelPosition getNegativeItemLabelPositionFallback() {
        return this.negativeItemLabelPositionFallback;
    }

    public void setNegativeItemLabelPositionFallback(ItemLabelPosition itemLabelPosition) {
        this.negativeItemLabelPositionFallback = itemLabelPosition;
        this.fireChangeEvent();
    }

    public boolean getIncludeBaseInRange() {
        return this.includeBaseInRange;
    }

    public void setIncludeBaseInRange(boolean bl) {
        if (this.includeBaseInRange != bl) {
            this.includeBaseInRange = bl;
            this.fireChangeEvent();
        }
    }

    public BarPainter getBarPainter() {
        return this.barPainter;
    }

    public void setBarPainter(BarPainter barPainter) {
        if (barPainter == null) {
            throw new IllegalArgumentException("Null 'painter' argument.");
        }
        this.barPainter = barPainter;
        this.fireChangeEvent();
    }

    public boolean getShadowsVisible() {
        return this.shadowsVisible;
    }

    public void setShadowVisible(boolean bl) {
        this.shadowsVisible = bl;
        this.fireChangeEvent();
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.shadowPaint = paint;
        this.fireChangeEvent();
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double d) {
        this.shadowXOffset = d;
        this.fireChangeEvent();
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double d) {
        this.shadowYOffset = d;
        this.fireChangeEvent();
    }

    public double getLowerClip() {
        return this.lowerClip;
    }

    public double getUpperClip() {
        return this.upperClip;
    }

    public CategoryItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, int n, PlotRenderingInfo plotRenderingInfo) {
        CategoryItemRendererState categoryItemRendererState = super.initialise(graphics2D, rectangle2D, categoryPlot, n, plotRenderingInfo);
        ValueAxis valueAxis = categoryPlot.getRangeAxisForDataset(n);
        this.lowerClip = valueAxis.getRange().getLowerBound();
        this.upperClip = valueAxis.getRange().getUpperBound();
        this.calculateBarWidth(categoryPlot, rectangle2D, n, categoryItemRendererState);
        return categoryItemRendererState;
    }

    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, int n, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        if (categoryDataset != null) {
            int n2 = categoryDataset.getColumnCount();
            int n3 = categoryItemRendererState.getVisibleSeriesCount() >= 0 ? categoryItemRendererState.getVisibleSeriesCount() : categoryDataset.getRowCount();
            double d = 0.0;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = d * this.getMaximumBarWidth();
            double d3 = 0.0;
            double d4 = 0.0;
            if (n2 > 1) {
                d3 = categoryAxis.getCategoryMargin();
            }
            if (n3 > 1) {
                d4 = this.getItemMargin();
            }
            double d5 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d3 - d4);
            if (n3 * n2 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d5 / (double)(n3 * n2), d2));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d5, d2));
            }
        }
    }

    protected double calculateBarW0(CategoryPlot categoryPlot, PlotOrientation plotOrientation, Rectangle2D rectangle2D, CategoryAxis categoryAxis, CategoryItemRendererState categoryItemRendererState, int n, int n2) {
        double d = 0.0;
        d = plotOrientation == PlotOrientation.HORIZONTAL ? rectangle2D.getHeight() : rectangle2D.getWidth();
        double d2 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        int n3 = categoryItemRendererState.getVisibleSeriesCount() >= 0 ? categoryItemRendererState.getVisibleSeriesCount() : this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            double d3 = d * this.getItemMargin() / (double)(n4 * (n3 - 1));
            double d4 = this.calculateSeriesWidth(d, categoryAxis, n4, n3);
            d2 = d2 + (double)n * (d4 + d3) + d4 / 2.0 - categoryItemRendererState.getBarWidth() / 2.0;
        } else {
            d2 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        }
        return d2;
    }

    protected double[] calculateBarL0L1(double d) {
        double d2 = this.getLowerClip();
        double d3 = this.getUpperClip();
        double d4 = Math.min(this.base, d);
        double d5 = Math.max(this.base, d);
        if (d5 < d2) {
            return null;
        }
        if (d4 > d3) {
            return null;
        }
        d4 = Math.max(d4, d2);
        d5 = Math.min(d5, d3);
        return new double[]{d4, d5};
    }

    public Range findRangeBounds(CategoryDataset categoryDataset, boolean bl) {
        if (categoryDataset == null) {
            return null;
        }
        Range range = super.findRangeBounds(categoryDataset, bl);
        if (range != null && this.includeBaseInRange) {
            range = Range.expandToInclude(range, this.base);
        }
        return range;
    }

    public LegendItem getLegendItem(int n, int n2) {
        String string;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        if (!this.isSeriesVisible(n2) || !this.isSeriesVisibleInLegend(n2)) {
            return null;
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        String string2 = string = this.getLegendItemLabelGenerator().generateLabel(categoryDataset, n2);
        String string3 = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            string3 = this.getLegendItemToolTipGenerator().generateLabel(categoryDataset, n2);
        }
        String string4 = null;
        if (this.getLegendItemURLGenerator() != null) {
            string4 = this.getLegendItemURLGenerator().generateLabel(categoryDataset, n2);
        }
        Shape shape = this.lookupLegendShape(n2);
        Paint paint = this.lookupSeriesPaint(n2);
        Paint paint2 = this.lookupSeriesOutlinePaint(n2);
        Stroke stroke = this.lookupSeriesOutlineStroke(n2);
        LegendItem legendItem = new LegendItem(string, string2, string3, string4, true, shape, true, paint, this.isDrawBarOutline(), paint2, stroke, false, (Shape)new Line2D.Float(), (Stroke)new BasicStroke(1.0f), (Paint)Color.black);
        legendItem.setLabelFont(this.lookupLegendTextFont(n2));
        Paint paint3 = this.lookupLegendTextPaint(n2);
        if (paint3 != null) {
            legendItem.setLabelPaint(paint3);
        }
        legendItem.setDataset(categoryDataset);
        legendItem.setDatasetIndex(n);
        legendItem.setSeriesKey(categoryDataset.getRowKey(n2));
        legendItem.setSeriesIndex(n2);
        if (this.gradientPaintTransformer != null) {
            legendItem.setFillPaintTransformer(this.gradientPaintTransformer);
        }
        return legendItem;
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        RectangleEdge rectangleEdge;
        int n4 = categoryItemRendererState.getVisibleSeriesIndex(n);
        if (n4 < 0) {
            return;
        }
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d2 = this.calculateBarW0(categoryPlot, plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, n4, n2);
        double[] dArray = this.calculateBarL0L1(d);
        if (dArray == null) {
            return;
        }
        RectangleEdge rectangleEdge2 = categoryPlot.getRangeAxisEdge();
        double d3 = valueAxis.valueToJava2D(dArray[0], rectangle2D, rectangleEdge2);
        double d4 = valueAxis.valueToJava2D(dArray[1], rectangle2D, rectangleEdge2);
        boolean bl = d >= this.base;
        boolean bl2 = valueAxis.isInverted();
        double d5 = Math.min(d3, d4);
        double d6 = Math.abs(d4 - d3);
        double d7 = 0.0;
        if (d6 > 0.0 && d6 < this.getMinimumBarLength()) {
            d7 = this.getMinimumBarLength() - d6;
        }
        double d8 = 0.0;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            if (bl && bl2 || !bl && !bl2) {
                d8 = d7;
                rectangleEdge = RectangleEdge.RIGHT;
            } else {
                rectangleEdge = RectangleEdge.LEFT;
            }
        } else if (bl && !bl2 || !bl && bl2) {
            d8 = d7;
            rectangleEdge = RectangleEdge.BOTTOM;
        } else {
            rectangleEdge = RectangleEdge.TOP;
        }
        Rectangle2D.Double double_ = null;
        double_ = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d5 - d8, d2, d6 + d7, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d2, d5 - d8, categoryItemRendererState.getBarWidth(), d6 + d7);
        if (this.getShadowsVisible()) {
            this.barPainter.paintBarShadow(graphics2D, this, n, n2, double_, rectangleEdge, true);
        }
        this.barPainter.paintBar(graphics2D, this, n, n2, double_, rectangleEdge);
        CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
        if (categoryItemLabelGenerator != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, d < 0.0);
        }
        int n5 = categoryPlot.indexOf(categoryDataset);
        this.updateCrosshairValues(categoryItemRendererState.getCrosshairState(), categoryDataset.getRowKey(n), categoryDataset.getColumnKey(n2), d, n5, d2, d5, plotOrientation);
        EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
        if (entityCollection != null) {
            this.addItemEntity(entityCollection, categoryDataset, n, n2, double_);
        }
    }

    protected double calculateSeriesWidth(double d, CategoryAxis categoryAxis, int n, int n2) {
        double d2 = 1.0 - this.getItemMargin() - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin();
        if (n > 1) {
            d2 -= categoryAxis.getCategoryMargin();
        }
        return d * d2 / (double)(n * n2);
    }

    protected void drawItemLabel(Graphics2D graphics2D, CategoryDataset categoryDataset, int n, int n2, CategoryPlot categoryPlot, CategoryItemLabelGenerator categoryItemLabelGenerator, Rectangle2D rectangle2D, boolean bl) {
        Shape shape;
        String string = categoryItemLabelGenerator.generateLabel(categoryDataset, n, n2);
        if (string == null) {
            return;
        }
        Font font = this.getItemLabelFont(n, n2);
        graphics2D.setFont(font);
        Paint paint = this.getItemLabelPaint(n, n2);
        graphics2D.setPaint(paint);
        ItemLabelPosition itemLabelPosition = null;
        itemLabelPosition = !bl ? this.getPositiveItemLabelPosition(n, n2) : this.getNegativeItemLabelPosition(n, n2);
        Point2D point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), rectangle2D, categoryPlot.getOrientation());
        if (this.isInternalAnchor(itemLabelPosition.getItemLabelAnchor()) && (shape = TextUtilities.calculateRotatedStringBounds(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getAngle(), itemLabelPosition.getRotationAnchor())) != null && !rectangle2D.contains(shape.getBounds2D()) && (itemLabelPosition = !bl ? this.getPositiveItemLabelPositionFallback() : this.getNegativeItemLabelPositionFallback()) != null) {
            point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), rectangle2D, categoryPlot.getOrientation());
        }
        if (itemLabelPosition != null) {
            TextUtilities.drawRotatedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getAngle(), itemLabelPosition.getRotationAnchor());
        }
    }

    private Point2D calculateLabelAnchorPoint(ItemLabelAnchor itemLabelAnchor, Rectangle2D rectangle2D, PlotOrientation plotOrientation) {
        Point2D.Double double_ = null;
        double d = this.getItemLabelAnchorOffset();
        double d2 = rectangle2D.getX() - d;
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getX() + d;
        double d5 = rectangle2D.getCenterX();
        double d6 = rectangle2D.getMaxX() - d;
        double d7 = rectangle2D.getMaxX();
        double d8 = rectangle2D.getMaxX() + d;
        double d9 = rectangle2D.getMaxY() + d;
        double d10 = rectangle2D.getMaxY();
        double d11 = rectangle2D.getMaxY() - d;
        double d12 = rectangle2D.getCenterY();
        double d13 = rectangle2D.getMinY() + d;
        double d14 = rectangle2D.getMinY();
        double d15 = rectangle2D.getMinY() - d;
        if (itemLabelAnchor == ItemLabelAnchor.CENTER) {
            double_ = new Point2D.Double(d5, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE1) {
            double_ = new Point2D.Double(d6, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE2) {
            double_ = new Point2D.Double(d6, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE3) {
            double_ = new Point2D.Double(d6, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE4) {
            double_ = new Point2D.Double(d6, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE5) {
            double_ = new Point2D.Double(d6, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE6) {
            double_ = new Point2D.Double(d5, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE7) {
            double_ = new Point2D.Double(d4, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE8) {
            double_ = new Point2D.Double(d4, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE9) {
            double_ = new Point2D.Double(d4, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE10) {
            double_ = new Point2D.Double(d4, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE11) {
            double_ = new Point2D.Double(d4, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE12) {
            double_ = new Point2D.Double(d5, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE1) {
            double_ = new Point2D.Double(d7, d15);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE2) {
            double_ = new Point2D.Double(d8, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE3) {
            double_ = new Point2D.Double(d8, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE4) {
            double_ = new Point2D.Double(d8, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE5) {
            double_ = new Point2D.Double(d7, d9);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE6) {
            double_ = new Point2D.Double(d5, d9);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE7) {
            double_ = new Point2D.Double(d3, d9);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE8) {
            double_ = new Point2D.Double(d2, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE9) {
            double_ = new Point2D.Double(d2, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE10) {
            double_ = new Point2D.Double(d2, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE11) {
            double_ = new Point2D.Double(d3, d15);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE12) {
            double_ = new Point2D.Double(d5, d15);
        }
        return double_;
    }

    private boolean isInternalAnchor(ItemLabelAnchor itemLabelAnchor) {
        return itemLabelAnchor == ItemLabelAnchor.CENTER || itemLabelAnchor == ItemLabelAnchor.INSIDE1 || itemLabelAnchor == ItemLabelAnchor.INSIDE2 || itemLabelAnchor == ItemLabelAnchor.INSIDE3 || itemLabelAnchor == ItemLabelAnchor.INSIDE4 || itemLabelAnchor == ItemLabelAnchor.INSIDE5 || itemLabelAnchor == ItemLabelAnchor.INSIDE6 || itemLabelAnchor == ItemLabelAnchor.INSIDE7 || itemLabelAnchor == ItemLabelAnchor.INSIDE8 || itemLabelAnchor == ItemLabelAnchor.INSIDE9 || itemLabelAnchor == ItemLabelAnchor.INSIDE10 || itemLabelAnchor == ItemLabelAnchor.INSIDE11 || itemLabelAnchor == ItemLabelAnchor.INSIDE12;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BarRenderer)) {
            return false;
        }
        BarRenderer barRenderer = (BarRenderer)object;
        if (this.base != barRenderer.base) {
            return false;
        }
        if (this.itemMargin != barRenderer.itemMargin) {
            return false;
        }
        if (this.drawBarOutline != barRenderer.drawBarOutline) {
            return false;
        }
        if (this.maximumBarWidth != barRenderer.maximumBarWidth) {
            return false;
        }
        if (this.minimumBarLength != barRenderer.minimumBarLength) {
            return false;
        }
        if (!ObjectUtilities.equal(this.gradientPaintTransformer, barRenderer.gradientPaintTransformer)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.positiveItemLabelPositionFallback, barRenderer.positiveItemLabelPositionFallback)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.negativeItemLabelPositionFallback, barRenderer.negativeItemLabelPositionFallback)) {
            return false;
        }
        if (!this.barPainter.equals(barRenderer.barPainter)) {
            return false;
        }
        if (this.shadowsVisible != barRenderer.shadowsVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.shadowPaint, barRenderer.shadowPaint)) {
            return false;
        }
        if (this.shadowXOffset != barRenderer.shadowXOffset) {
            return false;
        }
        if (this.shadowYOffset != barRenderer.shadowYOffset) {
            return false;
        }
        return super.equals(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.shadowPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.shadowPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

