/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.AreaRendererEndType;
import ai.org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class AreaRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -4231878281385812757L;
    private AreaRendererEndType endType = AreaRendererEndType.TAPER;

    public AreaRenderer() {
        this.setBaseLegendShape(new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0));
    }

    public AreaRendererEndType getEndType() {
        return this.endType;
    }

    public void setEndType(AreaRendererEndType areaRendererEndType) {
        if (areaRendererEndType == null) {
            throw new IllegalArgumentException("Null 'type' argument.");
        }
        this.endType = areaRendererEndType;
        this.fireChangeEvent();
    }

    public LegendItem getLegendItem(int n, int n2) {
        String string;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        if (!this.isSeriesVisible(n2) || !this.isSeriesVisibleInLegend(n2)) {
            return null;
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        String string2 = string = this.getLegendItemLabelGenerator().generateLabel(categoryDataset, n2);
        String string3 = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            string3 = this.getLegendItemToolTipGenerator().generateLabel(categoryDataset, n2);
        }
        String string4 = null;
        if (this.getLegendItemURLGenerator() != null) {
            string4 = this.getLegendItemURLGenerator().generateLabel(categoryDataset, n2);
        }
        Shape shape = this.lookupLegendShape(n2);
        Paint paint = this.lookupSeriesPaint(n2);
        Paint paint2 = this.lookupSeriesOutlinePaint(n2);
        Stroke stroke = this.lookupSeriesOutlineStroke(n2);
        LegendItem legendItem = new LegendItem(string, string2, string3, string4, shape, paint, stroke, paint2);
        legendItem.setLabelFont(this.lookupLegendTextFont(n2));
        Paint paint3 = this.lookupLegendTextPaint(n2);
        if (paint3 != null) {
            legendItem.setLabelPaint(paint3);
        }
        legendItem.setDataset(categoryDataset);
        legendItem.setDatasetIndex(n);
        legendItem.setSeriesKey(categoryDataset.getRowKey(n2));
        legendItem.setSeriesIndex(n2);
        return legendItem;
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Serializable serializable;
        Number number;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        Number number2 = categoryDataset.getValue(n, n2);
        if (number2 == null) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        RectangleEdge rectangleEdge = categoryPlot.getDomainAxisEdge();
        int n4 = categoryDataset.getColumnCount();
        float f = (float)categoryAxis.getCategoryStart(n2, n4, rectangle2D, rectangleEdge);
        float f2 = (float)categoryAxis.getCategoryMiddle(n2, n4, rectangle2D, rectangleEdge);
        float f3 = (float)categoryAxis.getCategoryEnd(n2, n4, rectangle2D, rectangleEdge);
        f = Math.round(f);
        f2 = Math.round(f2);
        f3 = Math.round(f3);
        if (this.endType == AreaRendererEndType.TRUNCATE) {
            if (n2 == 0) {
                f = f2;
            } else if (n2 == this.getColumnCount() - 1) {
                f3 = f2;
            }
        }
        double d = number2.doubleValue();
        double d2 = 0.0;
        if (this.endType == AreaRendererEndType.LEVEL) {
            d2 = d;
        }
        if (n2 > 0 && (number = categoryDataset.getValue(n, n2 - 1)) != null) {
            d2 = (number.doubleValue() + d) / 2.0;
        }
        double d3 = 0.0;
        if (n2 < categoryDataset.getColumnCount() - 1) {
            serializable = categoryDataset.getValue(n, n2 + 1);
            if (serializable != null) {
                d3 = (((Number)serializable).doubleValue() + d) / 2.0;
            }
        } else if (this.endType == AreaRendererEndType.LEVEL) {
            d3 = d;
        }
        serializable = categoryPlot.getRangeAxisEdge();
        float f4 = (float)valueAxis.valueToJava2D(d2, rectangle2D, (RectangleEdge)serializable);
        float f5 = (float)valueAxis.valueToJava2D(d, rectangle2D, (RectangleEdge)serializable);
        float f6 = (float)valueAxis.valueToJava2D(d3, rectangle2D, (RectangleEdge)serializable);
        float f7 = (float)valueAxis.valueToJava2D(0.0, rectangle2D, (RectangleEdge)serializable);
        double d4 = f2;
        double d5 = f5;
        graphics2D.setPaint(this.getItemPaint(n, n2));
        graphics2D.setStroke(this.getItemStroke(n, n2));
        GeneralPath generalPath = new GeneralPath();
        if (plotOrientation == PlotOrientation.VERTICAL) {
            generalPath.moveTo(f, f7);
            generalPath.lineTo(f, f4);
            generalPath.lineTo(f2, f5);
            generalPath.lineTo(f3, f6);
            generalPath.lineTo(f3, f7);
        } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
            generalPath.moveTo(f7, f);
            generalPath.lineTo(f4, f);
            generalPath.lineTo(f5, f2);
            generalPath.lineTo(f6, f3);
            generalPath.lineTo(f7, f3);
            double d6 = d4;
            d4 = d5;
            d5 = d6;
        }
        generalPath.closePath();
        graphics2D.setPaint(this.getItemPaint(n, n2));
        graphics2D.fill(generalPath);
        if (this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, d4, d5, number2.doubleValue() < 0.0);
        }
        int n5 = categoryPlot.indexOf(categoryDataset);
        this.updateCrosshairValues(categoryItemRendererState.getCrosshairState(), categoryDataset.getRowKey(n), categoryDataset.getColumnKey(n2), d, n5, f2, f5, plotOrientation);
        EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
        if (entityCollection != null) {
            this.addItemEntity(entityCollection, categoryDataset, n, n2, generalPath);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AreaRenderer)) {
            return false;
        }
        AreaRenderer areaRenderer = (AreaRenderer)object;
        if (!this.endType.equals(areaRenderer.endType)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

