/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.LegendItemCollection;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.CategoryItemEntity;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.CategoryItemLabelGenerator;
import ai.org.jfree.chart.labels.CategorySeriesLabelGenerator;
import ai.org.jfree.chart.labels.CategoryToolTipGenerator;
import ai.org.jfree.chart.labels.ItemLabelPosition;
import ai.org.jfree.chart.labels.StandardCategorySeriesLabelGenerator;
import ai.org.jfree.chart.plot.CategoryCrosshairState;
import ai.org.jfree.chart.plot.CategoryMarker;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.DrawingSupplier;
import ai.org.jfree.chart.plot.IntervalMarker;
import ai.org.jfree.chart.plot.Marker;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.ValueMarker;
import ai.org.jfree.chart.renderer.AbstractRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.chart.urls.CategoryURLGenerator;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.LengthAdjustmentType;
import ai.org.jfree.ui.RectangleAnchor;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.util.ObjectList;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.SortOrder;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class AbstractCategoryItemRenderer
extends AbstractRenderer
implements CategoryItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 1247553218442497391L;
    private CategoryPlot plot;
    private ObjectList itemLabelGeneratorList = new ObjectList();
    private CategoryItemLabelGenerator baseItemLabelGenerator;
    private ObjectList toolTipGeneratorList = new ObjectList();
    private CategoryToolTipGenerator baseToolTipGenerator;
    private ObjectList itemURLGeneratorList = new ObjectList();
    private CategoryURLGenerator baseItemURLGenerator;
    private CategorySeriesLabelGenerator legendItemLabelGenerator = new StandardCategorySeriesLabelGenerator();
    private CategorySeriesLabelGenerator legendItemToolTipGenerator;
    private CategorySeriesLabelGenerator legendItemURLGenerator;
    private transient int rowCount;
    private transient int columnCount;
    private CategoryItemLabelGenerator itemLabelGenerator = null;
    private CategoryToolTipGenerator toolTipGenerator = null;
    private CategoryURLGenerator itemURLGenerator = null;

    protected AbstractCategoryItemRenderer() {
    }

    public int getPassCount() {
        return 1;
    }

    public CategoryPlot getPlot() {
        return this.plot;
    }

    public void setPlot(CategoryPlot categoryPlot) {
        if (categoryPlot == null) {
            throw new IllegalArgumentException("Null 'plot' argument.");
        }
        this.plot = categoryPlot;
    }

    public CategoryItemLabelGenerator getItemLabelGenerator(int n, int n2) {
        return this.getSeriesItemLabelGenerator(n);
    }

    public CategoryItemLabelGenerator getSeriesItemLabelGenerator(int n) {
        if (this.itemLabelGenerator != null) {
            return this.itemLabelGenerator;
        }
        CategoryItemLabelGenerator categoryItemLabelGenerator = (CategoryItemLabelGenerator)this.itemLabelGeneratorList.get(n);
        if (categoryItemLabelGenerator == null) {
            categoryItemLabelGenerator = this.baseItemLabelGenerator;
        }
        return categoryItemLabelGenerator;
    }

    public void setSeriesItemLabelGenerator(int n, CategoryItemLabelGenerator categoryItemLabelGenerator) {
        this.itemLabelGeneratorList.set(n, categoryItemLabelGenerator);
        this.fireChangeEvent();
    }

    public CategoryItemLabelGenerator getBaseItemLabelGenerator() {
        return this.baseItemLabelGenerator;
    }

    public void setBaseItemLabelGenerator(CategoryItemLabelGenerator categoryItemLabelGenerator) {
        this.baseItemLabelGenerator = categoryItemLabelGenerator;
        this.fireChangeEvent();
    }

    public CategoryToolTipGenerator getToolTipGenerator(int n, int n2) {
        CategoryToolTipGenerator categoryToolTipGenerator = null;
        if (this.toolTipGenerator != null) {
            categoryToolTipGenerator = this.toolTipGenerator;
        } else {
            categoryToolTipGenerator = this.getSeriesToolTipGenerator(n);
            if (categoryToolTipGenerator == null) {
                categoryToolTipGenerator = this.baseToolTipGenerator;
            }
        }
        return categoryToolTipGenerator;
    }

    public CategoryToolTipGenerator getSeriesToolTipGenerator(int n) {
        return (CategoryToolTipGenerator)this.toolTipGeneratorList.get(n);
    }

    public void setSeriesToolTipGenerator(int n, CategoryToolTipGenerator categoryToolTipGenerator) {
        this.toolTipGeneratorList.set(n, categoryToolTipGenerator);
        this.fireChangeEvent();
    }

    public CategoryToolTipGenerator getBaseToolTipGenerator() {
        return this.baseToolTipGenerator;
    }

    public void setBaseToolTipGenerator(CategoryToolTipGenerator categoryToolTipGenerator) {
        this.baseToolTipGenerator = categoryToolTipGenerator;
        this.fireChangeEvent();
    }

    public CategoryURLGenerator getItemURLGenerator(int n, int n2) {
        return this.getSeriesItemURLGenerator(n);
    }

    public CategoryURLGenerator getSeriesItemURLGenerator(int n) {
        if (this.itemURLGenerator != null) {
            return this.itemURLGenerator;
        }
        CategoryURLGenerator categoryURLGenerator = (CategoryURLGenerator)this.itemURLGeneratorList.get(n);
        if (categoryURLGenerator == null) {
            categoryURLGenerator = this.baseItemURLGenerator;
        }
        return categoryURLGenerator;
    }

    public void setSeriesItemURLGenerator(int n, CategoryURLGenerator categoryURLGenerator) {
        this.itemURLGeneratorList.set(n, categoryURLGenerator);
        this.fireChangeEvent();
    }

    public CategoryURLGenerator getBaseItemURLGenerator() {
        return this.baseItemURLGenerator;
    }

    public void setBaseItemURLGenerator(CategoryURLGenerator categoryURLGenerator) {
        this.baseItemURLGenerator = categoryURLGenerator;
        this.fireChangeEvent();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    protected CategoryItemRendererState createState(PlotRenderingInfo plotRenderingInfo) {
        return new CategoryItemRendererState(plotRenderingInfo);
    }

    public CategoryItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, int n, PlotRenderingInfo plotRenderingInfo) {
        this.setPlot(categoryPlot);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        if (categoryDataset != null) {
            this.rowCount = categoryDataset.getRowCount();
            this.columnCount = categoryDataset.getColumnCount();
        } else {
            this.rowCount = 0;
            this.columnCount = 0;
        }
        CategoryItemRendererState categoryItemRendererState = this.createState(plotRenderingInfo);
        int[] nArray = new int[this.rowCount];
        int n2 = 0;
        for (int i = 0; i < this.rowCount; ++i) {
            if (!this.isSeriesVisible(i)) continue;
            nArray[n2] = i;
            ++n2;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        categoryItemRendererState.setVisibleSeriesArray(nArray2);
        return categoryItemRendererState;
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        return this.findRangeBounds(categoryDataset, false);
    }

    protected Range findRangeBounds(CategoryDataset categoryDataset, boolean bl) {
        if (categoryDataset == null) {
            return null;
        }
        if (this.getDataBoundsIncludesVisibleSeriesOnly()) {
            ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
            int n = categoryDataset.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (!this.isSeriesVisible(i)) continue;
                arrayList.add(categoryDataset.getRowKey(i));
            }
            return DatasetUtilities.findRangeBounds(categoryDataset, arrayList, bl);
        }
        return DatasetUtilities.findRangeBounds(categoryDataset, bl);
    }

    public double getItemMiddle(Comparable comparable, Comparable comparable2, CategoryDataset categoryDataset, CategoryAxis categoryAxis, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return categoryAxis.getCategoryMiddle(comparable2, categoryDataset.getColumnKeys(), rectangle2D, rectangleEdge);
    }

    public void drawBackground(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        categoryPlot.drawBackground(graphics2D, rectangle2D);
    }

    public void drawOutline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        categoryPlot.drawOutline(graphics2D, rectangle2D);
    }

    public void drawDomainGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, double d) {
        Line2D.Double double_ = null;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d, rectangle2D.getMaxX(), d);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(d, rectangle2D.getMinY(), d, rectangle2D.getMaxY());
        }
        Paint paint = categoryPlot.getDomainGridlinePaint();
        if (paint == null) {
            paint = CategoryPlot.DEFAULT_GRIDLINE_PAINT;
        }
        graphics2D.setPaint(paint);
        Stroke stroke = categoryPlot.getDomainGridlineStroke();
        if (stroke == null) {
            stroke = CategoryPlot.DEFAULT_GRIDLINE_STROKE;
        }
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    public void drawRangeGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d2 = valueAxis.valueToJava2D(d, rectangle2D, categoryPlot.getRangeAxisEdge());
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        Paint paint = categoryPlot.getRangeGridlinePaint();
        if (paint == null) {
            paint = CategoryPlot.DEFAULT_GRIDLINE_PAINT;
        }
        graphics2D.setPaint(paint);
        Stroke stroke = categoryPlot.getRangeGridlineStroke();
        if (stroke == null) {
            stroke = CategoryPlot.DEFAULT_GRIDLINE_STROKE;
        }
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    public void drawRangeLine(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d, Paint paint, Stroke stroke) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        Line2D.Double double_ = null;
        double d2 = valueAxis.valueToJava2D(d, rectangle2D, categoryPlot.getRangeAxisEdge());
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    public void drawDomainMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, CategoryMarker categoryMarker, Rectangle2D rectangle2D) {
        double d;
        Comparable comparable = categoryMarker.getKey();
        CategoryDataset categoryDataset = categoryPlot.getDataset(categoryPlot.getIndexOf(this));
        int n = categoryDataset.getColumnIndex(comparable);
        if (n < 0) {
            return;
        }
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, categoryMarker.getAlpha()));
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        Rectangle2D rectangle2D2 = null;
        if (categoryMarker.getDrawAsLine()) {
            d = categoryAxis.getCategoryMiddle(n, categoryDataset.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(rectangle2D.getMinX(), d, rectangle2D.getMaxX(), d);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(d, rectangle2D.getMinY(), d, rectangle2D.getMaxY());
            }
            graphics2D.setPaint(categoryMarker.getPaint());
            graphics2D.setStroke(categoryMarker.getStroke());
            graphics2D.draw(double_);
            rectangle2D2 = double_.getBounds2D();
        } else {
            d = categoryAxis.getCategoryStart(n, categoryDataset.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d2 = categoryAxis.getCategoryEnd(n, categoryDataset.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            Rectangle2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Rectangle2D.Double(rectangle2D.getMinX(), d, rectangle2D.getWidth(), d2 - d);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Rectangle2D.Double(d, rectangle2D.getMinY(), d2 - d, rectangle2D.getHeight());
            }
            graphics2D.setPaint(categoryMarker.getPaint());
            graphics2D.fill(double_);
            rectangle2D2 = double_;
        }
        String string = categoryMarker.getLabel();
        RectangleAnchor rectangleAnchor = categoryMarker.getLabelAnchor();
        if (string != null) {
            Font font = categoryMarker.getLabelFont();
            graphics2D.setFont(font);
            graphics2D.setPaint(categoryMarker.getLabelPaint());
            Point2D point2D = this.calculateDomainMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, rectangle2D2, categoryMarker.getLabelOffset(), categoryMarker.getLabelOffsetType(), rectangleAnchor);
            TextUtilities.drawAlignedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), categoryMarker.getLabelTextAnchor());
        }
        graphics2D.setComposite(composite);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        if (marker instanceof ValueMarker) {
            ValueMarker valueMarker = (ValueMarker)marker;
            double d = valueMarker.getValue();
            Range range = valueAxis.getRange();
            if (!range.contains(d)) {
                return;
            }
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, marker.getAlpha()));
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d2 = valueAxis.valueToJava2D(d, rectangle2D, categoryPlot.getRangeAxisEdge());
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
            }
            graphics2D.setPaint(marker.getPaint());
            graphics2D.setStroke(marker.getStroke());
            graphics2D.draw(double_);
            String string = marker.getLabel();
            RectangleAnchor rectangleAnchor = marker.getLabelAnchor();
            if (string != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateRangeMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_.getBounds2D(), marker.getLabelOffset(), LengthAdjustmentType.EXPAND, rectangleAnchor);
                TextUtilities.drawAlignedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), marker.getLabelTextAnchor());
            }
            graphics2D.setComposite(composite);
        } else if (marker instanceof IntervalMarker) {
            Object object;
            Object object2;
            IntervalMarker intervalMarker = (IntervalMarker)marker;
            double d = intervalMarker.getStartValue();
            double d3 = intervalMarker.getEndValue();
            Range range = valueAxis.getRange();
            if (!range.intersects(d, d3)) {
                return;
            }
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, marker.getAlpha()));
            double d4 = valueAxis.valueToJava2D(d, rectangle2D, categoryPlot.getRangeAxisEdge());
            double d5 = valueAxis.valueToJava2D(d3, rectangle2D, categoryPlot.getRangeAxisEdge());
            double d6 = Math.min(d4, d5);
            double d7 = Math.max(d4, d5);
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            Rectangle2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d6 = Math.max(d6, rectangle2D.getMinX());
                d7 = Math.min(d7, rectangle2D.getMaxX());
                double_ = new Rectangle2D.Double(d6, rectangle2D.getMinY(), d7 - d6, rectangle2D.getHeight());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d6 = Math.max(d6, rectangle2D.getMinY());
                d7 = Math.min(d7, rectangle2D.getMaxY());
                double_ = new Rectangle2D.Double(rectangle2D.getMinX(), d6, rectangle2D.getWidth(), d7 - d6);
            }
            Paint paint = marker.getPaint();
            if (paint instanceof GradientPaint) {
                object2 = (GradientPaint)paint;
                object = intervalMarker.getGradientPaintTransformer();
                if (object != null) {
                    object2 = object.transform((GradientPaint)object2, double_);
                }
                graphics2D.setPaint((Paint)object2);
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(double_);
            if (intervalMarker.getOutlinePaint() != null && intervalMarker.getOutlineStroke() != null) {
                double d8;
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    object2 = new Line2D.Double();
                    double d9 = rectangle2D.getMinX();
                    d8 = rectangle2D.getMaxX();
                    graphics2D.setPaint(intervalMarker.getOutlinePaint());
                    graphics2D.setStroke(intervalMarker.getOutlineStroke());
                    if (range.contains(d)) {
                        ((Line2D)object2).setLine(d9, d4, d8, d4);
                        graphics2D.draw((Shape)object2);
                    }
                    if (range.contains(d3)) {
                        ((Line2D)object2).setLine(d9, d5, d8, d5);
                        graphics2D.draw((Shape)object2);
                    }
                } else {
                    object2 = new Line2D.Double();
                    double d10 = rectangle2D.getMinY();
                    d8 = rectangle2D.getMaxY();
                    graphics2D.setPaint(intervalMarker.getOutlinePaint());
                    graphics2D.setStroke(intervalMarker.getOutlineStroke());
                    if (range.contains(d)) {
                        ((Line2D)object2).setLine(d4, d10, d4, d8);
                        graphics2D.draw((Shape)object2);
                    }
                    if (range.contains(d3)) {
                        ((Line2D)object2).setLine(d5, d10, d5, d8);
                        graphics2D.draw((Shape)object2);
                    }
                }
            }
            object2 = marker.getLabel();
            object = marker.getLabelAnchor();
            if (object2 != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateRangeMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_, marker.getLabelOffset(), marker.getLabelOffsetType(), (RectangleAnchor)object);
                TextUtilities.drawAlignedString((String)object2, graphics2D, (float)point2D.getX(), (float)point2D.getY(), marker.getLabelTextAnchor());
            }
            graphics2D.setComposite(composite);
        }
    }

    protected Point2D calculateDomainMarkerTextAnchorPoint(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleInsets rectangleInsets, LengthAdjustmentType lengthAdjustmentType, RectangleAnchor rectangleAnchor) {
        Rectangle2D rectangle2D3 = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, LengthAdjustmentType.CONTRACT, lengthAdjustmentType);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, lengthAdjustmentType, LengthAdjustmentType.CONTRACT);
        }
        return RectangleAnchor.coordinates(rectangle2D3, rectangleAnchor);
    }

    protected Point2D calculateRangeMarkerTextAnchorPoint(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleInsets rectangleInsets, LengthAdjustmentType lengthAdjustmentType, RectangleAnchor rectangleAnchor) {
        Rectangle2D rectangle2D3 = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, lengthAdjustmentType, LengthAdjustmentType.CONTRACT);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, LengthAdjustmentType.CONTRACT, lengthAdjustmentType);
        }
        return RectangleAnchor.coordinates(rectangle2D3, rectangleAnchor);
    }

    public LegendItem getLegendItem(int n, int n2) {
        String string;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        if (!this.isSeriesVisible(n2) || !this.isSeriesVisibleInLegend(n2)) {
            return null;
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        String string2 = string = this.legendItemLabelGenerator.generateLabel(categoryDataset, n2);
        String string3 = null;
        if (this.legendItemToolTipGenerator != null) {
            string3 = this.legendItemToolTipGenerator.generateLabel(categoryDataset, n2);
        }
        String string4 = null;
        if (this.legendItemURLGenerator != null) {
            string4 = this.legendItemURLGenerator.generateLabel(categoryDataset, n2);
        }
        Shape shape = this.lookupLegendShape(n2);
        Paint paint = this.lookupSeriesPaint(n2);
        Paint paint2 = this.lookupSeriesOutlinePaint(n2);
        Stroke stroke = this.lookupSeriesOutlineStroke(n2);
        LegendItem legendItem = new LegendItem(string, string2, string3, string4, shape, paint, stroke, paint2);
        legendItem.setLabelFont(this.lookupLegendTextFont(n2));
        Paint paint3 = this.lookupLegendTextPaint(n2);
        if (paint3 != null) {
            legendItem.setLabelPaint(paint3);
        }
        legendItem.setSeriesKey(categoryDataset.getRowKey(n2));
        legendItem.setSeriesIndex(n2);
        legendItem.setDataset(categoryDataset);
        legendItem.setDatasetIndex(n);
        return legendItem;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractCategoryItemRenderer)) {
            return false;
        }
        AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)object;
        if (!ObjectUtilities.equal(this.itemLabelGenerator, abstractCategoryItemRenderer.itemLabelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemLabelGeneratorList, abstractCategoryItemRenderer.itemLabelGeneratorList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseItemLabelGenerator, abstractCategoryItemRenderer.baseItemLabelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.toolTipGenerator, abstractCategoryItemRenderer.toolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.toolTipGeneratorList, abstractCategoryItemRenderer.toolTipGeneratorList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseToolTipGenerator, abstractCategoryItemRenderer.baseToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemURLGenerator, abstractCategoryItemRenderer.itemURLGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.itemURLGeneratorList, abstractCategoryItemRenderer.itemURLGeneratorList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseItemURLGenerator, abstractCategoryItemRenderer.baseItemURLGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemLabelGenerator, abstractCategoryItemRenderer.legendItemLabelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemToolTipGenerator, abstractCategoryItemRenderer.legendItemToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemURLGenerator, abstractCategoryItemRenderer.legendItemURLGenerator)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = super.hashCode();
        return n;
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot != null) {
            drawingSupplier = categoryPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }

    protected void updateCrosshairValues(CategoryCrosshairState categoryCrosshairState, Comparable comparable, Comparable comparable2, double d, int n, double d2, double d3, PlotOrientation plotOrientation) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        if (categoryCrosshairState != null) {
            if (this.plot.isRangeCrosshairLockedOnData()) {
                categoryCrosshairState.updateCrosshairPoint(comparable, comparable2, d, n, d2, d3, plotOrientation);
            } else {
                categoryCrosshairState.updateCrosshairX(comparable, comparable2, n, d2, plotOrientation);
            }
        }
    }

    protected void drawItemLabel(Graphics2D graphics2D, PlotOrientation plotOrientation, CategoryDataset categoryDataset, int n, int n2, double d, double d2, boolean bl) {
        CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
        if (categoryItemLabelGenerator != null) {
            Font font = this.getItemLabelFont(n, n2);
            Paint paint = this.getItemLabelPaint(n, n2);
            graphics2D.setFont(font);
            graphics2D.setPaint(paint);
            String string = categoryItemLabelGenerator.generateLabel(categoryDataset, n, n2);
            ItemLabelPosition itemLabelPosition = null;
            itemLabelPosition = !bl ? this.getPositiveItemLabelPosition(n, n2) : this.getNegativeItemLabelPosition(n, n2);
            Point2D point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), d, d2, plotOrientation);
            TextUtilities.drawRotatedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getAngle(), itemLabelPosition.getRotationAnchor());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PublicCloneable publicCloneable;
        AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)super.clone();
        if (this.itemLabelGenerator != null) {
            if (this.itemLabelGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)((Object)this.itemLabelGenerator);
                abstractCategoryItemRenderer.itemLabelGenerator = (CategoryItemLabelGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("ItemLabelGenerator not cloneable.");
            }
        }
        if (this.itemLabelGeneratorList != null) {
            abstractCategoryItemRenderer.itemLabelGeneratorList = (ObjectList)this.itemLabelGeneratorList.clone();
        }
        if (this.baseItemLabelGenerator != null) {
            if (this.baseItemLabelGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)((Object)this.baseItemLabelGenerator);
                abstractCategoryItemRenderer.baseItemLabelGenerator = (CategoryItemLabelGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("ItemLabelGenerator not cloneable.");
            }
        }
        if (this.toolTipGenerator != null) {
            if (this.toolTipGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)((Object)this.toolTipGenerator);
                abstractCategoryItemRenderer.toolTipGenerator = (CategoryToolTipGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("Tool tip generator not cloneable.");
            }
        }
        if (this.toolTipGeneratorList != null) {
            abstractCategoryItemRenderer.toolTipGeneratorList = (ObjectList)this.toolTipGeneratorList.clone();
        }
        if (this.baseToolTipGenerator != null) {
            if (this.baseToolTipGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)((Object)this.baseToolTipGenerator);
                abstractCategoryItemRenderer.baseToolTipGenerator = (CategoryToolTipGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("Base tool tip generator not cloneable.");
            }
        }
        if (this.itemURLGenerator != null) {
            if (this.itemURLGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)((Object)this.itemURLGenerator);
                abstractCategoryItemRenderer.itemURLGenerator = (CategoryURLGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("Item URL generator not cloneable.");
            }
        }
        if (this.itemURLGeneratorList != null) {
            abstractCategoryItemRenderer.itemURLGeneratorList = (ObjectList)this.itemURLGeneratorList.clone();
        }
        if (this.baseItemURLGenerator != null) {
            if (this.baseItemURLGenerator instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)((Object)this.baseItemURLGenerator);
                abstractCategoryItemRenderer.baseItemURLGenerator = (CategoryURLGenerator)publicCloneable.clone();
            } else {
                throw new CloneNotSupportedException("Base item URL generator not cloneable.");
            }
        }
        if (this.legendItemLabelGenerator instanceof PublicCloneable) {
            abstractCategoryItemRenderer.legendItemLabelGenerator = (CategorySeriesLabelGenerator)ObjectUtilities.clone(this.legendItemLabelGenerator);
        }
        if (this.legendItemToolTipGenerator instanceof PublicCloneable) {
            abstractCategoryItemRenderer.legendItemToolTipGenerator = (CategorySeriesLabelGenerator)ObjectUtilities.clone(this.legendItemToolTipGenerator);
        }
        if (this.legendItemURLGenerator instanceof PublicCloneable) {
            abstractCategoryItemRenderer.legendItemURLGenerator = (CategorySeriesLabelGenerator)ObjectUtilities.clone(this.legendItemURLGenerator);
        }
        return abstractCategoryItemRenderer;
    }

    protected CategoryAxis getDomainAxis(CategoryPlot categoryPlot, int n) {
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis(n);
        if (categoryAxis == null) {
            categoryAxis = categoryPlot.getDomainAxis();
        }
        return categoryAxis;
    }

    protected ValueAxis getRangeAxis(CategoryPlot categoryPlot, int n) {
        ValueAxis valueAxis = categoryPlot.getRangeAxis(n);
        if (valueAxis == null) {
            valueAxis = categoryPlot.getRangeAxis();
        }
        return valueAxis;
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.plot == null) {
            return legendItemCollection;
        }
        int n = this.plot.getIndexOf(this);
        CategoryDataset categoryDataset = this.plot.getDataset(n);
        if (categoryDataset == null) {
            return legendItemCollection;
        }
        int n2 = categoryDataset.getRowCount();
        if (this.plot.getRowRenderingOrder().equals(SortOrder.ASCENDING)) {
            for (int i = 0; i < n2; ++i) {
                LegendItem legendItem;
                if (!this.isSeriesVisibleInLegend(i) || (legendItem = this.getLegendItem(n, i)) == null) continue;
                legendItemCollection.add(legendItem);
            }
        } else {
            for (int i = n2 - 1; i >= 0; --i) {
                LegendItem legendItem;
                if (!this.isSeriesVisibleInLegend(i) || (legendItem = this.getLegendItem(n, i)) == null) continue;
                legendItemCollection.add(legendItem);
            }
        }
        return legendItemCollection;
    }

    public CategorySeriesLabelGenerator getLegendItemLabelGenerator() {
        return this.legendItemLabelGenerator;
    }

    public void setLegendItemLabelGenerator(CategorySeriesLabelGenerator categorySeriesLabelGenerator) {
        if (categorySeriesLabelGenerator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.legendItemLabelGenerator = categorySeriesLabelGenerator;
        this.fireChangeEvent();
    }

    public CategorySeriesLabelGenerator getLegendItemToolTipGenerator() {
        return this.legendItemToolTipGenerator;
    }

    public void setLegendItemToolTipGenerator(CategorySeriesLabelGenerator categorySeriesLabelGenerator) {
        this.legendItemToolTipGenerator = categorySeriesLabelGenerator;
        this.fireChangeEvent();
    }

    public CategorySeriesLabelGenerator getLegendItemURLGenerator() {
        return this.legendItemURLGenerator;
    }

    public void setLegendItemURLGenerator(CategorySeriesLabelGenerator categorySeriesLabelGenerator) {
        this.legendItemURLGenerator = categorySeriesLabelGenerator;
        this.fireChangeEvent();
    }

    protected void addItemEntity(EntityCollection entityCollection, CategoryDataset categoryDataset, int n, int n2, Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'hotspot' argument.");
        }
        if (!this.getItemCreateEntity(n, n2)) {
            return;
        }
        String string = null;
        CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
        if (categoryToolTipGenerator != null) {
            string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
        }
        String string2 = null;
        CategoryURLGenerator categoryURLGenerator = this.getItemURLGenerator(n, n2);
        if (categoryURLGenerator != null) {
            string2 = categoryURLGenerator.generateURL(categoryDataset, n, n2);
        }
        CategoryItemEntity categoryItemEntity = new CategoryItemEntity(shape, string, string2, categoryDataset, categoryDataset.getRowKey(n), categoryDataset.getColumnKey(n2));
        entityCollection.add(categoryItemEntity);
    }

    protected void addEntity(EntityCollection entityCollection, Shape shape, CategoryDataset categoryDataset, int n, int n2, double d, double d2) {
        if (!this.getItemCreateEntity(n, n2)) {
            return;
        }
        Shape shape2 = shape;
        if (shape == null) {
            double d3 = this.getDefaultEntityRadius();
            double d4 = d3 * 2.0;
            shape2 = this.getPlot().getOrientation() == PlotOrientation.VERTICAL ? new Ellipse2D.Double(d - d3, d2 - d3, d4, d4) : new Ellipse2D.Double(d2 - d3, d - d3, d4, d4);
        }
        String string = null;
        CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
        if (categoryToolTipGenerator != null) {
            string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
        }
        String string2 = null;
        CategoryURLGenerator categoryURLGenerator = this.getItemURLGenerator(n, n2);
        if (categoryURLGenerator != null) {
            string2 = categoryURLGenerator.generateURL(categoryDataset, n, n2);
        }
        CategoryItemEntity categoryItemEntity = new CategoryItemEntity(shape2, string, string2, categoryDataset, categoryDataset.getRowKey(n), categoryDataset.getColumnKey(n2));
        entityCollection.add(categoryItemEntity);
    }

    public void setItemLabelGenerator(CategoryItemLabelGenerator categoryItemLabelGenerator) {
        this.itemLabelGenerator = categoryItemLabelGenerator;
        this.fireChangeEvent();
    }

    public CategoryToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(CategoryToolTipGenerator categoryToolTipGenerator) {
        this.toolTipGenerator = categoryToolTipGenerator;
        this.fireChangeEvent();
    }

    public void setItemURLGenerator(CategoryURLGenerator categoryURLGenerator) {
        this.itemURLGenerator = categoryURLGenerator;
        this.fireChangeEvent();
    }
}

