/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot.dial;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.plot.dial.AbstractDialLayer;
import ai.org.jfree.chart.plot.dial.DialLayer;
import ai.org.jfree.chart.plot.dial.DialLayerChangeEvent;
import ai.org.jfree.chart.plot.dial.DialPlot;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.RectangleAnchor;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.ui.Size2D;
import ai.org.jfree.ui.TextAnchor;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class DialValueIndicator
extends AbstractDialLayer
implements DialLayer,
Cloneable,
PublicCloneable,
Serializable {
    static final long serialVersionUID = 803094354130942585L;
    private int datasetIndex;
    private double angle;
    private double radius;
    private RectangleAnchor frameAnchor;
    private Number templateValue;
    private Number maxTemplateValue;
    private NumberFormat formatter;
    private Font font;
    private transient Paint paint;
    private transient Paint backgroundPaint;
    private transient Stroke outlineStroke;
    private transient Paint outlinePaint;
    private RectangleInsets insets;
    private RectangleAnchor valueAnchor;
    private TextAnchor textAnchor;

    public DialValueIndicator() {
        this(0);
    }

    public DialValueIndicator(int n) {
        this.datasetIndex = n;
        this.angle = -90.0;
        this.radius = 0.3;
        this.frameAnchor = RectangleAnchor.CENTER;
        this.templateValue = new Double(100.0);
        this.maxTemplateValue = null;
        this.formatter = new DecimalFormat("0.0");
        this.font = new Font("Dialog", 1, 14);
        this.paint = Color.black;
        this.backgroundPaint = Color.white;
        this.outlineStroke = new BasicStroke(1.0f);
        this.outlinePaint = Color.blue;
        this.insets = new RectangleInsets(4.0, 4.0, 4.0, 4.0);
        this.valueAnchor = RectangleAnchor.RIGHT;
        this.textAnchor = TextAnchor.CENTER_RIGHT;
    }

    public int getDatasetIndex() {
        return this.datasetIndex;
    }

    public void setDatasetIndex(int n) {
        this.datasetIndex = n;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public RectangleAnchor getFrameAnchor() {
        return this.frameAnchor;
    }

    public void setFrameAnchor(RectangleAnchor rectangleAnchor) {
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.frameAnchor = rectangleAnchor;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Number getTemplateValue() {
        return this.templateValue;
    }

    public void setTemplateValue(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("Null 'value' argument.");
        }
        this.templateValue = number;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Number getMaxTemplateValue() {
        return this.maxTemplateValue;
    }

    public void setMaxTemplateValue(Number number) {
        this.maxTemplateValue = number;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public NumberFormat getNumberFormat() {
        return this.formatter;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.formatter = numberFormat;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.font = font;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.paint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.backgroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.outlineStroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.outlinePaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public RectangleInsets getInsets() {
        return this.insets;
    }

    public void setInsets(RectangleInsets rectangleInsets) {
        if (rectangleInsets == null) {
            throw new IllegalArgumentException("Null 'insets' argument.");
        }
        this.insets = rectangleInsets;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public RectangleAnchor getValueAnchor() {
        return this.valueAnchor;
    }

    public void setValueAnchor(RectangleAnchor rectangleAnchor) {
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.valueAnchor = rectangleAnchor;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public TextAnchor getTextAnchor() {
        return this.textAnchor;
    }

    public void setTextAnchor(TextAnchor textAnchor) {
        if (textAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.textAnchor = textAnchor;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean isClippedToWindow() {
        return true;
    }

    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.radius, this.radius);
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D3, this.angle, 0.0, 0);
        Point2D point2D = double_.getStartPoint();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
        double d = dialPlot.getValue(this.datasetIndex);
        String string = this.formatter.format(d);
        Rectangle2D rectangle2D4 = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
        String string2 = this.formatter.format(this.templateValue);
        Rectangle2D rectangle2D5 = TextUtilities.getTextBounds(string2, graphics2D, fontMetrics);
        double d2 = rectangle2D5.getWidth();
        double d3 = rectangle2D5.getHeight();
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MAX_VALUE;
        if (this.maxTemplateValue != null) {
            string2 = this.formatter.format(this.maxTemplateValue);
            rectangle2D5 = TextUtilities.getTextBounds(string2, graphics2D, fontMetrics);
            d4 = Math.max(rectangle2D5.getWidth(), d2);
            d5 = Math.max(rectangle2D5.getHeight(), d3);
        }
        double d6 = this.fixToRange(rectangle2D4.getWidth(), d2, d4);
        double d7 = this.fixToRange(rectangle2D4.getHeight(), d3, d5);
        Rectangle2D rectangle2D6 = RectangleAnchor.createRectangle(new Size2D(d6, d7), point2D.getX(), point2D.getY(), this.frameAnchor);
        Rectangle2D rectangle2D7 = this.insets.createOutsetRectangle(rectangle2D6);
        graphics2D.setPaint(this.backgroundPaint);
        graphics2D.fill(rectangle2D7);
        graphics2D.setStroke(this.outlineStroke);
        graphics2D.setPaint(this.outlinePaint);
        graphics2D.draw(rectangle2D7);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D7);
        Point2D point2D2 = RectangleAnchor.coordinates(rectangle2D6, this.valueAnchor);
        graphics2D.setPaint(this.paint);
        graphics2D.setFont(this.font);
        TextUtilities.drawAlignedString(string, graphics2D, (float)point2D2.getX(), (float)point2D2.getY(), this.textAnchor);
        graphics2D.setClip(shape);
    }

    private double fixToRange(double d, double d2, double d3) {
        if (d2 > d3) {
            throw new IllegalArgumentException("Requires 'minX' <= 'maxX'.");
        }
        if (d < d2) {
            return d2;
        }
        if (d > d3) {
            return d3;
        }
        return d;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DialValueIndicator)) {
            return false;
        }
        DialValueIndicator dialValueIndicator = (DialValueIndicator)object;
        if (this.datasetIndex != dialValueIndicator.datasetIndex) {
            return false;
        }
        if (this.angle != dialValueIndicator.angle) {
            return false;
        }
        if (this.radius != dialValueIndicator.radius) {
            return false;
        }
        if (!this.frameAnchor.equals(dialValueIndicator.frameAnchor)) {
            return false;
        }
        if (!this.templateValue.equals(dialValueIndicator.templateValue)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.maxTemplateValue, dialValueIndicator.maxTemplateValue)) {
            return false;
        }
        if (!this.font.equals(dialValueIndicator.font)) {
            return false;
        }
        if (!PaintUtilities.equal(this.paint, dialValueIndicator.paint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.backgroundPaint, dialValueIndicator.backgroundPaint)) {
            return false;
        }
        if (!this.outlineStroke.equals(dialValueIndicator.outlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.outlinePaint, dialValueIndicator.outlinePaint)) {
            return false;
        }
        if (!this.insets.equals(dialValueIndicator.insets)) {
            return false;
        }
        if (!this.valueAnchor.equals(dialValueIndicator.valueAnchor)) {
            return false;
        }
        if (!this.textAnchor.equals(dialValueIndicator.textAnchor)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 193;
        n = 37 * n + HashUtilities.hashCodeForPaint(this.paint);
        n = 37 * n + HashUtilities.hashCodeForPaint(this.backgroundPaint);
        n = 37 * n + HashUtilities.hashCodeForPaint(this.outlinePaint);
        n = 37 * n + this.outlineStroke.hashCode();
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
    }
}

