/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot.dial;

import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.PlotState;
import ai.org.jfree.chart.plot.dial.AbstractDialLayer;
import ai.org.jfree.chart.plot.dial.ArcDialFrame;
import ai.org.jfree.chart.plot.dial.DialFrame;
import ai.org.jfree.chart.plot.dial.DialLayer;
import ai.org.jfree.chart.plot.dial.DialLayerChangeEvent;
import ai.org.jfree.chart.plot.dial.DialLayerChangeListener;
import ai.org.jfree.chart.plot.dial.DialPointer;
import ai.org.jfree.chart.plot.dial.DialScale;
import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.general.ValueDataset;
import ai.org.jfree.util.ObjectList;
import ai.org.jfree.util.ObjectUtilities;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DialPlot
extends Plot
implements DialLayerChangeListener {
    private DialLayer background = null;
    private DialLayer cap = null;
    private DialFrame dialFrame = new ArcDialFrame();
    private ObjectList datasets = new ObjectList();
    private ObjectList scales;
    private ObjectList datasetToScaleMap;
    private List layers;
    private List pointers;
    private double viewX;
    private double viewY;
    private double viewW;
    private double viewH;

    public DialPlot() {
        this(null);
    }

    public DialPlot(ValueDataset valueDataset) {
        if (valueDataset != null) {
            this.setDataset(valueDataset);
        }
        this.scales = new ObjectList();
        this.datasetToScaleMap = new ObjectList();
        this.layers = new ArrayList();
        this.pointers = new ArrayList();
        this.viewX = 0.0;
        this.viewY = 0.0;
        this.viewW = 1.0;
        this.viewH = 1.0;
    }

    public DialLayer getBackground() {
        return this.background;
    }

    public void setBackground(DialLayer dialLayer) {
        if (this.background != null) {
            this.background.removeChangeListener(this);
        }
        this.background = dialLayer;
        if (dialLayer != null) {
            dialLayer.addChangeListener(this);
        }
        this.fireChangeEvent();
    }

    public DialLayer getCap() {
        return this.cap;
    }

    public void setCap(DialLayer dialLayer) {
        if (this.cap != null) {
            this.cap.removeChangeListener(this);
        }
        this.cap = dialLayer;
        if (dialLayer != null) {
            dialLayer.addChangeListener(this);
        }
        this.fireChangeEvent();
    }

    public DialFrame getDialFrame() {
        return this.dialFrame;
    }

    public void setDialFrame(DialFrame dialFrame) {
        if (dialFrame == null) {
            throw new IllegalArgumentException("Null 'frame' argument.");
        }
        this.dialFrame.removeChangeListener(this);
        this.dialFrame = dialFrame;
        dialFrame.addChangeListener(this);
        this.fireChangeEvent();
    }

    public double getViewX() {
        return this.viewX;
    }

    public double getViewY() {
        return this.viewY;
    }

    public double getViewWidth() {
        return this.viewW;
    }

    public double getViewHeight() {
        return this.viewH;
    }

    public void setView(double d, double d2, double d3, double d4) {
        this.viewX = d;
        this.viewY = d2;
        this.viewW = d3;
        this.viewH = d4;
        this.fireChangeEvent();
    }

    public void addLayer(DialLayer dialLayer) {
        if (dialLayer == null) {
            throw new IllegalArgumentException("Null 'layer' argument.");
        }
        this.layers.add(dialLayer);
        dialLayer.addChangeListener(this);
        this.fireChangeEvent();
    }

    public int getLayerIndex(DialLayer dialLayer) {
        if (dialLayer == null) {
            throw new IllegalArgumentException("Null 'layer' argument.");
        }
        return this.layers.indexOf(dialLayer);
    }

    public void removeLayer(int n) {
        DialLayer dialLayer = (DialLayer)this.layers.get(n);
        if (dialLayer != null) {
            dialLayer.removeChangeListener(this);
        }
        this.layers.remove(n);
        this.fireChangeEvent();
    }

    public void removeLayer(DialLayer dialLayer) {
        this.removeLayer(this.getLayerIndex(dialLayer));
    }

    public void addPointer(DialPointer dialPointer) {
        if (dialPointer == null) {
            throw new IllegalArgumentException("Null 'pointer' argument.");
        }
        this.pointers.add(dialPointer);
        dialPointer.addChangeListener(this);
        this.fireChangeEvent();
    }

    public int getPointerIndex(DialPointer dialPointer) {
        if (dialPointer == null) {
            throw new IllegalArgumentException("Null 'pointer' argument.");
        }
        return this.pointers.indexOf(dialPointer);
    }

    public void removePointer(int n) {
        DialPointer dialPointer = (DialPointer)this.pointers.get(n);
        if (dialPointer != null) {
            dialPointer.removeChangeListener(this);
        }
        this.pointers.remove(n);
        this.fireChangeEvent();
    }

    public void removePointer(DialPointer dialPointer) {
        this.removeLayer(this.getPointerIndex(dialPointer));
    }

    public DialPointer getPointerForDataset(int n) {
        DialPointer dialPointer = null;
        for (DialPointer dialPointer2 : this.pointers) {
            if (dialPointer2.getDatasetIndex() != n) continue;
            return dialPointer2;
        }
        return dialPointer;
    }

    public ValueDataset getDataset() {
        return this.getDataset(0);
    }

    public ValueDataset getDataset(int n) {
        ValueDataset valueDataset = null;
        if (this.datasets.size() > n) {
            valueDataset = (ValueDataset)this.datasets.get(n);
        }
        return valueDataset;
    }

    public void setDataset(ValueDataset valueDataset) {
        this.setDataset(0, valueDataset);
    }

    public void setDataset(int n, ValueDataset valueDataset) {
        ValueDataset valueDataset2 = (ValueDataset)this.datasets.get(n);
        if (valueDataset2 != null) {
            valueDataset2.removeChangeListener(this);
        }
        this.datasets.set(n, valueDataset);
        if (valueDataset != null) {
            valueDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, valueDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Shape shape;
        Shape shape2 = graphics2D.getClip();
        graphics2D.setClip(rectangle2D);
        Rectangle2D rectangle2D2 = this.viewToFrame(rectangle2D);
        if (this.background != null && this.background.isVisible()) {
            if (this.background.isClippedToWindow()) {
                Iterator iterator = graphics2D.getClip();
                graphics2D.clip(this.dialFrame.getWindow(rectangle2D2));
                this.background.draw(graphics2D, this, rectangle2D2, rectangle2D);
                graphics2D.setClip((Shape)((Object)iterator));
            } else {
                this.background.draw(graphics2D, this, rectangle2D2, rectangle2D);
            }
        }
        for (Object object : this.layers) {
            if (!object.isVisible()) continue;
            if (object.isClippedToWindow()) {
                shape = graphics2D.getClip();
                graphics2D.clip(this.dialFrame.getWindow(rectangle2D2));
                object.draw(graphics2D, this, rectangle2D2, rectangle2D);
                graphics2D.setClip(shape);
                continue;
            }
            object.draw(graphics2D, this, rectangle2D2, rectangle2D);
        }
        for (Object object : this.pointers) {
            if (!((AbstractDialLayer)object).isVisible()) continue;
            if (((DialPointer)object).isClippedToWindow()) {
                shape = graphics2D.getClip();
                graphics2D.clip(this.dialFrame.getWindow(rectangle2D2));
                object.draw(graphics2D, this, rectangle2D2, rectangle2D);
                graphics2D.setClip(shape);
                continue;
            }
            object.draw(graphics2D, this, rectangle2D2, rectangle2D);
        }
        if (this.cap != null && this.cap.isVisible()) {
            if (this.cap.isClippedToWindow()) {
                Object object;
                object = graphics2D.getClip();
                graphics2D.clip(this.dialFrame.getWindow(rectangle2D2));
                this.cap.draw(graphics2D, this, rectangle2D2, rectangle2D);
                graphics2D.setClip((Shape)object);
            } else {
                this.cap.draw(graphics2D, this, rectangle2D2, rectangle2D);
            }
        }
        if (this.dialFrame.isVisible()) {
            this.dialFrame.draw(graphics2D, this, rectangle2D2, rectangle2D);
        }
        graphics2D.setClip(shape2);
    }

    private Rectangle2D viewToFrame(Rectangle2D rectangle2D) {
        double d = rectangle2D.getWidth() / this.viewW;
        double d2 = rectangle2D.getHeight() / this.viewH;
        double d3 = rectangle2D.getX() - d * this.viewX;
        double d4 = rectangle2D.getY() - d2 * this.viewY;
        return new Rectangle2D.Double(d3, d4, d, d2);
    }

    public double getValue(int n) {
        Number number;
        double d = Double.NaN;
        ValueDataset valueDataset = this.getDataset(n);
        if (valueDataset != null && (number = valueDataset.getValue()) != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public void addScale(int n, DialScale dialScale) {
        if (dialScale == null) {
            throw new IllegalArgumentException("Null 'scale' argument.");
        }
        DialScale dialScale2 = (DialScale)this.scales.get(n);
        if (dialScale2 != null) {
            this.removeLayer(dialScale2);
        }
        this.layers.add(dialScale);
        this.scales.set(n, dialScale);
        dialScale.addChangeListener(this);
        this.fireChangeEvent();
    }

    public DialScale getScale(int n) {
        DialScale dialScale = null;
        if (this.scales.size() > n) {
            dialScale = (DialScale)this.scales.get(n);
        }
        return dialScale;
    }

    public void mapDatasetToScale(int n, int n2) {
        this.datasetToScaleMap.set(n, new Integer(n2));
        this.fireChangeEvent();
    }

    public DialScale getScaleForDataset(int n) {
        DialScale dialScale = (DialScale)this.scales.get(0);
        Integer n2 = (Integer)this.datasetToScaleMap.get(n);
        if (n2 != null) {
            dialScale = this.getScale(n2);
        }
        return dialScale;
    }

    public static Rectangle2D rectangleByRadius(Rectangle2D rectangle2D, double d, double d2) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null 'rect' argument.");
        }
        double d3 = rectangle2D.getCenterX();
        double d4 = rectangle2D.getCenterY();
        double d5 = rectangle2D.getWidth() * d;
        double d6 = rectangle2D.getHeight() * d2;
        return new Rectangle2D.Double(d3 - d5 / 2.0, d4 - d6 / 2.0, d5, d6);
    }

    public void dialLayerChanged(DialLayerChangeEvent dialLayerChangeEvent) {
        this.fireChangeEvent();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DialPlot)) {
            return false;
        }
        DialPlot dialPlot = (DialPlot)object;
        if (!ObjectUtilities.equal(this.background, dialPlot.background)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.cap, dialPlot.cap)) {
            return false;
        }
        if (!this.dialFrame.equals(dialPlot.dialFrame)) {
            return false;
        }
        if (this.viewX != dialPlot.viewX) {
            return false;
        }
        if (this.viewY != dialPlot.viewY) {
            return false;
        }
        if (this.viewW != dialPlot.viewW) {
            return false;
        }
        if (this.viewH != dialPlot.viewH) {
            return false;
        }
        if (!this.layers.equals(dialPlot.layers)) {
            return false;
        }
        if (!this.pointers.equals(dialPlot.pointers)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 193;
        n = 37 * n + ObjectUtilities.hashCode(this.background);
        n = 37 * n + ObjectUtilities.hashCode(this.cap);
        n = 37 * n + this.dialFrame.hashCode();
        long l = Double.doubleToLongBits(this.viewX);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.viewY);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.viewW);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.viewH);
        n = 37 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public String getPlotType() {
        return "DialPlot";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

