/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot.dial;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.plot.dial.AbstractDialLayer;
import ai.org.jfree.chart.plot.dial.DialLayer;
import ai.org.jfree.chart.plot.dial.DialLayerChangeEvent;
import ai.org.jfree.chart.plot.dial.DialPlot;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DialCap
extends AbstractDialLayer
implements DialLayer,
Cloneable,
PublicCloneable,
Serializable {
    static final long serialVersionUID = -2929484264982524463L;
    private double radius = 0.05;
    private transient Paint fillPaint = Color.white;
    private transient Paint outlinePaint = Color.black;
    private transient Stroke outlineStroke = new BasicStroke(2.0f);

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Requires radius > 0.0.");
        }
        this.radius = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.fillPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.outlinePaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.outlineStroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean isClippedToWindow() {
        return true;
    }

    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        graphics2D.setPaint(this.fillPaint);
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.radius, this.radius);
        Ellipse2D.Double double_ = new Ellipse2D.Double(rectangle2D3.getX(), rectangle2D3.getY(), rectangle2D3.getWidth(), rectangle2D3.getHeight());
        graphics2D.fill(double_);
        graphics2D.setPaint(this.outlinePaint);
        graphics2D.setStroke(this.outlineStroke);
        graphics2D.draw(double_);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DialCap)) {
            return false;
        }
        DialCap dialCap = (DialCap)object;
        if (this.radius != dialCap.radius) {
            return false;
        }
        if (!PaintUtilities.equal(this.fillPaint, dialCap.fillPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.outlinePaint, dialCap.outlinePaint)) {
            return false;
        }
        if (!this.outlineStroke.equals(dialCap.outlineStroke)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 193;
        n = 37 * n + HashUtilities.hashCodeForPaint(this.fillPaint);
        n = 37 * n + HashUtilities.hashCodeForPaint(this.outlinePaint);
        n = 37 * n + this.outlineStroke.hashCode();
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.fillPaint, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.fillPaint = SerialUtilities.readPaint(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
    }
}

