/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot.dial;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.plot.dial.AbstractDialLayer;
import ai.org.jfree.chart.plot.dial.DialLayer;
import ai.org.jfree.chart.plot.dial.DialLayerChangeEvent;
import ai.org.jfree.chart.plot.dial.DialPlot;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.GradientPaintTransformer;
import ai.org.jfree.ui.StandardGradientPaintTransformer;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DialBackground
extends AbstractDialLayer
implements DialLayer,
Cloneable,
PublicCloneable,
Serializable {
    static final long serialVersionUID = -9019069533317612375L;
    private transient Paint paint;
    private GradientPaintTransformer gradientPaintTransformer;

    public DialBackground() {
        this(Color.white);
    }

    public DialBackground(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.paint = paint;
        this.gradientPaintTransformer = new StandardGradientPaintTransformer();
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.paint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public GradientPaintTransformer getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientPaintTransformer(GradientPaintTransformer gradientPaintTransformer) {
        if (gradientPaintTransformer == null) {
            throw new IllegalArgumentException("Null 't' argument.");
        }
        this.gradientPaintTransformer = gradientPaintTransformer;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean isClippedToWindow() {
        return true;
    }

    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Paint paint = this.paint;
        if (paint instanceof GradientPaint) {
            paint = this.gradientPaintTransformer.transform((GradientPaint)paint, rectangle2D2);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(rectangle2D2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DialBackground)) {
            return false;
        }
        DialBackground dialBackground = (DialBackground)object;
        if (!PaintUtilities.equal(this.paint, dialBackground.paint)) {
            return false;
        }
        if (!this.gradientPaintTransformer.equals(dialBackground.gradientPaintTransformer)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 193;
        n = 37 * n + HashUtilities.hashCodeForPaint(this.paint);
        n = 37 * n + this.gradientPaintTransformer.hashCode();
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
    }
}

