/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot.dial;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.plot.dial.DialLayer;
import ai.org.jfree.chart.plot.dial.DialLayerChangeEvent;
import ai.org.jfree.chart.plot.dial.DialLayerChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;

public abstract class AbstractDialLayer
implements DialLayer {
    private boolean visible = true;
    private transient EventListenerList listenerList = new EventListenerList();

    protected AbstractDialLayer() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractDialLayer)) {
            return false;
        }
        AbstractDialLayer abstractDialLayer = (AbstractDialLayer)object;
        return this.visible == abstractDialLayer.visible;
    }

    public int hashCode() {
        int n = 23;
        n = HashUtilities.hashCode(n, this.visible);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractDialLayer abstractDialLayer = (AbstractDialLayer)super.clone();
        abstractDialLayer.listenerList = new EventListenerList();
        return abstractDialLayer;
    }

    public void addChangeListener(DialLayerChangeListener dialLayerChangeListener) {
        this.listenerList.add(DialLayerChangeListener.class, dialLayerChangeListener);
    }

    public void removeChangeListener(DialLayerChangeListener dialLayerChangeListener) {
        this.listenerList.remove(DialLayerChangeListener.class, dialLayerChangeListener);
    }

    public boolean hasListener(EventListener eventListener) {
        List<Object> list = Arrays.asList(this.listenerList.getListenerList());
        return list.contains(eventListener);
    }

    protected void notifyListeners(DialLayerChangeEvent dialLayerChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DialLayerChangeListener.class) continue;
            ((DialLayerChangeListener)objectArray[i + 1]).dialLayerChanged(dialLayerChangeEvent);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
    }
}

