/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.LegendItemCollection;
import ai.org.jfree.chart.annotations.XYAnnotation;
import ai.org.jfree.chart.annotations.XYAnnotationBoundsInfo;
import ai.org.jfree.chart.axis.Axis;
import ai.org.jfree.chart.axis.AxisCollection;
import ai.org.jfree.chart.axis.AxisLocation;
import ai.org.jfree.chart.axis.AxisSpace;
import ai.org.jfree.chart.axis.AxisState;
import ai.org.jfree.chart.axis.TickType;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.axis.ValueTick;
import ai.org.jfree.chart.event.AnnotationChangeEvent;
import ai.org.jfree.chart.event.ChartChangeEventType;
import ai.org.jfree.chart.event.PlotChangeEvent;
import ai.org.jfree.chart.event.RendererChangeEvent;
import ai.org.jfree.chart.event.RendererChangeListener;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.DatasetRenderingOrder;
import ai.org.jfree.chart.plot.Marker;
import ai.org.jfree.chart.plot.Pannable;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.PlotState;
import ai.org.jfree.chart.plot.SeriesRenderingOrder;
import ai.org.jfree.chart.plot.ValueAxisPlot;
import ai.org.jfree.chart.plot.Zoomable;
import ai.org.jfree.chart.renderer.RendererUtilities;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.chart.util.ResourceBundleWrapper;
import ai.org.jfree.chart.util.ShadowGenerator;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.general.Dataset;
import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.Layer;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.util.ObjectList;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;

public class XYPlot
extends Plot
implements ValueAxisPlot,
Pannable,
Zoomable,
RendererChangeListener,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 7044148245716569264L;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final Stroke DEFAULT_CROSSHAIR_STROKE = DEFAULT_GRIDLINE_STROKE;
    public static final Paint DEFAULT_CROSSHAIR_PAINT = Color.blue;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("ai.org.jfree.chart.plot.LocalizationBundle");
    private PlotOrientation orientation;
    private RectangleInsets axisOffset;
    private ObjectList domainAxes;
    private ObjectList domainAxisLocations;
    private ObjectList rangeAxes;
    private ObjectList rangeAxisLocations;
    private ObjectList datasets;
    private ObjectList renderers;
    private Map datasetToDomainAxesMap;
    private Map datasetToRangeAxesMap;
    private transient Point2D quadrantOrigin = new Point2D.Double(0.0, 0.0);
    private transient Paint[] quadrantPaint = new Paint[]{null, null, null, null};
    private boolean domainGridlinesVisible;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private boolean domainMinorGridlinesVisible;
    private transient Stroke domainMinorGridlineStroke;
    private transient Paint domainMinorGridlinePaint;
    private boolean rangeMinorGridlinesVisible;
    private transient Stroke rangeMinorGridlineStroke;
    private transient Paint rangeMinorGridlinePaint;
    private boolean domainZeroBaselineVisible;
    private transient Stroke domainZeroBaselineStroke;
    private transient Paint domainZeroBaselinePaint;
    private boolean rangeZeroBaselineVisible;
    private transient Stroke rangeZeroBaselineStroke;
    private transient Paint rangeZeroBaselinePaint;
    private boolean domainCrosshairVisible;
    private double domainCrosshairValue;
    private transient Stroke domainCrosshairStroke;
    private transient Paint domainCrosshairPaint;
    private boolean domainCrosshairLockedOnData = true;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private Map foregroundDomainMarkers;
    private Map backgroundDomainMarkers;
    private Map foregroundRangeMarkers;
    private Map backgroundRangeMarkers;
    private List annotations;
    private transient Paint domainTickBandPaint;
    private transient Paint rangeTickBandPaint;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;
    private DatasetRenderingOrder datasetRenderingOrder = DatasetRenderingOrder.REVERSE;
    private SeriesRenderingOrder seriesRenderingOrder = SeriesRenderingOrder.REVERSE;
    private int weight = 1;
    private LegendItemCollection fixedLegendItems;
    private boolean domainPannable;
    private boolean rangePannable;
    private ShadowGenerator shadowGenerator;

    public XYPlot() {
        this(null, null, null, null);
    }

    public XYPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2, XYItemRenderer xYItemRenderer) {
        this.orientation = PlotOrientation.VERTICAL;
        this.axisOffset = RectangleInsets.ZERO_INSETS;
        this.domainAxes = new ObjectList();
        this.domainAxisLocations = new ObjectList();
        this.foregroundDomainMarkers = new HashMap();
        this.backgroundDomainMarkers = new HashMap();
        this.rangeAxes = new ObjectList();
        this.rangeAxisLocations = new ObjectList();
        this.foregroundRangeMarkers = new HashMap();
        this.backgroundRangeMarkers = new HashMap();
        this.datasets = new ObjectList();
        this.renderers = new ObjectList();
        this.datasetToDomainAxesMap = new TreeMap();
        this.datasetToRangeAxesMap = new TreeMap();
        this.annotations = new ArrayList();
        this.datasets.set(0, xYDataset);
        if (xYDataset != null) {
            xYDataset.addChangeListener(this);
        }
        this.renderers.set(0, xYItemRenderer);
        if (xYItemRenderer != null) {
            xYItemRenderer.setPlot(this);
            xYItemRenderer.addChangeListener(this);
        }
        this.domainAxes.set(0, valueAxis);
        this.mapDatasetToDomainAxis(0, 0);
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.domainAxisLocations.set(0, AxisLocation.BOTTOM_OR_LEFT);
        this.rangeAxes.set(0, valueAxis2);
        this.mapDatasetToRangeAxis(0, 0);
        if (valueAxis2 != null) {
            valueAxis2.setPlot(this);
            valueAxis2.addChangeListener(this);
        }
        this.rangeAxisLocations.set(0, AxisLocation.BOTTOM_OR_LEFT);
        this.configureDomainAxes();
        this.configureRangeAxes();
        this.domainGridlinesVisible = true;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.domainMinorGridlinesVisible = false;
        this.domainMinorGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainMinorGridlinePaint = Color.white;
        this.domainZeroBaselineVisible = false;
        this.domainZeroBaselinePaint = Color.black;
        this.domainZeroBaselineStroke = new BasicStroke(0.5f);
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeMinorGridlinesVisible = false;
        this.rangeMinorGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeMinorGridlinePaint = Color.white;
        this.rangeZeroBaselineVisible = false;
        this.rangeZeroBaselinePaint = Color.black;
        this.rangeZeroBaselineStroke = new BasicStroke(0.5f);
        this.domainCrosshairVisible = false;
        this.domainCrosshairValue = 0.0;
        this.domainCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.domainCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.rangeCrosshairVisible = false;
        this.rangeCrosshairValue = 0.0;
        this.rangeCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.rangeCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.shadowGenerator = null;
    }

    public String getPlotType() {
        return localizationResources.getString("XY_Plot");
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        if (plotOrientation != this.orientation) {
            this.orientation = plotOrientation;
            this.fireChangeEvent();
        }
    }

    public RectangleInsets getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(RectangleInsets rectangleInsets) {
        if (rectangleInsets == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.axisOffset = rectangleInsets;
        this.fireChangeEvent();
    }

    public ValueAxis getDomainAxis() {
        return this.getDomainAxis(0);
    }

    public ValueAxis getDomainAxis(int n) {
        Plot plot;
        ValueAxis valueAxis = null;
        if (n < this.domainAxes.size()) {
            valueAxis = (ValueAxis)this.domainAxes.get(n);
        }
        if (valueAxis == null && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            valueAxis = xYPlot.getDomainAxis(n);
        }
        return valueAxis;
    }

    public void setDomainAxis(ValueAxis valueAxis) {
        this.setDomainAxis(0, valueAxis);
    }

    public void setDomainAxis(int n, ValueAxis valueAxis) {
        this.setDomainAxis(n, valueAxis, true);
    }

    public void setDomainAxis(int n, ValueAxis valueAxis, boolean bl) {
        ValueAxis valueAxis2 = this.getDomainAxis(n);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        this.domainAxes.set(n, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setDomainAxes(ValueAxis[] valueAxisArray) {
        for (int i = 0; i < valueAxisArray.length; ++i) {
            this.setDomainAxis(i, valueAxisArray[i], false);
        }
        this.fireChangeEvent();
    }

    public AxisLocation getDomainAxisLocation() {
        return (AxisLocation)this.domainAxisLocations.get(0);
    }

    public void setDomainAxisLocation(AxisLocation axisLocation) {
        this.setDomainAxisLocation(0, axisLocation, true);
    }

    public void setDomainAxisLocation(AxisLocation axisLocation, boolean bl) {
        this.setDomainAxisLocation(0, axisLocation, bl);
    }

    public RectangleEdge getDomainAxisEdge() {
        return Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), this.orientation);
    }

    public int getDomainAxisCount() {
        return this.domainAxes.size();
    }

    public void clearDomainAxes() {
        for (int i = 0; i < this.domainAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.domainAxes.get(i);
            if (valueAxis == null) continue;
            valueAxis.removeChangeListener(this);
        }
        this.domainAxes.clear();
        this.fireChangeEvent();
    }

    public void configureDomainAxes() {
        for (int i = 0; i < this.domainAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.domainAxes.get(i);
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
    }

    public AxisLocation getDomainAxisLocation(int n) {
        AxisLocation axisLocation = null;
        if (n < this.domainAxisLocations.size()) {
            axisLocation = (AxisLocation)this.domainAxisLocations.get(n);
        }
        if (axisLocation == null) {
            axisLocation = AxisLocation.getOpposite(this.getDomainAxisLocation());
        }
        return axisLocation;
    }

    public void setDomainAxisLocation(int n, AxisLocation axisLocation) {
        this.setDomainAxisLocation(n, axisLocation, true);
    }

    public void setDomainAxisLocation(int n, AxisLocation axisLocation, boolean bl) {
        if (n == 0 && axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.domainAxisLocations.set(n, axisLocation);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public RectangleEdge getDomainAxisEdge(int n) {
        AxisLocation axisLocation = this.getDomainAxisLocation(n);
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(axisLocation, this.orientation);
        if (rectangleEdge == null) {
            rectangleEdge = RectangleEdge.opposite(this.getDomainAxisEdge());
        }
        return rectangleEdge;
    }

    public ValueAxis getRangeAxis() {
        return this.getRangeAxis(0);
    }

    public void setRangeAxis(ValueAxis valueAxis) {
        ValueAxis valueAxis2;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        if ((valueAxis2 = this.getRangeAxis()) != null) {
            valueAxis2.removeChangeListener(this);
        }
        this.rangeAxes.set(0, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        this.fireChangeEvent();
    }

    public AxisLocation getRangeAxisLocation() {
        return (AxisLocation)this.rangeAxisLocations.get(0);
    }

    public void setRangeAxisLocation(AxisLocation axisLocation) {
        this.setRangeAxisLocation(0, axisLocation, true);
    }

    public void setRangeAxisLocation(AxisLocation axisLocation, boolean bl) {
        this.setRangeAxisLocation(0, axisLocation, bl);
    }

    public RectangleEdge getRangeAxisEdge() {
        return Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), this.orientation);
    }

    public ValueAxis getRangeAxis(int n) {
        Plot plot;
        ValueAxis valueAxis = null;
        if (n < this.rangeAxes.size()) {
            valueAxis = (ValueAxis)this.rangeAxes.get(n);
        }
        if (valueAxis == null && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            valueAxis = xYPlot.getRangeAxis(n);
        }
        return valueAxis;
    }

    public void setRangeAxis(int n, ValueAxis valueAxis) {
        this.setRangeAxis(n, valueAxis, true);
    }

    public void setRangeAxis(int n, ValueAxis valueAxis, boolean bl) {
        ValueAxis valueAxis2 = this.getRangeAxis(n);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        this.rangeAxes.set(n, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setRangeAxes(ValueAxis[] valueAxisArray) {
        for (int i = 0; i < valueAxisArray.length; ++i) {
            this.setRangeAxis(i, valueAxisArray[i], false);
        }
        this.fireChangeEvent();
    }

    public int getRangeAxisCount() {
        return this.rangeAxes.size();
    }

    public void clearRangeAxes() {
        for (int i = 0; i < this.rangeAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(i);
            if (valueAxis == null) continue;
            valueAxis.removeChangeListener(this);
        }
        this.rangeAxes.clear();
        this.fireChangeEvent();
    }

    public void configureRangeAxes() {
        for (int i = 0; i < this.rangeAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(i);
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
    }

    public AxisLocation getRangeAxisLocation(int n) {
        AxisLocation axisLocation = null;
        if (n < this.rangeAxisLocations.size()) {
            axisLocation = (AxisLocation)this.rangeAxisLocations.get(n);
        }
        if (axisLocation == null) {
            axisLocation = AxisLocation.getOpposite(this.getRangeAxisLocation());
        }
        return axisLocation;
    }

    public void setRangeAxisLocation(int n, AxisLocation axisLocation) {
        this.setRangeAxisLocation(n, axisLocation, true);
    }

    public void setRangeAxisLocation(int n, AxisLocation axisLocation, boolean bl) {
        if (n == 0 && axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.rangeAxisLocations.set(n, axisLocation);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public RectangleEdge getRangeAxisEdge(int n) {
        AxisLocation axisLocation = this.getRangeAxisLocation(n);
        RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(axisLocation, this.orientation);
        if (rectangleEdge == null) {
            rectangleEdge = RectangleEdge.opposite(this.getRangeAxisEdge());
        }
        return rectangleEdge;
    }

    public XYDataset getDataset() {
        return this.getDataset(0);
    }

    public XYDataset getDataset(int n) {
        XYDataset xYDataset = null;
        if (this.datasets.size() > n) {
            xYDataset = (XYDataset)this.datasets.get(n);
        }
        return xYDataset;
    }

    public void setDataset(XYDataset xYDataset) {
        this.setDataset(0, xYDataset);
    }

    public void setDataset(int n, XYDataset xYDataset) {
        XYDataset xYDataset2 = this.getDataset(n);
        if (xYDataset2 != null) {
            xYDataset2.removeChangeListener(this);
        }
        this.datasets.set(n, xYDataset);
        if (xYDataset != null) {
            xYDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, xYDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public int indexOf(XYDataset xYDataset) {
        int n = -1;
        for (int i = 0; i < this.datasets.size(); ++i) {
            if (xYDataset != this.datasets.get(i)) continue;
            n = i;
            break;
        }
        return n;
    }

    public void mapDatasetToDomainAxis(int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        arrayList.add(new Integer(n2));
        this.mapDatasetToDomainAxes(n, arrayList);
    }

    public void mapDatasetToDomainAxes(int n, List list) {
        if (n < 0) {
            throw new IllegalArgumentException("Requires 'index' >= 0.");
        }
        this.checkAxisIndices(list);
        Integer n2 = new Integer(n);
        this.datasetToDomainAxesMap.put(n2, new ArrayList(list));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n)));
    }

    public void mapDatasetToRangeAxis(int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        arrayList.add(new Integer(n2));
        this.mapDatasetToRangeAxes(n, arrayList);
    }

    public void mapDatasetToRangeAxes(int n, List list) {
        if (n < 0) {
            throw new IllegalArgumentException("Requires 'index' >= 0.");
        }
        this.checkAxisIndices(list);
        Integer n2 = new Integer(n);
        this.datasetToRangeAxesMap.put(n2, new ArrayList(list));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n)));
    }

    private void checkAxisIndices(List list) {
        if (list == null) {
            return;
        }
        int n = list.size();
        if (n == 0) {
            throw new IllegalArgumentException("Empty list not permitted.");
        }
        HashSet hashSet = new HashSet();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (!(e instanceof Integer)) {
                throw new IllegalArgumentException("Indices must be Integer instances.");
            }
            if (hashSet.contains(e)) {
                throw new IllegalArgumentException("Indices must be unique.");
            }
            hashSet.add(e);
        }
    }

    public int getRendererCount() {
        return this.renderers.size();
    }

    public XYItemRenderer getRenderer() {
        return this.getRenderer(0);
    }

    public XYItemRenderer getRenderer(int n) {
        XYItemRenderer xYItemRenderer = null;
        if (this.renderers.size() > n) {
            xYItemRenderer = (XYItemRenderer)this.renderers.get(n);
        }
        return xYItemRenderer;
    }

    public void setRenderer(XYItemRenderer xYItemRenderer) {
        this.setRenderer(0, xYItemRenderer);
    }

    public void setRenderer(int n, XYItemRenderer xYItemRenderer) {
        this.setRenderer(n, xYItemRenderer, true);
    }

    public void setRenderer(int n, XYItemRenderer xYItemRenderer, boolean bl) {
        XYItemRenderer xYItemRenderer2 = this.getRenderer(n);
        if (xYItemRenderer2 != null) {
            xYItemRenderer2.removeChangeListener(this);
        }
        this.renderers.set(n, xYItemRenderer);
        if (xYItemRenderer != null) {
            xYItemRenderer.setPlot(this);
            xYItemRenderer.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setRenderers(XYItemRenderer[] xYItemRendererArray) {
        for (int i = 0; i < xYItemRendererArray.length; ++i) {
            this.setRenderer(i, xYItemRendererArray[i], false);
        }
        this.fireChangeEvent();
    }

    public DatasetRenderingOrder getDatasetRenderingOrder() {
        return this.datasetRenderingOrder;
    }

    public void setDatasetRenderingOrder(DatasetRenderingOrder datasetRenderingOrder) {
        if (datasetRenderingOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.datasetRenderingOrder = datasetRenderingOrder;
        this.fireChangeEvent();
    }

    public SeriesRenderingOrder getSeriesRenderingOrder() {
        return this.seriesRenderingOrder;
    }

    public void setSeriesRenderingOrder(SeriesRenderingOrder seriesRenderingOrder) {
        if (seriesRenderingOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.seriesRenderingOrder = seriesRenderingOrder;
        this.fireChangeEvent();
    }

    public int getIndexOf(XYItemRenderer xYItemRenderer) {
        return this.renderers.indexOf(xYItemRenderer);
    }

    public XYItemRenderer getRendererForDataset(XYDataset xYDataset) {
        XYItemRenderer xYItemRenderer = null;
        for (int i = 0; i < this.datasets.size(); ++i) {
            if (this.datasets.get(i) != xYDataset) continue;
            xYItemRenderer = (XYItemRenderer)this.renderers.get(i);
            if (xYItemRenderer != null) break;
            xYItemRenderer = this.getRenderer();
            break;
        }
        return xYItemRenderer;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
        this.fireChangeEvent();
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean bl) {
        if (this.domainGridlinesVisible != bl) {
            this.domainGridlinesVisible = bl;
            this.fireChangeEvent();
        }
    }

    public boolean isDomainMinorGridlinesVisible() {
        return this.domainMinorGridlinesVisible;
    }

    public void setDomainMinorGridlinesVisible(boolean bl) {
        if (this.domainMinorGridlinesVisible != bl) {
            this.domainMinorGridlinesVisible = bl;
            this.fireChangeEvent();
        }
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.domainGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Stroke getDomainMinorGridlineStroke() {
        return this.domainMinorGridlineStroke;
    }

    public void setDomainMinorGridlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.domainMinorGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public Paint getDomainMinorGridlinePaint() {
        return this.domainMinorGridlinePaint;
    }

    public void setDomainMinorGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainMinorGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean bl) {
        if (this.rangeGridlinesVisible != bl) {
            this.rangeGridlinesVisible = bl;
            this.fireChangeEvent();
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeMinorGridlinesVisible() {
        return this.rangeMinorGridlinesVisible;
    }

    public void setRangeMinorGridlinesVisible(boolean bl) {
        if (this.rangeMinorGridlinesVisible != bl) {
            this.rangeMinorGridlinesVisible = bl;
            this.fireChangeEvent();
        }
    }

    public Stroke getRangeMinorGridlineStroke() {
        return this.rangeMinorGridlineStroke;
    }

    public void setRangeMinorGridlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeMinorGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeMinorGridlinePaint() {
        return this.rangeMinorGridlinePaint;
    }

    public void setRangeMinorGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeMinorGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isDomainZeroBaselineVisible() {
        return this.domainZeroBaselineVisible;
    }

    public void setDomainZeroBaselineVisible(boolean bl) {
        this.domainZeroBaselineVisible = bl;
        this.fireChangeEvent();
    }

    public Stroke getDomainZeroBaselineStroke() {
        return this.domainZeroBaselineStroke;
    }

    public void setDomainZeroBaselineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.domainZeroBaselineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getDomainZeroBaselinePaint() {
        return this.domainZeroBaselinePaint;
    }

    public void setDomainZeroBaselinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainZeroBaselinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeZeroBaselineVisible() {
        return this.rangeZeroBaselineVisible;
    }

    public void setRangeZeroBaselineVisible(boolean bl) {
        this.rangeZeroBaselineVisible = bl;
        this.fireChangeEvent();
    }

    public Stroke getRangeZeroBaselineStroke() {
        return this.rangeZeroBaselineStroke;
    }

    public void setRangeZeroBaselineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeZeroBaselineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeZeroBaselinePaint() {
        return this.rangeZeroBaselinePaint;
    }

    public void setRangeZeroBaselinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeZeroBaselinePaint = paint;
        this.fireChangeEvent();
    }

    public Paint getDomainTickBandPaint() {
        return this.domainTickBandPaint;
    }

    public void setDomainTickBandPaint(Paint paint) {
        this.domainTickBandPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getRangeTickBandPaint() {
        return this.rangeTickBandPaint;
    }

    public void setRangeTickBandPaint(Paint paint) {
        this.rangeTickBandPaint = paint;
        this.fireChangeEvent();
    }

    public Point2D getQuadrantOrigin() {
        return this.quadrantOrigin;
    }

    public void setQuadrantOrigin(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException("Null 'origin' argument.");
        }
        this.quadrantOrigin = point2D;
        this.fireChangeEvent();
    }

    public Paint getQuadrantPaint(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("The index value (" + n + ") should be in the range 0 to 3.");
        }
        return this.quadrantPaint[n];
    }

    public void setQuadrantPaint(int n, Paint paint) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("The index value (" + n + ") should be in the range 0 to 3.");
        }
        this.quadrantPaint[n] = paint;
        this.fireChangeEvent();
    }

    public void addDomainMarker(Marker marker) {
        this.addDomainMarker(marker, Layer.FOREGROUND);
    }

    public void addDomainMarker(Marker marker, Layer layer) {
        this.addDomainMarker(0, marker, layer);
    }

    public void clearDomainMarkers() {
        Set set;
        if (this.backgroundDomainMarkers != null) {
            set = this.backgroundDomainMarkers.keySet();
            for (Integer n : set) {
                this.clearDomainMarkers(n);
            }
            this.backgroundDomainMarkers.clear();
        }
        if (this.foregroundDomainMarkers != null) {
            set = this.foregroundDomainMarkers.keySet();
            for (Integer n : set) {
                this.clearDomainMarkers(n);
            }
            this.foregroundDomainMarkers.clear();
        }
        this.fireChangeEvent();
    }

    public void clearDomainMarkers(int n) {
        Collection collection;
        Integer n2 = new Integer(n);
        if (this.backgroundDomainMarkers != null && (collection = (Collection)this.backgroundDomainMarkers.get(n2)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        if (this.foregroundRangeMarkers != null && (collection = (Collection)this.foregroundDomainMarkers.get(n2)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        this.fireChangeEvent();
    }

    public void addDomainMarker(int n, Marker marker, Layer layer) {
        this.addDomainMarker(n, marker, layer, true);
    }

    public void addDomainMarker(int n, Marker marker, Layer layer, boolean bl) {
        if (marker == null) {
            throw new IllegalArgumentException("Null 'marker' not permitted.");
        }
        if (layer == null) {
            throw new IllegalArgumentException("Null 'layer' not permitted.");
        }
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.foregroundDomainMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.foregroundDomainMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.backgroundDomainMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.backgroundDomainMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        }
        marker.addChangeListener(this);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public boolean removeDomainMarker(Marker marker) {
        return this.removeDomainMarker(marker, Layer.FOREGROUND);
    }

    public boolean removeDomainMarker(Marker marker, Layer layer) {
        return this.removeDomainMarker(0, marker, layer);
    }

    public boolean removeDomainMarker(int n, Marker marker, Layer layer) {
        return this.removeDomainMarker(n, marker, layer, true);
    }

    public boolean removeDomainMarker(int n, Marker marker, Layer layer, boolean bl) {
        ArrayList arrayList = layer == Layer.FOREGROUND ? (ArrayList)this.foregroundDomainMarkers.get(new Integer(n)) : (ArrayList)this.backgroundDomainMarkers.get(new Integer(n));
        if (arrayList == null) {
            return false;
        }
        boolean bl2 = arrayList.remove(marker);
        if (bl2 && bl) {
            this.fireChangeEvent();
        }
        return bl2;
    }

    public void addRangeMarker(Marker marker) {
        this.addRangeMarker(marker, Layer.FOREGROUND);
    }

    public void addRangeMarker(Marker marker, Layer layer) {
        this.addRangeMarker(0, marker, layer);
    }

    public void clearRangeMarkers() {
        Set set;
        if (this.backgroundRangeMarkers != null) {
            set = this.backgroundRangeMarkers.keySet();
            for (Integer n : set) {
                this.clearRangeMarkers(n);
            }
            this.backgroundRangeMarkers.clear();
        }
        if (this.foregroundRangeMarkers != null) {
            set = this.foregroundRangeMarkers.keySet();
            for (Integer n : set) {
                this.clearRangeMarkers(n);
            }
            this.foregroundRangeMarkers.clear();
        }
        this.fireChangeEvent();
    }

    public void addRangeMarker(int n, Marker marker, Layer layer) {
        this.addRangeMarker(n, marker, layer, true);
    }

    public void addRangeMarker(int n, Marker marker, Layer layer, boolean bl) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.foregroundRangeMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.foregroundRangeMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.backgroundRangeMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.backgroundRangeMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        }
        marker.addChangeListener(this);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void clearRangeMarkers(int n) {
        Collection collection;
        Integer n2 = new Integer(n);
        if (this.backgroundRangeMarkers != null && (collection = (Collection)this.backgroundRangeMarkers.get(n2)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        if (this.foregroundRangeMarkers != null && (collection = (Collection)this.foregroundRangeMarkers.get(n2)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        this.fireChangeEvent();
    }

    public boolean removeRangeMarker(Marker marker) {
        return this.removeRangeMarker(marker, Layer.FOREGROUND);
    }

    public boolean removeRangeMarker(Marker marker, Layer layer) {
        return this.removeRangeMarker(0, marker, layer);
    }

    public boolean removeRangeMarker(int n, Marker marker, Layer layer) {
        return this.removeRangeMarker(n, marker, layer, true);
    }

    public boolean removeRangeMarker(int n, Marker marker, Layer layer, boolean bl) {
        if (marker == null) {
            throw new IllegalArgumentException("Null 'marker' argument.");
        }
        ArrayList arrayList = layer == Layer.FOREGROUND ? (ArrayList)this.foregroundRangeMarkers.get(new Integer(n)) : (ArrayList)this.backgroundRangeMarkers.get(new Integer(n));
        if (arrayList == null) {
            return false;
        }
        boolean bl2 = arrayList.remove(marker);
        if (bl2 && bl) {
            this.fireChangeEvent();
        }
        return bl2;
    }

    public void addAnnotation(XYAnnotation xYAnnotation) {
        this.addAnnotation(xYAnnotation, true);
    }

    public void addAnnotation(XYAnnotation xYAnnotation, boolean bl) {
        if (xYAnnotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        this.annotations.add(xYAnnotation);
        xYAnnotation.addChangeListener(this);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public boolean removeAnnotation(XYAnnotation xYAnnotation) {
        return this.removeAnnotation(xYAnnotation, true);
    }

    public boolean removeAnnotation(XYAnnotation xYAnnotation, boolean bl) {
        if (xYAnnotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        boolean bl2 = this.annotations.remove(xYAnnotation);
        xYAnnotation.removeChangeListener(this);
        if (bl2 && bl) {
            this.fireChangeEvent();
        }
        return bl2;
    }

    public List getAnnotations() {
        return new ArrayList(this.annotations);
    }

    public void clearAnnotations() {
        for (int i = 0; i < this.annotations.size(); ++i) {
            XYAnnotation xYAnnotation = (XYAnnotation)this.annotations.get(i);
            xYAnnotation.removeChangeListener(this);
        }
        this.annotations.clear();
        this.fireChangeEvent();
    }

    public ShadowGenerator getShadowGenerator() {
        return this.shadowGenerator;
    }

    public void setShadowGenerator(ShadowGenerator shadowGenerator) {
        this.shadowGenerator = shadowGenerator;
        this.fireChangeEvent();
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.calculateRangeAxisSpace(graphics2D, rectangle2D, axisSpace);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        axisSpace = this.calculateDomainAxisSpace(graphics2D, rectangle2D2, axisSpace);
        return axisSpace;
    }

    protected AxisSpace calculateDomainAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block4: {
            block2: {
                block3: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block2;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block3;
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block4;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block4;
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block4;
            }
            for (int i = 0; i < this.domainAxes.size(); ++i) {
                Axis axis = (Axis)this.domainAxes.get(i);
                if (axis == null) continue;
                RectangleEdge rectangleEdge = this.getDomainAxisEdge(i);
                axisSpace = axis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateRangeAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block4: {
            block2: {
                block3: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block2;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block3;
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block4;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block4;
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block4;
            }
            for (int i = 0; i < this.rangeAxes.size(); ++i) {
                Axis axis = (Axis)this.rangeAxes.get(i);
                if (axis == null) continue;
                RectangleEdge rectangleEdge = this.getRangeAxisEdge(i);
                axisSpace = axis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        return axisSpace;
    }

    private Rectangle integerise(Rectangle2D rectangle2D) {
        int n = (int)Math.ceil(rectangle2D.getMinX());
        int n2 = (int)Math.ceil(rectangle2D.getMinY());
        int n3 = (int)Math.floor(rectangle2D.getMaxX());
        int n4 = (int)Math.floor(rectangle2D.getMaxY());
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        int n;
        Object object;
        ValueAxis valueAxis;
        ValueAxis valueAxis2;
        Object object2;
        int n2;
        int n3;
        int n4;
        AxisState axisState;
        Object object3;
        Object object4;
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.axisOffset.trim(rectangle2D2);
        rectangle2D2 = this.integerise(rectangle2D2);
        if (rectangle2D2.isEmpty()) {
            return;
        }
        this.createAndAddEntity((Rectangle2D)rectangle2D2.clone(), plotRenderingInfo, null, null);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
        this.drawBackground(graphics2D, rectangle2D2);
        Map map = this.drawAxes(graphics2D, rectangle2D, rectangle2D2, plotRenderingInfo);
        PlotOrientation plotOrientation = this.getOrientation();
        if (point2D != null && !rectangle2D2.contains(point2D)) {
            point2D = null;
        }
        CrosshairState crosshairState = new CrosshairState();
        crosshairState.setCrosshairDistance(Double.POSITIVE_INFINITY);
        crosshairState.setAnchor(point2D);
        crosshairState.setAnchorX(Double.NaN);
        crosshairState.setAnchorY(Double.NaN);
        if (point2D != null) {
            object4 = this.getDomainAxis();
            if (object4 != null) {
                double d = plotOrientation == PlotOrientation.VERTICAL ? ((ValueAxis)object4).java2DToValue(point2D.getX(), rectangle2D2, this.getDomainAxisEdge()) : ((ValueAxis)object4).java2DToValue(point2D.getY(), rectangle2D2, this.getDomainAxisEdge());
                crosshairState.setAnchorX(d);
            }
            if ((object3 = this.getRangeAxis()) != null) {
                double d = plotOrientation == PlotOrientation.VERTICAL ? ((ValueAxis)object3).java2DToValue(point2D.getY(), rectangle2D2, this.getRangeAxisEdge()) : ((ValueAxis)object3).java2DToValue(point2D.getX(), rectangle2D2, this.getRangeAxisEdge());
                crosshairState.setAnchorY(d);
            }
        }
        crosshairState.setCrosshairX(this.getDomainCrosshairValue());
        crosshairState.setCrosshairY(this.getRangeCrosshairValue());
        object4 = graphics2D.getClip();
        object3 = graphics2D.getComposite();
        graphics2D.clip(rectangle2D2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        AxisState axisState2 = (AxisState)map.get(this.getDomainAxis());
        if (axisState2 == null && plotState != null) {
            axisState2 = (AxisState)plotState.getSharedAxisStates().get(this.getDomainAxis());
        }
        if ((axisState = (AxisState)map.get(this.getRangeAxis())) == null && plotState != null) {
            axisState = (AxisState)plotState.getSharedAxisStates().get(this.getRangeAxis());
        }
        if (axisState2 != null) {
            this.drawDomainTickBands(graphics2D, rectangle2D2, axisState2.getTicks());
        }
        if (axisState != null) {
            this.drawRangeTickBands(graphics2D, rectangle2D2, axisState.getTicks());
        }
        if (axisState2 != null) {
            this.drawDomainGridlines(graphics2D, rectangle2D2, axisState2.getTicks());
            this.drawZeroDomainBaseline(graphics2D, rectangle2D2);
        }
        if (axisState != null) {
            this.drawRangeGridlines(graphics2D, rectangle2D2, axisState.getTicks());
            this.drawZeroRangeBaseline(graphics2D, rectangle2D2);
        }
        Graphics2D graphics2D2 = graphics2D;
        BufferedImage bufferedImage = null;
        if (this.shadowGenerator != null) {
            bufferedImage = new BufferedImage((int)rectangle2D2.getWidth(), (int)rectangle2D2.getHeight(), 2);
            graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(-rectangle2D2.getX(), -rectangle2D2.getY());
            graphics2D.setRenderingHints(graphics2D2.getRenderingHints());
        }
        for (n4 = 0; n4 < this.renderers.size(); ++n4) {
            this.drawDomainMarkers(graphics2D, rectangle2D2, n4, Layer.BACKGROUND);
        }
        for (n4 = 0; n4 < this.renderers.size(); ++n4) {
            this.drawRangeMarkers(graphics2D, rectangle2D2, n4, Layer.BACKGROUND);
        }
        n4 = 0;
        DatasetRenderingOrder datasetRenderingOrder = this.getDatasetRenderingOrder();
        if (datasetRenderingOrder == DatasetRenderingOrder.FORWARD) {
            n3 = this.renderers.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object2 = this.getRenderer(n2);
                if (object2 == null) continue;
                valueAxis2 = this.getDomainAxisForDataset(n2);
                valueAxis = this.getRangeAxisForDataset(n2);
                object2.drawAnnotations(graphics2D, rectangle2D2, valueAxis2, valueAxis, Layer.BACKGROUND, plotRenderingInfo);
            }
            for (n2 = 0; n2 < this.getDatasetCount(); ++n2) {
                n4 = this.render(graphics2D, rectangle2D2, n2, plotRenderingInfo, crosshairState) || n4 != 0 ? 1 : 0;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                object2 = this.getRenderer(n2);
                if (object2 == null) continue;
                valueAxis2 = this.getDomainAxisForDataset(n2);
                valueAxis = this.getRangeAxisForDataset(n2);
                object2.drawAnnotations(graphics2D, rectangle2D2, valueAxis2, valueAxis, Layer.FOREGROUND, plotRenderingInfo);
            }
        } else if (datasetRenderingOrder == DatasetRenderingOrder.REVERSE) {
            n3 = this.renderers.size();
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                object2 = this.getRenderer(n2);
                if (n2 >= this.getDatasetCount() || object2 == null) continue;
                valueAxis2 = this.getDomainAxisForDataset(n2);
                valueAxis = this.getRangeAxisForDataset(n2);
                object2.drawAnnotations(graphics2D, rectangle2D2, valueAxis2, valueAxis, Layer.BACKGROUND, plotRenderingInfo);
            }
            for (n2 = this.getDatasetCount() - 1; n2 >= 0; --n2) {
                n4 = this.render(graphics2D, rectangle2D2, n2, plotRenderingInfo, crosshairState) || n4 != 0 ? 1 : 0;
            }
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                object2 = this.getRenderer(n2);
                if (n2 >= this.getDatasetCount() || object2 == null) continue;
                valueAxis2 = this.getDomainAxisForDataset(n2);
                valueAxis = this.getRangeAxisForDataset(n2);
                object2.drawAnnotations(graphics2D, rectangle2D2, valueAxis2, valueAxis, Layer.FOREGROUND, plotRenderingInfo);
            }
        }
        n3 = crosshairState.getDomainAxisIndex();
        ValueAxis valueAxis3 = this.getDomainAxis(n3);
        object2 = this.getDomainAxisEdge(n3);
        if (!this.domainCrosshairLockedOnData && point2D != null) {
            double d = plotOrientation == PlotOrientation.VERTICAL ? valueAxis3.java2DToValue(point2D.getX(), rectangle2D2, (RectangleEdge)object2) : valueAxis3.java2DToValue(point2D.getY(), rectangle2D2, (RectangleEdge)object2);
            crosshairState.setCrosshairX(d);
        }
        this.setDomainCrosshairValue(crosshairState.getCrosshairX(), false);
        if (this.isDomainCrosshairVisible()) {
            double d = this.getDomainCrosshairValue();
            object = this.getDomainCrosshairPaint();
            Stroke stroke = this.getDomainCrosshairStroke();
            this.drawDomainCrosshair(graphics2D, rectangle2D2, plotOrientation, d, valueAxis3, stroke, (Paint)object);
        }
        int n5 = crosshairState.getRangeAxisIndex();
        valueAxis = this.getRangeAxis(n5);
        object = this.getRangeAxisEdge(n5);
        if (!this.rangeCrosshairLockedOnData && point2D != null) {
            double d = plotOrientation == PlotOrientation.VERTICAL ? valueAxis.java2DToValue(point2D.getY(), rectangle2D2, (RectangleEdge)object) : valueAxis.java2DToValue(point2D.getX(), rectangle2D2, (RectangleEdge)object);
            crosshairState.setCrosshairY(d);
        }
        this.setRangeCrosshairValue(crosshairState.getCrosshairY(), false);
        if (this.isRangeCrosshairVisible()) {
            double d = this.getRangeCrosshairValue();
            Paint paint = this.getRangeCrosshairPaint();
            Stroke stroke = this.getRangeCrosshairStroke();
            this.drawRangeCrosshair(graphics2D, rectangle2D2, plotOrientation, d, valueAxis, stroke, paint);
        }
        if (n4 == 0) {
            this.drawNoDataMessage(graphics2D, rectangle2D2);
        }
        for (n = 0; n < this.renderers.size(); ++n) {
            this.drawDomainMarkers(graphics2D, rectangle2D2, n, Layer.FOREGROUND);
        }
        for (n = 0; n < this.renderers.size(); ++n) {
            this.drawRangeMarkers(graphics2D, rectangle2D2, n, Layer.FOREGROUND);
        }
        this.drawAnnotations(graphics2D, rectangle2D2, plotRenderingInfo);
        if (this.shadowGenerator != null) {
            BufferedImage bufferedImage2 = this.shadowGenerator.createDropShadow(bufferedImage);
            graphics2D = graphics2D2;
            graphics2D.drawImage((Image)bufferedImage2, (int)rectangle2D2.getX() + this.shadowGenerator.calculateOffsetX(), (int)rectangle2D2.getY() + this.shadowGenerator.calculateOffsetY(), null);
            graphics2D.drawImage((Image)bufferedImage, (int)rectangle2D2.getX(), (int)rectangle2D2.getY(), null);
        }
        graphics2D.setClip((Shape)object4);
        graphics2D.setComposite((Composite)object3);
        this.drawOutline(graphics2D, rectangle2D2);
    }

    public void drawBackground(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.fillBackground(graphics2D, rectangle2D, this.orientation);
        this.drawQuadrants(graphics2D, rectangle2D);
        this.drawBackgroundImage(graphics2D, rectangle2D);
    }

    protected void drawQuadrants(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        boolean bl = false;
        ValueAxis valueAxis = this.getDomainAxis();
        if (valueAxis == null) {
            return;
        }
        double d = valueAxis.getRange().constrain(this.quadrantOrigin.getX());
        double d2 = valueAxis.valueToJava2D(d, rectangle2D, this.getDomainAxisEdge());
        ValueAxis valueAxis2 = this.getRangeAxis();
        if (valueAxis2 == null) {
            return;
        }
        double d3 = valueAxis2.getRange().constrain(this.quadrantOrigin.getY());
        double d4 = valueAxis2.valueToJava2D(d3, rectangle2D, this.getRangeAxisEdge());
        double d5 = valueAxis.getLowerBound();
        double d6 = valueAxis.valueToJava2D(d5, rectangle2D, this.getDomainAxisEdge());
        double d7 = valueAxis.getUpperBound();
        double d8 = valueAxis.valueToJava2D(d7, rectangle2D, this.getDomainAxisEdge());
        double d9 = valueAxis2.getLowerBound();
        double d10 = valueAxis2.valueToJava2D(d9, rectangle2D, this.getRangeAxisEdge());
        double d11 = valueAxis2.getUpperBound();
        double d12 = valueAxis2.valueToJava2D(d11, rectangle2D, this.getRangeAxisEdge());
        Rectangle2D[] rectangle2DArray = new Rectangle2D[]{null, null, null, null};
        if (this.quadrantPaint[0] != null && d > d5 && d3 < d11) {
            rectangle2DArray[0] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(d12, d4), Math.min(d6, d2), Math.abs(d4 - d12), Math.abs(d2 - d6)) : new Rectangle2D.Double(Math.min(d6, d2), Math.min(d12, d4), Math.abs(d2 - d6), Math.abs(d4 - d12));
            bl = true;
        }
        if (this.quadrantPaint[1] != null && d < d7 && d3 < d11) {
            rectangle2DArray[1] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(d12, d4), Math.min(d8, d2), Math.abs(d4 - d12), Math.abs(d2 - d8)) : new Rectangle2D.Double(Math.min(d2, d8), Math.min(d12, d4), Math.abs(d2 - d8), Math.abs(d4 - d12));
            bl = true;
        }
        if (this.quadrantPaint[2] != null && d > d5 && d3 > d9) {
            rectangle2DArray[2] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(d10, d4), Math.min(d6, d2), Math.abs(d4 - d10), Math.abs(d2 - d6)) : new Rectangle2D.Double(Math.min(d6, d2), Math.min(d10, d4), Math.abs(d2 - d6), Math.abs(d4 - d10));
            bl = true;
        }
        if (this.quadrantPaint[3] != null && d < d7 && d3 > d9) {
            rectangle2DArray[3] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(d10, d4), Math.min(d8, d2), Math.abs(d4 - d10), Math.abs(d2 - d8)) : new Rectangle2D.Double(Math.min(d2, d8), Math.min(d10, d4), Math.abs(d2 - d8), Math.abs(d4 - d10));
            bl = true;
        }
        if (bl) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.getBackgroundAlpha()));
            for (int i = 0; i < 4; ++i) {
                if (this.quadrantPaint[i] == null || rectangle2DArray[i] == null) continue;
                graphics2D.setPaint(this.quadrantPaint[i]);
                graphics2D.fill(rectangle2DArray[i]);
            }
            graphics2D.setComposite(composite);
        }
    }

    public void drawDomainTickBands(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        Paint paint = this.getDomainTickBandPaint();
        if (paint != null) {
            boolean bl = false;
            ValueAxis valueAxis = this.getDomainAxis();
            double d = valueAxis.getLowerBound();
            for (ValueTick valueTick : list) {
                double d2 = valueTick.getValue();
                if (bl) {
                    this.getRenderer().fillDomainGridBand(graphics2D, this, valueAxis, rectangle2D, d, d2);
                }
                d = d2;
                bl = !bl;
            }
            double d3 = valueAxis.getUpperBound();
            if (bl) {
                this.getRenderer().fillDomainGridBand(graphics2D, this, valueAxis, rectangle2D, d, d3);
            }
        }
    }

    public void drawRangeTickBands(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        Paint paint = this.getRangeTickBandPaint();
        if (paint != null) {
            boolean bl = false;
            ValueAxis valueAxis = this.getRangeAxis();
            double d = valueAxis.getLowerBound();
            for (ValueTick valueTick : list) {
                double d2 = valueTick.getValue();
                if (bl) {
                    this.getRenderer().fillRangeGridBand(graphics2D, this, valueAxis, rectangle2D, d, d2);
                }
                d = d2;
                bl = !bl;
            }
            double d3 = valueAxis.getUpperBound();
            if (bl) {
                this.getRenderer().fillRangeGridBand(graphics2D, this, valueAxis, rectangle2D, d, d3);
            }
        }
    }

    protected Map drawAxes(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState;
        ValueAxis valueAxis;
        int n;
        AxisCollection axisCollection = new AxisCollection();
        for (n = 0; n < this.domainAxes.size(); ++n) {
            valueAxis = (ValueAxis)this.domainAxes.get(n);
            if (valueAxis == null) continue;
            axisCollection.add(valueAxis, this.getDomainAxisEdge(n));
        }
        for (n = 0; n < this.rangeAxes.size(); ++n) {
            valueAxis = (ValueAxis)this.rangeAxes.get(n);
            if (valueAxis == null) continue;
            axisCollection.add(valueAxis, this.getRangeAxisEdge(n));
        }
        HashMap<ValueAxis, AxisState> hashMap = new HashMap<ValueAxis, AxisState>();
        double d = rectangle2D2.getMinY() - this.axisOffset.calculateTopOutset(rectangle2D2.getHeight());
        for (ValueAxis valueAxis2 : axisCollection.getAxesAtTop()) {
            axisState = valueAxis2.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.TOP, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(valueAxis2, axisState);
        }
        d = rectangle2D2.getMaxY() + this.axisOffset.calculateBottomOutset(rectangle2D2.getHeight());
        for (ValueAxis valueAxis2 : axisCollection.getAxesAtBottom()) {
            axisState = valueAxis2.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.BOTTOM, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(valueAxis2, axisState);
        }
        d = rectangle2D2.getMinX() - this.axisOffset.calculateLeftOutset(rectangle2D2.getWidth());
        for (ValueAxis valueAxis2 : axisCollection.getAxesAtLeft()) {
            axisState = valueAxis2.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.LEFT, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(valueAxis2, axisState);
        }
        d = rectangle2D2.getMaxX() + this.axisOffset.calculateRightOutset(rectangle2D2.getWidth());
        for (ValueAxis valueAxis2 : axisCollection.getAxesAtRight()) {
            axisState = valueAxis2.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.RIGHT, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(valueAxis2, axisState);
        }
        return hashMap;
    }

    public boolean render(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, PlotRenderingInfo plotRenderingInfo, CrosshairState crosshairState) {
        boolean bl;
        block12: {
            bl = false;
            XYDataset xYDataset = this.getDataset(n);
            if (DatasetUtilities.isEmptyOrNull(xYDataset)) break block12;
            bl = true;
            ValueAxis valueAxis = this.getDomainAxisForDataset(n);
            ValueAxis valueAxis2 = this.getRangeAxisForDataset(n);
            if (valueAxis == null || valueAxis2 == null) {
                return bl;
            }
            XYItemRenderer xYItemRenderer = this.getRenderer(n);
            if (xYItemRenderer == null && (xYItemRenderer = this.getRenderer()) == null) {
                return bl;
            }
            XYItemRendererState xYItemRendererState = xYItemRenderer.initialise(graphics2D, rectangle2D, this, xYDataset, plotRenderingInfo);
            int n2 = xYItemRenderer.getPassCount();
            SeriesRenderingOrder seriesRenderingOrder = this.getSeriesRenderingOrder();
            if (seriesRenderingOrder == SeriesRenderingOrder.REVERSE) {
                for (int i = 0; i < n2; ++i) {
                    int n3 = xYDataset.getSeriesCount();
                    for (int j = n3 - 1; j >= 0; --j) {
                        int n4 = 0;
                        int n5 = xYDataset.getItemCount(j) - 1;
                        if (n5 == -1) continue;
                        if (xYItemRendererState.getProcessVisibleItemsOnly()) {
                            int[] nArray = RendererUtilities.findLiveItems(xYDataset, j, valueAxis.getLowerBound(), valueAxis.getUpperBound());
                            n4 = Math.max(nArray[0] - 1, 0);
                            n5 = Math.min(nArray[1] + 1, n5);
                        }
                        xYItemRendererState.startSeriesPass(xYDataset, j, n4, n5, i, n2);
                        for (int k = n4; k <= n5; ++k) {
                            xYItemRenderer.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, this, valueAxis, valueAxis2, xYDataset, j, k, crosshairState, i);
                        }
                        xYItemRendererState.endSeriesPass(xYDataset, j, n4, n5, i, n2);
                    }
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    int n6 = xYDataset.getSeriesCount();
                    for (int j = 0; j < n6; ++j) {
                        int n7 = 0;
                        int n8 = xYDataset.getItemCount(j) - 1;
                        if (xYItemRendererState.getProcessVisibleItemsOnly()) {
                            int[] nArray = RendererUtilities.findLiveItems(xYDataset, j, valueAxis.getLowerBound(), valueAxis.getUpperBound());
                            n7 = Math.max(nArray[0] - 1, 0);
                            n8 = Math.min(nArray[1] + 1, n8);
                        }
                        xYItemRendererState.startSeriesPass(xYDataset, j, n7, n8, i, n2);
                        for (int k = n7; k <= n8; ++k) {
                            xYItemRenderer.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, this, valueAxis, valueAxis2, xYDataset, j, k, crosshairState, i);
                        }
                        xYItemRendererState.endSeriesPass(xYDataset, j, n7, n8, i, n2);
                    }
                }
            }
        }
        return bl;
    }

    public ValueAxis getDomainAxisForDataset(int n) {
        int n2 = Math.max(this.getDatasetCount(), this.getRendererCount());
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Index " + n + " out of bounds.");
        }
        ValueAxis valueAxis = null;
        List list = (List)this.datasetToDomainAxesMap.get(new Integer(n));
        if (list != null) {
            Integer n3 = (Integer)list.get(0);
            valueAxis = this.getDomainAxis(n3);
        } else {
            valueAxis = this.getDomainAxis(0);
        }
        return valueAxis;
    }

    public ValueAxis getRangeAxisForDataset(int n) {
        int n2 = Math.max(this.getDatasetCount(), this.getRendererCount());
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Index " + n + " out of bounds.");
        }
        ValueAxis valueAxis = null;
        List list = (List)this.datasetToRangeAxesMap.get(new Integer(n));
        if (list != null) {
            Integer n3 = (Integer)list.get(0);
            valueAxis = this.getRangeAxis(n3);
        } else {
            valueAxis = this.getRangeAxis(0);
        }
        return valueAxis;
    }

    protected void drawDomainGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (this.getRenderer() == null) {
            return;
        }
        if (this.isDomainGridlinesVisible() || this.isDomainMinorGridlinesVisible()) {
            Stroke stroke = null;
            Paint paint = null;
            Iterator iterator = list.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                XYItemRenderer xYItemRenderer;
                bl = false;
                ValueTick valueTick = (ValueTick)iterator.next();
                if (valueTick.getTickType() == TickType.MINOR && this.isDomainMinorGridlinesVisible()) {
                    stroke = this.getDomainMinorGridlineStroke();
                    paint = this.getDomainMinorGridlinePaint();
                    bl = true;
                } else if (valueTick.getTickType() == TickType.MAJOR && this.isDomainGridlinesVisible()) {
                    stroke = this.getDomainGridlineStroke();
                    paint = this.getDomainGridlinePaint();
                    bl = true;
                }
                if (!((xYItemRenderer = this.getRenderer()) instanceof AbstractXYItemRenderer) || !bl) continue;
                ((AbstractXYItemRenderer)xYItemRenderer).drawDomainLine(graphics2D, this, this.getDomainAxis(), rectangle2D, valueTick.getValue(), paint, stroke);
            }
        }
    }

    protected void drawRangeGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (this.getRenderer() == null) {
            return;
        }
        if (this.isRangeGridlinesVisible() || this.isRangeMinorGridlinesVisible()) {
            Stroke stroke = null;
            Paint paint = null;
            ValueAxis valueAxis = this.getRangeAxis();
            if (valueAxis != null) {
                Iterator iterator = list.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    bl = false;
                    ValueTick valueTick = (ValueTick)iterator.next();
                    if (valueTick.getTickType() == TickType.MINOR && this.isRangeMinorGridlinesVisible()) {
                        stroke = this.getRangeMinorGridlineStroke();
                        paint = this.getRangeMinorGridlinePaint();
                        bl = true;
                    } else if (valueTick.getTickType() == TickType.MAJOR && this.isRangeGridlinesVisible()) {
                        stroke = this.getRangeGridlineStroke();
                        paint = this.getRangeGridlinePaint();
                        bl = true;
                    }
                    if (valueTick.getValue() == 0.0 && this.isRangeZeroBaselineVisible() || !bl) continue;
                    this.getRenderer().drawRangeLine(graphics2D, this, this.getRangeAxis(), rectangle2D, valueTick.getValue(), paint, stroke);
                }
            }
        }
    }

    protected void drawZeroDomainBaseline(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        XYItemRenderer xYItemRenderer;
        if (this.isDomainZeroBaselineVisible() && (xYItemRenderer = this.getRenderer()) instanceof AbstractXYItemRenderer) {
            AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)xYItemRenderer;
            abstractXYItemRenderer.drawDomainLine(graphics2D, this, this.getDomainAxis(), rectangle2D, 0.0, this.domainZeroBaselinePaint, this.domainZeroBaselineStroke);
        }
    }

    protected void drawZeroRangeBaseline(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.isRangeZeroBaselineVisible()) {
            this.getRenderer().drawRangeLine(graphics2D, this, this.getRangeAxis(), rectangle2D, 0.0, this.rangeZeroBaselinePaint, this.rangeZeroBaselineStroke);
        }
    }

    public void drawAnnotations(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        for (XYAnnotation xYAnnotation : this.annotations) {
            ValueAxis valueAxis = this.getDomainAxis();
            ValueAxis valueAxis2 = this.getRangeAxis();
            xYAnnotation.draw(graphics2D, this, rectangle2D, valueAxis, valueAxis2, 0, plotRenderingInfo);
        }
    }

    protected void drawDomainMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, Layer layer) {
        XYItemRenderer xYItemRenderer = this.getRenderer(n);
        if (xYItemRenderer == null) {
            return;
        }
        if (n >= this.getDatasetCount()) {
            return;
        }
        Collection collection = this.getDomainMarkers(n, layer);
        ValueAxis valueAxis = this.getDomainAxisForDataset(n);
        if (collection != null && valueAxis != null) {
            for (Marker marker : collection) {
                xYItemRenderer.drawDomainMarker(graphics2D, this, valueAxis, marker, rectangle2D);
            }
        }
    }

    protected void drawRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, Layer layer) {
        XYItemRenderer xYItemRenderer = this.getRenderer(n);
        if (xYItemRenderer == null) {
            return;
        }
        if (n >= this.getDatasetCount()) {
            return;
        }
        Collection collection = this.getRangeMarkers(n, layer);
        ValueAxis valueAxis = this.getRangeAxisForDataset(n);
        if (collection != null && valueAxis != null) {
            for (Marker marker : collection) {
                xYItemRenderer.drawRangeMarker(graphics2D, this, valueAxis, marker, rectangle2D);
            }
        }
    }

    public Collection getDomainMarkers(Layer layer) {
        return this.getDomainMarkers(0, layer);
    }

    public Collection getRangeMarkers(Layer layer) {
        return this.getRangeMarkers(0, layer);
    }

    public Collection getDomainMarkers(int n, Layer layer) {
        Collection collection = null;
        Integer n2 = new Integer(n);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.foregroundDomainMarkers.get(n2);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.backgroundDomainMarkers.get(n2);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    public Collection getRangeMarkers(int n, Layer layer) {
        Collection collection = null;
        Integer n2 = new Integer(n);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.foregroundRangeMarkers.get(n2);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.backgroundRangeMarkers.get(n2);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    protected void drawHorizontalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        ValueAxis valueAxis = this.getRangeAxis();
        if (this.getOrientation() == PlotOrientation.HORIZONTAL) {
            valueAxis = this.getDomainAxis();
        }
        if (valueAxis.getRange().contains(d)) {
            double d2 = valueAxis.valueToJava2D(d, rectangle2D, RectangleEdge.LEFT);
            Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
    }

    protected void drawDomainCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotOrientation plotOrientation, double d, ValueAxis valueAxis, Stroke stroke, Paint paint) {
        if (valueAxis.getRange().contains(d)) {
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.VERTICAL) {
                double d2 = valueAxis.valueToJava2D(d, rectangle2D, RectangleEdge.BOTTOM);
                double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            } else {
                double d3 = valueAxis.valueToJava2D(d, rectangle2D, RectangleEdge.LEFT);
                double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
            }
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
    }

    protected void drawVerticalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        ValueAxis valueAxis = this.getDomainAxis();
        if (this.getOrientation() == PlotOrientation.HORIZONTAL) {
            valueAxis = this.getRangeAxis();
        }
        if (valueAxis.getRange().contains(d)) {
            double d2 = valueAxis.valueToJava2D(d, rectangle2D, RectangleEdge.BOTTOM);
            Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
    }

    protected void drawRangeCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotOrientation plotOrientation, double d, ValueAxis valueAxis, Stroke stroke, Paint paint) {
        if (valueAxis.getRange().contains(d)) {
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double d2 = valueAxis.valueToJava2D(d, rectangle2D, RectangleEdge.BOTTOM);
                double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            } else {
                double d3 = valueAxis.valueToJava2D(d, rectangle2D, RectangleEdge.LEFT);
                double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
            }
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            ValueAxis valueAxis;
            ValueAxis valueAxis2 = this.getDomainAxis();
            if (valueAxis2 != null) {
                double d = valueAxis2.java2DToValue(n, plotRenderingInfo.getDataArea(), this.getDomainAxisEdge());
                this.setDomainCrosshairValue(d);
            }
            if ((valueAxis = this.getRangeAxis()) != null) {
                double d = valueAxis.java2DToValue(n2, plotRenderingInfo.getDataArea(), this.getRangeAxisEdge());
                this.setRangeCrosshairValue(d);
            }
        }
    }

    private List getDatasetsMappedToDomainAxis(Integer n) {
        if (n == null) {
            throw new IllegalArgumentException("Null 'axisIndex' argument.");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.datasets.size(); ++i) {
            List list = (List)this.datasetToDomainAxesMap.get(new Integer(i));
            if (list == null) {
                if (!n.equals(ZERO)) continue;
                arrayList.add(this.datasets.get(i));
                continue;
            }
            if (!list.contains(n)) continue;
            arrayList.add(this.datasets.get(i));
        }
        return arrayList;
    }

    private List getDatasetsMappedToRangeAxis(Integer n) {
        if (n == null) {
            throw new IllegalArgumentException("Null 'axisIndex' argument.");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.datasets.size(); ++i) {
            List list = (List)this.datasetToRangeAxesMap.get(new Integer(i));
            if (list == null) {
                if (!n.equals(ZERO)) continue;
                arrayList.add(this.datasets.get(i));
                continue;
            }
            if (!list.contains(n)) continue;
            arrayList.add(this.datasets.get(i));
        }
        return arrayList;
    }

    public int getDomainAxisIndex(ValueAxis valueAxis) {
        Plot plot;
        int n = this.domainAxes.indexOf(valueAxis);
        if (n < 0 && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            n = xYPlot.getDomainAxisIndex(valueAxis);
        }
        return n;
    }

    public int getRangeAxisIndex(ValueAxis valueAxis) {
        Plot plot;
        int n = this.rangeAxes.indexOf(valueAxis);
        if (n < 0 && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            n = xYPlot.getRangeAxisIndex(valueAxis);
        }
        return n;
    }

    public Range getDataRange(ValueAxis valueAxis) {
        int n;
        Range range = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        boolean bl = true;
        int n2 = this.getDomainAxisIndex(valueAxis);
        if (n2 >= 0) {
            bl = true;
            arrayList.addAll(this.getDatasetsMappedToDomainAxis(new Integer(n2)));
            if (n2 == 0) {
                for (Object object : this.annotations) {
                    if (!(object instanceof XYAnnotationBoundsInfo)) continue;
                    arrayList2.add(object);
                }
            }
        }
        if ((n = this.getRangeAxisIndex(valueAxis)) >= 0) {
            bl = false;
            arrayList.addAll(this.getDatasetsMappedToRangeAxis(new Integer(n)));
            if (n == 0) {
                for (Object object : this.annotations) {
                    if (!(object instanceof XYAnnotationBoundsInfo)) continue;
                    arrayList2.add(object);
                }
            }
        }
        for (Object object : arrayList) {
            if (object == null) continue;
            Object object2 = this.getRendererForDataset((XYDataset)object);
            range = bl ? (object2 != null ? Range.combine(range, object2.findDomainBounds((XYDataset)object)) : Range.combine(range, DatasetUtilities.findDomainBounds((XYDataset)object))) : (object2 != null ? Range.combine(range, object2.findRangeBounds((XYDataset)object)) : Range.combine(range, DatasetUtilities.findRangeBounds((XYDataset)object)));
            if (!(object2 instanceof AbstractXYItemRenderer)) continue;
            AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)object2;
            Collection collection = abstractXYItemRenderer.getAnnotations();
            for (XYAnnotation xYAnnotation : collection) {
                if (!(xYAnnotation instanceof XYAnnotationBoundsInfo)) continue;
                arrayList2.add(xYAnnotation);
            }
        }
        for (Object object2 : arrayList2) {
            if (!object2.getIncludeInDataBounds()) continue;
            if (bl) {
                range = Range.combine(range, object2.getXRange());
                continue;
            }
            range = Range.combine(range, object2.getYRange());
        }
        return range;
    }

    public void annotationChanged(AnnotationChangeEvent annotationChangeEvent) {
        if (this.getParent() != null) {
            this.getParent().annotationChanged(annotationChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.configureDomainAxes();
        this.configureRangeAxes();
        if (this.getParent() != null) {
            this.getParent().datasetChanged(datasetChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            plotChangeEvent.setType(ChartChangeEventType.DATASET_UPDATED);
            this.notifyListeners(plotChangeEvent);
        }
    }

    public void rendererChanged(RendererChangeEvent rendererChangeEvent) {
        if (rendererChangeEvent.getSeriesVisibilityChanged()) {
            this.configureDomainAxes();
            this.configureRangeAxes();
        }
        this.fireChangeEvent();
    }

    public boolean isDomainCrosshairVisible() {
        return this.domainCrosshairVisible;
    }

    public void setDomainCrosshairVisible(boolean bl) {
        if (this.domainCrosshairVisible != bl) {
            this.domainCrosshairVisible = bl;
            this.fireChangeEvent();
        }
    }

    public boolean isDomainCrosshairLockedOnData() {
        return this.domainCrosshairLockedOnData;
    }

    public void setDomainCrosshairLockedOnData(boolean bl) {
        if (this.domainCrosshairLockedOnData != bl) {
            this.domainCrosshairLockedOnData = bl;
            this.fireChangeEvent();
        }
    }

    public double getDomainCrosshairValue() {
        return this.domainCrosshairValue;
    }

    public void setDomainCrosshairValue(double d) {
        this.setDomainCrosshairValue(d, true);
    }

    public void setDomainCrosshairValue(double d, boolean bl) {
        this.domainCrosshairValue = d;
        if (this.isDomainCrosshairVisible() && bl) {
            this.fireChangeEvent();
        }
    }

    public Stroke getDomainCrosshairStroke() {
        return this.domainCrosshairStroke;
    }

    public void setDomainCrosshairStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.domainCrosshairStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getDomainCrosshairPaint() {
        return this.domainCrosshairPaint;
    }

    public void setDomainCrosshairPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainCrosshairPaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean bl) {
        if (this.rangeCrosshairVisible != bl) {
            this.rangeCrosshairVisible = bl;
            this.fireChangeEvent();
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean bl) {
        if (this.rangeCrosshairLockedOnData != bl) {
            this.rangeCrosshairLockedOnData = bl;
            this.fireChangeEvent();
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double d) {
        this.setRangeCrosshairValue(d, true);
    }

    public void setRangeCrosshairValue(double d, boolean bl) {
        this.rangeCrosshairValue = d;
        if (this.isRangeCrosshairVisible() && bl) {
            this.fireChangeEvent();
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeCrosshairStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeCrosshairPaint = paint;
        this.fireChangeEvent();
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace axisSpace) {
        this.setFixedDomainAxisSpace(axisSpace, true);
    }

    public void setFixedDomainAxisSpace(AxisSpace axisSpace, boolean bl) {
        this.fixedDomainAxisSpace = axisSpace;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace axisSpace) {
        this.setFixedRangeAxisSpace(axisSpace, true);
    }

    public void setFixedRangeAxisSpace(AxisSpace axisSpace, boolean bl) {
        this.fixedRangeAxisSpace = axisSpace;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public boolean isDomainPannable() {
        return this.domainPannable;
    }

    public void setDomainPannable(boolean bl) {
        this.domainPannable = bl;
    }

    public boolean isRangePannable() {
        return this.rangePannable;
    }

    public void setRangePannable(boolean bl) {
        this.rangePannable = bl;
    }

    public void panDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        if (!this.isDomainPannable()) {
            return;
        }
        int n = this.getDomainAxisCount();
        for (int i = 0; i < n; ++i) {
            ValueAxis valueAxis = this.getDomainAxis(i);
            if (valueAxis == null) continue;
            if (valueAxis.isInverted()) {
                d = -d;
            }
            valueAxis.pan(d);
        }
    }

    public void panRangeAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        if (!this.isRangePannable()) {
            return;
        }
        int n = this.getRangeAxisCount();
        for (int i = 0; i < n; ++i) {
            ValueAxis valueAxis = this.getRangeAxis(i);
            if (valueAxis == null) continue;
            if (valueAxis.isInverted()) {
                d = -d;
            }
            valueAxis.pan(d);
        }
    }

    public void zoomDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.zoomDomainAxes(d, plotRenderingInfo, point2D, false);
    }

    public void zoomDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl) {
        for (int i = 0; i < this.domainAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.domainAxes.get(i);
            if (valueAxis == null) continue;
            if (bl) {
                double d2 = point2D.getX();
                if (this.orientation == PlotOrientation.HORIZONTAL) {
                    d2 = point2D.getY();
                }
                double d3 = valueAxis.java2DToValue(d2, plotRenderingInfo.getDataArea(), this.getDomainAxisEdge());
                valueAxis.resizeRange2(d, d3);
                continue;
            }
            valueAxis.resizeRange(d);
        }
    }

    public void zoomDomainAxes(double d, double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        for (int i = 0; i < this.domainAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.domainAxes.get(i);
            if (valueAxis == null) continue;
            valueAxis.zoomRange(d, d2);
        }
    }

    public void zoomRangeAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.zoomRangeAxes(d, plotRenderingInfo, point2D, false);
    }

    public void zoomRangeAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl) {
        for (int i = 0; i < this.rangeAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(i);
            if (valueAxis == null) continue;
            if (bl) {
                double d2 = point2D.getY();
                if (this.orientation == PlotOrientation.HORIZONTAL) {
                    d2 = point2D.getX();
                }
                double d3 = valueAxis.java2DToValue(d2, plotRenderingInfo.getDataArea(), this.getRangeAxisEdge());
                valueAxis.resizeRange2(d, d3);
                continue;
            }
            valueAxis.resizeRange(d);
        }
    }

    public void zoomRangeAxes(double d, double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        for (int i = 0; i < this.rangeAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(i);
            if (valueAxis == null) continue;
            valueAxis.zoomRange(d, d2);
        }
    }

    public boolean isDomainZoomable() {
        return true;
    }

    public boolean isRangeZoomable() {
        return true;
    }

    public int getSeriesCount() {
        int n = 0;
        XYDataset xYDataset = this.getDataset();
        if (xYDataset != null) {
            n = xYDataset.getSeriesCount();
        }
        return n;
    }

    public LegendItemCollection getFixedLegendItems() {
        return this.fixedLegendItems;
    }

    public void setFixedLegendItems(LegendItemCollection legendItemCollection) {
        this.fixedLegendItems = legendItemCollection;
        this.fireChangeEvent();
    }

    public LegendItemCollection getLegendItems() {
        if (this.fixedLegendItems != null) {
            return this.fixedLegendItems;
        }
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        int n = this.datasets.size();
        for (int i = 0; i < n; ++i) {
            XYDataset xYDataset = this.getDataset(i);
            if (xYDataset == null) continue;
            XYItemRenderer xYItemRenderer = this.getRenderer(i);
            if (xYItemRenderer == null) {
                xYItemRenderer = this.getRenderer(0);
            }
            if (xYItemRenderer == null) continue;
            int n2 = xYDataset.getSeriesCount();
            for (int j = 0; j < n2; ++j) {
                LegendItem legendItem;
                if (!xYItemRenderer.isSeriesVisible(j) || !xYItemRenderer.isSeriesVisibleInLegend(j) || (legendItem = xYItemRenderer.getLegendItem(i, j)) == null) continue;
                legendItemCollection.add(legendItem);
            }
        }
        return legendItemCollection;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYPlot)) {
            return false;
        }
        XYPlot xYPlot = (XYPlot)object;
        if (this.weight != xYPlot.weight) {
            return false;
        }
        if (this.orientation != xYPlot.orientation) {
            return false;
        }
        if (!this.domainAxes.equals(xYPlot.domainAxes)) {
            return false;
        }
        if (!this.domainAxisLocations.equals(xYPlot.domainAxisLocations)) {
            return false;
        }
        if (this.rangeCrosshairLockedOnData != xYPlot.rangeCrosshairLockedOnData) {
            return false;
        }
        if (this.domainGridlinesVisible != xYPlot.domainGridlinesVisible) {
            return false;
        }
        if (this.rangeGridlinesVisible != xYPlot.rangeGridlinesVisible) {
            return false;
        }
        if (this.domainMinorGridlinesVisible != xYPlot.domainMinorGridlinesVisible) {
            return false;
        }
        if (this.rangeMinorGridlinesVisible != xYPlot.rangeMinorGridlinesVisible) {
            return false;
        }
        if (this.domainZeroBaselineVisible != xYPlot.domainZeroBaselineVisible) {
            return false;
        }
        if (this.rangeZeroBaselineVisible != xYPlot.rangeZeroBaselineVisible) {
            return false;
        }
        if (this.domainCrosshairVisible != xYPlot.domainCrosshairVisible) {
            return false;
        }
        if (this.domainCrosshairValue != xYPlot.domainCrosshairValue) {
            return false;
        }
        if (this.domainCrosshairLockedOnData != xYPlot.domainCrosshairLockedOnData) {
            return false;
        }
        if (this.rangeCrosshairVisible != xYPlot.rangeCrosshairVisible) {
            return false;
        }
        if (this.rangeCrosshairValue != xYPlot.rangeCrosshairValue) {
            return false;
        }
        if (!ObjectUtilities.equal(this.axisOffset, xYPlot.axisOffset)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.renderers, xYPlot.renderers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeAxes, xYPlot.rangeAxes)) {
            return false;
        }
        if (!this.rangeAxisLocations.equals(xYPlot.rangeAxisLocations)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.datasetToDomainAxesMap, xYPlot.datasetToDomainAxesMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.datasetToRangeAxesMap, xYPlot.datasetToRangeAxesMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainGridlineStroke, xYPlot.domainGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainGridlinePaint, xYPlot.domainGridlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeGridlineStroke, xYPlot.rangeGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeGridlinePaint, xYPlot.rangeGridlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainMinorGridlineStroke, xYPlot.domainMinorGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainMinorGridlinePaint, xYPlot.domainMinorGridlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeMinorGridlineStroke, xYPlot.rangeMinorGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeMinorGridlinePaint, xYPlot.rangeMinorGridlinePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainZeroBaselinePaint, xYPlot.domainZeroBaselinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainZeroBaselineStroke, xYPlot.domainZeroBaselineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeZeroBaselinePaint, xYPlot.rangeZeroBaselinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeZeroBaselineStroke, xYPlot.rangeZeroBaselineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainCrosshairStroke, xYPlot.domainCrosshairStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainCrosshairPaint, xYPlot.domainCrosshairPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeCrosshairStroke, xYPlot.rangeCrosshairStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeCrosshairPaint, xYPlot.rangeCrosshairPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundDomainMarkers, xYPlot.foregroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundDomainMarkers, xYPlot.backgroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundRangeMarkers, xYPlot.foregroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundRangeMarkers, xYPlot.backgroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundDomainMarkers, xYPlot.foregroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundDomainMarkers, xYPlot.backgroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundRangeMarkers, xYPlot.foregroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundRangeMarkers, xYPlot.backgroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.annotations, xYPlot.annotations)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fixedLegendItems, xYPlot.fixedLegendItems)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainTickBandPaint, xYPlot.domainTickBandPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeTickBandPaint, xYPlot.rangeTickBandPaint)) {
            return false;
        }
        if (!this.quadrantOrigin.equals(xYPlot.quadrantOrigin)) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (PaintUtilities.equal(this.quadrantPaint[i], xYPlot.quadrantPaint[i])) continue;
            return false;
        }
        if (!ObjectUtilities.equal(this.shadowGenerator, xYPlot.shadowGenerator)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        PublicCloneable publicCloneable;
        Object object;
        int n;
        XYPlot xYPlot = (XYPlot)super.clone();
        xYPlot.domainAxes = (ObjectList)ObjectUtilities.clone(this.domainAxes);
        for (n = 0; n < this.domainAxes.size(); ++n) {
            object = (ValueAxis)this.domainAxes.get(n);
            if (object == null) continue;
            publicCloneable = (ValueAxis)((ValueAxis)object).clone();
            xYPlot.domainAxes.set(n, publicCloneable);
            ((Axis)((Object)publicCloneable)).setPlot(xYPlot);
            ((Axis)((Object)publicCloneable)).addChangeListener(xYPlot);
        }
        xYPlot.domainAxisLocations = (ObjectList)this.domainAxisLocations.clone();
        xYPlot.rangeAxes = (ObjectList)ObjectUtilities.clone(this.rangeAxes);
        for (n = 0; n < this.rangeAxes.size(); ++n) {
            object = (ValueAxis)this.rangeAxes.get(n);
            if (object == null) continue;
            publicCloneable = (ValueAxis)((ValueAxis)object).clone();
            xYPlot.rangeAxes.set(n, publicCloneable);
            ((Axis)((Object)publicCloneable)).setPlot(xYPlot);
            ((Axis)((Object)publicCloneable)).addChangeListener(xYPlot);
        }
        xYPlot.rangeAxisLocations = (ObjectList)ObjectUtilities.clone(this.rangeAxisLocations);
        xYPlot.datasets = (ObjectList)ObjectUtilities.clone(this.datasets);
        for (n = 0; n < xYPlot.datasets.size(); ++n) {
            object = this.getDataset(n);
            if (object == null) continue;
            object.addChangeListener(xYPlot);
        }
        xYPlot.datasetToDomainAxesMap = new TreeMap();
        xYPlot.datasetToDomainAxesMap.putAll(this.datasetToDomainAxesMap);
        xYPlot.datasetToRangeAxesMap = new TreeMap();
        xYPlot.datasetToRangeAxesMap.putAll(this.datasetToRangeAxesMap);
        xYPlot.renderers = (ObjectList)ObjectUtilities.clone(this.renderers);
        for (n = 0; n < this.renderers.size(); ++n) {
            object = (XYItemRenderer)this.renderers.get(n);
            if (!(object instanceof PublicCloneable)) continue;
            publicCloneable = (PublicCloneable)object;
            XYItemRenderer xYItemRenderer = (XYItemRenderer)publicCloneable.clone();
            xYPlot.renderers.set(n, xYItemRenderer);
            xYItemRenderer.setPlot(xYPlot);
            xYItemRenderer.addChangeListener(xYPlot);
        }
        xYPlot.foregroundDomainMarkers = (Map)ObjectUtilities.clone(this.foregroundDomainMarkers);
        xYPlot.backgroundDomainMarkers = (Map)ObjectUtilities.clone(this.backgroundDomainMarkers);
        xYPlot.foregroundRangeMarkers = (Map)ObjectUtilities.clone(this.foregroundRangeMarkers);
        xYPlot.backgroundRangeMarkers = (Map)ObjectUtilities.clone(this.backgroundRangeMarkers);
        xYPlot.annotations = (List)ObjectUtilities.deepClone(this.annotations);
        if (this.fixedDomainAxisSpace != null) {
            xYPlot.fixedDomainAxisSpace = (AxisSpace)ObjectUtilities.clone(this.fixedDomainAxisSpace);
        }
        if (this.fixedRangeAxisSpace != null) {
            xYPlot.fixedRangeAxisSpace = (AxisSpace)ObjectUtilities.clone(this.fixedRangeAxisSpace);
        }
        if (this.fixedLegendItems != null) {
            xYPlot.fixedLegendItems = (LegendItemCollection)this.fixedLegendItems.clone();
        }
        xYPlot.quadrantOrigin = (Point2D)ObjectUtilities.clone(this.quadrantOrigin);
        xYPlot.quadrantPaint = (Paint[])this.quadrantPaint.clone();
        return xYPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.domainGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.domainMinorGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainMinorGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeMinorGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeMinorGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeZeroBaselineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeZeroBaselinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.domainCrosshairStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainCrosshairPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeCrosshairStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeCrosshairPaint, objectOutputStream);
        SerialUtilities.writePaint(this.domainTickBandPaint, objectOutputStream);
        SerialUtilities.writePaint(this.rangeTickBandPaint, objectOutputStream);
        SerialUtilities.writePoint2D(this.quadrantOrigin, objectOutputStream);
        for (int i = 0; i < 4; ++i) {
            SerialUtilities.writePaint(this.quadrantPaint[i], objectOutputStream);
        }
        SerialUtilities.writeStroke(this.domainZeroBaselineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainZeroBaselinePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        int n2;
        int n3;
        int n4;
        objectInputStream.defaultReadObject();
        this.domainGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.domainMinorGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainMinorGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeMinorGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeMinorGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeZeroBaselineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeZeroBaselinePaint = SerialUtilities.readPaint(objectInputStream);
        this.domainCrosshairStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainCrosshairPaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeCrosshairStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeCrosshairPaint = SerialUtilities.readPaint(objectInputStream);
        this.domainTickBandPaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeTickBandPaint = SerialUtilities.readPaint(objectInputStream);
        this.quadrantOrigin = SerialUtilities.readPoint2D(objectInputStream);
        this.quadrantPaint = new Paint[4];
        for (n4 = 0; n4 < 4; ++n4) {
            this.quadrantPaint[n4] = SerialUtilities.readPaint(objectInputStream);
        }
        this.domainZeroBaselineStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainZeroBaselinePaint = SerialUtilities.readPaint(objectInputStream);
        n4 = this.domainAxes.size();
        for (n3 = 0; n3 < n4; ++n3) {
            Axis axis = (Axis)this.domainAxes.get(n3);
            if (axis == null) continue;
            axis.setPlot(this);
            axis.addChangeListener(this);
        }
        n3 = this.rangeAxes.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Axis axis = (Axis)this.rangeAxes.get(n2);
            if (axis == null) continue;
            axis.setPlot(this);
            axis.addChangeListener(this);
        }
        n2 = this.datasets.size();
        for (n = 0; n < n2; ++n) {
            Dataset dataset = (Dataset)this.datasets.get(n);
            if (dataset == null) continue;
            dataset.addChangeListener(this);
        }
        n = this.renderers.size();
        for (int i = 0; i < n; ++i) {
            XYItemRenderer xYItemRenderer = (XYItemRenderer)this.renderers.get(i);
            if (xYItemRenderer == null) continue;
            xYItemRenderer.addChangeListener(this);
        }
    }
}

