/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.LegendItemCollection;
import ai.org.jfree.chart.axis.Axis;
import ai.org.jfree.chart.axis.AxisState;
import ai.org.jfree.chart.axis.NumberTick;
import ai.org.jfree.chart.axis.NumberTickUnit;
import ai.org.jfree.chart.axis.TickUnit;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.event.RendererChangeEvent;
import ai.org.jfree.chart.event.RendererChangeListener;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.PlotState;
import ai.org.jfree.chart.plot.PolarAxisLocation;
import ai.org.jfree.chart.plot.ValueAxisPlot;
import ai.org.jfree.chart.plot.Zoomable;
import ai.org.jfree.chart.renderer.PolarItemRenderer;
import ai.org.jfree.chart.util.ResourceBundleWrapper;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.general.Dataset;
import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.ui.TextAnchor;
import ai.org.jfree.util.ObjectList;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class PolarPlot
extends Plot
implements ValueAxisPlot,
Zoomable,
RendererChangeListener,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3794383185924179525L;
    private static final int DEFAULT_MARGIN = 20;
    private static final double ANNOTATION_MARGIN = 7.0;
    public static final double DEFAULT_ANGLE_TICK_UNIT_SIZE = 45.0;
    public static final double DEFAULT_ANGLE_OFFSET = -90.0;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.gray;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("ai.org.jfree.chart.plot.LocalizationBundle");
    private List angleTicks;
    private ObjectList axes;
    private ObjectList axisLocations;
    private ObjectList datasets;
    private ObjectList renderers;
    private TickUnit angleTickUnit;
    private double angleOffset;
    private boolean counterClockwise;
    private boolean angleLabelsVisible = true;
    private Font angleLabelFont = new Font("SansSerif", 0, 12);
    private transient Paint angleLabelPaint = Color.black;
    private boolean angleGridlinesVisible;
    private transient Stroke angleGridlineStroke;
    private transient Paint angleGridlinePaint;
    private boolean radiusGridlinesVisible;
    private transient Stroke radiusGridlineStroke;
    private transient Paint radiusGridlinePaint;
    private List cornerTextItems = new ArrayList();
    private int margin;
    private LegendItemCollection fixedLegendItems;
    private Map datasetToAxesMap;

    public PolarPlot() {
        this(null, null, null);
    }

    public PolarPlot(XYDataset xYDataset, ValueAxis valueAxis, PolarItemRenderer polarItemRenderer) {
        this.datasets = new ObjectList();
        this.datasets.set(0, xYDataset);
        if (xYDataset != null) {
            xYDataset.addChangeListener(this);
        }
        this.angleTickUnit = new NumberTickUnit(45.0);
        this.axes = new ObjectList();
        this.datasetToAxesMap = new TreeMap();
        this.axes.set(0, valueAxis);
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.axisLocations = new ObjectList();
        this.axisLocations.set(0, PolarAxisLocation.EAST_ABOVE);
        this.axisLocations.set(1, PolarAxisLocation.NORTH_LEFT);
        this.axisLocations.set(2, PolarAxisLocation.WEST_BELOW);
        this.axisLocations.set(3, PolarAxisLocation.SOUTH_RIGHT);
        this.axisLocations.set(4, PolarAxisLocation.EAST_BELOW);
        this.axisLocations.set(5, PolarAxisLocation.NORTH_RIGHT);
        this.axisLocations.set(6, PolarAxisLocation.WEST_ABOVE);
        this.axisLocations.set(7, PolarAxisLocation.SOUTH_LEFT);
        this.renderers = new ObjectList();
        this.renderers.set(0, polarItemRenderer);
        if (polarItemRenderer != null) {
            polarItemRenderer.setPlot(this);
            polarItemRenderer.addChangeListener(this);
        }
        this.angleOffset = -90.0;
        this.counterClockwise = false;
        this.angleGridlinesVisible = true;
        this.angleGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.angleGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.radiusGridlinesVisible = true;
        this.radiusGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.radiusGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.margin = 20;
    }

    public String getPlotType() {
        return localizationResources.getString("Polar_Plot");
    }

    public ValueAxis getAxis() {
        return this.getAxis(0);
    }

    public ValueAxis getAxis(int n) {
        ValueAxis valueAxis = null;
        if (n < this.axes.size()) {
            valueAxis = (ValueAxis)this.axes.get(n);
        }
        return valueAxis;
    }

    public void setAxis(ValueAxis valueAxis) {
        this.setAxis(0, valueAxis);
    }

    public void setAxis(int n, ValueAxis valueAxis) {
        this.setAxis(n, valueAxis, true);
    }

    public void setAxis(int n, ValueAxis valueAxis, boolean bl) {
        ValueAxis valueAxis2 = this.getAxis(n);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        this.axes.set(n, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public PolarAxisLocation getAxisLocation() {
        return this.getAxisLocation(0);
    }

    public PolarAxisLocation getAxisLocation(int n) {
        PolarAxisLocation polarAxisLocation = null;
        if (n < this.axisLocations.size()) {
            polarAxisLocation = (PolarAxisLocation)this.axisLocations.get(n);
        }
        return polarAxisLocation;
    }

    public void setAxisLocation(PolarAxisLocation polarAxisLocation) {
        this.setAxisLocation(0, polarAxisLocation, true);
    }

    public void setAxisLocation(PolarAxisLocation polarAxisLocation, boolean bl) {
        this.setAxisLocation(0, polarAxisLocation, bl);
    }

    public void setAxisLocation(int n, PolarAxisLocation polarAxisLocation) {
        this.setAxisLocation(n, polarAxisLocation, true);
    }

    public void setAxisLocation(int n, PolarAxisLocation polarAxisLocation, boolean bl) {
        if (polarAxisLocation == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        this.axisLocations.set(n, polarAxisLocation);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public int getAxisCount() {
        return this.axes.size();
    }

    public XYDataset getDataset() {
        return this.getDataset(0);
    }

    public XYDataset getDataset(int n) {
        XYDataset xYDataset = null;
        if (n < this.datasets.size()) {
            xYDataset = (XYDataset)this.datasets.get(n);
        }
        return xYDataset;
    }

    public void setDataset(XYDataset xYDataset) {
        this.setDataset(0, xYDataset);
    }

    public void setDataset(int n, XYDataset xYDataset) {
        XYDataset xYDataset2 = this.getDataset(n);
        if (xYDataset2 != null) {
            xYDataset2.removeChangeListener(this);
        }
        this.datasets.set(n, xYDataset);
        if (xYDataset != null) {
            xYDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, xYDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public int indexOf(XYDataset xYDataset) {
        int n = -1;
        for (int i = 0; i < this.datasets.size(); ++i) {
            if (xYDataset != this.datasets.get(i)) continue;
            n = i;
            break;
        }
        return n;
    }

    public PolarItemRenderer getRenderer() {
        return this.getRenderer(0);
    }

    public PolarItemRenderer getRenderer(int n) {
        PolarItemRenderer polarItemRenderer = null;
        if (n < this.renderers.size()) {
            polarItemRenderer = (PolarItemRenderer)this.renderers.get(n);
        }
        return polarItemRenderer;
    }

    public void setRenderer(PolarItemRenderer polarItemRenderer) {
        this.setRenderer(0, polarItemRenderer);
    }

    public void setRenderer(int n, PolarItemRenderer polarItemRenderer) {
        this.setRenderer(n, polarItemRenderer, true);
    }

    public void setRenderer(int n, PolarItemRenderer polarItemRenderer, boolean bl) {
        PolarItemRenderer polarItemRenderer2 = this.getRenderer(n);
        if (polarItemRenderer2 != null) {
            polarItemRenderer2.removeChangeListener(this);
        }
        this.renderers.set(n, polarItemRenderer);
        if (polarItemRenderer != null) {
            polarItemRenderer.setPlot(this);
            polarItemRenderer.addChangeListener(this);
        }
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public TickUnit getAngleTickUnit() {
        return this.angleTickUnit;
    }

    public void setAngleTickUnit(TickUnit tickUnit) {
        if (tickUnit == null) {
            throw new IllegalArgumentException("Null 'unit' argument.");
        }
        this.angleTickUnit = tickUnit;
        this.fireChangeEvent();
    }

    public double getAngleOffset() {
        return this.angleOffset;
    }

    public void setAngleOffset(double d) {
        this.angleOffset = d;
        this.fireChangeEvent();
    }

    public boolean isCounterClockwise() {
        return this.counterClockwise;
    }

    public void setCounterClockwise(boolean bl) {
        this.counterClockwise = bl;
    }

    public boolean isAngleLabelsVisible() {
        return this.angleLabelsVisible;
    }

    public void setAngleLabelsVisible(boolean bl) {
        if (this.angleLabelsVisible != bl) {
            this.angleLabelsVisible = bl;
            this.fireChangeEvent();
        }
    }

    public Font getAngleLabelFont() {
        return this.angleLabelFont;
    }

    public void setAngleLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.angleLabelFont = font;
        this.fireChangeEvent();
    }

    public Paint getAngleLabelPaint() {
        return this.angleLabelPaint;
    }

    public void setAngleLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.angleLabelPaint = paint;
        this.fireChangeEvent();
    }

    public boolean isAngleGridlinesVisible() {
        return this.angleGridlinesVisible;
    }

    public void setAngleGridlinesVisible(boolean bl) {
        if (this.angleGridlinesVisible != bl) {
            this.angleGridlinesVisible = bl;
            this.fireChangeEvent();
        }
    }

    public Stroke getAngleGridlineStroke() {
        return this.angleGridlineStroke;
    }

    public void setAngleGridlineStroke(Stroke stroke) {
        this.angleGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getAngleGridlinePaint() {
        return this.angleGridlinePaint;
    }

    public void setAngleGridlinePaint(Paint paint) {
        this.angleGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRadiusGridlinesVisible() {
        return this.radiusGridlinesVisible;
    }

    public void setRadiusGridlinesVisible(boolean bl) {
        if (this.radiusGridlinesVisible != bl) {
            this.radiusGridlinesVisible = bl;
            this.fireChangeEvent();
        }
    }

    public Stroke getRadiusGridlineStroke() {
        return this.radiusGridlineStroke;
    }

    public void setRadiusGridlineStroke(Stroke stroke) {
        this.radiusGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRadiusGridlinePaint() {
        return this.radiusGridlinePaint;
    }

    public void setRadiusGridlinePaint(Paint paint) {
        this.radiusGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int n) {
        this.margin = n;
        this.fireChangeEvent();
    }

    public LegendItemCollection getFixedLegendItems() {
        return this.fixedLegendItems;
    }

    public void setFixedLegendItems(LegendItemCollection legendItemCollection) {
        this.fixedLegendItems = legendItemCollection;
        this.fireChangeEvent();
    }

    public void addCornerTextItem(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        this.cornerTextItems.add(string);
        this.fireChangeEvent();
    }

    public void removeCornerTextItem(String string) {
        boolean bl = this.cornerTextItems.remove(string);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void clearCornerTextItems() {
        if (this.cornerTextItems.size() > 0) {
            this.cornerTextItems.clear();
            this.fireChangeEvent();
        }
    }

    protected List refreshAngleTicks() {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        for (double d = 0.0; d < 360.0; d += this.angleTickUnit.getSize()) {
            TextAnchor textAnchor = this.calculateTextAnchor(d);
            NumberTick numberTick = new NumberTick(new Double(d), this.angleTickUnit.valueToString(d), textAnchor, TextAnchor.CENTER, 0.0);
            arrayList.add(numberTick);
        }
        return arrayList;
    }

    protected TextAnchor calculateTextAnchor(double d) {
        double d2;
        TextAnchor textAnchor = TextAnchor.CENTER;
        for (double d3 = this.angleOffset; d3 < 0.0; d3 += 360.0) {
        }
        for (d2 = ((double)(this.counterClockwise ? -1 : 1) * d + d3) % 360.0; this.counterClockwise && d2 < 0.0; d2 += 360.0) {
        }
        if (d2 == 0.0) {
            textAnchor = TextAnchor.CENTER_LEFT;
        } else if (d2 > 0.0 && d2 < 90.0) {
            textAnchor = TextAnchor.TOP_LEFT;
        } else if (d2 == 90.0) {
            textAnchor = TextAnchor.TOP_CENTER;
        } else if (d2 > 90.0 && d2 < 180.0) {
            textAnchor = TextAnchor.TOP_RIGHT;
        } else if (d2 == 180.0) {
            textAnchor = TextAnchor.CENTER_RIGHT;
        } else if (d2 > 180.0 && d2 < 270.0) {
            textAnchor = TextAnchor.BOTTOM_RIGHT;
        } else if (d2 == 270.0) {
            textAnchor = TextAnchor.BOTTOM_CENTER;
        } else if (d2 > 270.0 && d2 < 360.0) {
            textAnchor = TextAnchor.BOTTOM_LEFT;
        }
        return textAnchor;
    }

    public void mapDatasetToAxis(int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        arrayList.add(new Integer(n2));
        this.mapDatasetToAxes(n, arrayList);
    }

    public void mapDatasetToAxes(int n, List list) {
        if (n < 0) {
            throw new IllegalArgumentException("Requires 'index' >= 0.");
        }
        this.checkAxisIndices(list);
        Integer n2 = new Integer(n);
        this.datasetToAxesMap.put(n2, new ArrayList(list));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n)));
    }

    private void checkAxisIndices(List list) {
        if (list == null) {
            return;
        }
        int n = list.size();
        if (n == 0) {
            throw new IllegalArgumentException("Empty list not permitted.");
        }
        HashSet hashSet = new HashSet();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (!(e instanceof Integer)) {
                throw new IllegalArgumentException("Indices must be Integer instances.");
            }
            if (hashSet.contains(e)) {
                throw new IllegalArgumentException("Indices must be unique.");
            }
            hashSet.add(e);
        }
    }

    public ValueAxis getAxisForDataset(int n) {
        ValueAxis valueAxis = null;
        List list = (List)this.datasetToAxesMap.get(new Integer(n));
        if (list != null) {
            Integer n2 = (Integer)list.get(0);
            valueAxis = this.getAxis(n2);
        } else {
            valueAxis = this.getAxis(0);
        }
        return valueAxis;
    }

    public int getAxisIndex(ValueAxis valueAxis) {
        Plot plot;
        int n = this.axes.indexOf(valueAxis);
        if (n < 0 && (plot = this.getParent()) instanceof PolarPlot) {
            PolarPlot polarPlot = (PolarPlot)plot;
            n = polarPlot.getAxisIndex(valueAxis);
        }
        return n;
    }

    public int getIndexOf(PolarItemRenderer polarItemRenderer) {
        return this.renderers.indexOf(polarItemRenderer);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Object object;
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        Rectangle2D rectangle2D2 = rectangle2D;
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
        this.drawBackground(graphics2D, rectangle2D2);
        int n = this.axes.size();
        AxisState axisState = null;
        for (int i = 0; i < n; ++i) {
            object = this.getAxis(i);
            if (object == null) continue;
            PolarAxisLocation polarAxisLocation = (PolarAxisLocation)this.axisLocations.get(i);
            AxisState axisState2 = this.drawAxis((ValueAxis)object, polarAxisLocation, graphics2D, rectangle2D2);
            if (i != 0) continue;
            axisState = axisState2;
        }
        Shape shape = graphics2D.getClip();
        object = graphics2D.getComposite();
        graphics2D.clip(rectangle2D2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        this.angleTicks = this.refreshAngleTicks();
        this.drawGridlines(graphics2D, rectangle2D2, this.angleTicks, axisState.getTicks());
        this.render(graphics2D, rectangle2D2, plotRenderingInfo);
        graphics2D.setClip(shape);
        graphics2D.setComposite((Composite)object);
        this.drawOutline(graphics2D, rectangle2D2);
        this.drawCornerTextItems(graphics2D, rectangle2D2);
    }

    protected void drawCornerTextItems(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.cornerTextItems.isEmpty()) {
            return;
        }
        graphics2D.setColor(Color.black);
        double d = 0.0;
        double d2 = 0.0;
        for (String string : this.cornerTextItems) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
            d = Math.max(d, rectangle2D2.getWidth());
            d2 += rectangle2D2.getHeight();
        }
        double d3 = 14.0;
        double d4 = 7.0;
        double d5 = rectangle2D.getMaxX() - (d += d3);
        double d6 = rectangle2D.getMaxY() - (d2 += d4);
        graphics2D.drawRect((int)d5, (int)d6, (int)d, (int)d2);
        d5 += 7.0;
        for (String string : this.cornerTextItems) {
            Rectangle2D rectangle2D3 = TextUtilities.getTextBounds(string, graphics2D, graphics2D.getFontMetrics());
            graphics2D.drawString(string, (int)d5, (int)(d6 += rectangle2D3.getHeight()));
        }
    }

    protected AxisState drawAxis(ValueAxis valueAxis, PolarAxisLocation polarAxisLocation, Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = rectangle2D.getCenterX();
        double d2 = rectangle2D.getCenterY();
        double d3 = Math.min(rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0) - (double)this.margin;
        double d4 = d - d3;
        double d5 = d2 - d3;
        Rectangle2D.Double double_ = null;
        AxisState axisState = null;
        if (polarAxisLocation == PolarAxisLocation.NORTH_RIGHT) {
            double_ = new Rectangle2D.Double(d4, d5, d3, d3);
            axisState = valueAxis.draw(graphics2D, d, rectangle2D, double_, RectangleEdge.RIGHT, null);
        } else if (polarAxisLocation == PolarAxisLocation.NORTH_LEFT) {
            double_ = new Rectangle2D.Double(d, d5, d3, d3);
            axisState = valueAxis.draw(graphics2D, d, rectangle2D, double_, RectangleEdge.LEFT, null);
        } else if (polarAxisLocation == PolarAxisLocation.SOUTH_LEFT) {
            double_ = new Rectangle2D.Double(d, d2, d3, d3);
            axisState = valueAxis.draw(graphics2D, d, rectangle2D, double_, RectangleEdge.LEFT, null);
        } else if (polarAxisLocation == PolarAxisLocation.SOUTH_RIGHT) {
            double_ = new Rectangle2D.Double(d4, d2, d3, d3);
            axisState = valueAxis.draw(graphics2D, d, rectangle2D, double_, RectangleEdge.RIGHT, null);
        } else if (polarAxisLocation == PolarAxisLocation.EAST_ABOVE) {
            double_ = new Rectangle2D.Double(d, d2, d3, d3);
            axisState = valueAxis.draw(graphics2D, d2, rectangle2D, double_, RectangleEdge.TOP, null);
        } else if (polarAxisLocation == PolarAxisLocation.EAST_BELOW) {
            double_ = new Rectangle2D.Double(d, d5, d3, d3);
            axisState = valueAxis.draw(graphics2D, d2, rectangle2D, double_, RectangleEdge.BOTTOM, null);
        } else if (polarAxisLocation == PolarAxisLocation.WEST_ABOVE) {
            double_ = new Rectangle2D.Double(d4, d2, d3, d3);
            axisState = valueAxis.draw(graphics2D, d2, rectangle2D, double_, RectangleEdge.TOP, null);
        } else if (polarAxisLocation == PolarAxisLocation.WEST_BELOW) {
            double_ = new Rectangle2D.Double(d4, d5, d3, d3);
            axisState = valueAxis.draw(graphics2D, d2, rectangle2D, double_, RectangleEdge.BOTTOM, null);
        }
        return axisState;
    }

    protected void render(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        boolean bl = false;
        int n = this.datasets.size();
        for (int i = n - 1; i >= 0; --i) {
            PolarItemRenderer polarItemRenderer;
            XYDataset xYDataset = this.getDataset(i);
            if (xYDataset == null || (polarItemRenderer = this.getRenderer(i)) == null || DatasetUtilities.isEmptyOrNull(xYDataset)) continue;
            bl = true;
            int n2 = xYDataset.getSeriesCount();
            for (int j = 0; j < n2; ++j) {
                polarItemRenderer.drawSeries(graphics2D, rectangle2D, plotRenderingInfo, this, xYDataset, j);
            }
        }
        if (!bl) {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
    }

    protected void drawGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list, List list2) {
        Paint paint;
        Stroke stroke;
        PolarItemRenderer polarItemRenderer = this.getRenderer();
        if (polarItemRenderer == null) {
            return;
        }
        if (this.isAngleGridlinesVisible()) {
            stroke = this.getAngleGridlineStroke();
            paint = this.getAngleGridlinePaint();
            if (stroke != null && paint != null) {
                polarItemRenderer.drawAngularGridLines(graphics2D, this, list, rectangle2D);
            }
        }
        if (this.isRadiusGridlinesVisible()) {
            stroke = this.getRadiusGridlineStroke();
            paint = this.getRadiusGridlinePaint();
            if (stroke != null && paint != null) {
                polarItemRenderer.drawRadialGridLines(graphics2D, this, this.getAxis(), list2, rectangle2D);
            }
        }
    }

    public void zoom(double d) {
        for (int i = 0; i < this.getAxisCount(); ++i) {
            ValueAxis valueAxis = this.getAxis(i);
            if (valueAxis == null) continue;
            if (d > 0.0) {
                double d2 = valueAxis.getUpperBound();
                double d3 = d2 * d;
                valueAxis.setUpperBound(d3);
                valueAxis.setAutoRange(false);
                continue;
            }
            valueAxis.setAutoRange(true);
        }
    }

    private List getDatasetsMappedToAxis(Integer n) {
        if (n == null) {
            throw new IllegalArgumentException("Null 'axisIndex' argument.");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.datasets.size(); ++i) {
            List list = (List)this.datasetToAxesMap.get(new Integer(i));
            if (list == null) {
                if (!n.equals(ZERO)) continue;
                arrayList.add(this.datasets.get(i));
                continue;
            }
            if (!list.contains(n)) continue;
            arrayList.add(this.datasets.get(i));
        }
        return arrayList;
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        int n = this.getAxisIndex(valueAxis);
        List list = new ArrayList();
        if (n >= 0) {
            list = this.getDatasetsMappedToAxis(new Integer(n));
        }
        Iterator iterator = list.iterator();
        int n2 = -1;
        while (iterator.hasNext()) {
            ++n2;
            XYDataset xYDataset = (XYDataset)iterator.next();
            if (xYDataset == null) continue;
            range = Range.combine(range, DatasetUtilities.findRangeBounds(xYDataset));
        }
        return range;
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        for (int i = 0; i < this.axes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.axes.get(i);
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(datasetChangeEvent);
        } else {
            super.datasetChanged(datasetChangeEvent);
        }
    }

    public void rendererChanged(RendererChangeEvent rendererChangeEvent) {
        this.fireChangeEvent();
    }

    public LegendItemCollection getLegendItems() {
        if (this.fixedLegendItems != null) {
            return this.fixedLegendItems;
        }
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        int n = this.datasets.size();
        for (int i = 0; i < n; ++i) {
            XYDataset xYDataset = this.getDataset(i);
            PolarItemRenderer polarItemRenderer = this.getRenderer(i);
            if (xYDataset == null || polarItemRenderer == null) continue;
            int n2 = xYDataset.getSeriesCount();
            for (int j = 0; j < n2; ++j) {
                LegendItem legendItem = polarItemRenderer.getLegendItem(j);
                legendItemCollection.add(legendItem);
            }
        }
        return legendItemCollection;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PolarPlot)) {
            return false;
        }
        PolarPlot polarPlot = (PolarPlot)object;
        if (!this.axes.equals(polarPlot.axes)) {
            return false;
        }
        if (!this.axisLocations.equals(polarPlot.axisLocations)) {
            return false;
        }
        if (!this.renderers.equals(polarPlot.renderers)) {
            return false;
        }
        if (!this.angleTickUnit.equals(polarPlot.angleTickUnit)) {
            return false;
        }
        if (this.angleGridlinesVisible != polarPlot.angleGridlinesVisible) {
            return false;
        }
        if (this.angleOffset != polarPlot.angleOffset) {
            return false;
        }
        if (this.counterClockwise != polarPlot.counterClockwise) {
            return false;
        }
        if (this.angleLabelsVisible != polarPlot.angleLabelsVisible) {
            return false;
        }
        if (!this.angleLabelFont.equals(polarPlot.angleLabelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.angleLabelPaint, polarPlot.angleLabelPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.angleGridlineStroke, polarPlot.angleGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.angleGridlinePaint, polarPlot.angleGridlinePaint)) {
            return false;
        }
        if (this.radiusGridlinesVisible != polarPlot.radiusGridlinesVisible) {
            return false;
        }
        if (!ObjectUtilities.equal(this.radiusGridlineStroke, polarPlot.radiusGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.radiusGridlinePaint, polarPlot.radiusGridlinePaint)) {
            return false;
        }
        if (!this.cornerTextItems.equals(polarPlot.cornerTextItems)) {
            return false;
        }
        if (this.margin != polarPlot.margin) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fixedLegendItems, polarPlot.fixedLegendItems)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        PublicCloneable publicCloneable;
        Object object;
        int n;
        PolarPlot polarPlot = (PolarPlot)super.clone();
        polarPlot.axes = (ObjectList)ObjectUtilities.clone(this.axes);
        for (n = 0; n < this.axes.size(); ++n) {
            object = (ValueAxis)this.axes.get(n);
            if (object == null) continue;
            publicCloneable = (ValueAxis)((ValueAxis)object).clone();
            polarPlot.axes.set(n, publicCloneable);
            ((Axis)((Object)publicCloneable)).setPlot(polarPlot);
            ((Axis)((Object)publicCloneable)).addChangeListener(polarPlot);
        }
        polarPlot.datasets = (ObjectList)ObjectUtilities.clone(this.datasets);
        for (n = 0; n < polarPlot.datasets.size(); ++n) {
            object = this.getDataset(n);
            if (object == null) continue;
            object.addChangeListener(polarPlot);
        }
        polarPlot.renderers = (ObjectList)ObjectUtilities.clone(this.renderers);
        for (n = 0; n < this.renderers.size(); ++n) {
            object = (PolarItemRenderer)this.renderers.get(n);
            if (!(object instanceof PublicCloneable)) continue;
            publicCloneable = (PublicCloneable)object;
            PolarItemRenderer polarItemRenderer = (PolarItemRenderer)publicCloneable.clone();
            polarPlot.renderers.set(n, polarItemRenderer);
            polarItemRenderer.setPlot(polarPlot);
            polarItemRenderer.addChangeListener(polarPlot);
        }
        polarPlot.cornerTextItems = new ArrayList(this.cornerTextItems);
        return polarPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.angleGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.angleGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.radiusGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.radiusGridlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.angleLabelPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        int n2;
        objectInputStream.defaultReadObject();
        this.angleGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.angleGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.radiusGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.radiusGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.angleLabelPaint = SerialUtilities.readPaint(objectInputStream);
        int n3 = this.axes.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Axis axis = (Axis)this.axes.get(n2);
            if (axis == null) continue;
            axis.setPlot(this);
            axis.addChangeListener(this);
        }
        n2 = this.datasets.size();
        for (n = 0; n < n2; ++n) {
            Dataset dataset = (Dataset)this.datasets.get(n);
            if (dataset == null) continue;
            dataset.addChangeListener(this);
        }
        n = this.renderers.size();
        for (int i = 0; i < n; ++i) {
            PolarItemRenderer polarItemRenderer = (PolarItemRenderer)this.renderers.get(i);
            if (polarItemRenderer == null) continue;
            polarItemRenderer.addChangeListener(this);
        }
    }

    public void zoomDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    public void zoomDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl) {
    }

    public void zoomDomainAxes(double d, double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    public void zoomRangeAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.zoom(d);
    }

    public void zoomRangeAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl) {
        double d2 = point2D.getX();
        for (int i = 0; i < this.getAxisCount(); ++i) {
            ValueAxis valueAxis = this.getAxis(i);
            if (valueAxis == null) continue;
            if (bl) {
                double d3 = valueAxis.java2DToValue(d2, plotRenderingInfo.getDataArea(), RectangleEdge.BOTTOM);
                valueAxis.resizeRange(d, d3);
                continue;
            }
            valueAxis.resizeRange(d);
        }
    }

    public void zoomRangeAxes(double d, double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.zoom((d2 + d) / 2.0);
    }

    public boolean isDomainZoomable() {
        return false;
    }

    public boolean isRangeZoomable() {
        return true;
    }

    public PlotOrientation getOrientation() {
        return PlotOrientation.HORIZONTAL;
    }

    public Point translateToJava2D(double d, double d2, ValueAxis valueAxis, Rectangle2D rectangle2D) {
        if (this.counterClockwise) {
            d = -d;
        }
        double d3 = Math.toRadians(d + this.angleOffset);
        double d4 = rectangle2D.getMinX() + (double)this.margin;
        double d5 = rectangle2D.getMaxX() - (double)this.margin;
        double d6 = rectangle2D.getMinY() + (double)this.margin;
        double d7 = rectangle2D.getMaxY() - (double)this.margin;
        double d8 = (d5 - d4) / 2.0;
        double d9 = (d7 - d6) / 2.0;
        double d10 = d4 + d8;
        double d11 = d6 + d9;
        double d12 = Math.min(d8, d9);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d10, d11, d12, d12);
        double d13 = valueAxis.getLowerBound();
        double d14 = Math.max(d2, d13);
        double d15 = valueAxis.valueToJava2D(d14, double_, RectangleEdge.BOTTOM) - d10;
        float f = (float)(d10 + Math.cos(d3) * d15);
        float f2 = (float)(d11 + Math.sin(d3) * d15);
        int n = Math.round(f);
        int n2 = Math.round(f2);
        Point point = new Point(n, n2);
        return point;
    }

    public Point translateValueThetaRadiusToJava2D(double d, double d2, Rectangle2D rectangle2D) {
        return this.translateToJava2D(d, d2, this.getAxis(), rectangle2D);
    }

    public double getMaxRadius() {
        return this.getAxis().getUpperBound();
    }

    public int getSeriesCount() {
        int n = 0;
        XYDataset xYDataset = this.getDataset(0);
        if (xYDataset != null) {
            n = xYDataset.getSeriesCount();
        }
        return n;
    }

    protected AxisState drawAxis(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        return this.getAxis().draw(graphics2D, rectangle2D2.getMinY(), rectangle2D, rectangle2D2, RectangleEdge.TOP, null);
    }
}

