/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot;

import ai.org.jfree.chart.plot.AbstractPieLabelDistributor;
import ai.org.jfree.chart.plot.PieLabelRecord;
import java.util.Collections;

public class PieLabelDistributor
extends AbstractPieLabelDistributor {
    private double minGap = 4.0;

    public PieLabelDistributor(int n) {
    }

    public void distributeLabels(double d, double d2) {
        this.sort();
        if (this.isOverlap()) {
            this.adjustDownwards(d, d2);
        }
        if (this.isOverlap()) {
            this.adjustUpwards(d, d2);
        }
        if (this.isOverlap()) {
            this.spreadEvenly(d, d2);
        }
    }

    private boolean isOverlap() {
        double d = 0.0;
        for (int i = 0; i < this.labels.size(); ++i) {
            PieLabelRecord pieLabelRecord = this.getPieLabelRecord(i);
            if (d > pieLabelRecord.getLowerY()) {
                return true;
            }
            d = pieLabelRecord.getUpperY();
        }
        return false;
    }

    protected void adjustInwards() {
        int n = 0;
        for (int i = this.labels.size() - 1; i > n; ++n, --i) {
            double d;
            PieLabelRecord pieLabelRecord;
            PieLabelRecord pieLabelRecord2;
            if (n < i - 1) {
                pieLabelRecord2 = this.getPieLabelRecord(n);
                pieLabelRecord = this.getPieLabelRecord(n + 1);
                if (pieLabelRecord.getLowerY() < pieLabelRecord2.getUpperY()) {
                    d = pieLabelRecord2.getUpperY() - pieLabelRecord.getLowerY() + this.minGap;
                    pieLabelRecord.setAllocatedY(pieLabelRecord.getAllocatedY() + d);
                }
            }
            pieLabelRecord2 = this.getPieLabelRecord(i - 1);
            pieLabelRecord = this.getPieLabelRecord(i);
            if (!(pieLabelRecord2.getUpperY() > pieLabelRecord.getLowerY())) continue;
            d = pieLabelRecord2.getUpperY() - pieLabelRecord.getLowerY() + this.minGap;
            pieLabelRecord.setAllocatedY(pieLabelRecord.getAllocatedY() + d);
        }
    }

    protected void adjustDownwards(double d, double d2) {
        for (int i = 0; i < this.labels.size() - 1; ++i) {
            PieLabelRecord pieLabelRecord = this.getPieLabelRecord(i);
            PieLabelRecord pieLabelRecord2 = this.getPieLabelRecord(i + 1);
            if (!(pieLabelRecord2.getLowerY() < pieLabelRecord.getUpperY())) continue;
            pieLabelRecord2.setAllocatedY(Math.min(d + d2 - pieLabelRecord2.getLabelHeight() / 2.0, pieLabelRecord.getUpperY() + this.minGap + pieLabelRecord2.getLabelHeight() / 2.0));
        }
    }

    protected void adjustUpwards(double d, double d2) {
        for (int i = this.labels.size() - 1; i > 0; --i) {
            PieLabelRecord pieLabelRecord = this.getPieLabelRecord(i);
            PieLabelRecord pieLabelRecord2 = this.getPieLabelRecord(i - 1);
            if (!(pieLabelRecord2.getUpperY() > pieLabelRecord.getLowerY())) continue;
            pieLabelRecord2.setAllocatedY(Math.max(d + pieLabelRecord2.getLabelHeight() / 2.0, pieLabelRecord.getLowerY() - this.minGap - pieLabelRecord2.getLabelHeight() / 2.0));
        }
    }

    protected void spreadEvenly(double d, double d2) {
        double d3 = d;
        double d4 = 0.0;
        for (int i = 0; i < this.labels.size(); ++i) {
            d4 += this.getPieLabelRecord(i).getLabelHeight();
        }
        double d5 = d2 - d4;
        if (this.labels.size() > 1) {
            d5 /= (double)(this.labels.size() - 1);
        }
        for (int i = 0; i < this.labels.size(); ++i) {
            PieLabelRecord pieLabelRecord = this.getPieLabelRecord(i);
            pieLabelRecord.setAllocatedY(d3 += pieLabelRecord.getLabelHeight() / 2.0);
            d3 = d3 + pieLabelRecord.getLabelHeight() / 2.0 + d5;
        }
    }

    public void sort() {
        Collections.sort(this.labels);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.labels.size(); ++i) {
            stringBuffer.append(this.getPieLabelRecord(i).toString()).append("\n");
        }
        return stringBuffer.toString();
    }
}

