/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot;

import ai.org.jfree.chart.LegendItemCollection;
import ai.org.jfree.chart.axis.AxisSpace;
import ai.org.jfree.chart.axis.AxisState;
import ai.org.jfree.chart.axis.NumberAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.event.PlotChangeEvent;
import ai.org.jfree.chart.event.PlotChangeListener;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.PlotState;
import ai.org.jfree.data.Range;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.util.ObjectUtilities;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CombinedRangeCategoryPlot
extends CategoryPlot
implements PlotChangeListener {
    private static final long serialVersionUID = 7260210007554504515L;
    private List subplots = new ArrayList();
    private double gap = 5.0;
    private transient Rectangle2D[] subplotArea;

    public CombinedRangeCategoryPlot() {
        this(new NumberAxis());
    }

    public CombinedRangeCategoryPlot(ValueAxis valueAxis) {
        super(null, null, valueAxis, null);
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double d) {
        this.gap = d;
        this.fireChangeEvent();
    }

    public void add(CategoryPlot categoryPlot) {
        this.add(categoryPlot, 1);
    }

    public void add(CategoryPlot categoryPlot, int n) {
        if (categoryPlot == null) {
            throw new IllegalArgumentException("Null 'subplot' argument.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Require weight >= 1.");
        }
        categoryPlot.setParent(this);
        categoryPlot.setWeight(n);
        categoryPlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        categoryPlot.setRangeAxis(null);
        categoryPlot.setOrientation(this.getOrientation());
        categoryPlot.addChangeListener(this);
        this.subplots.add(categoryPlot);
        ValueAxis valueAxis = this.getRangeAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
        this.fireChangeEvent();
    }

    public void remove(CategoryPlot categoryPlot) {
        if (categoryPlot == null) {
            throw new IllegalArgumentException(" Null 'subplot' argument.");
        }
        int n = -1;
        int n2 = this.subplots.size();
        for (int i = 0; n == -1 && i < n2; ++i) {
            if (this.subplots.get(i) != categoryPlot) continue;
            n = i;
        }
        if (n != -1) {
            ValueAxis valueAxis;
            this.subplots.remove(n);
            categoryPlot.setParent(null);
            categoryPlot.removeChangeListener(this);
            ValueAxis valueAxis2 = this.getRangeAxis();
            if (valueAxis2 != null) {
                valueAxis2.configure();
            }
            if ((valueAxis = this.getRangeAxis(1)) != null) {
                valueAxis.configure();
            }
            this.fireChangeEvent();
        }
    }

    public List getSubplots() {
        if (this.subplots != null) {
            return Collections.unmodifiableList(this.subplots);
        }
        return Collections.EMPTY_LIST;
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Cloneable cloneable;
        AxisSpace axisSpace = new AxisSpace();
        PlotOrientation plotOrientation = this.getOrientation();
        AxisSpace axisSpace2 = this.getFixedRangeAxisSpace();
        if (axisSpace2 != null) {
            if (plotOrientation == PlotOrientation.VERTICAL) {
                axisSpace.setLeft(axisSpace2.getLeft());
                axisSpace.setRight(axisSpace2.getRight());
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                axisSpace.setTop(axisSpace2.getTop());
                axisSpace.setBottom(axisSpace2.getBottom());
            }
        } else {
            cloneable = this.getRangeAxis();
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), plotOrientation);
            if (cloneable != null) {
                axisSpace = ((ValueAxis)cloneable).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        cloneable = axisSpace.shrink(rectangle2D, null);
        int n = this.subplots.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i);
            n2 += categoryPlot.getWeight();
        }
        this.subplotArea = new Rectangle2D[n];
        double d = ((RectangularShape)cloneable).getX();
        double d2 = ((RectangularShape)cloneable).getY();
        double d3 = 0.0;
        if (plotOrientation == PlotOrientation.VERTICAL) {
            d3 = ((RectangularShape)cloneable).getWidth() - this.gap * (double)(n - 1);
        } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d3 = ((RectangularShape)cloneable).getHeight() - this.gap * (double)(n - 1);
        }
        for (int i = 0; i < n; ++i) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i);
            if (plotOrientation == PlotOrientation.VERTICAL) {
                double d4 = d3 * (double)categoryPlot.getWeight() / (double)n2;
                this.subplotArea[i] = new Rectangle2D.Double(d, d2, d4, ((RectangularShape)cloneable).getHeight());
                d = d + d4 + this.gap;
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double d5 = d3 * (double)categoryPlot.getWeight() / (double)n2;
                this.subplotArea[i] = new Rectangle2D.Double(d, d2, ((RectangularShape)cloneable).getWidth(), d5);
                d2 = d2 + d5 + this.gap;
            }
            AxisSpace axisSpace3 = categoryPlot.calculateDomainAxisSpace(graphics2D, this.subplotArea[i], null);
            axisSpace.ensureAtLeast(axisSpace3);
        }
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.setFixedDomainAxisSpaceForSubplots(axisSpace);
        ValueAxis valueAxis = this.getRangeAxis();
        RectangleEdge rectangleEdge = this.getRangeAxisEdge();
        double d = RectangleEdge.coordinate(rectangle2D2, rectangleEdge);
        AxisState axisState = valueAxis.draw(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge, plotRenderingInfo);
        if (plotState == null) {
            plotState = new PlotState();
        }
        plotState.getSharedAxisStates().put(valueAxis, axisState);
        for (int i = 0; i < this.subplots.size(); ++i) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i);
            PlotRenderingInfo plotRenderingInfo2 = null;
            if (plotRenderingInfo != null) {
                plotRenderingInfo2 = new PlotRenderingInfo(plotRenderingInfo.getOwner());
                plotRenderingInfo.addSubplotInfo(plotRenderingInfo2);
            }
            Point2D point2D2 = null;
            if (point2D != null && this.subplotArea[i].contains(point2D)) {
                point2D2 = point2D;
            }
            categoryPlot.draw(graphics2D, this.subplotArea[i], point2D2, plotState, plotRenderingInfo2);
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        super.setOrientation(plotOrientation);
        for (CategoryPlot categoryPlot : this.subplots) {
            categoryPlot.setOrientation(plotOrientation);
        }
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            for (CategoryPlot categoryPlot : this.subplots) {
                range = Range.combine(range, categoryPlot.getDataRange(valueAxis));
            }
        }
        return range;
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = this.getFixedLegendItems();
        if (legendItemCollection == null) {
            legendItemCollection = new LegendItemCollection();
            if (this.subplots != null) {
                for (CategoryPlot categoryPlot : this.subplots) {
                    LegendItemCollection legendItemCollection2 = categoryPlot.getLegendItems();
                    legendItemCollection.addAll(legendItemCollection2);
                }
            }
        }
        return legendItemCollection;
    }

    protected void setFixedDomainAxisSpaceForSubplots(AxisSpace axisSpace) {
        for (CategoryPlot categoryPlot : this.subplots) {
            categoryPlot.setFixedDomainAxisSpace(axisSpace, false);
        }
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            for (int i = 0; i < this.subplots.size(); ++i) {
                CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i);
                PlotRenderingInfo plotRenderingInfo2 = plotRenderingInfo.getSubplotInfo(i);
                categoryPlot.handleClick(n, n2, plotRenderingInfo2);
            }
        }
    }

    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        this.notifyListeners(plotChangeEvent);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CombinedRangeCategoryPlot)) {
            return false;
        }
        CombinedRangeCategoryPlot combinedRangeCategoryPlot = (CombinedRangeCategoryPlot)object;
        if (this.gap != combinedRangeCategoryPlot.gap) {
            return false;
        }
        if (!ObjectUtilities.equal(this.subplots, combinedRangeCategoryPlot.subplots)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        CombinedRangeCategoryPlot combinedRangeCategoryPlot = (CombinedRangeCategoryPlot)super.clone();
        combinedRangeCategoryPlot.subplots = (List)ObjectUtilities.deepClone(this.subplots);
        for (Plot plot : combinedRangeCategoryPlot.subplots) {
            plot.setParent(combinedRangeCategoryPlot);
        }
        ValueAxis valueAxis = combinedRangeCategoryPlot.getRangeAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
        return combinedRangeCategoryPlot;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        ValueAxis valueAxis = this.getRangeAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
    }
}

