/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot;

import ai.org.jfree.chart.LegendItemCollection;
import ai.org.jfree.chart.annotations.CategoryAnnotation;
import ai.org.jfree.chart.axis.Axis;
import ai.org.jfree.chart.axis.AxisCollection;
import ai.org.jfree.chart.axis.AxisLocation;
import ai.org.jfree.chart.axis.AxisSpace;
import ai.org.jfree.chart.axis.AxisState;
import ai.org.jfree.chart.axis.CategoryAnchor;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.TickType;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.axis.ValueTick;
import ai.org.jfree.chart.event.AnnotationChangeEvent;
import ai.org.jfree.chart.event.AnnotationChangeListener;
import ai.org.jfree.chart.event.ChartChangeEventType;
import ai.org.jfree.chart.event.PlotChangeEvent;
import ai.org.jfree.chart.event.RendererChangeEvent;
import ai.org.jfree.chart.event.RendererChangeListener;
import ai.org.jfree.chart.plot.CategoryCrosshairState;
import ai.org.jfree.chart.plot.CategoryMarker;
import ai.org.jfree.chart.plot.DatasetRenderingOrder;
import ai.org.jfree.chart.plot.Marker;
import ai.org.jfree.chart.plot.Pannable;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.PlotState;
import ai.org.jfree.chart.plot.ValueAxisPlot;
import ai.org.jfree.chart.plot.Zoomable;
import ai.org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.chart.util.ResourceBundleWrapper;
import ai.org.jfree.chart.util.ShadowGenerator;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.general.Dataset;
import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.Layer;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.util.ObjectList;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.ShapeUtilities;
import ai.org.jfree.util.SortOrder;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;

public class CategoryPlot
extends Plot
implements ValueAxisPlot,
Pannable,
Zoomable,
AnnotationChangeListener,
RendererChangeListener,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -3537691700434728188L;
    public static final boolean DEFAULT_DOMAIN_GRIDLINES_VISIBLE = false;
    public static final boolean DEFAULT_RANGE_GRIDLINES_VISIBLE = true;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final Font DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final Stroke DEFAULT_CROSSHAIR_STROKE = DEFAULT_GRIDLINE_STROKE;
    public static final Paint DEFAULT_CROSSHAIR_PAINT = Color.blue;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("ai.org.jfree.chart.plot.LocalizationBundle");
    private PlotOrientation orientation;
    private RectangleInsets axisOffset;
    private ObjectList domainAxes;
    private ObjectList domainAxisLocations;
    private boolean drawSharedDomainAxis;
    private ObjectList rangeAxes;
    private ObjectList rangeAxisLocations;
    private ObjectList datasets;
    private TreeMap datasetToDomainAxesMap;
    private TreeMap datasetToRangeAxesMap;
    private ObjectList renderers;
    private DatasetRenderingOrder renderingOrder = DatasetRenderingOrder.REVERSE;
    private SortOrder columnRenderingOrder = SortOrder.ASCENDING;
    private SortOrder rowRenderingOrder = SortOrder.ASCENDING;
    private boolean domainGridlinesVisible;
    private CategoryAnchor domainGridlinePosition;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeZeroBaselineVisible;
    private transient Stroke rangeZeroBaselineStroke;
    private transient Paint rangeZeroBaselinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private boolean rangeMinorGridlinesVisible;
    private transient Stroke rangeMinorGridlineStroke;
    private transient Paint rangeMinorGridlinePaint;
    private double anchorValue;
    private int crosshairDatasetIndex;
    private boolean domainCrosshairVisible;
    private Comparable domainCrosshairRowKey;
    private Comparable domainCrosshairColumnKey;
    private transient Stroke domainCrosshairStroke;
    private transient Paint domainCrosshairPaint;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private Map foregroundDomainMarkers;
    private Map backgroundDomainMarkers;
    private Map foregroundRangeMarkers;
    private Map backgroundRangeMarkers;
    private List annotations;
    private int weight;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;
    private LegendItemCollection fixedLegendItems;
    private boolean rangePannable;
    private ShadowGenerator shadowGenerator;

    public CategoryPlot() {
        this(null, null, null, null);
    }

    public CategoryPlot(CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer) {
        this.orientation = PlotOrientation.VERTICAL;
        this.domainAxes = new ObjectList();
        this.domainAxisLocations = new ObjectList();
        this.rangeAxes = new ObjectList();
        this.rangeAxisLocations = new ObjectList();
        this.datasetToDomainAxesMap = new TreeMap();
        this.datasetToRangeAxesMap = new TreeMap();
        this.renderers = new ObjectList();
        this.datasets = new ObjectList();
        this.datasets.set(0, categoryDataset);
        if (categoryDataset != null) {
            categoryDataset.addChangeListener(this);
        }
        this.axisOffset = RectangleInsets.ZERO_INSETS;
        this.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT, false);
        this.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT, false);
        this.renderers.set(0, categoryItemRenderer);
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
            categoryItemRenderer.addChangeListener(this);
        }
        this.domainAxes.set(0, categoryAxis);
        this.mapDatasetToDomainAxis(0, 0);
        if (categoryAxis != null) {
            categoryAxis.setPlot(this);
            categoryAxis.addChangeListener(this);
        }
        this.drawSharedDomainAxis = false;
        this.rangeAxes.set(0, valueAxis);
        this.mapDatasetToRangeAxis(0, 0);
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
        this.domainGridlinesVisible = false;
        this.domainGridlinePosition = CategoryAnchor.MIDDLE;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeZeroBaselineVisible = false;
        this.rangeZeroBaselinePaint = Color.black;
        this.rangeZeroBaselineStroke = new BasicStroke(0.5f);
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeMinorGridlinesVisible = false;
        this.rangeMinorGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeMinorGridlinePaint = Color.white;
        this.foregroundDomainMarkers = new HashMap();
        this.backgroundDomainMarkers = new HashMap();
        this.foregroundRangeMarkers = new HashMap();
        this.backgroundRangeMarkers = new HashMap();
        this.anchorValue = 0.0;
        this.domainCrosshairVisible = false;
        this.domainCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.domainCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.rangeCrosshairVisible = false;
        this.rangeCrosshairValue = 0.0;
        this.rangeCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.rangeCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.annotations = new ArrayList();
        this.rangePannable = false;
        this.shadowGenerator = null;
    }

    public String getPlotType() {
        return localizationResources.getString("Category_Plot");
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        this.orientation = plotOrientation;
        this.fireChangeEvent();
    }

    public RectangleInsets getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(RectangleInsets rectangleInsets) {
        if (rectangleInsets == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.axisOffset = rectangleInsets;
        this.fireChangeEvent();
    }

    public CategoryAxis getDomainAxis() {
        return this.getDomainAxis(0);
    }

    public CategoryAxis getDomainAxis(int n) {
        Plot plot;
        CategoryAxis categoryAxis = null;
        if (n < this.domainAxes.size()) {
            categoryAxis = (CategoryAxis)this.domainAxes.get(n);
        }
        if (categoryAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            categoryAxis = categoryPlot.getDomainAxis(n);
        }
        return categoryAxis;
    }

    public void setDomainAxis(CategoryAxis categoryAxis) {
        this.setDomainAxis(0, categoryAxis);
    }

    public void setDomainAxis(int n, CategoryAxis categoryAxis) {
        this.setDomainAxis(n, categoryAxis, true);
    }

    public void setDomainAxis(int n, CategoryAxis categoryAxis, boolean bl) {
        CategoryAxis categoryAxis2 = (CategoryAxis)this.domainAxes.get(n);
        if (categoryAxis2 != null) {
            categoryAxis2.removeChangeListener(this);
        }
        if (categoryAxis != null) {
            categoryAxis.setPlot(this);
        }
        this.domainAxes.set(n, categoryAxis);
        if (categoryAxis != null) {
            categoryAxis.configure();
            categoryAxis.addChangeListener(this);
        }
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setDomainAxes(CategoryAxis[] categoryAxisArray) {
        for (int i = 0; i < categoryAxisArray.length; ++i) {
            this.setDomainAxis(i, categoryAxisArray[i], false);
        }
        this.fireChangeEvent();
    }

    public int getDomainAxisIndex(CategoryAxis categoryAxis) {
        if (categoryAxis == null) {
            throw new IllegalArgumentException("Null 'axis' argument.");
        }
        return this.domainAxes.indexOf(categoryAxis);
    }

    public AxisLocation getDomainAxisLocation() {
        return this.getDomainAxisLocation(0);
    }

    public AxisLocation getDomainAxisLocation(int n) {
        AxisLocation axisLocation = null;
        if (n < this.domainAxisLocations.size()) {
            axisLocation = (AxisLocation)this.domainAxisLocations.get(n);
        }
        if (axisLocation == null) {
            axisLocation = AxisLocation.getOpposite(this.getDomainAxisLocation(0));
        }
        return axisLocation;
    }

    public void setDomainAxisLocation(AxisLocation axisLocation) {
        this.setDomainAxisLocation(0, axisLocation, true);
    }

    public void setDomainAxisLocation(AxisLocation axisLocation, boolean bl) {
        this.setDomainAxisLocation(0, axisLocation, bl);
    }

    public void setDomainAxisLocation(int n, AxisLocation axisLocation) {
        this.setDomainAxisLocation(n, axisLocation, true);
    }

    public void setDomainAxisLocation(int n, AxisLocation axisLocation, boolean bl) {
        if (n == 0 && axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.domainAxisLocations.set(n, axisLocation);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public RectangleEdge getDomainAxisEdge() {
        return this.getDomainAxisEdge(0);
    }

    public RectangleEdge getDomainAxisEdge(int n) {
        RectangleEdge rectangleEdge = null;
        AxisLocation axisLocation = this.getDomainAxisLocation(n);
        rectangleEdge = axisLocation != null ? Plot.resolveDomainAxisLocation(axisLocation, this.orientation) : RectangleEdge.opposite(this.getDomainAxisEdge(0));
        return rectangleEdge;
    }

    public int getDomainAxisCount() {
        return this.domainAxes.size();
    }

    public void clearDomainAxes() {
        for (int i = 0; i < this.domainAxes.size(); ++i) {
            CategoryAxis categoryAxis = (CategoryAxis)this.domainAxes.get(i);
            if (categoryAxis == null) continue;
            categoryAxis.removeChangeListener(this);
        }
        this.domainAxes.clear();
        this.fireChangeEvent();
    }

    public void configureDomainAxes() {
        for (int i = 0; i < this.domainAxes.size(); ++i) {
            CategoryAxis categoryAxis = (CategoryAxis)this.domainAxes.get(i);
            if (categoryAxis == null) continue;
            categoryAxis.configure();
        }
    }

    public ValueAxis getRangeAxis() {
        return this.getRangeAxis(0);
    }

    public ValueAxis getRangeAxis(int n) {
        Plot plot;
        ValueAxis valueAxis = null;
        if (n < this.rangeAxes.size()) {
            valueAxis = (ValueAxis)this.rangeAxes.get(n);
        }
        if (valueAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            valueAxis = categoryPlot.getRangeAxis(n);
        }
        return valueAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) {
        this.setRangeAxis(0, valueAxis);
    }

    public void setRangeAxis(int n, ValueAxis valueAxis) {
        this.setRangeAxis(n, valueAxis, true);
    }

    public void setRangeAxis(int n, ValueAxis valueAxis, boolean bl) {
        ValueAxis valueAxis2 = (ValueAxis)this.rangeAxes.get(n);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        this.rangeAxes.set(n, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setRangeAxes(ValueAxis[] valueAxisArray) {
        for (int i = 0; i < valueAxisArray.length; ++i) {
            this.setRangeAxis(i, valueAxisArray[i], false);
        }
        this.fireChangeEvent();
    }

    public int getRangeAxisIndex(ValueAxis valueAxis) {
        Plot plot;
        if (valueAxis == null) {
            throw new IllegalArgumentException("Null 'axis' argument.");
        }
        int n = this.rangeAxes.indexOf(valueAxis);
        if (n < 0 && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            n = categoryPlot.getRangeAxisIndex(valueAxis);
        }
        return n;
    }

    public AxisLocation getRangeAxisLocation() {
        return this.getRangeAxisLocation(0);
    }

    public AxisLocation getRangeAxisLocation(int n) {
        AxisLocation axisLocation = null;
        if (n < this.rangeAxisLocations.size()) {
            axisLocation = (AxisLocation)this.rangeAxisLocations.get(n);
        }
        if (axisLocation == null) {
            axisLocation = AxisLocation.getOpposite(this.getRangeAxisLocation(0));
        }
        return axisLocation;
    }

    public void setRangeAxisLocation(AxisLocation axisLocation) {
        this.setRangeAxisLocation(axisLocation, true);
    }

    public void setRangeAxisLocation(AxisLocation axisLocation, boolean bl) {
        this.setRangeAxisLocation(0, axisLocation, bl);
    }

    public void setRangeAxisLocation(int n, AxisLocation axisLocation) {
        this.setRangeAxisLocation(n, axisLocation, true);
    }

    public void setRangeAxisLocation(int n, AxisLocation axisLocation, boolean bl) {
        if (n == 0 && axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.rangeAxisLocations.set(n, axisLocation);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public RectangleEdge getRangeAxisEdge() {
        return this.getRangeAxisEdge(0);
    }

    public RectangleEdge getRangeAxisEdge(int n) {
        AxisLocation axisLocation = this.getRangeAxisLocation(n);
        RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(axisLocation, this.orientation);
        if (rectangleEdge == null) {
            rectangleEdge = RectangleEdge.opposite(this.getRangeAxisEdge(0));
        }
        return rectangleEdge;
    }

    public int getRangeAxisCount() {
        return this.rangeAxes.size();
    }

    public void clearRangeAxes() {
        for (int i = 0; i < this.rangeAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(i);
            if (valueAxis == null) continue;
            valueAxis.removeChangeListener(this);
        }
        this.rangeAxes.clear();
        this.fireChangeEvent();
    }

    public void configureRangeAxes() {
        for (int i = 0; i < this.rangeAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(i);
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
    }

    public CategoryDataset getDataset() {
        return this.getDataset(0);
    }

    public CategoryDataset getDataset(int n) {
        CategoryDataset categoryDataset = null;
        if (this.datasets.size() > n) {
            categoryDataset = (CategoryDataset)this.datasets.get(n);
        }
        return categoryDataset;
    }

    public void setDataset(CategoryDataset categoryDataset) {
        this.setDataset(0, categoryDataset);
    }

    public void setDataset(int n, CategoryDataset categoryDataset) {
        CategoryDataset categoryDataset2 = (CategoryDataset)this.datasets.get(n);
        if (categoryDataset2 != null) {
            categoryDataset2.removeChangeListener(this);
        }
        this.datasets.set(n, categoryDataset);
        if (categoryDataset != null) {
            categoryDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, categoryDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public int indexOf(CategoryDataset categoryDataset) {
        int n = -1;
        for (int i = 0; i < this.datasets.size(); ++i) {
            if (categoryDataset != this.datasets.get(i)) continue;
            n = i;
            break;
        }
        return n;
    }

    public void mapDatasetToDomainAxis(int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        arrayList.add(new Integer(n2));
        this.mapDatasetToDomainAxes(n, arrayList);
    }

    public void mapDatasetToDomainAxes(int n, List list) {
        if (n < 0) {
            throw new IllegalArgumentException("Requires 'index' >= 0.");
        }
        this.checkAxisIndices(list);
        Integer n2 = new Integer(n);
        this.datasetToDomainAxesMap.put(n2, new ArrayList(list));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n)));
    }

    private void checkAxisIndices(List list) {
        if (list == null) {
            return;
        }
        int n = list.size();
        if (n == 0) {
            throw new IllegalArgumentException("Empty list not permitted.");
        }
        HashSet hashSet = new HashSet();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (!(e instanceof Integer)) {
                throw new IllegalArgumentException("Indices must be Integer instances.");
            }
            if (hashSet.contains(e)) {
                throw new IllegalArgumentException("Indices must be unique.");
            }
            hashSet.add(e);
        }
    }

    public CategoryAxis getDomainAxisForDataset(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative 'index'.");
        }
        CategoryAxis categoryAxis = null;
        List list = (List)this.datasetToDomainAxesMap.get(new Integer(n));
        if (list != null) {
            Integer n2 = (Integer)list.get(0);
            categoryAxis = this.getDomainAxis(n2);
        } else {
            categoryAxis = this.getDomainAxis(0);
        }
        return categoryAxis;
    }

    public void mapDatasetToRangeAxis(int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        arrayList.add(new Integer(n2));
        this.mapDatasetToRangeAxes(n, arrayList);
    }

    public void mapDatasetToRangeAxes(int n, List list) {
        if (n < 0) {
            throw new IllegalArgumentException("Requires 'index' >= 0.");
        }
        this.checkAxisIndices(list);
        Integer n2 = new Integer(n);
        this.datasetToRangeAxesMap.put(n2, new ArrayList(list));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n)));
    }

    public ValueAxis getRangeAxisForDataset(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative 'index'.");
        }
        ValueAxis valueAxis = null;
        List list = (List)this.datasetToRangeAxesMap.get(new Integer(n));
        if (list != null) {
            Integer n2 = (Integer)list.get(0);
            valueAxis = this.getRangeAxis(n2);
        } else {
            valueAxis = this.getRangeAxis(0);
        }
        return valueAxis;
    }

    public int getRendererCount() {
        return this.renderers.size();
    }

    public CategoryItemRenderer getRenderer() {
        return this.getRenderer(0);
    }

    public CategoryItemRenderer getRenderer(int n) {
        CategoryItemRenderer categoryItemRenderer = null;
        if (this.renderers.size() > n) {
            categoryItemRenderer = (CategoryItemRenderer)this.renderers.get(n);
        }
        return categoryItemRenderer;
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer) {
        this.setRenderer(0, categoryItemRenderer, true);
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer, boolean bl) {
        this.setRenderer(0, categoryItemRenderer, bl);
    }

    public void setRenderer(int n, CategoryItemRenderer categoryItemRenderer) {
        this.setRenderer(n, categoryItemRenderer, true);
    }

    public void setRenderer(int n, CategoryItemRenderer categoryItemRenderer, boolean bl) {
        CategoryItemRenderer categoryItemRenderer2 = (CategoryItemRenderer)this.renderers.get(n);
        if (categoryItemRenderer2 != null) {
            categoryItemRenderer2.removeChangeListener(this);
        }
        this.renderers.set(n, categoryItemRenderer);
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
            categoryItemRenderer.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setRenderers(CategoryItemRenderer[] categoryItemRendererArray) {
        for (int i = 0; i < categoryItemRendererArray.length; ++i) {
            this.setRenderer(i, categoryItemRendererArray[i], false);
        }
        this.fireChangeEvent();
    }

    public CategoryItemRenderer getRendererForDataset(CategoryDataset categoryDataset) {
        CategoryItemRenderer categoryItemRenderer = null;
        for (int i = 0; i < this.datasets.size(); ++i) {
            if (this.datasets.get(i) != categoryDataset) continue;
            categoryItemRenderer = (CategoryItemRenderer)this.renderers.get(i);
            break;
        }
        return categoryItemRenderer;
    }

    public int getIndexOf(CategoryItemRenderer categoryItemRenderer) {
        return this.renderers.indexOf(categoryItemRenderer);
    }

    public DatasetRenderingOrder getDatasetRenderingOrder() {
        return this.renderingOrder;
    }

    public void setDatasetRenderingOrder(DatasetRenderingOrder datasetRenderingOrder) {
        if (datasetRenderingOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.renderingOrder = datasetRenderingOrder;
        this.fireChangeEvent();
    }

    public SortOrder getColumnRenderingOrder() {
        return this.columnRenderingOrder;
    }

    public void setColumnRenderingOrder(SortOrder sortOrder) {
        if (sortOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.columnRenderingOrder = sortOrder;
        this.fireChangeEvent();
    }

    public SortOrder getRowRenderingOrder() {
        return this.rowRenderingOrder;
    }

    public void setRowRenderingOrder(SortOrder sortOrder) {
        if (sortOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.rowRenderingOrder = sortOrder;
        this.fireChangeEvent();
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean bl) {
        if (this.domainGridlinesVisible != bl) {
            this.domainGridlinesVisible = bl;
            this.fireChangeEvent();
        }
    }

    public CategoryAnchor getDomainGridlinePosition() {
        return this.domainGridlinePosition;
    }

    public void setDomainGridlinePosition(CategoryAnchor categoryAnchor) {
        if (categoryAnchor == null) {
            throw new IllegalArgumentException("Null 'position' argument.");
        }
        this.domainGridlinePosition = categoryAnchor;
        this.fireChangeEvent();
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' not permitted.");
        }
        this.domainGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeZeroBaselineVisible() {
        return this.rangeZeroBaselineVisible;
    }

    public void setRangeZeroBaselineVisible(boolean bl) {
        this.rangeZeroBaselineVisible = bl;
        this.fireChangeEvent();
    }

    public Stroke getRangeZeroBaselineStroke() {
        return this.rangeZeroBaselineStroke;
    }

    public void setRangeZeroBaselineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeZeroBaselineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeZeroBaselinePaint() {
        return this.rangeZeroBaselinePaint;
    }

    public void setRangeZeroBaselinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeZeroBaselinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean bl) {
        if (this.rangeGridlinesVisible != bl) {
            this.rangeGridlinesVisible = bl;
            this.fireChangeEvent();
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeMinorGridlinesVisible() {
        return this.rangeMinorGridlinesVisible;
    }

    public void setRangeMinorGridlinesVisible(boolean bl) {
        if (this.rangeMinorGridlinesVisible != bl) {
            this.rangeMinorGridlinesVisible = bl;
            this.fireChangeEvent();
        }
    }

    public Stroke getRangeMinorGridlineStroke() {
        return this.rangeMinorGridlineStroke;
    }

    public void setRangeMinorGridlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeMinorGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeMinorGridlinePaint() {
        return this.rangeMinorGridlinePaint;
    }

    public void setRangeMinorGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeMinorGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public LegendItemCollection getFixedLegendItems() {
        return this.fixedLegendItems;
    }

    public void setFixedLegendItems(LegendItemCollection legendItemCollection) {
        this.fixedLegendItems = legendItemCollection;
        this.fireChangeEvent();
    }

    public LegendItemCollection getLegendItems() {
        if (this.fixedLegendItems != null) {
            return this.fixedLegendItems;
        }
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        int n = this.datasets.size();
        for (int i = 0; i < n; ++i) {
            CategoryItemRenderer categoryItemRenderer;
            CategoryDataset categoryDataset = this.getDataset(i);
            if (categoryDataset == null || (categoryItemRenderer = this.getRenderer(i)) == null) continue;
            legendItemCollection.addAll(categoryItemRenderer.getLegendItems());
        }
        return legendItemCollection;
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            double d = 0.0;
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                d = n;
            } else if (this.orientation == PlotOrientation.VERTICAL) {
                d = n2;
            }
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), this.orientation);
            double d2 = this.getRangeAxis().java2DToValue(d, plotRenderingInfo.getDataArea(), rectangleEdge);
            this.setAnchorValue(d2);
            this.setRangeCrosshairValue(d2);
        }
    }

    public void zoom(double d) {
        if (d > 0.0) {
            double d2 = this.getRangeAxis().getRange().getLength();
            double d3 = d2 * d;
            this.getRangeAxis().setRange(this.anchorValue - d3 / 2.0, this.anchorValue + d3 / 2.0);
        } else {
            this.getRangeAxis().setAutoRange(true);
        }
    }

    public void annotationChanged(AnnotationChangeEvent annotationChangeEvent) {
        if (this.getParent() != null) {
            this.getParent().annotationChanged(annotationChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        int n = this.rangeAxes.size();
        for (int i = 0; i < n; ++i) {
            ValueAxis valueAxis = this.getRangeAxis(i);
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(datasetChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            plotChangeEvent.setType(ChartChangeEventType.DATASET_UPDATED);
            this.notifyListeners(plotChangeEvent);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rendererChanged(RendererChangeEvent rendererChangeEvent) {
        Plot plot = this.getParent();
        if (plot != null) {
            if (!(plot instanceof RendererChangeListener)) throw new RuntimeException("The renderer has changed and I don't know what to do!");
            RendererChangeListener rendererChangeListener = (RendererChangeListener)((Object)plot);
            rendererChangeListener.rendererChanged(rendererChangeEvent);
            return;
        } else {
            this.configureRangeAxes();
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    public void addDomainMarker(CategoryMarker categoryMarker) {
        this.addDomainMarker(categoryMarker, Layer.FOREGROUND);
    }

    public void addDomainMarker(CategoryMarker categoryMarker, Layer layer) {
        this.addDomainMarker(0, categoryMarker, layer);
    }

    public void addDomainMarker(int n, CategoryMarker categoryMarker, Layer layer) {
        this.addDomainMarker(n, categoryMarker, layer, true);
    }

    public void addDomainMarker(int n, CategoryMarker categoryMarker, Layer layer, boolean bl) {
        if (categoryMarker == null) {
            throw new IllegalArgumentException("Null 'marker' not permitted.");
        }
        if (layer == null) {
            throw new IllegalArgumentException("Null 'layer' not permitted.");
        }
        if (layer == Layer.FOREGROUND) {
            ArrayList<CategoryMarker> arrayList = (ArrayList<CategoryMarker>)this.foregroundDomainMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<CategoryMarker>();
                this.foregroundDomainMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(categoryMarker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<CategoryMarker> arrayList = (ArrayList<CategoryMarker>)this.backgroundDomainMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<CategoryMarker>();
                this.backgroundDomainMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(categoryMarker);
        }
        categoryMarker.addChangeListener(this);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void clearDomainMarkers() {
        Set set;
        if (this.backgroundDomainMarkers != null) {
            set = this.backgroundDomainMarkers.keySet();
            for (Integer n : set) {
                this.clearDomainMarkers(n);
            }
            this.backgroundDomainMarkers.clear();
        }
        if (this.foregroundDomainMarkers != null) {
            set = this.foregroundDomainMarkers.keySet();
            for (Integer n : set) {
                this.clearDomainMarkers(n);
            }
            this.foregroundDomainMarkers.clear();
        }
        this.fireChangeEvent();
    }

    public Collection getDomainMarkers(Layer layer) {
        return this.getDomainMarkers(0, layer);
    }

    public Collection getDomainMarkers(int n, Layer layer) {
        Collection collection = null;
        Integer n2 = new Integer(n);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.foregroundDomainMarkers.get(n2);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.backgroundDomainMarkers.get(n2);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    public void clearDomainMarkers(int n) {
        Collection collection;
        Integer n2 = new Integer(n);
        if (this.backgroundDomainMarkers != null && (collection = (Collection)this.backgroundDomainMarkers.get(n2)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        if (this.foregroundDomainMarkers != null && (collection = (Collection)this.foregroundDomainMarkers.get(n2)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        this.fireChangeEvent();
    }

    public boolean removeDomainMarker(Marker marker) {
        return this.removeDomainMarker(marker, Layer.FOREGROUND);
    }

    public boolean removeDomainMarker(Marker marker, Layer layer) {
        return this.removeDomainMarker(0, marker, layer);
    }

    public boolean removeDomainMarker(int n, Marker marker, Layer layer) {
        return this.removeDomainMarker(n, marker, layer, true);
    }

    public boolean removeDomainMarker(int n, Marker marker, Layer layer, boolean bl) {
        ArrayList arrayList = layer == Layer.FOREGROUND ? (ArrayList)this.foregroundDomainMarkers.get(new Integer(n)) : (ArrayList)this.backgroundDomainMarkers.get(new Integer(n));
        if (arrayList == null) {
            return false;
        }
        boolean bl2 = arrayList.remove(marker);
        if (bl2 && bl) {
            this.fireChangeEvent();
        }
        return bl2;
    }

    public void addRangeMarker(Marker marker) {
        this.addRangeMarker(marker, Layer.FOREGROUND);
    }

    public void addRangeMarker(Marker marker, Layer layer) {
        this.addRangeMarker(0, marker, layer);
    }

    public void addRangeMarker(int n, Marker marker, Layer layer) {
        this.addRangeMarker(n, marker, layer, true);
    }

    public void addRangeMarker(int n, Marker marker, Layer layer, boolean bl) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.foregroundRangeMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.foregroundRangeMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.backgroundRangeMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.backgroundRangeMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        }
        marker.addChangeListener(this);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void clearRangeMarkers() {
        Set set;
        if (this.backgroundRangeMarkers != null) {
            set = this.backgroundRangeMarkers.keySet();
            for (Integer n : set) {
                this.clearRangeMarkers(n);
            }
            this.backgroundRangeMarkers.clear();
        }
        if (this.foregroundRangeMarkers != null) {
            set = this.foregroundRangeMarkers.keySet();
            for (Integer n : set) {
                this.clearRangeMarkers(n);
            }
            this.foregroundRangeMarkers.clear();
        }
        this.fireChangeEvent();
    }

    public Collection getRangeMarkers(Layer layer) {
        return this.getRangeMarkers(0, layer);
    }

    public Collection getRangeMarkers(int n, Layer layer) {
        Collection collection = null;
        Integer n2 = new Integer(n);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.foregroundRangeMarkers.get(n2);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.backgroundRangeMarkers.get(n2);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    public void clearRangeMarkers(int n) {
        Collection collection;
        Integer n2 = new Integer(n);
        if (this.backgroundRangeMarkers != null && (collection = (Collection)this.backgroundRangeMarkers.get(n2)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        if (this.foregroundRangeMarkers != null && (collection = (Collection)this.foregroundRangeMarkers.get(n2)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        this.fireChangeEvent();
    }

    public boolean removeRangeMarker(Marker marker) {
        return this.removeRangeMarker(marker, Layer.FOREGROUND);
    }

    public boolean removeRangeMarker(Marker marker, Layer layer) {
        return this.removeRangeMarker(0, marker, layer);
    }

    public boolean removeRangeMarker(int n, Marker marker, Layer layer) {
        return this.removeRangeMarker(n, marker, layer, true);
    }

    public boolean removeRangeMarker(int n, Marker marker, Layer layer, boolean bl) {
        if (marker == null) {
            throw new IllegalArgumentException("Null 'marker' argument.");
        }
        ArrayList arrayList = layer == Layer.FOREGROUND ? (ArrayList)this.foregroundRangeMarkers.get(new Integer(n)) : (ArrayList)this.backgroundRangeMarkers.get(new Integer(n));
        if (arrayList == null) {
            return false;
        }
        boolean bl2 = arrayList.remove(marker);
        if (bl2 && bl) {
            this.fireChangeEvent();
        }
        return bl2;
    }

    public boolean isDomainCrosshairVisible() {
        return this.domainCrosshairVisible;
    }

    public void setDomainCrosshairVisible(boolean bl) {
        if (this.domainCrosshairVisible != bl) {
            this.domainCrosshairVisible = bl;
            this.fireChangeEvent();
        }
    }

    public Comparable getDomainCrosshairRowKey() {
        return this.domainCrosshairRowKey;
    }

    public void setDomainCrosshairRowKey(Comparable comparable) {
        this.setDomainCrosshairRowKey(comparable, true);
    }

    public void setDomainCrosshairRowKey(Comparable comparable, boolean bl) {
        this.domainCrosshairRowKey = comparable;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Comparable getDomainCrosshairColumnKey() {
        return this.domainCrosshairColumnKey;
    }

    public void setDomainCrosshairColumnKey(Comparable comparable) {
        this.setDomainCrosshairColumnKey(comparable, true);
    }

    public void setDomainCrosshairColumnKey(Comparable comparable, boolean bl) {
        this.domainCrosshairColumnKey = comparable;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public int getCrosshairDatasetIndex() {
        return this.crosshairDatasetIndex;
    }

    public void setCrosshairDatasetIndex(int n) {
        this.setCrosshairDatasetIndex(n, true);
    }

    public void setCrosshairDatasetIndex(int n, boolean bl) {
        this.crosshairDatasetIndex = n;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Paint getDomainCrosshairPaint() {
        return this.domainCrosshairPaint;
    }

    public void setDomainCrosshairPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainCrosshairPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getDomainCrosshairStroke() {
        return this.domainCrosshairStroke;
    }

    public void setDomainCrosshairStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.domainCrosshairStroke = stroke;
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean bl) {
        if (this.rangeCrosshairVisible != bl) {
            this.rangeCrosshairVisible = bl;
            this.fireChangeEvent();
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean bl) {
        if (this.rangeCrosshairLockedOnData != bl) {
            this.rangeCrosshairLockedOnData = bl;
            this.fireChangeEvent();
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double d) {
        this.setRangeCrosshairValue(d, true);
    }

    public void setRangeCrosshairValue(double d, boolean bl) {
        this.rangeCrosshairValue = d;
        if (this.isRangeCrosshairVisible() && bl) {
            this.fireChangeEvent();
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeCrosshairStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeCrosshairPaint = paint;
        this.fireChangeEvent();
    }

    public List getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(CategoryAnnotation categoryAnnotation) {
        this.addAnnotation(categoryAnnotation, true);
    }

    public void addAnnotation(CategoryAnnotation categoryAnnotation, boolean bl) {
        if (categoryAnnotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        this.annotations.add(categoryAnnotation);
        categoryAnnotation.addChangeListener(this);
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public boolean removeAnnotation(CategoryAnnotation categoryAnnotation) {
        return this.removeAnnotation(categoryAnnotation, true);
    }

    public boolean removeAnnotation(CategoryAnnotation categoryAnnotation, boolean bl) {
        if (categoryAnnotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        boolean bl2 = this.annotations.remove(categoryAnnotation);
        categoryAnnotation.removeChangeListener(this);
        if (bl2 && bl) {
            this.fireChangeEvent();
        }
        return bl2;
    }

    public void clearAnnotations() {
        for (int i = 0; i < this.annotations.size(); ++i) {
            CategoryAnnotation categoryAnnotation = (CategoryAnnotation)this.annotations.get(i);
            categoryAnnotation.removeChangeListener(this);
        }
        this.annotations.clear();
        this.fireChangeEvent();
    }

    public ShadowGenerator getShadowGenerator() {
        return this.shadowGenerator;
    }

    public void setShadowGenerator(ShadowGenerator shadowGenerator) {
        this.shadowGenerator = shadowGenerator;
        this.fireChangeEvent();
    }

    protected AxisSpace calculateDomainAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block5: {
            block3: {
                block4: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block3;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block4;
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block5;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block5;
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block5;
            }
            RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), this.orientation);
            if (this.drawSharedDomainAxis) {
                axisSpace = this.getDomainAxis().reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
            for (int i = 0; i < this.domainAxes.size(); ++i) {
                Axis axis = (Axis)this.domainAxes.get(i);
                if (axis == null) continue;
                RectangleEdge rectangleEdge2 = this.getDomainAxisEdge(i);
                axisSpace = axis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge2, axisSpace);
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateRangeAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block4: {
            block2: {
                block3: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block2;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block3;
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block4;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block4;
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block4;
            }
            for (int i = 0; i < this.rangeAxes.size(); ++i) {
                Axis axis = (Axis)this.rangeAxes.get(i);
                if (axis == null) continue;
                RectangleEdge rectangleEdge = this.getRangeAxisEdge(i);
                axisSpace = axis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        return axisSpace;
    }

    private Rectangle integerise(Rectangle2D rectangle2D) {
        int n = (int)Math.ceil(rectangle2D.getMinX());
        int n2 = (int)Math.ceil(rectangle2D.getMinY());
        int n3 = (int)Math.floor(rectangle2D.getMaxX());
        int n4 = (int)Math.floor(rectangle2D.getMaxY());
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.calculateRangeAxisSpace(graphics2D, rectangle2D, axisSpace);
        axisSpace = this.calculateDomainAxisSpace(graphics2D, rectangle2D, axisSpace);
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        double d;
        Object object;
        Object object2;
        int n;
        int n2;
        Object object3;
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (plotRenderingInfo == null) {
            plotRenderingInfo = new PlotRenderingInfo(null);
        }
        plotRenderingInfo.setPlotArea(rectangle2D);
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.axisOffset.trim(rectangle2D2);
        rectangle2D2 = this.integerise(rectangle2D2);
        if (rectangle2D2.isEmpty()) {
            return;
        }
        plotRenderingInfo.setDataArea(rectangle2D2);
        this.createAndAddEntity((Rectangle2D)rectangle2D2.clone(), plotRenderingInfo, null, null);
        if (this.getRenderer() != null) {
            this.getRenderer().drawBackground(graphics2D, this, rectangle2D2);
        } else {
            this.drawBackground(graphics2D, rectangle2D2);
        }
        Map map = this.drawAxes(graphics2D, rectangle2D, rectangle2D2, plotRenderingInfo);
        if (point2D != null && !rectangle2D2.contains(point2D)) {
            point2D = ShapeUtilities.getPointInRectangle(point2D.getX(), point2D.getY(), rectangle2D2);
        }
        CategoryCrosshairState categoryCrosshairState = new CategoryCrosshairState();
        categoryCrosshairState.setCrosshairDistance(Double.POSITIVE_INFINITY);
        categoryCrosshairState.setAnchor(point2D);
        categoryCrosshairState.setAnchorX(Double.NaN);
        categoryCrosshairState.setAnchorY(Double.NaN);
        if (point2D != null && (object3 = this.getRangeAxis()) != null) {
            double d2 = this.getOrientation() == PlotOrientation.VERTICAL ? ((ValueAxis)object3).java2DToValue(point2D.getY(), rectangle2D2, this.getRangeAxisEdge()) : ((ValueAxis)object3).java2DToValue(point2D.getX(), rectangle2D2, this.getRangeAxisEdge());
            categoryCrosshairState.setAnchorY(d2);
        }
        categoryCrosshairState.setRowKey(this.getDomainCrosshairRowKey());
        categoryCrosshairState.setColumnKey(this.getDomainCrosshairColumnKey());
        categoryCrosshairState.setCrosshairY(this.getRangeCrosshairValue());
        object3 = graphics2D.getClip();
        graphics2D.clip(rectangle2D2);
        this.drawDomainGridlines(graphics2D, rectangle2D2);
        AxisState axisState = (AxisState)map.get(this.getRangeAxis());
        if (axisState == null && plotState != null) {
            axisState = (AxisState)plotState.getSharedAxisStates().get(this.getRangeAxis());
        }
        if (axisState != null) {
            this.drawRangeGridlines(graphics2D, rectangle2D2, axisState.getTicks());
            this.drawZeroRangeBaseline(graphics2D, rectangle2D2);
        }
        Graphics2D graphics2D2 = graphics2D;
        BufferedImage bufferedImage = null;
        if (this.shadowGenerator != null) {
            bufferedImage = new BufferedImage((int)rectangle2D2.getWidth(), (int)rectangle2D2.getHeight(), 2);
            graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(-rectangle2D2.getX(), -rectangle2D2.getY());
            graphics2D.setRenderingHints(graphics2D2.getRenderingHints());
        }
        for (n2 = 0; n2 < this.renderers.size(); ++n2) {
            this.drawDomainMarkers(graphics2D, rectangle2D2, n2, Layer.BACKGROUND);
        }
        for (n2 = 0; n2 < this.renderers.size(); ++n2) {
            this.drawRangeMarkers(graphics2D, rectangle2D2, n2, Layer.BACKGROUND);
        }
        n2 = 0;
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        DatasetRenderingOrder datasetRenderingOrder = this.getDatasetRenderingOrder();
        if (datasetRenderingOrder == DatasetRenderingOrder.FORWARD) {
            for (n = 0; n < this.datasets.size(); ++n) {
                n2 = this.render(graphics2D, rectangle2D2, n, plotRenderingInfo, categoryCrosshairState) || n2 != 0 ? 1 : 0;
            }
        } else {
            for (n = this.datasets.size() - 1; n >= 0; --n) {
                n2 = this.render(graphics2D, rectangle2D2, n, plotRenderingInfo, categoryCrosshairState) || n2 != 0 ? 1 : 0;
            }
        }
        for (n = 0; n < this.renderers.size(); ++n) {
            this.drawDomainMarkers(graphics2D, rectangle2D2, n, Layer.FOREGROUND);
        }
        for (n = 0; n < this.renderers.size(); ++n) {
            this.drawRangeMarkers(graphics2D, rectangle2D2, n, Layer.FOREGROUND);
        }
        this.drawAnnotations(graphics2D, rectangle2D2);
        if (this.shadowGenerator != null) {
            BufferedImage bufferedImage2 = this.shadowGenerator.createDropShadow(bufferedImage);
            graphics2D = graphics2D2;
            graphics2D.drawImage((Image)bufferedImage2, (int)rectangle2D2.getX() + this.shadowGenerator.calculateOffsetX(), (int)rectangle2D2.getY() + this.shadowGenerator.calculateOffsetY(), null);
            graphics2D.drawImage((Image)bufferedImage, (int)rectangle2D2.getX(), (int)rectangle2D2.getY(), null);
        }
        graphics2D.setClip((Shape)object3);
        graphics2D.setComposite(composite);
        if (n2 == 0) {
            this.drawNoDataMessage(graphics2D, rectangle2D2);
        }
        int n3 = categoryCrosshairState.getDatasetIndex();
        this.setCrosshairDatasetIndex(n3, false);
        Comparable comparable = categoryCrosshairState.getRowKey();
        Comparable comparable2 = categoryCrosshairState.getColumnKey();
        this.setDomainCrosshairRowKey(comparable, false);
        this.setDomainCrosshairColumnKey(comparable2, false);
        if (this.isDomainCrosshairVisible() && comparable2 != null) {
            object2 = this.getDomainCrosshairPaint();
            object = this.getDomainCrosshairStroke();
            this.drawDomainCrosshair(graphics2D, rectangle2D2, this.orientation, n3, comparable, comparable2, (Stroke)object, (Paint)object2);
        }
        object2 = this.getRangeAxisForDataset(n3);
        object = this.getRangeAxisEdge();
        if (!this.rangeCrosshairLockedOnData && point2D != null) {
            d = this.getOrientation() == PlotOrientation.VERTICAL ? ((ValueAxis)object2).java2DToValue(point2D.getY(), rectangle2D2, (RectangleEdge)object) : ((ValueAxis)object2).java2DToValue(point2D.getX(), rectangle2D2, (RectangleEdge)object);
            categoryCrosshairState.setCrosshairY(d);
        }
        this.setRangeCrosshairValue(categoryCrosshairState.getCrosshairY(), false);
        if (this.isRangeCrosshairVisible()) {
            d = this.getRangeCrosshairValue();
            Paint paint = this.getRangeCrosshairPaint();
            Stroke stroke = this.getRangeCrosshairStroke();
            this.drawRangeCrosshair(graphics2D, rectangle2D2, this.getOrientation(), d, (ValueAxis)object2, stroke, paint);
        }
        if (this.isOutlineVisible()) {
            if (this.getRenderer() != null) {
                this.getRenderer().drawOutline(graphics2D, this, rectangle2D2);
            } else {
                this.drawOutline(graphics2D, rectangle2D2);
            }
        }
    }

    public void drawBackground(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.fillBackground(graphics2D, rectangle2D, this.orientation);
        this.drawBackgroundImage(graphics2D, rectangle2D);
    }

    protected Map drawAxes(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState;
        Axis axis;
        int n;
        AxisCollection axisCollection = new AxisCollection();
        for (n = 0; n < this.domainAxes.size(); ++n) {
            axis = (CategoryAxis)this.domainAxes.get(n);
            if (axis == null) continue;
            axisCollection.add(axis, this.getDomainAxisEdge(n));
        }
        for (n = 0; n < this.rangeAxes.size(); ++n) {
            axis = (ValueAxis)this.rangeAxes.get(n);
            if (axis == null) continue;
            axisCollection.add(axis, this.getRangeAxisEdge(n));
        }
        HashMap<Axis, AxisState> hashMap = new HashMap<Axis, AxisState>();
        double d = rectangle2D2.getMinY() - this.axisOffset.calculateTopOutset(rectangle2D2.getHeight());
        for (Axis axis2 : axisCollection.getAxesAtTop()) {
            if (axis2 == null) continue;
            axisState = axis2.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.TOP, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(axis2, axisState);
        }
        d = rectangle2D2.getMaxY() + this.axisOffset.calculateBottomOutset(rectangle2D2.getHeight());
        for (Axis axis2 : axisCollection.getAxesAtBottom()) {
            if (axis2 == null) continue;
            axisState = axis2.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.BOTTOM, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(axis2, axisState);
        }
        d = rectangle2D2.getMinX() - this.axisOffset.calculateLeftOutset(rectangle2D2.getWidth());
        for (Axis axis2 : axisCollection.getAxesAtLeft()) {
            if (axis2 == null) continue;
            axisState = axis2.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.LEFT, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(axis2, axisState);
        }
        d = rectangle2D2.getMaxX() + this.axisOffset.calculateRightOutset(rectangle2D2.getWidth());
        for (Axis axis2 : axisCollection.getAxesAtRight()) {
            if (axis2 == null) continue;
            axisState = axis2.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.RIGHT, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(axis2, axisState);
        }
        return hashMap;
    }

    public boolean render(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, PlotRenderingInfo plotRenderingInfo, CategoryCrosshairState categoryCrosshairState) {
        boolean bl;
        boolean bl2 = false;
        CategoryDataset categoryDataset = this.getDataset(n);
        CategoryItemRenderer categoryItemRenderer = this.getRenderer(n);
        CategoryAxis categoryAxis = this.getDomainAxisForDataset(n);
        ValueAxis valueAxis = this.getRangeAxisForDataset(n);
        boolean bl3 = bl = !DatasetUtilities.isEmptyOrNull(categoryDataset);
        if (bl && categoryItemRenderer != null) {
            bl2 = true;
            CategoryItemRendererState categoryItemRendererState = categoryItemRenderer.initialise(graphics2D, rectangle2D, this, n, plotRenderingInfo);
            categoryItemRendererState.setCrosshairState(categoryCrosshairState);
            int n2 = categoryDataset.getColumnCount();
            int n3 = categoryDataset.getRowCount();
            int n4 = categoryItemRenderer.getPassCount();
            for (int i = 0; i < n4; ++i) {
                int n5;
                int n6;
                if (this.columnRenderingOrder == SortOrder.ASCENDING) {
                    for (n6 = 0; n6 < n2; ++n6) {
                        if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                            for (n5 = 0; n5 < n3; ++n5) {
                                categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n5, n6, i);
                            }
                            continue;
                        }
                        for (n5 = n3 - 1; n5 >= 0; --n5) {
                            categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n5, n6, i);
                        }
                    }
                    continue;
                }
                for (n6 = n2 - 1; n6 >= 0; --n6) {
                    if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                        for (n5 = 0; n5 < n3; ++n5) {
                            categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n5, n6, i);
                        }
                        continue;
                    }
                    for (n5 = n3 - 1; n5 >= 0; --n5) {
                        categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n5, n6, i);
                    }
                }
            }
        }
        return bl2;
    }

    protected void drawDomainGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (!this.isDomainGridlinesVisible()) {
            return;
        }
        CategoryAnchor categoryAnchor = this.getDomainGridlinePosition();
        RectangleEdge rectangleEdge = this.getDomainAxisEdge();
        CategoryDataset categoryDataset = this.getDataset();
        if (categoryDataset == null) {
            return;
        }
        CategoryAxis categoryAxis = this.getDomainAxis();
        if (categoryAxis != null) {
            int n = categoryDataset.getColumnCount();
            for (int i = 0; i < n; ++i) {
                double d = categoryAxis.getCategoryJava2DCoordinate(categoryAnchor, i, n, rectangle2D, rectangleEdge);
                CategoryItemRenderer categoryItemRenderer = this.getRenderer();
                if (categoryItemRenderer == null) continue;
                categoryItemRenderer.drawDomainGridline(graphics2D, this, rectangle2D, d);
            }
        }
    }

    protected void drawRangeGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (!this.isRangeGridlinesVisible() && !this.isRangeMinorGridlinesVisible()) {
            return;
        }
        ValueAxis valueAxis = this.getRangeAxis();
        if (valueAxis == null) {
            return;
        }
        CategoryItemRenderer categoryItemRenderer = this.getRenderer();
        if (categoryItemRenderer == null) {
            return;
        }
        Stroke stroke = null;
        Paint paint = null;
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            bl = false;
            ValueTick valueTick = (ValueTick)iterator.next();
            if (valueTick.getTickType() == TickType.MINOR && this.isRangeMinorGridlinesVisible()) {
                stroke = this.getRangeMinorGridlineStroke();
                paint = this.getRangeMinorGridlinePaint();
                bl = true;
            } else if (valueTick.getTickType() == TickType.MAJOR && this.isRangeGridlinesVisible()) {
                stroke = this.getRangeGridlineStroke();
                paint = this.getRangeGridlinePaint();
                bl = true;
            }
            if (valueTick.getValue() == 0.0 && this.isRangeZeroBaselineVisible() || !bl) continue;
            if (categoryItemRenderer instanceof AbstractCategoryItemRenderer) {
                AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)categoryItemRenderer;
                abstractCategoryItemRenderer.drawRangeLine(graphics2D, this, valueAxis, rectangle2D, valueTick.getValue(), paint, stroke);
                continue;
            }
            categoryItemRenderer.drawRangeGridline(graphics2D, this, valueAxis, rectangle2D, valueTick.getValue());
        }
    }

    protected void drawZeroRangeBaseline(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (!this.isRangeZeroBaselineVisible()) {
            return;
        }
        CategoryItemRenderer categoryItemRenderer = this.getRenderer();
        if (categoryItemRenderer instanceof AbstractCategoryItemRenderer) {
            AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)categoryItemRenderer;
            abstractCategoryItemRenderer.drawRangeLine(graphics2D, this, this.getRangeAxis(), rectangle2D, 0.0, this.rangeZeroBaselinePaint, this.rangeZeroBaselineStroke);
        } else {
            categoryItemRenderer.drawRangeGridline(graphics2D, this, this.getRangeAxis(), rectangle2D, 0.0);
        }
    }

    protected void drawAnnotations(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.getAnnotations() != null) {
            for (CategoryAnnotation categoryAnnotation : this.getAnnotations()) {
                categoryAnnotation.draw(graphics2D, this, rectangle2D, this.getDomainAxis(), this.getRangeAxis());
            }
        }
    }

    protected void drawDomainMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, Layer layer) {
        CategoryItemRenderer categoryItemRenderer = this.getRenderer(n);
        if (categoryItemRenderer == null) {
            return;
        }
        Collection collection = this.getDomainMarkers(n, layer);
        CategoryAxis categoryAxis = this.getDomainAxisForDataset(n);
        if (collection != null && categoryAxis != null) {
            for (CategoryMarker categoryMarker : collection) {
                categoryItemRenderer.drawDomainMarker(graphics2D, this, categoryAxis, categoryMarker, rectangle2D);
            }
        }
    }

    protected void drawRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, Layer layer) {
        CategoryItemRenderer categoryItemRenderer = this.getRenderer(n);
        if (categoryItemRenderer == null) {
            return;
        }
        Collection collection = this.getRangeMarkers(n, layer);
        ValueAxis valueAxis = this.getRangeAxisForDataset(n);
        if (collection != null && valueAxis != null) {
            for (Marker marker : collection) {
                categoryItemRenderer.drawRangeMarker(graphics2D, this, valueAxis, marker, rectangle2D);
            }
        }
    }

    protected void drawRangeLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().valueToJava2D(d, rectangle2D, this.getRangeAxisEdge());
        Line2D.Double double_ = null;
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (this.orientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    protected void drawDomainCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotOrientation plotOrientation, int n, Comparable comparable, Comparable comparable2, Stroke stroke, Paint paint) {
        CategoryDataset categoryDataset = this.getDataset(n);
        CategoryAxis categoryAxis = this.getDomainAxisForDataset(n);
        CategoryItemRenderer categoryItemRenderer = this.getRenderer(n);
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.VERTICAL) {
            double d = categoryItemRenderer.getItemMiddle(comparable, comparable2, categoryDataset, categoryAxis, rectangle2D, RectangleEdge.BOTTOM);
            double_ = new Line2D.Double(d, rectangle2D.getMinY(), d, rectangle2D.getMaxY());
        } else {
            double d = categoryItemRenderer.getItemMiddle(comparable, comparable2, categoryDataset, categoryAxis, rectangle2D, RectangleEdge.LEFT);
            double_ = new Line2D.Double(rectangle2D.getMinX(), d, rectangle2D.getMaxX(), d);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    protected void drawRangeCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotOrientation plotOrientation, double d, ValueAxis valueAxis, Stroke stroke, Paint paint) {
        if (!valueAxis.getRange().contains(d)) {
            return;
        }
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double d2 = valueAxis.valueToJava2D(d, rectangle2D, RectangleEdge.BOTTOM);
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else {
            double d3 = valueAxis.valueToJava2D(d, rectangle2D, RectangleEdge.LEFT);
            double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        ArrayList arrayList = new ArrayList();
        int n = this.rangeAxes.indexOf(valueAxis);
        if (n >= 0) {
            arrayList.addAll(this.datasetsMappedToRangeAxis(n));
        } else if (valueAxis == this.getRangeAxis()) {
            arrayList.addAll(this.datasetsMappedToRangeAxis(0));
        }
        for (CategoryDataset categoryDataset : arrayList) {
            CategoryItemRenderer categoryItemRenderer = this.getRendererForDataset(categoryDataset);
            if (categoryItemRenderer == null) continue;
            range = Range.combine(range, categoryItemRenderer.findRangeBounds(categoryDataset));
        }
        return range;
    }

    private List datasetsMappedToDomainAxis(int n) {
        Integer n2 = new Integer(n);
        ArrayList<CategoryDataset> arrayList = new ArrayList<CategoryDataset>();
        for (int i = 0; i < this.datasets.size(); ++i) {
            List list = (List)this.datasetToDomainAxesMap.get(new Integer(i));
            CategoryDataset categoryDataset = (CategoryDataset)this.datasets.get(i);
            if (list == null) {
                if (!n2.equals(ZERO) || categoryDataset == null) continue;
                arrayList.add(categoryDataset);
                continue;
            }
            if (!list.contains(n2) || categoryDataset == null) continue;
            arrayList.add(categoryDataset);
        }
        return arrayList;
    }

    private List datasetsMappedToRangeAxis(int n) {
        Integer n2 = new Integer(n);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.datasets.size(); ++i) {
            List list = (List)this.datasetToRangeAxesMap.get(new Integer(i));
            if (list == null) {
                if (!n2.equals(ZERO)) continue;
                arrayList.add(this.datasets.get(i));
                continue;
            }
            if (!list.contains(n2)) continue;
            arrayList.add(this.datasets.get(i));
        }
        return arrayList;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
        this.fireChangeEvent();
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace axisSpace) {
        this.setFixedDomainAxisSpace(axisSpace, true);
    }

    public void setFixedDomainAxisSpace(AxisSpace axisSpace, boolean bl) {
        this.fixedDomainAxisSpace = axisSpace;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace axisSpace) {
        this.setFixedRangeAxisSpace(axisSpace, true);
    }

    public void setFixedRangeAxisSpace(AxisSpace axisSpace, boolean bl) {
        this.fixedRangeAxisSpace = axisSpace;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public List getCategories() {
        List list = null;
        if (this.getDataset() != null) {
            list = Collections.unmodifiableList(this.getDataset().getColumnKeys());
        }
        return list;
    }

    public List getCategoriesForAxis(CategoryAxis categoryAxis) {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        int n = this.domainAxes.indexOf(categoryAxis);
        List list = this.datasetsMappedToDomainAxis(n);
        for (CategoryDataset categoryDataset : list) {
            for (int i = 0; i < categoryDataset.getColumnCount(); ++i) {
                Comparable comparable = categoryDataset.getColumnKey(i);
                if (arrayList.contains(comparable)) continue;
                arrayList.add(comparable);
            }
        }
        return arrayList;
    }

    public boolean getDrawSharedDomainAxis() {
        return this.drawSharedDomainAxis;
    }

    public void setDrawSharedDomainAxis(boolean bl) {
        this.drawSharedDomainAxis = bl;
        this.fireChangeEvent();
    }

    public boolean isDomainPannable() {
        return false;
    }

    public boolean isRangePannable() {
        return this.rangePannable;
    }

    public void setRangePannable(boolean bl) {
        this.rangePannable = bl;
    }

    public void panDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    public void panRangeAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        if (!this.isRangePannable()) {
            return;
        }
        int n = this.getRangeAxisCount();
        for (int i = 0; i < n; ++i) {
            ValueAxis valueAxis = this.getRangeAxis(i);
            if (valueAxis == null) continue;
            double d2 = valueAxis.getRange().getLength();
            double d3 = d * d2;
            if (valueAxis.isInverted()) {
                d3 = -d3;
            }
            valueAxis.setRange(valueAxis.getLowerBound() + d3, valueAxis.getUpperBound() + d3);
        }
    }

    public boolean isDomainZoomable() {
        return false;
    }

    public boolean isRangeZoomable() {
        return true;
    }

    public void zoomDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    public void zoomDomainAxes(double d, double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    public void zoomDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl) {
    }

    public void zoomRangeAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.zoomRangeAxes(d, plotRenderingInfo, point2D, false);
    }

    public void zoomRangeAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl) {
        for (int i = 0; i < this.rangeAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(i);
            if (valueAxis == null) continue;
            if (bl) {
                double d2 = point2D.getY();
                if (this.orientation == PlotOrientation.HORIZONTAL) {
                    d2 = point2D.getX();
                }
                double d3 = valueAxis.java2DToValue(d2, plotRenderingInfo.getDataArea(), this.getRangeAxisEdge());
                valueAxis.resizeRange2(d, d3);
                continue;
            }
            valueAxis.resizeRange(d);
        }
    }

    public void zoomRangeAxes(double d, double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        for (int i = 0; i < this.rangeAxes.size(); ++i) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(i);
            if (valueAxis == null) continue;
            valueAxis.zoomRange(d, d2);
        }
    }

    public double getAnchorValue() {
        return this.anchorValue;
    }

    public void setAnchorValue(double d) {
        this.setAnchorValue(d, true);
    }

    public void setAnchorValue(double d, boolean bl) {
        this.anchorValue = d;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CategoryPlot)) {
            return false;
        }
        CategoryPlot categoryPlot = (CategoryPlot)object;
        if (this.orientation != categoryPlot.orientation) {
            return false;
        }
        if (!ObjectUtilities.equal(this.axisOffset, categoryPlot.axisOffset)) {
            return false;
        }
        if (!this.domainAxes.equals(categoryPlot.domainAxes)) {
            return false;
        }
        if (!this.domainAxisLocations.equals(categoryPlot.domainAxisLocations)) {
            return false;
        }
        if (this.drawSharedDomainAxis != categoryPlot.drawSharedDomainAxis) {
            return false;
        }
        if (!this.rangeAxes.equals(categoryPlot.rangeAxes)) {
            return false;
        }
        if (!this.rangeAxisLocations.equals(categoryPlot.rangeAxisLocations)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.datasetToDomainAxesMap, categoryPlot.datasetToDomainAxesMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.datasetToRangeAxesMap, categoryPlot.datasetToRangeAxesMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.renderers, categoryPlot.renderers)) {
            return false;
        }
        if (this.renderingOrder != categoryPlot.renderingOrder) {
            return false;
        }
        if (this.columnRenderingOrder != categoryPlot.columnRenderingOrder) {
            return false;
        }
        if (this.rowRenderingOrder != categoryPlot.rowRenderingOrder) {
            return false;
        }
        if (this.domainGridlinesVisible != categoryPlot.domainGridlinesVisible) {
            return false;
        }
        if (this.domainGridlinePosition != categoryPlot.domainGridlinePosition) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainGridlineStroke, categoryPlot.domainGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainGridlinePaint, categoryPlot.domainGridlinePaint)) {
            return false;
        }
        if (this.rangeGridlinesVisible != categoryPlot.rangeGridlinesVisible) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeGridlineStroke, categoryPlot.rangeGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeGridlinePaint, categoryPlot.rangeGridlinePaint)) {
            return false;
        }
        if (this.anchorValue != categoryPlot.anchorValue) {
            return false;
        }
        if (this.rangeCrosshairVisible != categoryPlot.rangeCrosshairVisible) {
            return false;
        }
        if (this.rangeCrosshairValue != categoryPlot.rangeCrosshairValue) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeCrosshairStroke, categoryPlot.rangeCrosshairStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeCrosshairPaint, categoryPlot.rangeCrosshairPaint)) {
            return false;
        }
        if (this.rangeCrosshairLockedOnData != categoryPlot.rangeCrosshairLockedOnData) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundDomainMarkers, categoryPlot.foregroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundDomainMarkers, categoryPlot.backgroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundRangeMarkers, categoryPlot.foregroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundRangeMarkers, categoryPlot.backgroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.annotations, categoryPlot.annotations)) {
            return false;
        }
        if (this.weight != categoryPlot.weight) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fixedDomainAxisSpace, categoryPlot.fixedDomainAxisSpace)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fixedRangeAxisSpace, categoryPlot.fixedRangeAxisSpace)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fixedLegendItems, categoryPlot.fixedLegendItems)) {
            return false;
        }
        if (this.domainCrosshairVisible != categoryPlot.domainCrosshairVisible) {
            return false;
        }
        if (this.crosshairDatasetIndex != categoryPlot.crosshairDatasetIndex) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainCrosshairColumnKey, categoryPlot.domainCrosshairColumnKey)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainCrosshairRowKey, categoryPlot.domainCrosshairRowKey)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainCrosshairPaint, categoryPlot.domainCrosshairPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainCrosshairStroke, categoryPlot.domainCrosshairStroke)) {
            return false;
        }
        if (this.rangeMinorGridlinesVisible != categoryPlot.rangeMinorGridlinesVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeMinorGridlinePaint, categoryPlot.rangeMinorGridlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeMinorGridlineStroke, categoryPlot.rangeMinorGridlineStroke)) {
            return false;
        }
        if (this.rangeZeroBaselineVisible != categoryPlot.rangeZeroBaselineVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeZeroBaselinePaint, categoryPlot.rangeZeroBaselinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeZeroBaselineStroke, categoryPlot.rangeZeroBaselineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.shadowGenerator, categoryPlot.shadowGenerator)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        Cloneable cloneable;
        Object object;
        int n;
        CategoryPlot categoryPlot = (CategoryPlot)super.clone();
        categoryPlot.domainAxes = new ObjectList();
        for (n = 0; n < this.domainAxes.size(); ++n) {
            object = (CategoryAxis)this.domainAxes.get(n);
            if (object == null) continue;
            cloneable = (CategoryAxis)((CategoryAxis)object).clone();
            categoryPlot.setDomainAxis(n, (CategoryAxis)cloneable);
        }
        categoryPlot.domainAxisLocations = (ObjectList)this.domainAxisLocations.clone();
        categoryPlot.rangeAxes = new ObjectList();
        for (n = 0; n < this.rangeAxes.size(); ++n) {
            object = (ValueAxis)this.rangeAxes.get(n);
            if (object == null) continue;
            cloneable = (ValueAxis)((ValueAxis)object).clone();
            categoryPlot.setRangeAxis(n, (ValueAxis)cloneable);
        }
        categoryPlot.rangeAxisLocations = (ObjectList)this.rangeAxisLocations.clone();
        categoryPlot.datasets = (ObjectList)this.datasets.clone();
        for (n = 0; n < categoryPlot.datasets.size(); ++n) {
            object = categoryPlot.getDataset(n);
            if (object == null) continue;
            object.addChangeListener(categoryPlot);
        }
        categoryPlot.datasetToDomainAxesMap = new TreeMap();
        categoryPlot.datasetToDomainAxesMap.putAll(this.datasetToDomainAxesMap);
        categoryPlot.datasetToRangeAxesMap = new TreeMap();
        categoryPlot.datasetToRangeAxesMap.putAll(this.datasetToRangeAxesMap);
        categoryPlot.renderers = (ObjectList)this.renderers.clone();
        for (n = 0; n < this.renderers.size(); ++n) {
            object = (CategoryItemRenderer)this.renderers.get(n);
            if (!(object instanceof PublicCloneable)) continue;
            cloneable = (PublicCloneable)object;
            CategoryItemRenderer categoryItemRenderer = (CategoryItemRenderer)cloneable.clone();
            categoryPlot.renderers.set(n, categoryItemRenderer);
            categoryItemRenderer.setPlot(categoryPlot);
            categoryItemRenderer.addChangeListener(categoryPlot);
        }
        if (this.fixedDomainAxisSpace != null) {
            categoryPlot.fixedDomainAxisSpace = (AxisSpace)ObjectUtilities.clone(this.fixedDomainAxisSpace);
        }
        if (this.fixedRangeAxisSpace != null) {
            categoryPlot.fixedRangeAxisSpace = (AxisSpace)ObjectUtilities.clone(this.fixedRangeAxisSpace);
        }
        categoryPlot.annotations = (List)ObjectUtilities.deepClone(this.annotations);
        categoryPlot.foregroundDomainMarkers = this.cloneMarkerMap(this.foregroundDomainMarkers);
        categoryPlot.backgroundDomainMarkers = this.cloneMarkerMap(this.backgroundDomainMarkers);
        categoryPlot.foregroundRangeMarkers = this.cloneMarkerMap(this.foregroundRangeMarkers);
        categoryPlot.backgroundRangeMarkers = this.cloneMarkerMap(this.backgroundRangeMarkers);
        if (this.fixedLegendItems != null) {
            categoryPlot.fixedLegendItems = (LegendItemCollection)this.fixedLegendItems.clone();
        }
        return categoryPlot;
    }

    private Map cloneMarkerMap(Map map) throws CloneNotSupportedException {
        HashMap hashMap = new HashMap();
        Set set = map.keySet();
        for (Object k : set) {
            List list = (List)map.get(k);
            Collection collection = ObjectUtilities.deepClone(list);
            hashMap.put(k, collection);
        }
        return hashMap;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.domainGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeCrosshairStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeCrosshairPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.domainCrosshairStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainCrosshairPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeMinorGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeMinorGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeZeroBaselineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeZeroBaselinePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        Axis axis;
        int n2;
        objectInputStream.defaultReadObject();
        this.domainGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeCrosshairStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeCrosshairPaint = SerialUtilities.readPaint(objectInputStream);
        this.domainCrosshairStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainCrosshairPaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeMinorGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeMinorGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeZeroBaselineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeZeroBaselinePaint = SerialUtilities.readPaint(objectInputStream);
        for (n2 = 0; n2 < this.domainAxes.size(); ++n2) {
            axis = (CategoryAxis)this.domainAxes.get(n2);
            if (axis == null) continue;
            axis.setPlot(this);
            axis.addChangeListener(this);
        }
        for (n2 = 0; n2 < this.rangeAxes.size(); ++n2) {
            axis = (ValueAxis)this.rangeAxes.get(n2);
            if (axis == null) continue;
            axis.setPlot(this);
            axis.addChangeListener(this);
        }
        n2 = this.datasets.size();
        for (n = 0; n < n2; ++n) {
            Dataset dataset = (Dataset)this.datasets.get(n);
            if (dataset == null) continue;
            dataset.addChangeListener(this);
        }
        n = this.renderers.size();
        for (int i = 0; i < n; ++i) {
            CategoryItemRenderer categoryItemRenderer = (CategoryItemRenderer)this.renderers.get(i);
            if (categoryItemRenderer == null) continue;
            categoryItemRenderer.addChangeListener(this);
        }
    }
}

