/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.needle;

import ai.org.jfree.chart.needle.MeterNeedle;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class PinNeedle
extends MeterNeedle
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3787089953079863373L;

    protected void drawNeedle(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, double d) {
        GeneralPath generalPath = new GeneralPath();
        int n = (int)rectangle2D.getMinY();
        int n2 = (int)rectangle2D.getMaxY();
        int n3 = (int)(rectangle2D.getMinX() + rectangle2D.getWidth() / 2.0);
        int n4 = (int)(rectangle2D.getWidth() / 10.0);
        if (n4 < 2) {
            n4 = 2;
        }
        generalPath.moveTo(n3 - n4, n2 - n4);
        generalPath.lineTo(n3 + n4, n2 - n4);
        generalPath.lineTo(n3, n + n4);
        generalPath.closePath();
        n4 = 4 * n4;
        Ellipse2D.Double double_ = new Ellipse2D.Double(n3 - n4 / 2, rectangle2D.getMaxY() - (double)n4, n4, n4);
        Area area = new Area(double_);
        area.add(new Area(generalPath));
        if (point2D != null && d != 0.0) {
            this.getTransform().setToRotation(d, point2D.getX(), point2D.getY());
            area.transform(this.getTransform());
        }
        this.defaultDisplay(graphics2D, area);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PinNeedle)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

