/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.labels;

import ai.org.jfree.chart.labels.CrosshairLabelGenerator;
import ai.org.jfree.chart.plot.Crosshair;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.NumberFormat;

public class StandardCrosshairLabelGenerator
implements CrosshairLabelGenerator,
Serializable {
    private String labelTemplate;
    private NumberFormat numberFormat;

    public StandardCrosshairLabelGenerator() {
        this("{0}", NumberFormat.getNumberInstance());
    }

    public StandardCrosshairLabelGenerator(String string, NumberFormat numberFormat) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'labelTemplate' argument.");
        }
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'numberFormat' argument.");
        }
        this.labelTemplate = string;
        this.numberFormat = numberFormat;
    }

    public String getLabelTemplate() {
        return this.labelTemplate;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public String generateLabel(Crosshair crosshair) {
        Object[] objectArray = new Object[]{this.numberFormat.format(crosshair.getValue())};
        String string = MessageFormat.format(this.labelTemplate, objectArray);
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardCrosshairLabelGenerator)) {
            return false;
        }
        StandardCrosshairLabelGenerator standardCrosshairLabelGenerator = (StandardCrosshairLabelGenerator)object;
        if (!this.labelTemplate.equals(standardCrosshairLabelGenerator.labelTemplate)) {
            return false;
        }
        return this.numberFormat.equals(standardCrosshairLabelGenerator.numberFormat);
    }

    public int hashCode() {
        return this.labelTemplate.hashCode();
    }
}

