/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.labels;

import ai.org.jfree.chart.labels.AbstractXYItemLabelGenerator;
import ai.org.jfree.chart.labels.XYItemLabelGenerator;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.util.PublicCloneable;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;

public class IntervalXYItemLabelGenerator
extends AbstractXYItemLabelGenerator
implements XYItemLabelGenerator,
Cloneable,
PublicCloneable,
Serializable {
    public static final String DEFAULT_ITEM_LABEL_FORMAT = "{5} - {6}";

    public IntervalXYItemLabelGenerator() {
        this(DEFAULT_ITEM_LABEL_FORMAT, NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    public IntervalXYItemLabelGenerator(String string, NumberFormat numberFormat, NumberFormat numberFormat2) {
        super(string, numberFormat, numberFormat2);
    }

    public IntervalXYItemLabelGenerator(String string, DateFormat dateFormat, NumberFormat numberFormat) {
        super(string, dateFormat, numberFormat);
    }

    public IntervalXYItemLabelGenerator(String string, NumberFormat numberFormat, DateFormat dateFormat) {
        super(string, numberFormat, dateFormat);
    }

    public IntervalXYItemLabelGenerator(String string, DateFormat dateFormat, DateFormat dateFormat2) {
        super(string, dateFormat, dateFormat2);
    }

    protected Object[] createItemArray(XYDataset xYDataset, int n, int n2) {
        NumberFormat numberFormat;
        DateFormat dateFormat;
        double d;
        double d2;
        IntervalXYDataset intervalXYDataset = null;
        if (xYDataset instanceof IntervalXYDataset) {
            intervalXYDataset = (IntervalXYDataset)xYDataset;
        }
        Object[] objectArray = new Object[7];
        objectArray[0] = xYDataset.getSeriesKey(n).toString();
        double d3 = d2 = xYDataset.getXValue(n, n2);
        double d4 = d2;
        double d5 = d = xYDataset.getYValue(n, n2);
        double d6 = d;
        if (intervalXYDataset != null) {
            d3 = intervalXYDataset.getStartXValue(n, n2);
            d4 = intervalXYDataset.getEndXValue(n, n2);
            d5 = intervalXYDataset.getStartYValue(n, n2);
            d6 = intervalXYDataset.getEndYValue(n, n2);
        }
        if ((dateFormat = this.getXDateFormat()) != null) {
            objectArray[1] = dateFormat.format(new Date((long)d2));
            objectArray[2] = dateFormat.format(new Date((long)d3));
            objectArray[3] = dateFormat.format(new Date((long)d4));
        } else {
            numberFormat = this.getXFormat();
            objectArray[1] = numberFormat.format(d2);
            objectArray[2] = numberFormat.format(d3);
            objectArray[3] = numberFormat.format(d4);
        }
        numberFormat = this.getYFormat();
        DateFormat dateFormat2 = this.getYDateFormat();
        objectArray[4] = Double.isNaN(d) && xYDataset.getY(n, n2) == null ? this.getNullYString() : (dateFormat2 != null ? dateFormat2.format(new Date((long)d)) : numberFormat.format(d));
        objectArray[5] = Double.isNaN(d5) && intervalXYDataset.getStartY(n, n2) == null ? this.getNullYString() : (dateFormat2 != null ? dateFormat2.format(new Date((long)d5)) : numberFormat.format(d5));
        objectArray[6] = Double.isNaN(d6) && intervalXYDataset.getEndY(n, n2) == null ? this.getNullYString() : (dateFormat2 != null ? dateFormat2.format(new Date((long)d6)) : numberFormat.format(d6));
        return objectArray;
    }

    public String generateLabel(XYDataset xYDataset, int n, int n2) {
        return this.generateLabelString(xYDataset, n, n2);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntervalXYItemLabelGenerator)) {
            return false;
        }
        return super.equals(object);
    }
}

