/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.labels;

import ai.org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.category.IntervalCategoryDataset;
import java.text.DateFormat;
import java.text.NumberFormat;

public class IntervalCategoryToolTipGenerator
extends StandardCategoryToolTipGenerator {
    private static final long serialVersionUID = -3853824986520333437L;
    public static final String DEFAULT_TOOL_TIP_FORMAT_STRING = "({0}, {1}) = {3} - {4}";

    public IntervalCategoryToolTipGenerator() {
        super(DEFAULT_TOOL_TIP_FORMAT_STRING, NumberFormat.getInstance());
    }

    public IntervalCategoryToolTipGenerator(String string, NumberFormat numberFormat) {
        super(string, numberFormat);
    }

    public IntervalCategoryToolTipGenerator(String string, DateFormat dateFormat) {
        super(string, dateFormat);
    }

    protected Object[] createItemArray(CategoryDataset categoryDataset, int n, int n2) {
        Object[] objectArray = new Object[5];
        objectArray[0] = categoryDataset.getRowKey(n).toString();
        objectArray[1] = categoryDataset.getColumnKey(n2).toString();
        Number number = categoryDataset.getValue(n, n2);
        if (this.getNumberFormat() != null) {
            objectArray[2] = this.getNumberFormat().format(number);
        } else if (this.getDateFormat() != null) {
            objectArray[2] = this.getDateFormat().format(number);
        }
        if (categoryDataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
            Number number2 = intervalCategoryDataset.getStartValue(n, n2);
            Number number3 = intervalCategoryDataset.getEndValue(n, n2);
            if (this.getNumberFormat() != null) {
                objectArray[3] = this.getNumberFormat().format(number2);
                objectArray[4] = this.getNumberFormat().format(number3);
            } else if (this.getDateFormat() != null) {
                objectArray[3] = this.getDateFormat().format(number2);
                objectArray[4] = this.getDateFormat().format(number3);
            }
        }
        return objectArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntervalCategoryToolTipGenerator)) {
            return false;
        }
        return super.equals(object);
    }
}

