/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.labels;

import ai.org.jfree.chart.labels.CategoryItemLabelGenerator;
import ai.org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.category.IntervalCategoryDataset;
import ai.org.jfree.util.PublicCloneable;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;

public class IntervalCategoryItemLabelGenerator
extends StandardCategoryItemLabelGenerator
implements CategoryItemLabelGenerator,
PublicCloneable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 5056909225610630529L;
    public static final String DEFAULT_LABEL_FORMAT_STRING = "({0}, {1}) = {3} - {4}";

    public IntervalCategoryItemLabelGenerator() {
        super(DEFAULT_LABEL_FORMAT_STRING, NumberFormat.getInstance());
    }

    public IntervalCategoryItemLabelGenerator(String string, NumberFormat numberFormat) {
        super(string, numberFormat);
    }

    public IntervalCategoryItemLabelGenerator(String string, DateFormat dateFormat) {
        super(string, dateFormat);
    }

    protected Object[] createItemArray(CategoryDataset categoryDataset, int n, int n2) {
        Object[] objectArray = new Object[5];
        objectArray[0] = categoryDataset.getRowKey(n).toString();
        objectArray[1] = categoryDataset.getColumnKey(n2).toString();
        Number number = categoryDataset.getValue(n, n2);
        if (this.getNumberFormat() != null) {
            objectArray[2] = this.getNumberFormat().format(number);
        } else if (this.getDateFormat() != null) {
            objectArray[2] = this.getDateFormat().format(number);
        }
        if (categoryDataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
            Number number2 = intervalCategoryDataset.getStartValue(n, n2);
            Number number3 = intervalCategoryDataset.getEndValue(n, n2);
            if (this.getNumberFormat() != null) {
                objectArray[3] = this.getNumberFormat().format(number2);
                objectArray[4] = this.getNumberFormat().format(number3);
            } else if (this.getDateFormat() != null) {
                objectArray[3] = this.getDateFormat().format(number2);
                objectArray[4] = this.getDateFormat().format(number3);
            }
        }
        return objectArray;
    }
}

