/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.labels;

import ai.org.jfree.chart.labels.StandardXYToolTipGenerator;
import ai.org.jfree.chart.labels.XYToolTipGenerator;
import ai.org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import ai.org.jfree.data.xy.XYDataset;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;

public class BoxAndWhiskerXYToolTipGenerator
extends StandardXYToolTipGenerator
implements XYToolTipGenerator,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2648775791161459710L;
    public static final String DEFAULT_TOOL_TIP_FORMAT = "X: {1} Mean: {2} Median: {3} Min: {4} Max: {5} Q1: {6} Q3: {7} ";

    public BoxAndWhiskerXYToolTipGenerator() {
        super(DEFAULT_TOOL_TIP_FORMAT, NumberFormat.getInstance(), NumberFormat.getInstance());
    }

    public BoxAndWhiskerXYToolTipGenerator(String string, DateFormat dateFormat, NumberFormat numberFormat) {
        super(string, dateFormat, numberFormat);
    }

    protected Object[] createItemArray(XYDataset xYDataset, int n, int n2) {
        Object[] objectArray = new Object[8];
        objectArray[0] = xYDataset.getSeriesKey(n).toString();
        Number number = xYDataset.getX(n, n2);
        objectArray[1] = this.getXDateFormat() != null ? this.getXDateFormat().format(new Date(number.longValue())) : this.getXFormat().format(number);
        NumberFormat numberFormat = this.getYFormat();
        if (xYDataset instanceof BoxAndWhiskerXYDataset) {
            BoxAndWhiskerXYDataset boxAndWhiskerXYDataset = (BoxAndWhiskerXYDataset)xYDataset;
            objectArray[2] = numberFormat.format(boxAndWhiskerXYDataset.getMeanValue(n, n2));
            objectArray[3] = numberFormat.format(boxAndWhiskerXYDataset.getMedianValue(n, n2));
            objectArray[4] = numberFormat.format(boxAndWhiskerXYDataset.getMinRegularValue(n, n2));
            objectArray[5] = numberFormat.format(boxAndWhiskerXYDataset.getMaxRegularValue(n, n2));
            objectArray[6] = numberFormat.format(boxAndWhiskerXYDataset.getQ1Value(n, n2));
            objectArray[7] = numberFormat.format(boxAndWhiskerXYDataset.getQ3Value(n, n2));
        }
        return objectArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BoxAndWhiskerXYToolTipGenerator)) {
            return false;
        }
        return super.equals(object);
    }
}

