/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.labels;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.data.general.PieDataset;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.NumberFormat;

public class AbstractPieItemLabelGenerator
implements Serializable {
    private static final long serialVersionUID = 7347703325267846275L;
    private String labelFormat;
    private NumberFormat numberFormat;
    private NumberFormat percentFormat;

    protected AbstractPieItemLabelGenerator(String string, NumberFormat numberFormat, NumberFormat numberFormat2) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'labelFormat' argument.");
        }
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'numberFormat' argument.");
        }
        if (numberFormat2 == null) {
            throw new IllegalArgumentException("Null 'percentFormat' argument.");
        }
        this.labelFormat = string;
        this.numberFormat = numberFormat;
        this.percentFormat = numberFormat2;
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public NumberFormat getPercentFormat() {
        return this.percentFormat;
    }

    protected Object[] createItemArray(PieDataset pieDataset, Comparable comparable) {
        double d;
        Object[] objectArray = new Object[4];
        double d2 = DatasetUtilities.calculatePieDatasetTotal(pieDataset);
        objectArray[0] = comparable.toString();
        Number number = pieDataset.getValue(comparable);
        objectArray[1] = number != null ? this.numberFormat.format(number) : "null";
        double d3 = 0.0;
        if (number != null && (d = number.doubleValue()) > 0.0) {
            d3 = d / d2;
        }
        objectArray[2] = this.percentFormat.format(d3);
        objectArray[3] = this.numberFormat.format(d2);
        return objectArray;
    }

    protected String generateSectionLabel(PieDataset pieDataset, Comparable comparable) {
        String string = null;
        if (pieDataset != null) {
            Object[] objectArray = this.createItemArray(pieDataset, comparable);
            string = MessageFormat.format(this.labelFormat, objectArray);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractPieItemLabelGenerator)) {
            return false;
        }
        AbstractPieItemLabelGenerator abstractPieItemLabelGenerator = (AbstractPieItemLabelGenerator)object;
        if (!this.labelFormat.equals(abstractPieItemLabelGenerator.labelFormat)) {
            return false;
        }
        if (!this.numberFormat.equals(abstractPieItemLabelGenerator.numberFormat)) {
            return false;
        }
        return this.percentFormat.equals(abstractPieItemLabelGenerator.percentFormat);
    }

    public int hashCode() {
        int n = 127;
        n = HashUtilities.hashCode(n, this.labelFormat);
        n = HashUtilities.hashCode(n, this.numberFormat);
        n = HashUtilities.hashCode(n, this.percentFormat);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractPieItemLabelGenerator abstractPieItemLabelGenerator = (AbstractPieItemLabelGenerator)super.clone();
        if (this.numberFormat != null) {
            abstractPieItemLabelGenerator.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        if (this.percentFormat != null) {
            abstractPieItemLabelGenerator.percentFormat = (NumberFormat)this.percentFormat.clone();
        }
        return abstractPieItemLabelGenerator;
    }
}

