/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.encoders;

import ai.com.keypoint.PngEncoder;
import ai.org.jfree.chart.encoders.ImageEncoder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public class KeypointPNGEncoderAdapter
implements ImageEncoder {
    private int quality = 9;
    private boolean encodingAlpha = false;

    public float getQuality() {
        return this.quality;
    }

    public void setQuality(float f) {
        this.quality = (int)f;
    }

    public boolean isEncodingAlpha() {
        return this.encodingAlpha;
    }

    public void setEncodingAlpha(boolean bl) {
        this.encodingAlpha = bl;
    }

    public byte[] encode(BufferedImage bufferedImage) throws IOException {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("Null 'image' argument.");
        }
        PngEncoder pngEncoder = new PngEncoder(bufferedImage, this.encodingAlpha, 0, this.quality);
        return pngEncoder.pngEncode();
    }

    public void encode(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("Null 'image' argument.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Null 'outputStream' argument.");
        }
        PngEncoder pngEncoder = new PngEncoder(bufferedImage, this.encodingAlpha, 0, this.quality);
        outputStream.write(pngEncoder.pngEncode());
    }
}

