/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.block;

import ai.org.jfree.chart.block.AbstractBlock;
import ai.org.jfree.chart.block.Block;
import ai.org.jfree.chart.block.RectangleConstraint;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.Size2D;
import ai.org.jfree.util.PaintUtilities;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ColorBlock
extends AbstractBlock
implements Block {
    static final long serialVersionUID = 3383866145634010865L;
    private transient Paint paint;

    public ColorBlock(Paint paint, double d, double d2) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.paint = paint;
        this.setWidth(d);
        this.setHeight(d2);
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Size2D arrange(Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        return new Size2D(this.calculateTotalWidth(this.getWidth()), this.calculateTotalHeight(this.getHeight()));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        rectangle2D = this.trimMargin(rectangle2D);
        this.drawBorder(graphics2D, rectangle2D);
        rectangle2D = this.trimBorder(rectangle2D);
        rectangle2D = this.trimPadding(rectangle2D);
        graphics2D.setPaint(this.paint);
        graphics2D.fill(rectangle2D);
    }

    public Object draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Object object) {
        this.draw(graphics2D, rectangle2D);
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ColorBlock)) {
            return false;
        }
        ColorBlock colorBlock = (ColorBlock)object;
        if (!PaintUtilities.equal(this.paint, colorBlock.paint)) {
            return false;
        }
        return super.equals(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
    }
}

