/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.axis;

import ai.org.jfree.data.time.RegularTimePeriod;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleInsets;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class PeriodAxisLabelInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5710451740920277357L;
    public static final RectangleInsets DEFAULT_INSETS = new RectangleInsets(2.0, 2.0, 2.0, 2.0);
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_LABEL_PAINT = Color.black;
    public static final Stroke DEFAULT_DIVIDER_STROKE = new BasicStroke(0.5f);
    public static final Paint DEFAULT_DIVIDER_PAINT = Color.gray;
    private Class periodClass;
    private RectangleInsets padding;
    private DateFormat dateFormat;
    private Font labelFont;
    private transient Paint labelPaint;
    private boolean drawDividers;
    private transient Stroke dividerStroke;
    private transient Paint dividerPaint;

    public PeriodAxisLabelInfo(Class clazz, DateFormat dateFormat) {
        this(clazz, dateFormat, DEFAULT_INSETS, DEFAULT_FONT, DEFAULT_LABEL_PAINT, true, DEFAULT_DIVIDER_STROKE, DEFAULT_DIVIDER_PAINT);
    }

    public PeriodAxisLabelInfo(Class clazz, DateFormat dateFormat, RectangleInsets rectangleInsets, Font font, Paint paint, boolean bl, Stroke stroke, Paint paint2) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null 'periodClass' argument.");
        }
        if (dateFormat == null) {
            throw new IllegalArgumentException("Null 'dateFormat' argument.");
        }
        if (rectangleInsets == null) {
            throw new IllegalArgumentException("Null 'padding' argument.");
        }
        if (font == null) {
            throw new IllegalArgumentException("Null 'labelFont' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'labelPaint' argument.");
        }
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'dividerStroke' argument.");
        }
        if (paint2 == null) {
            throw new IllegalArgumentException("Null 'dividerPaint' argument.");
        }
        this.periodClass = clazz;
        this.dateFormat = dateFormat;
        this.padding = rectangleInsets;
        this.labelFont = font;
        this.labelPaint = paint;
        this.drawDividers = bl;
        this.dividerStroke = stroke;
        this.dividerPaint = paint2;
    }

    public Class getPeriodClass() {
        return this.periodClass;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public RectangleInsets getPadding() {
        return this.padding;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public boolean getDrawDividers() {
        return this.drawDividers;
    }

    public Stroke getDividerStroke() {
        return this.dividerStroke;
    }

    public Paint getDividerPaint() {
        return this.dividerPaint;
    }

    public RegularTimePeriod createInstance(Date date, TimeZone timeZone) {
        return this.createInstance(date, timeZone, Locale.getDefault());
    }

    public RegularTimePeriod createInstance(Date date, TimeZone timeZone, Locale locale) {
        RegularTimePeriod regularTimePeriod = null;
        try {
            Constructor constructor = this.periodClass.getDeclaredConstructor(Date.class, TimeZone.class, Locale.class);
            regularTimePeriod = (RegularTimePeriod)constructor.newInstance(date, timeZone, locale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return regularTimePeriod;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PeriodAxisLabelInfo) {
            PeriodAxisLabelInfo periodAxisLabelInfo = (PeriodAxisLabelInfo)object;
            if (!periodAxisLabelInfo.periodClass.equals(this.periodClass)) {
                return false;
            }
            if (!periodAxisLabelInfo.dateFormat.equals(this.dateFormat)) {
                return false;
            }
            if (!periodAxisLabelInfo.padding.equals(this.padding)) {
                return false;
            }
            if (!periodAxisLabelInfo.labelFont.equals(this.labelFont)) {
                return false;
            }
            if (!periodAxisLabelInfo.labelPaint.equals(this.labelPaint)) {
                return false;
            }
            if (periodAxisLabelInfo.drawDividers != this.drawDividers) {
                return false;
            }
            if (!periodAxisLabelInfo.dividerStroke.equals(this.dividerStroke)) {
                return false;
            }
            return periodAxisLabelInfo.dividerPaint.equals(this.dividerPaint);
        }
        return false;
    }

    public int hashCode() {
        int n = 41;
        n = 37 * this.periodClass.hashCode();
        n = 37 * this.dateFormat.hashCode();
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        PeriodAxisLabelInfo periodAxisLabelInfo = (PeriodAxisLabelInfo)super.clone();
        return periodAxisLabelInfo;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.labelPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.dividerStroke, objectOutputStream);
        SerialUtilities.writePaint(this.dividerPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.labelPaint = SerialUtilities.readPaint(objectInputStream);
        this.dividerStroke = SerialUtilities.readStroke(objectInputStream);
        this.dividerPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

