/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.axis;

import ai.org.jfree.chart.axis.NumberAxis;
import ai.org.jfree.chart.plot.IntervalMarker;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.ObjectUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MarkerAxisBand
implements Serializable {
    private static final long serialVersionUID = -1729482413886398919L;
    private NumberAxis axis;
    private double topOuterGap;
    private double topInnerGap;
    private double bottomOuterGap;
    private double bottomInnerGap;
    private Font font;
    private List markers;

    public MarkerAxisBand(NumberAxis numberAxis, double d, double d2, double d3, double d4, Font font) {
        this.axis = numberAxis;
        this.topOuterGap = d;
        this.topInnerGap = d2;
        this.bottomOuterGap = d3;
        this.bottomInnerGap = d4;
        this.font = font;
        this.markers = new ArrayList();
    }

    public void addMarker(IntervalMarker intervalMarker) {
        this.markers.add(intervalMarker);
    }

    public double getHeight(Graphics2D graphics2D) {
        double d = 0.0;
        if (this.markers.size() > 0) {
            LineMetrics lineMetrics = this.font.getLineMetrics("123g", graphics2D.getFontRenderContext());
            d = this.topOuterGap + this.topInnerGap + (double)lineMetrics.getHeight() + this.bottomInnerGap + this.bottomOuterGap;
        }
        return d;
    }

    private void drawStringInRect(Graphics2D graphics2D, Rectangle2D rectangle2D, Font font, String string) {
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
        double d = rectangle2D.getX();
        if (rectangle2D2.getWidth() < rectangle2D.getWidth()) {
            d += (rectangle2D.getWidth() - rectangle2D2.getWidth()) / 2.0;
        }
        LineMetrics lineMetrics = font.getLineMetrics(string, graphics2D.getFontRenderContext());
        graphics2D.drawString(string, (float)d, (float)(rectangle2D.getMaxY() - this.bottomInnerGap - (double)lineMetrics.getDescent()));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d, double d2) {
        double d3 = this.getHeight(graphics2D);
        for (IntervalMarker intervalMarker : this.markers) {
            double d4 = Math.max(intervalMarker.getStartValue(), this.axis.getRange().getLowerBound());
            double d5 = Math.min(intervalMarker.getEndValue(), this.axis.getRange().getUpperBound());
            double d6 = this.axis.valueToJava2D(d4, rectangle2D2, RectangleEdge.BOTTOM);
            double d7 = this.axis.valueToJava2D(d5, rectangle2D2, RectangleEdge.BOTTOM);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d6, d2 + this.topOuterGap, d7 - d6, d3 - this.topOuterGap - this.bottomOuterGap);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, intervalMarker.getAlpha()));
            graphics2D.setPaint(intervalMarker.getPaint());
            graphics2D.fill(double_);
            graphics2D.setPaint(intervalMarker.getOutlinePaint());
            graphics2D.draw(double_);
            graphics2D.setComposite(composite);
            graphics2D.setPaint(Color.black);
            this.drawStringInRect(graphics2D, double_, this.font, intervalMarker.getLabel());
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MarkerAxisBand)) {
            return false;
        }
        MarkerAxisBand markerAxisBand = (MarkerAxisBand)object;
        if (this.topOuterGap != markerAxisBand.topOuterGap) {
            return false;
        }
        if (this.topInnerGap != markerAxisBand.topInnerGap) {
            return false;
        }
        if (this.bottomInnerGap != markerAxisBand.bottomInnerGap) {
            return false;
        }
        if (this.bottomOuterGap != markerAxisBand.bottomOuterGap) {
            return false;
        }
        if (!ObjectUtilities.equal(this.font, markerAxisBand.font)) {
            return false;
        }
        return ObjectUtilities.equal(this.markers, markerAxisBand.markers);
    }

    public int hashCode() {
        int n = 37;
        n = 19 * n + this.font.hashCode();
        n = 19 * n + this.markers.hashCode();
        return n;
    }
}

