/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.axis;

import ai.org.jfree.chart.axis.NumberAxis;
import ai.org.jfree.chart.axis.NumberTick;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.ValueAxisPlot;
import ai.org.jfree.data.Range;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.TextAnchor;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class LogarithmicAxis
extends NumberAxis {
    private static final long serialVersionUID = 2502918599004103054L;
    public static final double LOG10_VALUE = Math.log(10.0);
    public static final double SMALL_LOG_VALUE = 1.0E-100;
    protected boolean allowNegativesFlag = false;
    protected boolean strictValuesFlag = true;
    protected final NumberFormat numberFormatterObj = NumberFormat.getInstance();
    protected boolean expTickLabelsFlag = false;
    protected boolean log10TickLabelsFlag = false;
    protected boolean autoRangeNextLogFlag = false;
    protected boolean smallLogFlag = false;

    public LogarithmicAxis(String string) {
        super(string);
        this.setupNumberFmtObj();
    }

    public void setAllowNegativesFlag(boolean bl) {
        this.allowNegativesFlag = bl;
    }

    public boolean getAllowNegativesFlag() {
        return this.allowNegativesFlag;
    }

    public void setStrictValuesFlag(boolean bl) {
        this.strictValuesFlag = bl;
    }

    public boolean getStrictValuesFlag() {
        return this.strictValuesFlag;
    }

    public void setExpTickLabelsFlag(boolean bl) {
        this.expTickLabelsFlag = bl;
        this.setupNumberFmtObj();
    }

    public boolean getExpTickLabelsFlag() {
        return this.expTickLabelsFlag;
    }

    public void setLog10TickLabelsFlag(boolean bl) {
        this.log10TickLabelsFlag = bl;
    }

    public boolean getLog10TickLabelsFlag() {
        return this.log10TickLabelsFlag;
    }

    public void setAutoRangeNextLogFlag(boolean bl) {
        this.autoRangeNextLogFlag = bl;
    }

    public boolean getAutoRangeNextLogFlag() {
        return this.autoRangeNextLogFlag;
    }

    public void setRange(Range range) {
        super.setRange(range);
        this.setupSmallLogFlag();
    }

    protected void setupSmallLogFlag() {
        double d = this.getRange().getLowerBound();
        this.smallLogFlag = !this.allowNegativesFlag && d < 10.0 && d > 0.0;
    }

    protected void setupNumberFmtObj() {
        if (this.numberFormatterObj instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormatterObj).applyPattern(this.expTickLabelsFlag ? "0E0" : "0.###");
        }
    }

    protected double switchedLog10(double d) {
        return this.smallLogFlag ? Math.log(d) / LOG10_VALUE : this.adjustedLog10(d);
    }

    public double switchedPow10(double d) {
        return this.smallLogFlag ? Math.pow(10.0, d) : this.adjustedPow10(d);
    }

    public double adjustedLog10(double d) {
        boolean bl;
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        if (d < 10.0) {
            d += (10.0 - d) / 10.0;
        }
        double d2 = Math.log(d) / LOG10_VALUE;
        return bl ? -d2 : d2;
    }

    public double adjustedPow10(double d) {
        boolean bl;
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        double d2 = d < 1.0 ? (Math.pow(10.0, d + 1.0) - 10.0) / 9.0 : Math.pow(10.0, d);
        return bl ? -d2 : d2;
    }

    protected double computeLogFloor(double d) {
        double d2;
        if (this.allowNegativesFlag) {
            if (d > 10.0) {
                d2 = Math.log(d) / LOG10_VALUE;
                d2 = Math.floor(d2);
                d2 = Math.pow(10.0, d2);
            } else if (d < -10.0) {
                d2 = Math.log(-d) / LOG10_VALUE;
                d2 = Math.floor(-d2);
                d2 = -Math.pow(10.0, -d2);
            } else {
                d2 = Math.floor(d);
            }
        } else if (d > 0.0) {
            d2 = Math.log(d) / LOG10_VALUE;
            d2 = Math.floor(d2);
            d2 = Math.pow(10.0, d2);
        } else {
            d2 = Math.floor(d);
        }
        return d2;
    }

    protected double computeLogCeil(double d) {
        double d2;
        if (this.allowNegativesFlag) {
            if (d > 10.0) {
                d2 = Math.log(d) / LOG10_VALUE;
                d2 = Math.ceil(d2);
                d2 = Math.pow(10.0, d2);
            } else if (d < -10.0) {
                d2 = Math.log(-d) / LOG10_VALUE;
                d2 = Math.ceil(-d2);
                d2 = -Math.pow(10.0, -d2);
            } else {
                d2 = Math.ceil(d);
            }
        } else if (d > 0.0) {
            d2 = Math.log(d) / LOG10_VALUE;
            d2 = Math.ceil(d2);
            d2 = Math.pow(10.0, d2);
        } else {
            d2 = Math.ceil(d);
        }
        return d2;
    }

    public void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = this.getDefaultAutoRange();
                d5 = range.getLowerBound();
            } else {
                d5 = range.getLowerBound();
                if (this.strictValuesFlag && !this.allowNegativesFlag && d5 <= 0.0) {
                    throw new RuntimeException("Values less than or equal to zero not allowed with logarithmic axis");
                }
            }
            if (d5 > 0.0) {
                double d6;
                double d7 = this.getLowerMargin();
                if (d6 > 0.0) {
                    double d8;
                    d4 = Math.log(d5) / LOG10_VALUE;
                    d3 = Math.abs(d4);
                    if (d8 < 1.0) {
                        d3 = 1.0;
                    }
                    d5 = Math.pow(10.0, d4 - d3 * d7);
                }
            }
            if (this.autoRangeNextLogFlag) {
                d5 = this.computeLogFloor(d5);
            }
            if (!this.allowNegativesFlag && d5 >= 0.0 && d5 < 1.0E-100) {
                d5 = range.getLowerBound();
            }
            if ((d4 = range.getUpperBound()) > 0.0) {
                double d9;
                d3 = this.getUpperMargin();
                if (d9 > 0.0) {
                    double d10;
                    d2 = Math.log(d4) / LOG10_VALUE;
                    d = Math.abs(d2);
                    if (d10 < 1.0) {
                        d = 1.0;
                    }
                    d4 = Math.pow(10.0, d2 + d * d3);
                }
            }
            if (!this.allowNegativesFlag && d4 < 1.0 && d4 > 0.0 && d5 > 0.0) {
                d2 = Math.log(d4) / LOG10_VALUE;
                d2 = Math.ceil(-d2 + 0.001);
                d4 = (d2 = Math.pow(10.0, d2)) > 0.0 ? Math.ceil(d4 * d2) / d2 : Math.ceil(d4);
            } else {
                d4 = this.autoRangeNextLogFlag ? this.computeLogCeil(d4) : Math.ceil(d4);
            }
            d2 = this.getAutoRangeMinimumSize();
            if (d4 - d5 < d2 && (d4 = (d4 + d5 + d2) / 2.0) - (d5 = (d4 + d5 - d2) / 2.0) < d2) {
                d = Math.abs(d4);
                double d11 = d > 1.0E-100 ? d / 100.0 : 0.01;
                d4 = (d4 + d5 + d11) / 2.0;
                d5 = (d4 + d5 - d11) / 2.0;
            }
            this.setRange(new Range(d5, d4), false, false);
            this.setupSmallLogFlag();
        }
    }

    public double valueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = this.switchedLog10(range.getLowerBound());
        double d3 = this.switchedLog10(range.getUpperBound());
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = rectangle2D.getMinX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d4 = rectangle2D.getMaxY();
            d5 = rectangle2D.getMinY();
        }
        d = this.switchedLog10(d);
        if (this.isInverted()) {
            return d5 - (d - d2) / (d3 - d2) * (d5 - d4);
        }
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    public double java2DToValue(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = this.switchedLog10(range.getLowerBound());
        double d3 = this.switchedLog10(range.getUpperBound());
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d4 = rectangle2D.getMaxY();
            d5 = rectangle2D.getMinY();
        }
        if (this.isInverted()) {
            return this.switchedPow10(d3 - (d - d4) / (d5 - d4) * (d3 - d2));
        }
        return this.switchedPow10(d2 + (d - d4) / (d5 - d4) * (d3 - d2));
    }

    public void zoomRange(double d, double d2) {
        double d3 = this.switchedLog10(this.getRange().getLowerBound());
        double d4 = this.switchedLog10(this.getRange().getUpperBound()) - d3;
        Range range = this.isInverted() ? new Range(this.switchedPow10(d3 + d4 * (1.0 - d2)), this.switchedPow10(d3 + d4 * (1.0 - d))) : new Range(this.switchedPow10(d3 + d4 * d), this.switchedPow10(d3 + d4 * d2));
        this.setRange(range);
    }

    protected List refreshTicksHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        int n;
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        Range range = this.getRange();
        double d = range.getLowerBound();
        if (this.smallLogFlag && d < 1.0E-100) {
            d = 1.0E-100;
        }
        double d2 = range.getUpperBound();
        int n2 = (int)Math.rint(this.switchedLog10(d));
        if (n2 == (n = (int)Math.rint(this.switchedLog10(d2))) && n2 > 0 && Math.pow(10.0, n2) > d) {
            --n2;
        }
        boolean bl = false;
        for (int i = n2; i <= n; ++i) {
            for (int j = 0; j < 10; ++j) {
                String string;
                double d3;
                if (this.smallLogFlag) {
                    d3 = Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j;
                    if (this.expTickLabelsFlag || i < 0 && d3 > 0.0 && d3 < 1.0) {
                        if (j == 0 || i > -4 && j < 2 || d3 >= d2) {
                            this.numberFormatterObj.setMaximumFractionDigits(-i);
                            string = this.makeTickLabel(d3, true);
                        } else {
                            string = "";
                        }
                    } else {
                        string = j < 1 || i < 1 && j < 5 || j < 4 - i || d3 >= d2 ? this.makeTickLabel(d3) : "";
                    }
                } else {
                    if (bl) {
                        --j;
                    }
                    double d4 = d3 = i >= 0 ? Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j : -(Math.pow(10.0, -i) - Math.pow(10.0, -i - 1) * (double)j);
                    if (!bl) {
                        if (Math.abs(d3 - 1.0) < 1.0E-4 && d <= 0.0 && d2 >= 0.0) {
                            d3 = 0.0;
                            bl = true;
                        }
                    } else {
                        bl = false;
                    }
                    String string2 = string = this.expTickLabelsFlag && j < 2 || j < 1 || i < 1 && j < 5 || j < 4 - i || d3 >= d2 ? this.makeTickLabel(d3) : "";
                }
                if (d3 > d2) {
                    return arrayList;
                }
                if (!(d3 >= d - 1.0E-100)) continue;
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d5 = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                    d5 = rectangleEdge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
                } else if (rectangleEdge == RectangleEdge.TOP) {
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                } else {
                    textAnchor = TextAnchor.TOP_CENTER;
                    textAnchor2 = TextAnchor.TOP_CENTER;
                }
                NumberTick numberTick = new NumberTick(new Double(d3), string, textAnchor, textAnchor2, d5);
                arrayList.add(numberTick);
            }
        }
        return arrayList;
    }

    protected List refreshTicksVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        int n;
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        double d = this.getRange().getLowerBound();
        if (this.smallLogFlag && d < 1.0E-100) {
            d = 1.0E-100;
        }
        double d2 = this.getRange().getUpperBound();
        int n2 = (int)Math.rint(this.switchedLog10(d));
        if (n2 == (n = (int)Math.rint(this.switchedLog10(d2))) && n2 > 0 && Math.pow(10.0, n2) > d) {
            --n2;
        }
        boolean bl = false;
        for (int i = n2; i <= n; ++i) {
            int n3 = 10;
            if (i == n) {
                n3 = 1;
            }
            for (int j = 0; j < n3; ++j) {
                Serializable serializable;
                String string;
                double d3;
                if (this.smallLogFlag) {
                    d3 = Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j;
                    if (j == 0) {
                        if (this.log10TickLabelsFlag) {
                            string = "10^" + i;
                        } else if (this.expTickLabelsFlag) {
                            string = "1e" + i;
                        } else if (i >= 0) {
                            serializable = this.getNumberFormatOverride();
                            string = serializable != null ? serializable.format(d3) : Long.toString((long)Math.rint(d3));
                        } else {
                            this.numberFormatterObj.setMaximumFractionDigits(-i);
                            string = this.numberFormatterObj.format(d3);
                        }
                    } else {
                        string = "";
                    }
                } else {
                    if (bl) {
                        --j;
                    }
                    double d4 = d3 = i >= 0 ? Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j : -(Math.pow(10.0, -i) - Math.pow(10.0, -i - 1) * (double)j);
                    if (j == 0) {
                        if (!bl) {
                            if (i > n2 && i < n && Math.abs(d3 - 1.0) < 1.0E-4) {
                                d3 = 0.0;
                                bl = true;
                                string = "0";
                            } else {
                                string = this.log10TickLabelsFlag ? (i < 0 ? "-" : "") + "10^" + Math.abs(i) : (this.expTickLabelsFlag ? (i < 0 ? "-" : "") + "1e" + Math.abs(i) : ((serializable = this.getNumberFormatOverride()) != null ? serializable.format(d3) : Long.toString((long)Math.rint(d3))));
                            }
                        } else {
                            string = "";
                            bl = false;
                        }
                    } else {
                        string = "";
                        bl = false;
                    }
                }
                if (d3 > d2) {
                    return arrayList;
                }
                if (!(d3 >= d - 1.0E-100)) continue;
                serializable = null;
                TextAnchor textAnchor = null;
                double d5 = 0.0;
                if (this.isVerticalTickLabels()) {
                    if (rectangleEdge == RectangleEdge.LEFT) {
                        serializable = TextAnchor.BOTTOM_CENTER;
                        textAnchor = TextAnchor.BOTTOM_CENTER;
                        d5 = -1.5707963267948966;
                    } else {
                        serializable = TextAnchor.BOTTOM_CENTER;
                        textAnchor = TextAnchor.BOTTOM_CENTER;
                        d5 = 1.5707963267948966;
                    }
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    serializable = TextAnchor.CENTER_RIGHT;
                    textAnchor = TextAnchor.CENTER_RIGHT;
                } else {
                    serializable = TextAnchor.CENTER_LEFT;
                    textAnchor = TextAnchor.CENTER_LEFT;
                }
                arrayList.add(new NumberTick(new Double(d3), string, (TextAnchor)serializable, textAnchor, d5));
            }
        }
        return arrayList;
    }

    protected String makeTickLabel(double d, boolean bl) {
        if (this.expTickLabelsFlag || bl) {
            return this.numberFormatterObj.format(d).toLowerCase();
        }
        return this.getTickUnit().valueToString(d);
    }

    protected String makeTickLabel(double d) {
        return this.makeTickLabel(d, false);
    }
}

