/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.axis;

import ai.org.jfree.chart.axis.AxisState;
import ai.org.jfree.chart.axis.NumberTick;
import ai.org.jfree.chart.axis.NumberTickUnit;
import ai.org.jfree.chart.axis.TickType;
import ai.org.jfree.chart.axis.TickUnit;
import ai.org.jfree.chart.axis.TickUnitSource;
import ai.org.jfree.chart.axis.TickUnits;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.event.AxisChangeEvent;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.ValueAxisPlot;
import ai.org.jfree.chart.util.LogFormat;
import ai.org.jfree.data.Range;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.ui.TextAnchor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LogAxis
extends ValueAxis {
    private double base = 10.0;
    private double baseLog = Math.log(10.0);
    private double smallestValue = 1.0E-100;
    private NumberTickUnit tickUnit;
    private NumberFormat numberFormatOverride;

    public LogAxis() {
        this(null);
    }

    public LogAxis(String string) {
        super(string, LogAxis.createLogTickUnits(Locale.getDefault()));
        this.setDefaultAutoRange(new Range(0.01, 1.0));
        this.tickUnit = new NumberTickUnit(1.0, new DecimalFormat("0.#"), 9);
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double d) {
        if (d <= 1.0) {
            throw new IllegalArgumentException("Requires 'base' > 1.0.");
        }
        this.base = d;
        this.baseLog = Math.log(d);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getSmallestValue() {
        return this.smallestValue;
    }

    public void setSmallestValue(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Requires 'value' > 0.0.");
        }
        this.smallestValue = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public NumberTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(NumberTickUnit numberTickUnit) {
        this.setTickUnit(numberTickUnit, true, true);
    }

    public void setTickUnit(NumberTickUnit numberTickUnit, boolean bl, boolean bl2) {
        if (numberTickUnit == null) {
            throw new IllegalArgumentException("Null 'unit' argument.");
        }
        this.tickUnit = numberTickUnit;
        if (bl2) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (bl) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public NumberFormat getNumberFormatOverride() {
        return this.numberFormatOverride;
    }

    public void setNumberFormatOverride(NumberFormat numberFormat) {
        this.numberFormatOverride = numberFormat;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double calculateLog(double d) {
        return Math.log(d) / this.baseLog;
    }

    public double calculateValue(double d) {
        return Math.pow(this.base, d);
    }

    public double java2DToValue(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = this.calculateLog(range.getLowerBound());
        double d3 = this.calculateLog(range.getUpperBound());
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d4 = rectangle2D.getMaxY();
            d5 = rectangle2D.getY();
        }
        double d6 = 0.0;
        d6 = this.isInverted() ? d3 - (d - d4) / (d5 - d4) * (d3 - d2) : d2 + (d - d4) / (d5 - d4) * (d3 - d2);
        return this.calculateValue(d6);
    }

    public double valueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = this.calculateLog(range.getLowerBound());
        double d3 = this.calculateLog(range.getUpperBound());
        d = this.calculateLog(d);
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d5 = rectangle2D.getMinY();
            d4 = rectangle2D.getMaxY();
        }
        if (this.isInverted()) {
            return d5 - (d - d2) / (d3 - d2) * (d5 - d4);
        }
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = this.getDefaultAutoRange();
            }
            double d = range.getUpperBound();
            double d2 = Math.max(range.getLowerBound(), this.smallestValue);
            double d3 = d - d2;
            double d4 = this.getFixedAutoRange();
            if (d4 > 0.0) {
                d2 = Math.max(d - d4, this.smallestValue);
            } else {
                double d5;
                double d6 = this.getAutoRangeMinimumSize();
                if (d3 < d6) {
                    d5 = (d6 - d3) / 2.0;
                    d += d5;
                    d2 -= d5;
                }
                d5 = this.calculateLog(d);
                double d7 = this.calculateLog(d2);
                double d8 = d5 - d7;
                d = this.calculateValue(d5 += this.getUpperMargin() * d8);
                d2 = this.calculateValue(d7 -= this.getLowerMargin() * d8);
            }
            this.setRange(new Range(d2, d), false, false);
        }
    }

    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState = null;
        if (!this.isVisible()) {
            axisState = new AxisState(d);
            List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
            axisState.setTicks(list);
            return axisState;
        }
        axisState = this.drawTickMarksAndLabels(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        axisState = this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        this.createAndAddEntity(d, axisState, rectangle2D2, rectangleEdge, plotRenderingInfo);
        return axisState;
    }

    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        List list = new ArrayList();
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            list = this.refreshTicksHorizontal(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            list = this.refreshTicksVertical(graphics2D, rectangle2D, rectangleEdge);
        }
        return list;
    }

    protected List refreshTicksHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        boolean bl;
        Range range = this.getRange();
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        TextAnchor textAnchor = rectangleEdge == RectangleEdge.TOP ? TextAnchor.BOTTOM_CENTER : TextAnchor.TOP_CENTER;
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
        int n = this.tickUnit.getMinorTickCount();
        double d = Math.floor(this.calculateLog(this.getLowerBound()));
        double d2 = Math.ceil(this.calculateLog(this.getUpperBound()));
        boolean bl2 = bl = this.tickUnit.getSize() > 0.0 && !Double.isInfinite(d);
        for (double d3 = d; bl && d3 <= d2; d3 += this.tickUnit.getSize()) {
            double d4 = this.calculateValue(d3);
            if (range.contains(d4)) {
                arrayList.add(new NumberTick(TickType.MAJOR, d4, this.createTickLabel(d4), textAnchor, TextAnchor.CENTER, 0.0));
            }
            double d5 = Math.pow(this.base, d3 + this.tickUnit.getSize());
            for (int i = 1; i < n; ++i) {
                double d6 = d4 + (double)i * ((d5 - d4) / (double)n);
                if (!range.contains(d6)) continue;
                arrayList.add(new NumberTick(TickType.MINOR, d6, "", textAnchor, TextAnchor.CENTER, 0.0));
            }
        }
        return arrayList;
    }

    protected List refreshTicksVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        boolean bl;
        Range range = this.getRange();
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        TextAnchor textAnchor = rectangleEdge == RectangleEdge.RIGHT ? TextAnchor.CENTER_LEFT : TextAnchor.CENTER_RIGHT;
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
        int n = this.tickUnit.getMinorTickCount();
        double d = Math.floor(this.calculateLog(this.getLowerBound()));
        double d2 = Math.ceil(this.calculateLog(this.getUpperBound()));
        boolean bl2 = bl = this.tickUnit.getSize() > 0.0 && !Double.isInfinite(d);
        for (double d3 = d; bl && d3 <= d2; d3 += this.tickUnit.getSize()) {
            double d4 = this.calculateValue(d3);
            if (range.contains(d4)) {
                arrayList.add(new NumberTick(TickType.MAJOR, d4, this.createTickLabel(d4), textAnchor, TextAnchor.CENTER, 0.0));
            }
            double d5 = Math.pow(this.base, d3 + this.tickUnit.getSize());
            for (int i = 1; i < n; ++i) {
                double d6 = d4 + (double)i * ((d5 - d4) / (double)n);
                if (!range.contains(d6)) continue;
                arrayList.add(new NumberTick(TickType.MINOR, d6, "", textAnchor, TextAnchor.CENTER, 0.0));
            }
        }
        return arrayList;
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.selectHorizontalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.selectVerticalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
    }

    protected void selectHorizontalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = this.estimateMaximumTickLabelWidth(graphics2D, this.getTickUnit());
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit = tickUnitSource.getCeilingTickUnit(this.getTickUnit());
        double d2 = this.exponentLengthToJava2D(tickUnit.getSize(), rectangle2D, rectangleEdge);
        double d3 = d / d2 * tickUnit.getSize();
        NumberTickUnit numberTickUnit = (NumberTickUnit)tickUnitSource.getCeilingTickUnit(d3);
        double d4 = this.exponentLengthToJava2D(numberTickUnit.getSize(), rectangle2D, rectangleEdge);
        d = this.estimateMaximumTickLabelWidth(graphics2D, numberTickUnit);
        if (d > d4) {
            numberTickUnit = (NumberTickUnit)tickUnitSource.getLargerTickUnit(numberTickUnit);
        }
        this.setTickUnit(numberTickUnit, false, false);
    }

    public double exponentLengthToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = this.valueToJava2D(this.calculateValue(1.0), rectangle2D, rectangleEdge);
        double d3 = this.valueToJava2D(this.calculateValue(d + 1.0), rectangle2D, rectangleEdge);
        return Math.abs(d3 - d2);
    }

    protected void selectVerticalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = this.estimateMaximumTickLabelHeight(graphics2D);
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit = tickUnitSource.getCeilingTickUnit(this.getTickUnit());
        double d2 = this.exponentLengthToJava2D(tickUnit.getSize(), rectangle2D, rectangleEdge);
        double d3 = d / d2 * tickUnit.getSize();
        NumberTickUnit numberTickUnit = (NumberTickUnit)tickUnitSource.getCeilingTickUnit(d3);
        double d4 = this.exponentLengthToJava2D(numberTickUnit.getSize(), rectangle2D, rectangleEdge);
        d = this.estimateMaximumTickLabelHeight(graphics2D);
        if (d > d4) {
            numberTickUnit = (NumberTickUnit)tickUnitSource.getLargerTickUnit(numberTickUnit);
        }
        this.setTickUnit(numberTickUnit, false, false);
    }

    protected double estimateMaximumTickLabelHeight(Graphics2D graphics2D) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        double d = rectangleInsets.getTop() + rectangleInsets.getBottom();
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        return d += (double)font.getLineMetrics("123", fontRenderContext).getHeight();
    }

    protected double estimateMaximumTickLabelWidth(Graphics2D graphics2D, TickUnit tickUnit) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        double d = rectangleInsets.getLeft() + rectangleInsets.getRight();
        if (this.isVerticalTickLabels()) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            LineMetrics lineMetrics = this.getTickLabelFont().getLineMetrics("0", fontRenderContext);
            d += (double)lineMetrics.getHeight();
        } else {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.getTickLabelFont());
            Range range = this.getRange();
            double d2 = range.getLowerBound();
            double d3 = range.getUpperBound();
            String string = "";
            String string2 = "";
            NumberFormat numberFormat = this.getNumberFormatOverride();
            if (numberFormat != null) {
                string = numberFormat.format(d2);
                string2 = numberFormat.format(d3);
            } else {
                string = tickUnit.valueToString(d2);
                string2 = tickUnit.valueToString(d3);
            }
            double d4 = fontMetrics.stringWidth(string);
            double d5 = fontMetrics.stringWidth(string2);
            d += Math.max(d4, d5);
        }
        return d;
    }

    public void zoomRange(double d, double d2) {
        Range range = this.getRange();
        double d3 = range.getLowerBound();
        double d4 = range.getUpperBound();
        double d5 = this.calculateLog(d3);
        double d6 = this.calculateLog(d4);
        double d7 = d6 - d5;
        Range range2 = null;
        if (this.isInverted()) {
            double d8 = d5 + d7 * (1.0 - d2);
            double d9 = d5 + d7 * (1.0 - d);
            range2 = new Range(this.calculateValue(d8), this.calculateValue(d9));
        } else {
            double d10 = d5 + d7 * d;
            double d11 = d5 + d7 * d2;
            range2 = new Range(this.calculateValue(d10), this.calculateValue(d11));
        }
        this.setRange(range2);
    }

    public void pan(double d) {
        Range range = this.getRange();
        double d2 = range.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = this.calculateLog(d2);
        double d5 = this.calculateLog(d3);
        double d6 = d5 - d4;
        double d7 = d6 * d;
        this.setRange(this.calculateValue(d4 += d7), this.calculateValue(d5 += d7));
    }

    protected String createTickLabel(double d) {
        if (this.numberFormatOverride != null) {
            return this.numberFormatOverride.format(d);
        }
        return this.tickUnit.valueToString(d);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LogAxis)) {
            return false;
        }
        LogAxis logAxis = (LogAxis)object;
        if (this.base != logAxis.base) {
            return false;
        }
        if (this.smallestValue != logAxis.smallestValue) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 193;
        long l = Double.doubleToLongBits(this.base);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.smallestValue);
        n = 37 * n + (int)(l ^ l >>> 32);
        if (this.numberFormatOverride != null) {
            n = 37 * n + this.numberFormatOverride.hashCode();
        }
        n = 37 * n + this.tickUnit.hashCode();
        return n;
    }

    public static TickUnitSource createLogTickUnits(Locale locale) {
        TickUnits tickUnits = new TickUnits();
        LogFormat logFormat = new LogFormat();
        tickUnits.add(new NumberTickUnit(0.05, logFormat, 2));
        tickUnits.add(new NumberTickUnit(0.1, logFormat, 10));
        tickUnits.add(new NumberTickUnit(0.2, logFormat, 2));
        tickUnits.add(new NumberTickUnit(0.5, logFormat, 5));
        tickUnits.add(new NumberTickUnit(1.0, logFormat, 10));
        tickUnits.add(new NumberTickUnit(2.0, logFormat, 10));
        tickUnits.add(new NumberTickUnit(3.0, logFormat, 15));
        tickUnits.add(new NumberTickUnit(4.0, logFormat, 20));
        tickUnits.add(new NumberTickUnit(5.0, logFormat, 25));
        tickUnits.add(new NumberTickUnit(6.0, logFormat));
        tickUnits.add(new NumberTickUnit(7.0, logFormat));
        tickUnits.add(new NumberTickUnit(8.0, logFormat));
        tickUnits.add(new NumberTickUnit(9.0, logFormat));
        tickUnits.add(new NumberTickUnit(10.0, logFormat));
        return tickUnits;
    }
}

