/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.axis;

import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.event.AxisChangeEvent;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.text.TextBlock;
import ai.org.jfree.text.TextFragment;
import ai.org.jfree.text.TextLine;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PaintUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public class ExtendedCategoryAxis
extends CategoryAxis {
    static final long serialVersionUID = -3004429093959826567L;
    private Map sublabels = new HashMap();
    private Font sublabelFont = new Font("SansSerif", 0, 10);
    private transient Paint sublabelPaint = Color.black;

    public ExtendedCategoryAxis(String string) {
        super(string);
    }

    public Font getSubLabelFont() {
        return this.sublabelFont;
    }

    public void setSubLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.sublabelFont = font;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getSubLabelPaint() {
        return this.sublabelPaint;
    }

    public void setSubLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.sublabelPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void addSubLabel(Comparable comparable, String string) {
        this.sublabels.put(comparable, string);
    }

    protected TextBlock createLabel(Comparable comparable, float f, RectangleEdge rectangleEdge, Graphics2D graphics2D) {
        TextBlock textBlock = super.createLabel(comparable, f, rectangleEdge, graphics2D);
        String string = (String)this.sublabels.get(comparable);
        if (string != null) {
            TextLine textLine;
            if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                TextLine textLine2 = new TextLine(string, this.sublabelFont, this.sublabelPaint);
                textBlock.addLine(textLine2);
            } else if ((rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) && (textLine = textBlock.getLastLine()) != null) {
                textLine.addFragment(new TextFragment("  " + string, this.sublabelFont, this.sublabelPaint));
            }
        }
        return textBlock;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ExtendedCategoryAxis)) {
            return false;
        }
        ExtendedCategoryAxis extendedCategoryAxis = (ExtendedCategoryAxis)object;
        if (!this.sublabelFont.equals(extendedCategoryAxis.sublabelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.sublabelPaint, extendedCategoryAxis.sublabelPaint)) {
            return false;
        }
        if (!this.sublabels.equals(extendedCategoryAxis.sublabels)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        ExtendedCategoryAxis extendedCategoryAxis = (ExtendedCategoryAxis)super.clone();
        extendedCategoryAxis.sublabels = new HashMap(this.sublabels);
        return extendedCategoryAxis;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.sublabelPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.sublabelPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

