/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.axis;

import ai.org.jfree.chart.axis.Axis;
import ai.org.jfree.chart.axis.AxisSpace;
import ai.org.jfree.chart.axis.AxisState;
import ai.org.jfree.chart.axis.CategoryAnchor;
import ai.org.jfree.chart.axis.CategoryLabelPosition;
import ai.org.jfree.chart.axis.CategoryLabelPositions;
import ai.org.jfree.chart.axis.CategoryLabelWidthType;
import ai.org.jfree.chart.axis.CategoryTick;
import ai.org.jfree.chart.entity.CategoryLabelEntity;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.event.AxisChangeEvent;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.text.G2TextMeasurer;
import ai.org.jfree.text.TextBlock;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.RectangleAnchor;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.ui.Size2D;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CategoryAxis
extends Axis
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5886554608114265863L;
    public static final double DEFAULT_AXIS_MARGIN = 0.05;
    public static final double DEFAULT_CATEGORY_MARGIN = 0.2;
    private double lowerMargin = 0.05;
    private double upperMargin = 0.05;
    private double categoryMargin = 0.2;
    private int maximumCategoryLabelLines = 1;
    private float maximumCategoryLabelWidthRatio = 0.0f;
    private int categoryLabelPositionOffset = 4;
    private CategoryLabelPositions categoryLabelPositions = CategoryLabelPositions.STANDARD;
    private Map tickLabelFontMap = new HashMap();
    private transient Map tickLabelPaintMap = new HashMap();
    private Map categoryLabelToolTips = new HashMap();

    public CategoryAxis() {
        this(null);
    }

    public CategoryAxis(String string) {
        super(string);
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double d) {
        this.lowerMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double d) {
        this.upperMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getCategoryMargin() {
        return this.categoryMargin;
    }

    public void setCategoryMargin(double d) {
        this.categoryMargin = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public int getMaximumCategoryLabelLines() {
        return this.maximumCategoryLabelLines;
    }

    public void setMaximumCategoryLabelLines(int n) {
        this.maximumCategoryLabelLines = n;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public float getMaximumCategoryLabelWidthRatio() {
        return this.maximumCategoryLabelWidthRatio;
    }

    public void setMaximumCategoryLabelWidthRatio(float f) {
        this.maximumCategoryLabelWidthRatio = f;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public int getCategoryLabelPositionOffset() {
        return this.categoryLabelPositionOffset;
    }

    public void setCategoryLabelPositionOffset(int n) {
        this.categoryLabelPositionOffset = n;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public CategoryLabelPositions getCategoryLabelPositions() {
        return this.categoryLabelPositions;
    }

    public void setCategoryLabelPositions(CategoryLabelPositions categoryLabelPositions) {
        if (categoryLabelPositions == null) {
            throw new IllegalArgumentException("Null 'positions' argument.");
        }
        this.categoryLabelPositions = categoryLabelPositions;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Font getTickLabelFont(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        Font font = (Font)this.tickLabelFontMap.get(comparable);
        if (font == null) {
            font = this.getTickLabelFont();
        }
        return font;
    }

    public void setTickLabelFont(Comparable comparable, Font font) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        if (font == null) {
            this.tickLabelFontMap.remove(comparable);
        } else {
            this.tickLabelFontMap.put(comparable, font);
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getTickLabelPaint(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        Paint paint = (Paint)this.tickLabelPaintMap.get(comparable);
        if (paint == null) {
            paint = this.getTickLabelPaint();
        }
        return paint;
    }

    public void setTickLabelPaint(Comparable comparable, Paint paint) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        if (paint == null) {
            this.tickLabelPaintMap.remove(comparable);
        } else {
            this.tickLabelPaintMap.put(comparable, paint);
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void addCategoryLabelToolTip(Comparable comparable, String string) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        this.categoryLabelToolTips.put(comparable, string);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public String getCategoryLabelToolTip(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        return (String)this.categoryLabelToolTips.get(comparable);
    }

    public void removeCategoryLabelToolTip(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        this.categoryLabelToolTips.remove(comparable);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void clearCategoryLabelToolTips() {
        this.categoryLabelToolTips.clear();
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getCategoryJava2DCoordinate(CategoryAnchor categoryAnchor, int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        if (categoryAnchor == CategoryAnchor.START) {
            d = this.getCategoryStart(n, n2, rectangle2D, rectangleEdge);
        } else if (categoryAnchor == CategoryAnchor.MIDDLE) {
            d = this.getCategoryMiddle(n, n2, rectangle2D, rectangleEdge);
        } else if (categoryAnchor == CategoryAnchor.END) {
            d = this.getCategoryEnd(n, n2, rectangle2D, rectangleEdge);
        }
        return d;
    }

    public double getCategoryStart(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d = rectangle2D.getX() + rectangle2D.getWidth() * this.getLowerMargin();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d = rectangle2D.getMinY() + rectangle2D.getHeight() * this.getLowerMargin();
        }
        double d2 = this.calculateCategorySize(n2, rectangle2D, rectangleEdge);
        double d3 = this.calculateCategoryGapSize(n2, rectangle2D, rectangleEdge);
        return d += (double)n * (d2 + d3);
    }

    public double getCategoryMiddle(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Invalid category index: " + n);
        }
        return this.getCategoryStart(n, n2, rectangle2D, rectangleEdge) + this.calculateCategorySize(n2, rectangle2D, rectangleEdge) / 2.0;
    }

    public double getCategoryEnd(int n, int n2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return this.getCategoryStart(n, n2, rectangle2D, rectangleEdge) + this.calculateCategorySize(n2, rectangle2D, rectangleEdge);
    }

    public double getCategoryMiddle(Comparable comparable, List list, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        if (list == null) {
            throw new IllegalArgumentException("Null 'categories' argument.");
        }
        int n = list.indexOf(comparable);
        int n2 = list.size();
        return this.getCategoryMiddle(n, n2, rectangle2D, rectangleEdge);
    }

    public double getCategorySeriesMiddle(Comparable comparable, Comparable comparable2, CategoryDataset categoryDataset, double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        int n = categoryDataset.getColumnIndex(comparable);
        int n2 = categoryDataset.getColumnCount();
        int n3 = categoryDataset.getRowIndex(comparable2);
        int n4 = categoryDataset.getRowCount();
        double d2 = this.getCategoryStart(n, n2, rectangle2D, rectangleEdge);
        double d3 = this.getCategoryEnd(n, n2, rectangle2D, rectangleEdge);
        double d4 = d3 - d2;
        if (n4 == 1) {
            return d2 + d4 / 2.0;
        }
        double d5 = d4 * d / (double)(n4 - 1);
        double d6 = d4 * (1.0 - d) / (double)n4;
        return d2 + (double)n3 * (d6 + d5) + d6 / 2.0;
    }

    public double getCategorySeriesMiddle(int n, int n2, int n3, int n4, double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = this.getCategoryStart(n, n2, rectangle2D, rectangleEdge);
        double d3 = this.getCategoryEnd(n, n2, rectangle2D, rectangleEdge);
        double d4 = d3 - d2;
        if (n4 == 1) {
            return d2 + d4 / 2.0;
        }
        double d5 = d4 * d / (double)(n4 - 1);
        double d6 = d4 * (1.0 - d) / (double)n4;
        return d2 + (double)n3 * (d6 + d5) + d6 / 2.0;
    }

    protected double calculateCategorySize(int n, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        double d2 = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d2 = rectangle2D.getWidth();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d2 = rectangle2D.getHeight();
        }
        if (n > 1) {
            d = d2 * (1.0 - this.getLowerMargin() - this.getUpperMargin() - this.getCategoryMargin());
            d /= (double)n;
        } else {
            d = d2 * (1.0 - this.getLowerMargin() - this.getUpperMargin());
        }
        return d;
    }

    protected double calculateCategoryGapSize(int n, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d = 0.0;
        double d2 = 0.0;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            d2 = rectangle2D.getWidth();
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            d2 = rectangle2D.getHeight();
        }
        if (n > 1) {
            d = d2 * this.getCategoryMargin() / (double)(n - 1);
        }
        return d;
    }

    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        Object object;
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        if (!this.isVisible()) {
            return axisSpace;
        }
        double d = 0.0;
        double d2 = 0.0;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            object = new AxisState();
            this.refreshTicks(graphics2D, (AxisState)object, rectangle2D, rectangleEdge);
            if (rectangleEdge == RectangleEdge.TOP) {
                d = ((AxisState)object).getMax();
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                d = ((AxisState)object).getMax();
            } else if (rectangleEdge == RectangleEdge.LEFT) {
                d2 = ((AxisState)object).getMax();
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                d2 = ((AxisState)object).getMax();
            }
        }
        object = this.getLabelEnclosure(graphics2D, rectangleEdge);
        double d3 = 0.0;
        double d4 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d3 = ((RectangularShape)object).getHeight();
            axisSpace.add(d3 + d + (double)this.categoryLabelPositionOffset, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d4 = ((RectangularShape)object).getWidth();
            axisSpace.add(d4 + d2 + (double)this.categoryLabelPositionOffset, rectangleEdge);
        }
        return axisSpace;
    }

    public void configure() {
    }

    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        if (!this.isVisible()) {
            return new AxisState(d);
        }
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d, rectangle2D2, rectangleEdge);
        }
        AxisState axisState = new AxisState(d);
        if (this.isTickMarksVisible()) {
            this.drawTickMarks(graphics2D, d, rectangle2D2, rectangleEdge, axisState);
        }
        this.createAndAddEntity(d, axisState, rectangle2D2, rectangleEdge, plotRenderingInfo);
        axisState = this.drawCategoryLabels(graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState, plotRenderingInfo);
        axisState = this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        return axisState;
    }

    protected AxisState drawCategoryLabels(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisState axisState, PlotRenderingInfo plotRenderingInfo) {
        return this.drawCategoryLabels(graphics2D, rectangle2D, rectangle2D, rectangleEdge, axisState, plotRenderingInfo);
    }

    protected AxisState drawCategoryLabels(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, AxisState axisState, PlotRenderingInfo plotRenderingInfo) {
        if (axisState == null) {
            throw new IllegalArgumentException("Null 'state' argument.");
        }
        if (this.isTickLabelsVisible()) {
            List list = this.refreshTicks(graphics2D, axisState, rectangle2D, rectangleEdge);
            axisState.setTicks(list);
            int n = 0;
            for (CategoryTick categoryTick : list) {
                EntityCollection entityCollection;
                graphics2D.setFont(this.getTickLabelFont(categoryTick.getCategory()));
                graphics2D.setPaint(this.getTickLabelPaint(categoryTick.getCategory()));
                CategoryLabelPosition categoryLabelPosition = this.categoryLabelPositions.getLabelPosition(rectangleEdge);
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                if (rectangleEdge == RectangleEdge.TOP) {
                    d = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d2 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d4 = axisState.getCursor() - (double)this.categoryLabelPositionOffset;
                    d3 = d4 - axisState.getMax();
                } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                    d = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d2 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d3 = axisState.getCursor() + (double)this.categoryLabelPositionOffset;
                    d4 = d3 + axisState.getMax();
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    d3 = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d4 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d2 = axisState.getCursor() - (double)this.categoryLabelPositionOffset;
                    d = d2 - axisState.getMax();
                } else if (rectangleEdge == RectangleEdge.RIGHT) {
                    d3 = this.getCategoryStart(n, list.size(), rectangle2D2, rectangleEdge);
                    d4 = this.getCategoryEnd(n, list.size(), rectangle2D2, rectangleEdge);
                    d = axisState.getCursor() + (double)this.categoryLabelPositionOffset;
                    d2 = d - axisState.getMax();
                }
                Rectangle2D.Double double_ = new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
                Point2D point2D = RectangleAnchor.coordinates(double_, categoryLabelPosition.getCategoryAnchor());
                TextBlock textBlock = categoryTick.getLabel();
                textBlock.draw(graphics2D, (float)point2D.getX(), (float)point2D.getY(), categoryLabelPosition.getLabelAnchor(), (float)point2D.getX(), (float)point2D.getY(), categoryLabelPosition.getAngle());
                Shape shape = textBlock.calculateBounds(graphics2D, (float)point2D.getX(), (float)point2D.getY(), categoryLabelPosition.getLabelAnchor(), (float)point2D.getX(), (float)point2D.getY(), categoryLabelPosition.getAngle());
                if (plotRenderingInfo != null && plotRenderingInfo.getOwner() != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
                    String string = this.getCategoryLabelToolTip(categoryTick.getCategory());
                    entityCollection.add(new CategoryLabelEntity(categoryTick.getCategory(), shape, string, null));
                }
                ++n;
            }
            if (rectangleEdge.equals(RectangleEdge.TOP)) {
                double d = axisState.getMax() + (double)this.categoryLabelPositionOffset;
                axisState.cursorUp(d);
            } else if (rectangleEdge.equals(RectangleEdge.BOTTOM)) {
                double d = axisState.getMax() + (double)this.categoryLabelPositionOffset;
                axisState.cursorDown(d);
            } else if (rectangleEdge == RectangleEdge.LEFT) {
                double d = axisState.getMax() + (double)this.categoryLabelPositionOffset;
                axisState.cursorLeft(d);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                double d = axisState.getMax() + (double)this.categoryLabelPositionOffset;
                axisState.cursorRight(d);
            }
        }
        return axisState;
    }

    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<CategoryTick> arrayList = new ArrayList<CategoryTick>();
        if (rectangle2D.getHeight() <= 0.0 || rectangle2D.getWidth() < 0.0) {
            return arrayList;
        }
        CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
        List list = categoryPlot.getCategoriesForAxis(this);
        double d = 0.0;
        if (list != null) {
            CategoryLabelPosition categoryLabelPosition = this.categoryLabelPositions.getLabelPosition(rectangleEdge);
            float f = this.maximumCategoryLabelWidthRatio;
            if ((double)f <= 0.0) {
                f = categoryLabelPosition.getWidthRatio();
            }
            float f2 = 0.0f;
            f2 = categoryLabelPosition.getWidthType() == CategoryLabelWidthType.CATEGORY ? (float)this.calculateCategorySize(list.size(), rectangle2D, rectangleEdge) : (RectangleEdge.isLeftOrRight(rectangleEdge) ? (float)rectangle2D.getWidth() : (float)rectangle2D.getHeight());
            int n = 0;
            for (Comparable comparable : list) {
                graphics2D.setFont(this.getTickLabelFont(comparable));
                TextBlock textBlock = this.createLabel(comparable, f2 * f, rectangleEdge, graphics2D);
                if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                    d = Math.max(d, this.calculateTextBlockHeight(textBlock, categoryLabelPosition, graphics2D));
                } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                    d = Math.max(d, this.calculateTextBlockWidth(textBlock, categoryLabelPosition, graphics2D));
                }
                CategoryTick categoryTick = new CategoryTick(comparable, textBlock, categoryLabelPosition.getLabelAnchor(), categoryLabelPosition.getRotationAnchor(), categoryLabelPosition.getAngle());
                arrayList.add(categoryTick);
                ++n;
            }
        }
        axisState.setMax(d);
        return arrayList;
    }

    public void drawTickMarks(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisState axisState) {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        CategoryPlot categoryPlot = (CategoryPlot)plot;
        double d2 = this.getTickMarkInsideLength();
        double d3 = this.getTickMarkOutsideLength();
        Line2D.Double double_ = new Line2D.Double();
        List list = categoryPlot.getCategoriesForAxis(this);
        graphics2D.setPaint(this.getTickMarkPaint());
        graphics2D.setStroke(this.getTickMarkStroke());
        if (rectangleEdge.equals(RectangleEdge.TOP)) {
            for (Comparable comparable : list) {
                double d4 = this.getCategoryMiddle(comparable, list, rectangle2D, rectangleEdge);
                ((Line2D)double_).setLine(d4, d, d4, d + d2);
                graphics2D.draw(double_);
                ((Line2D)double_).setLine(d4, d, d4, d - d3);
                graphics2D.draw(double_);
            }
            axisState.cursorUp(d3);
        } else if (rectangleEdge.equals(RectangleEdge.BOTTOM)) {
            for (Comparable comparable : list) {
                double d5 = this.getCategoryMiddle(comparable, list, rectangle2D, rectangleEdge);
                ((Line2D)double_).setLine(d5, d, d5, d - d2);
                graphics2D.draw(double_);
                ((Line2D)double_).setLine(d5, d, d5, d + d3);
                graphics2D.draw(double_);
            }
            axisState.cursorDown(d3);
        } else if (rectangleEdge.equals(RectangleEdge.LEFT)) {
            for (Comparable comparable : list) {
                double d6 = this.getCategoryMiddle(comparable, list, rectangle2D, rectangleEdge);
                ((Line2D)double_).setLine(d, d6, d + d2, d6);
                graphics2D.draw(double_);
                ((Line2D)double_).setLine(d, d6, d - d3, d6);
                graphics2D.draw(double_);
            }
            axisState.cursorLeft(d3);
        } else if (rectangleEdge.equals(RectangleEdge.RIGHT)) {
            for (Comparable comparable : list) {
                double d7 = this.getCategoryMiddle(comparable, list, rectangle2D, rectangleEdge);
                ((Line2D)double_).setLine(d, d7, d - d2, d7);
                graphics2D.draw(double_);
                ((Line2D)double_).setLine(d, d7, d + d3, d7);
                graphics2D.draw(double_);
            }
            axisState.cursorRight(d3);
        }
    }

    protected TextBlock createLabel(Comparable comparable, float f, RectangleEdge rectangleEdge, Graphics2D graphics2D) {
        TextBlock textBlock = TextUtilities.createTextBlock(comparable.toString(), this.getTickLabelFont(comparable), this.getTickLabelPaint(comparable), f, this.maximumCategoryLabelLines, new G2TextMeasurer(graphics2D));
        return textBlock;
    }

    protected double calculateTextBlockWidth(TextBlock textBlock, CategoryLabelPosition categoryLabelPosition, Graphics2D graphics2D) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        Size2D size2D = textBlock.calculateDimensions(graphics2D);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, size2D.getWidth(), size2D.getHeight());
        Shape shape = ShapeUtilities.rotateShape(double_, categoryLabelPosition.getAngle(), 0.0f, 0.0f);
        double d = shape.getBounds2D().getWidth() + rectangleInsets.getLeft() + rectangleInsets.getRight();
        return d;
    }

    protected double calculateTextBlockHeight(TextBlock textBlock, CategoryLabelPosition categoryLabelPosition, Graphics2D graphics2D) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        Size2D size2D = textBlock.calculateDimensions(graphics2D);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, size2D.getWidth(), size2D.getHeight());
        Shape shape = ShapeUtilities.rotateShape(double_, categoryLabelPosition.getAngle(), 0.0f, 0.0f);
        double d = shape.getBounds2D().getHeight() + rectangleInsets.getTop() + rectangleInsets.getBottom();
        return d;
    }

    public Object clone() throws CloneNotSupportedException {
        CategoryAxis categoryAxis = (CategoryAxis)super.clone();
        categoryAxis.tickLabelFontMap = new HashMap(this.tickLabelFontMap);
        categoryAxis.tickLabelPaintMap = new HashMap(this.tickLabelPaintMap);
        categoryAxis.categoryLabelToolTips = new HashMap(this.categoryLabelToolTips);
        return categoryAxis;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CategoryAxis)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        CategoryAxis categoryAxis = (CategoryAxis)object;
        if (categoryAxis.lowerMargin != this.lowerMargin) {
            return false;
        }
        if (categoryAxis.upperMargin != this.upperMargin) {
            return false;
        }
        if (categoryAxis.categoryMargin != this.categoryMargin) {
            return false;
        }
        if (categoryAxis.maximumCategoryLabelWidthRatio != this.maximumCategoryLabelWidthRatio) {
            return false;
        }
        if (categoryAxis.categoryLabelPositionOffset != this.categoryLabelPositionOffset) {
            return false;
        }
        if (!ObjectUtilities.equal(categoryAxis.categoryLabelPositions, this.categoryLabelPositions)) {
            return false;
        }
        if (!ObjectUtilities.equal(categoryAxis.categoryLabelToolTips, this.categoryLabelToolTips)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.tickLabelFontMap, categoryAxis.tickLabelFontMap)) {
            return false;
        }
        return this.equalPaintMaps(this.tickLabelPaintMap, categoryAxis.tickLabelPaintMap);
    }

    public int hashCode() {
        if (this.getLabel() != null) {
            return this.getLabel().hashCode();
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.writePaintMap(this.tickLabelPaintMap, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.tickLabelPaintMap = this.readPaintMap(objectInputStream);
    }

    private Map readPaintMap(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            return null;
        }
        HashMap<Comparable, Paint> hashMap = new HashMap<Comparable, Paint>();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Comparable comparable = (Comparable)objectInputStream.readObject();
            Paint paint = SerialUtilities.readPaint(objectInputStream);
            hashMap.put(comparable, paint);
        }
        return hashMap;
    }

    private void writePaintMap(Map map, ObjectOutputStream objectOutputStream) throws IOException {
        if (map == null) {
            objectOutputStream.writeBoolean(true);
        } else {
            objectOutputStream.writeBoolean(false);
            Set set = map.keySet();
            int n = set.size();
            objectOutputStream.writeInt(n);
            for (Comparable comparable : set) {
                objectOutputStream.writeObject(comparable);
                SerialUtilities.writePaint((Paint)map.get(comparable), objectOutputStream);
            }
        }
    }

    private boolean equalPaintMaps(Map map, Map map2) {
        if (map.size() != map2.size()) {
            return false;
        }
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            Paint paint;
            Paint paint2 = (Paint)entry.getValue();
            if (PaintUtilities.equal(paint2, paint = (Paint)map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }
}

