/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.annotations;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.annotations.AbstractXYAnnotation;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class XYShapeAnnotation
extends AbstractXYAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -8553218317600684041L;
    private transient Shape shape;
    private transient Stroke stroke;
    private transient Paint outlinePaint;
    private transient Paint fillPaint;

    public XYShapeAnnotation(Shape shape) {
        this(shape, new BasicStroke(1.0f), Color.black);
    }

    public XYShapeAnnotation(Shape shape, Stroke stroke, Paint paint) {
        this(shape, stroke, paint, null);
    }

    public XYShapeAnnotation(Shape shape, Stroke stroke, Paint paint, Paint paint2) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        this.shape = shape;
        this.stroke = stroke;
        this.outlinePaint = paint;
        this.fillPaint = paint2;
    }

    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, int n, PlotRenderingInfo plotRenderingInfo) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(xYPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(xYPlot.getRangeAxisLocation(), plotOrientation);
        Rectangle2D rectangle2D2 = this.shape.getBounds2D();
        double d = rectangle2D2.getMinX();
        double d2 = rectangle2D2.getMaxX();
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d5 = (d4 - d3) / (d2 - d);
        double d6 = d3 - d * d5;
        double d7 = rectangle2D2.getMaxY();
        double d8 = rectangle2D2.getMinY();
        double d9 = valueAxis2.valueToJava2D(d7, rectangle2D, rectangleEdge2);
        double d10 = valueAxis2.valueToJava2D(d8, rectangle2D, rectangleEdge2);
        double d11 = (d10 - d9) / (d8 - d7);
        double d12 = d9 - d11 * d7;
        Shape shape = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            AffineTransform affineTransform = new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
            AffineTransform affineTransform2 = new AffineTransform(d11, 0.0, 0.0, d5, d12, d6);
            shape = affineTransform.createTransformedShape(this.shape);
            shape = affineTransform2.createTransformedShape(shape);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            AffineTransform affineTransform = new AffineTransform(d5, 0.0, 0.0, d11, d6, d12);
            shape = affineTransform.createTransformedShape(this.shape);
        }
        if (this.fillPaint != null) {
            graphics2D.setPaint(this.fillPaint);
            graphics2D.fill(shape);
        }
        if (this.stroke != null && this.outlinePaint != null) {
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(shape);
        }
        this.addEntity(plotRenderingInfo, shape, n, this.getToolTipText(), this.getURL());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof XYShapeAnnotation)) {
            return false;
        }
        XYShapeAnnotation xYShapeAnnotation = (XYShapeAnnotation)object;
        if (!this.shape.equals(xYShapeAnnotation.shape)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.stroke, xYShapeAnnotation.stroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.outlinePaint, xYShapeAnnotation.outlinePaint)) {
            return false;
        }
        return PaintUtilities.equal(this.fillPaint, xYShapeAnnotation.fillPaint);
    }

    public int hashCode() {
        int n = 193;
        n = 37 * n + this.shape.hashCode();
        if (this.stroke != null) {
            n = 37 * n + this.stroke.hashCode();
        }
        n = 37 * n + HashUtilities.hashCodeForPaint(this.outlinePaint);
        n = 37 * n + HashUtilities.hashCodeForPaint(this.fillPaint);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.shape, objectOutputStream);
        SerialUtilities.writeStroke(this.stroke, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.fillPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.shape = SerialUtilities.readShape(objectInputStream);
        this.stroke = SerialUtilities.readStroke(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.fillPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

