/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.annotations;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.annotations.AbstractXYAnnotation;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class XYPolygonAnnotation
extends AbstractXYAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -6984203651995900036L;
    private double[] polygon;
    private transient Stroke stroke;
    private transient Paint outlinePaint;
    private transient Paint fillPaint;

    public XYPolygonAnnotation(double[] dArray) {
        this(dArray, new BasicStroke(1.0f), Color.black);
    }

    public XYPolygonAnnotation(double[] dArray, Stroke stroke, Paint paint) {
        this(dArray, stroke, paint, null);
    }

    public XYPolygonAnnotation(double[] dArray, Stroke stroke, Paint paint, Paint paint2) {
        if (dArray == null) {
            throw new IllegalArgumentException("Null 'polygon' argument.");
        }
        if (dArray.length % 2 != 0) {
            throw new IllegalArgumentException("The 'polygon' array must contain an even number of items.");
        }
        this.polygon = (double[])dArray.clone();
        this.stroke = stroke;
        this.outlinePaint = paint;
        this.fillPaint = paint2;
    }

    public double[] getPolygonCoordinates() {
        return (double[])this.polygon.clone();
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public Stroke getOutlineStroke() {
        return this.stroke;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, int n, PlotRenderingInfo plotRenderingInfo) {
        if (this.polygon.length < 4) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(xYPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(xYPlot.getRangeAxisLocation(), plotOrientation);
        GeneralPath generalPath = new GeneralPath();
        double d = valueAxis.valueToJava2D(this.polygon[0], rectangle2D, rectangleEdge);
        double d2 = valueAxis2.valueToJava2D(this.polygon[1], rectangle2D, rectangleEdge2);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            generalPath.moveTo((float)d2, (float)d);
            for (int i = 2; i < this.polygon.length; i += 2) {
                d = valueAxis.valueToJava2D(this.polygon[i], rectangle2D, rectangleEdge);
                d2 = valueAxis2.valueToJava2D(this.polygon[i + 1], rectangle2D, rectangleEdge2);
                generalPath.lineTo((float)d2, (float)d);
            }
            generalPath.closePath();
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            generalPath.moveTo((float)d, (float)d2);
            for (int i = 2; i < this.polygon.length; i += 2) {
                d = valueAxis.valueToJava2D(this.polygon[i], rectangle2D, rectangleEdge);
                d2 = valueAxis2.valueToJava2D(this.polygon[i + 1], rectangle2D, rectangleEdge2);
                generalPath.lineTo((float)d, (float)d2);
            }
            generalPath.closePath();
        }
        if (this.fillPaint != null) {
            graphics2D.setPaint(this.fillPaint);
            graphics2D.fill(generalPath);
        }
        if (this.stroke != null && this.outlinePaint != null) {
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(generalPath);
        }
        this.addEntity(plotRenderingInfo, generalPath, n, this.getToolTipText(), this.getURL());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof XYPolygonAnnotation)) {
            return false;
        }
        XYPolygonAnnotation xYPolygonAnnotation = (XYPolygonAnnotation)object;
        if (!Arrays.equals(this.polygon, xYPolygonAnnotation.polygon)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.stroke, xYPolygonAnnotation.stroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.outlinePaint, xYPolygonAnnotation.outlinePaint)) {
            return false;
        }
        return PaintUtilities.equal(this.fillPaint, xYPolygonAnnotation.fillPaint);
    }

    public int hashCode() {
        int n = 193;
        n = 37 * n + HashUtilities.hashCodeForDoubleArray(this.polygon);
        n = 37 * n + HashUtilities.hashCodeForPaint(this.fillPaint);
        n = 37 * n + HashUtilities.hashCodeForPaint(this.outlinePaint);
        if (this.stroke != null) {
            n = 37 * n + this.stroke.hashCode();
        }
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.stroke, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.fillPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.stroke = SerialUtilities.readStroke(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.fillPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

