/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.annotations;

import ai.org.jfree.chart.annotations.AbstractXYAnnotation;
import ai.org.jfree.chart.axis.AxisLocation;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.ui.RectangleAnchor;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class XYImageAnnotation
extends AbstractXYAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -4364694501921559958L;
    private double x;
    private double y;
    private transient Image image;
    private RectangleAnchor anchor;

    public XYImageAnnotation(double d, double d2, Image image) {
        this(d, d2, image, RectangleAnchor.CENTER);
    }

    public XYImageAnnotation(double d, double d2, Image image, RectangleAnchor rectangleAnchor) {
        if (image == null) {
            throw new IllegalArgumentException("Null 'image' argument.");
        }
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.x = d;
        this.y = d2;
        this.image = image;
        this.anchor = rectangleAnchor;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Image getImage() {
        return this.image;
    }

    public RectangleAnchor getImageAnchor() {
        return this.anchor;
    }

    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, int n, PlotRenderingInfo plotRenderingInfo) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        AxisLocation axisLocation = xYPlot.getDomainAxisLocation();
        AxisLocation axisLocation2 = xYPlot.getRangeAxisLocation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(axisLocation, plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(axisLocation2, plotOrientation);
        float f = (float)valueAxis.valueToJava2D(this.x, rectangle2D, rectangleEdge);
        float f2 = (float)valueAxis2.valueToJava2D(this.y, rectangle2D, rectangleEdge2);
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            f3 = f2;
            f4 = f;
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            f3 = f;
            f4 = f2;
        }
        int n2 = this.image.getWidth(null);
        int n3 = this.image.getHeight(null);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n2, n3);
        Point2D point2D = RectangleAnchor.coordinates(double_, this.anchor);
        graphics2D.drawImage(this.image, (int)(f3 -= (float)point2D.getX()), (int)(f4 -= (float)point2D.getY()), null);
        String string = this.getToolTipText();
        String string2 = this.getURL();
        if (string != null || string2 != null) {
            this.addEntity(plotRenderingInfo, new Rectangle2D.Float(f3, f4, n2, n3), n, string, string2);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof XYImageAnnotation)) {
            return false;
        }
        XYImageAnnotation xYImageAnnotation = (XYImageAnnotation)object;
        if (this.x != xYImageAnnotation.x) {
            return false;
        }
        if (this.y != xYImageAnnotation.y) {
            return false;
        }
        if (!ObjectUtilities.equal(this.image, xYImageAnnotation.image)) {
            return false;
        }
        return this.anchor.equals(xYImageAnnotation.anchor);
    }

    public int hashCode() {
        return this.image.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

