/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.annotations;

import ai.org.jfree.chart.annotations.AbstractXYAnnotation;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.ui.Drawable;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class XYDrawableAnnotation
extends AbstractXYAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -6540812859722691020L;
    private double drawScaleFactor;
    private double x;
    private double y;
    private double displayWidth;
    private double displayHeight;
    private Drawable drawable;

    public XYDrawableAnnotation(double d, double d2, double d3, double d4, Drawable drawable) {
        this(d, d2, d3, d4, 1.0, drawable);
    }

    public XYDrawableAnnotation(double d, double d2, double d3, double d4, double d5, Drawable drawable) {
        if (drawable == null) {
            throw new IllegalArgumentException("Null 'drawable' argument.");
        }
        this.x = d;
        this.y = d2;
        this.displayWidth = d3;
        this.displayHeight = d4;
        this.drawScaleFactor = d5;
        this.drawable = drawable;
    }

    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, int n, PlotRenderingInfo plotRenderingInfo) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(xYPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(xYPlot.getRangeAxisLocation(), plotOrientation);
        float f = (float)valueAxis.valueToJava2D(this.x, rectangle2D, rectangleEdge);
        float f2 = (float)valueAxis2.valueToJava2D(this.y, rectangle2D, rectangleEdge2);
        Rectangle2D.Double double_ = new Rectangle2D.Double((double)f - this.displayWidth / 2.0, (double)f2 - this.displayHeight / 2.0, this.displayWidth, this.displayHeight);
        AffineTransform affineTransform = graphics2D.getTransform();
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, this.displayWidth * this.drawScaleFactor, this.displayHeight * this.drawScaleFactor);
        graphics2D.scale(1.0 / this.drawScaleFactor, 1.0 / this.drawScaleFactor);
        graphics2D.translate(((double)f - this.displayWidth / 2.0) * this.drawScaleFactor, ((double)f2 - this.displayHeight / 2.0) * this.drawScaleFactor);
        this.drawable.draw(graphics2D, double_2);
        graphics2D.setTransform(affineTransform);
        String string = this.getToolTipText();
        String string2 = this.getURL();
        if (string != null || string2 != null) {
            this.addEntity(plotRenderingInfo, double_, n, string, string2);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof XYDrawableAnnotation)) {
            return false;
        }
        XYDrawableAnnotation xYDrawableAnnotation = (XYDrawableAnnotation)object;
        if (this.x != xYDrawableAnnotation.x) {
            return false;
        }
        if (this.y != xYDrawableAnnotation.y) {
            return false;
        }
        if (this.displayWidth != xYDrawableAnnotation.displayWidth) {
            return false;
        }
        if (this.displayHeight != xYDrawableAnnotation.displayHeight) {
            return false;
        }
        if (this.drawScaleFactor != xYDrawableAnnotation.drawScaleFactor) {
            return false;
        }
        return ObjectUtilities.equal(this.drawable, xYDrawableAnnotation.drawable);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        int n = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 29 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.displayWidth);
        n = 29 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.displayHeight);
        n = 29 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

