/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.annotations;

import ai.org.jfree.chart.annotations.AbstractXYAnnotation;
import ai.org.jfree.chart.annotations.XYAnnotationBoundsInfo;
import ai.org.jfree.chart.axis.AxisLocation;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.data.Range;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class XYDataImageAnnotation
extends AbstractXYAnnotation
implements Cloneable,
PublicCloneable,
XYAnnotationBoundsInfo {
    private transient Image image;
    private double x;
    private double y;
    private double w;
    private double h;
    private boolean includeInDataBounds;

    public XYDataImageAnnotation(Image image, double d, double d2, double d3, double d4) {
        this(image, d, d2, d3, d4, false);
    }

    public XYDataImageAnnotation(Image image, double d, double d2, double d3, double d4, boolean bl) {
        if (image == null) {
            throw new IllegalArgumentException("Null 'image' argument.");
        }
        this.image = image;
        this.x = d;
        this.y = d2;
        this.w = d3;
        this.h = d4;
        this.includeInDataBounds = bl;
    }

    public Image getImage() {
        return this.image;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.w;
    }

    public double getHeight() {
        return this.h;
    }

    public boolean getIncludeInDataBounds() {
        return this.includeInDataBounds;
    }

    public Range getXRange() {
        return new Range(this.x, this.x + this.w);
    }

    public Range getYRange() {
        return new Range(this.y, this.y + this.h);
    }

    public void draw(Graphics2D graphics2D, XYPlot xYPlot, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, int n, PlotRenderingInfo plotRenderingInfo) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        AxisLocation axisLocation = xYPlot.getDomainAxisLocation();
        AxisLocation axisLocation2 = xYPlot.getRangeAxisLocation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(axisLocation, plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(axisLocation2, plotOrientation);
        float f = (float)valueAxis.valueToJava2D(this.x, rectangle2D, rectangleEdge);
        float f2 = (float)valueAxis2.valueToJava2D(this.y, rectangle2D, rectangleEdge2);
        float f3 = (float)valueAxis.valueToJava2D(this.x + this.w, rectangle2D, rectangleEdge);
        float f4 = (float)valueAxis2.valueToJava2D(this.y + this.h, rectangle2D, rectangleEdge2);
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            f5 = f2;
            f7 = f4;
            f6 = f;
            f8 = f3;
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            f5 = f;
            f7 = f3;
            f6 = f2;
            f8 = f4;
        }
        graphics2D.drawImage(this.image, (int)f5, (int)Math.min(f6, f8), (int)(f7 - f5), (int)Math.abs(f8 - f6), null);
        String string = this.getToolTipText();
        String string2 = this.getURL();
        if (string != null || string2 != null) {
            this.addEntity(plotRenderingInfo, new Rectangle2D.Float(f5, f6, f7 - f5, f8 - f6), n, string, string2);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof XYDataImageAnnotation)) {
            return false;
        }
        XYDataImageAnnotation xYDataImageAnnotation = (XYDataImageAnnotation)object;
        if (this.x != xYDataImageAnnotation.x) {
            return false;
        }
        if (this.y != xYDataImageAnnotation.y) {
            return false;
        }
        if (this.w != xYDataImageAnnotation.w) {
            return false;
        }
        if (this.h != xYDataImageAnnotation.h) {
            return false;
        }
        if (this.includeInDataBounds != xYDataImageAnnotation.includeInDataBounds) {
            return false;
        }
        return ObjectUtilities.equal(this.image, xYDataImageAnnotation.image);
    }

    public int hashCode() {
        return this.image.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

