/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.annotations;

import ai.org.jfree.chart.annotations.CategoryAnnotation;
import ai.org.jfree.chart.annotations.TextAnnotation;
import ai.org.jfree.chart.axis.CategoryAnchor;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class CategoryTextAnnotation
extends TextAnnotation
implements CategoryAnnotation,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 3333360090781320147L;
    private Comparable category;
    private CategoryAnchor categoryAnchor;
    private double value;

    public CategoryTextAnnotation(String string, Comparable comparable, double d) {
        super(string);
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        this.category = comparable;
        this.value = d;
        this.categoryAnchor = CategoryAnchor.MIDDLE;
    }

    public Comparable getCategory() {
        return this.category;
    }

    public void setCategory(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        this.category = comparable;
        this.fireAnnotationChanged();
    }

    public CategoryAnchor getCategoryAnchor() {
        return this.categoryAnchor;
    }

    public void setCategoryAnchor(CategoryAnchor categoryAnchor) {
        if (categoryAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.categoryAnchor = categoryAnchor;
        this.fireAnnotationChanged();
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
        this.fireAnnotationChanged();
    }

    public void draw(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, CategoryAxis categoryAxis, ValueAxis valueAxis) {
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        int n = categoryDataset.getColumnIndex(this.category);
        int n2 = categoryDataset.getColumnCount();
        float f = 0.0f;
        float f2 = 0.0f;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(categoryPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(categoryPlot.getRangeAxisLocation(), plotOrientation);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            f2 = (float)categoryAxis.getCategoryJava2DCoordinate(this.categoryAnchor, n, n2, rectangle2D, rectangleEdge);
            f = (float)valueAxis.valueToJava2D(this.value, rectangle2D, rectangleEdge2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            f = (float)categoryAxis.getCategoryJava2DCoordinate(this.categoryAnchor, n, n2, rectangle2D, rectangleEdge);
            f2 = (float)valueAxis.valueToJava2D(this.value, rectangle2D, rectangleEdge2);
        }
        graphics2D.setFont(this.getFont());
        graphics2D.setPaint(this.getPaint());
        TextUtilities.drawRotatedString(this.getText(), graphics2D, f, f2, this.getTextAnchor(), this.getRotationAngle(), this.getRotationAnchor());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CategoryTextAnnotation)) {
            return false;
        }
        CategoryTextAnnotation categoryTextAnnotation = (CategoryTextAnnotation)object;
        if (!super.equals(object)) {
            return false;
        }
        if (!this.category.equals(categoryTextAnnotation.getCategory())) {
            return false;
        }
        if (!this.categoryAnchor.equals(categoryTextAnnotation.getCategoryAnchor())) {
            return false;
        }
        return this.value == categoryTextAnnotation.getValue();
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + this.category.hashCode();
        n = 37 * n + this.categoryAnchor.hashCode();
        long l = Double.doubleToLongBits(this.value);
        n = 37 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

