/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.annotations;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.annotations.CategoryTextAnnotation;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CategoryPointerAnnotation
extends CategoryTextAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -4031161445009858551L;
    public static final double DEFAULT_TIP_RADIUS = 10.0;
    public static final double DEFAULT_BASE_RADIUS = 30.0;
    public static final double DEFAULT_LABEL_OFFSET = 3.0;
    public static final double DEFAULT_ARROW_LENGTH = 5.0;
    public static final double DEFAULT_ARROW_WIDTH = 3.0;
    private double angle;
    private double tipRadius;
    private double baseRadius;
    private double arrowLength;
    private double arrowWidth;
    private transient Stroke arrowStroke;
    private transient Paint arrowPaint;
    private double labelOffset;

    public CategoryPointerAnnotation(String string, Comparable comparable, double d, double d2) {
        super(string, comparable, d);
        this.angle = d2;
        this.tipRadius = 10.0;
        this.baseRadius = 30.0;
        this.arrowLength = 5.0;
        this.arrowWidth = 3.0;
        this.labelOffset = 3.0;
        this.arrowStroke = new BasicStroke(1.0f);
        this.arrowPaint = Color.black;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
        this.fireAnnotationChanged();
    }

    public double getTipRadius() {
        return this.tipRadius;
    }

    public void setTipRadius(double d) {
        this.tipRadius = d;
        this.fireAnnotationChanged();
    }

    public double getBaseRadius() {
        return this.baseRadius;
    }

    public void setBaseRadius(double d) {
        this.baseRadius = d;
        this.fireAnnotationChanged();
    }

    public double getLabelOffset() {
        return this.labelOffset;
    }

    public void setLabelOffset(double d) {
        this.labelOffset = d;
        this.fireAnnotationChanged();
    }

    public double getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(double d) {
        this.arrowLength = d;
        this.fireAnnotationChanged();
    }

    public double getArrowWidth() {
        return this.arrowWidth;
    }

    public void setArrowWidth(double d) {
        this.arrowWidth = d;
        this.fireAnnotationChanged();
    }

    public Stroke getArrowStroke() {
        return this.arrowStroke;
    }

    public void setArrowStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' not permitted.");
        }
        this.arrowStroke = stroke;
        this.fireAnnotationChanged();
    }

    public Paint getArrowPaint() {
        return this.arrowPaint;
    }

    public void setArrowPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.arrowPaint = paint;
        this.fireAnnotationChanged();
    }

    public void draw(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, CategoryAxis categoryAxis, ValueAxis valueAxis) {
        double d;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(categoryPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(categoryPlot.getRangeAxisLocation(), plotOrientation);
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        int n = categoryDataset.getColumnIndex(this.getCategory());
        int n2 = categoryDataset.getColumnCount();
        double d2 = categoryAxis.getCategoryMiddle(n, n2, rectangle2D, rectangleEdge);
        double d3 = valueAxis.valueToJava2D(this.getValue(), rectangle2D, rectangleEdge2);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d = d2;
            d2 = d3;
            d3 = d;
        }
        d = d2 + Math.cos(this.angle) * this.baseRadius;
        double d4 = d3 + Math.sin(this.angle) * this.baseRadius;
        double d5 = d2 + Math.cos(this.angle) * this.tipRadius;
        double d6 = d3 + Math.sin(this.angle) * this.tipRadius;
        double d7 = d5 + Math.cos(this.angle) * this.arrowLength;
        double d8 = d6 + Math.sin(this.angle) * this.arrowLength;
        double d9 = d7 + Math.cos(this.angle + 1.5707963267948966) * this.arrowWidth;
        double d10 = d8 + Math.sin(this.angle + 1.5707963267948966) * this.arrowWidth;
        double d11 = d7 - Math.cos(this.angle + 1.5707963267948966) * this.arrowWidth;
        double d12 = d8 - Math.sin(this.angle + 1.5707963267948966) * this.arrowWidth;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)d5, (float)d6);
        generalPath.lineTo((float)d9, (float)d10);
        generalPath.lineTo((float)d11, (float)d12);
        generalPath.closePath();
        graphics2D.setStroke(this.arrowStroke);
        graphics2D.setPaint(this.arrowPaint);
        Line2D.Double double_ = new Line2D.Double(d, d4, d7, d8);
        graphics2D.draw(double_);
        graphics2D.fill(generalPath);
        graphics2D.setFont(this.getFont());
        graphics2D.setPaint(this.getPaint());
        double d13 = d2 + Math.cos(this.angle) * (this.baseRadius + this.labelOffset);
        double d14 = d3 + Math.sin(this.angle) * (this.baseRadius + this.labelOffset);
        TextUtilities.drawAlignedString(this.getText(), graphics2D, (float)d13, (float)d14, this.getTextAnchor());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CategoryPointerAnnotation)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        CategoryPointerAnnotation categoryPointerAnnotation = (CategoryPointerAnnotation)object;
        if (this.angle != categoryPointerAnnotation.angle) {
            return false;
        }
        if (this.tipRadius != categoryPointerAnnotation.tipRadius) {
            return false;
        }
        if (this.baseRadius != categoryPointerAnnotation.baseRadius) {
            return false;
        }
        if (this.arrowLength != categoryPointerAnnotation.arrowLength) {
            return false;
        }
        if (this.arrowWidth != categoryPointerAnnotation.arrowWidth) {
            return false;
        }
        if (!this.arrowPaint.equals(categoryPointerAnnotation.arrowPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.arrowStroke, categoryPointerAnnotation.arrowStroke)) {
            return false;
        }
        return this.labelOffset == categoryPointerAnnotation.labelOffset;
    }

    public int hashCode() {
        int n = 193;
        long l = Double.doubleToLongBits(this.angle);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.tipRadius);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.baseRadius);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.arrowLength);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.arrowWidth);
        n = 37 * n + (int)(l ^ l >>> 32);
        n = 37 * n + HashUtilities.hashCodeForPaint(this.arrowPaint);
        n = 37 * n + this.arrowStroke.hashCode();
        l = Double.doubleToLongBits(this.labelOffset);
        n = 37 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.arrowPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.arrowStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.arrowPaint = SerialUtilities.readPaint(objectInputStream);
        this.arrowStroke = SerialUtilities.readStroke(objectInputStream);
    }
}

