/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart;

import ai.org.jfree.chart.ChartTheme;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.annotations.XYAnnotation;
import ai.org.jfree.chart.annotations.XYTextAnnotation;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.PeriodAxis;
import ai.org.jfree.chart.axis.PeriodAxisLabelInfo;
import ai.org.jfree.chart.axis.SubCategoryAxis;
import ai.org.jfree.chart.axis.SymbolAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.block.Block;
import ai.org.jfree.chart.block.BlockContainer;
import ai.org.jfree.chart.block.LabelBlock;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.CombinedDomainCategoryPlot;
import ai.org.jfree.chart.plot.CombinedDomainXYPlot;
import ai.org.jfree.chart.plot.CombinedRangeCategoryPlot;
import ai.org.jfree.chart.plot.CombinedRangeXYPlot;
import ai.org.jfree.chart.plot.DefaultDrawingSupplier;
import ai.org.jfree.chart.plot.DrawingSupplier;
import ai.org.jfree.chart.plot.FastScatterPlot;
import ai.org.jfree.chart.plot.MeterPlot;
import ai.org.jfree.chart.plot.MultiplePiePlot;
import ai.org.jfree.chart.plot.PieLabelLinkStyle;
import ai.org.jfree.chart.plot.PiePlot;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PolarPlot;
import ai.org.jfree.chart.plot.SpiderWebPlot;
import ai.org.jfree.chart.plot.ThermometerPlot;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.AbstractRenderer;
import ai.org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import ai.org.jfree.chart.renderer.category.BarPainter;
import ai.org.jfree.chart.renderer.category.BarRenderer;
import ai.org.jfree.chart.renderer.category.BarRenderer3D;
import ai.org.jfree.chart.renderer.category.CategoryItemRenderer;
import ai.org.jfree.chart.renderer.category.GradientBarPainter;
import ai.org.jfree.chart.renderer.category.LineRenderer3D;
import ai.org.jfree.chart.renderer.category.MinMaxCategoryRenderer;
import ai.org.jfree.chart.renderer.category.StatisticalBarRenderer;
import ai.org.jfree.chart.renderer.xy.GradientXYBarPainter;
import ai.org.jfree.chart.renderer.xy.XYBarPainter;
import ai.org.jfree.chart.renderer.xy.XYBarRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.title.CompositeTitle;
import ai.org.jfree.chart.title.LegendTitle;
import ai.org.jfree.chart.title.PaintScaleLegend;
import ai.org.jfree.chart.title.TextTitle;
import ai.org.jfree.chart.title.Title;
import ai.org.jfree.chart.util.DefaultShadowGenerator;
import ai.org.jfree.chart.util.ShadowGenerator;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;

public class StandardChartTheme
implements ChartTheme,
Cloneable,
PublicCloneable,
Serializable {
    private String name;
    private Font extraLargeFont;
    private Font largeFont;
    private Font regularFont;
    private Font smallFont;
    private transient Paint titlePaint;
    private transient Paint subtitlePaint;
    private transient Paint chartBackgroundPaint;
    private transient Paint legendBackgroundPaint;
    private transient Paint legendItemPaint;
    private DrawingSupplier drawingSupplier;
    private transient Paint plotBackgroundPaint;
    private transient Paint plotOutlinePaint;
    private PieLabelLinkStyle labelLinkStyle;
    private transient Paint labelLinkPaint;
    private transient Paint domainGridlinePaint;
    private transient Paint rangeGridlinePaint;
    private transient Paint baselinePaint;
    private transient Paint crosshairPaint;
    private RectangleInsets axisOffset;
    private transient Paint axisLabelPaint;
    private transient Paint tickLabelPaint;
    private transient Paint itemLabelPaint;
    private boolean shadowVisible;
    private transient Paint shadowPaint;
    private BarPainter barPainter;
    private XYBarPainter xyBarPainter;
    private transient Paint thermometerPaint;
    private transient Paint wallPaint;
    private transient Paint errorIndicatorPaint;
    private transient Paint gridBandPaint = SymbolAxis.DEFAULT_GRID_BAND_PAINT;
    private transient Paint gridBandAlternatePaint = SymbolAxis.DEFAULT_GRID_BAND_ALTERNATE_PAINT;
    private ShadowGenerator shadowGenerator;

    public static ChartTheme createJFreeTheme() {
        return new StandardChartTheme("JFree");
    }

    public static ChartTheme createDarknessTheme() {
        StandardChartTheme standardChartTheme = new StandardChartTheme("Darkness");
        standardChartTheme.titlePaint = Color.white;
        standardChartTheme.subtitlePaint = Color.white;
        standardChartTheme.legendBackgroundPaint = Color.black;
        standardChartTheme.legendItemPaint = Color.white;
        standardChartTheme.chartBackgroundPaint = Color.black;
        standardChartTheme.plotBackgroundPaint = Color.black;
        standardChartTheme.plotOutlinePaint = Color.yellow;
        standardChartTheme.baselinePaint = Color.white;
        standardChartTheme.crosshairPaint = Color.red;
        standardChartTheme.labelLinkPaint = Color.lightGray;
        standardChartTheme.tickLabelPaint = Color.white;
        standardChartTheme.axisLabelPaint = Color.white;
        standardChartTheme.shadowPaint = Color.darkGray;
        standardChartTheme.itemLabelPaint = Color.white;
        standardChartTheme.drawingSupplier = new DefaultDrawingSupplier(new Paint[]{Color.decode("0xFFFF00"), Color.decode("0x0036CC"), Color.decode("0xFF0000"), Color.decode("0xFFFF7F"), Color.decode("0x6681CC"), Color.decode("0xFF7F7F"), Color.decode("0xFFFFBF"), Color.decode("0x99A6CC"), Color.decode("0xFFBFBF"), Color.decode("0xA9A938"), Color.decode("0x2D4587")}, new Paint[]{Color.decode("0xFFFF00"), Color.decode("0x0036CC")}, new Stroke[]{new BasicStroke(2.0f)}, new Stroke[]{new BasicStroke(0.5f)}, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE);
        standardChartTheme.wallPaint = Color.darkGray;
        standardChartTheme.errorIndicatorPaint = Color.lightGray;
        standardChartTheme.gridBandPaint = new Color(255, 255, 255, 20);
        standardChartTheme.gridBandAlternatePaint = new Color(255, 255, 255, 40);
        standardChartTheme.shadowGenerator = null;
        return standardChartTheme;
    }

    public static ChartTheme createLegacyTheme() {
        StandardChartTheme standardChartTheme = new StandardChartTheme("Legacy"){

            public void apply(JFreeChart jFreeChart) {
            }
        };
        return standardChartTheme;
    }

    public StandardChartTheme(String string) {
        this(string, false);
    }

    public StandardChartTheme(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'name' argument.");
        }
        this.name = string;
        this.extraLargeFont = new Font("\ufffd\ufffd\ufffd\ufffd", 1, 20);
        this.largeFont = new Font("\ufffd\ufffd\ufffd\ufffd", 1, 14);
        this.regularFont = new Font("\ufffd\ufffd\ufffd\ufffd", 0, 12);
        this.smallFont = new Font("\ufffd\ufffd\ufffd\ufffd", 0, 10);
        this.titlePaint = Color.black;
        this.subtitlePaint = Color.black;
        this.legendBackgroundPaint = Color.white;
        this.legendItemPaint = Color.darkGray;
        this.chartBackgroundPaint = Color.white;
        this.drawingSupplier = new DefaultDrawingSupplier();
        this.plotBackgroundPaint = Color.lightGray;
        this.plotOutlinePaint = Color.black;
        this.labelLinkPaint = Color.black;
        this.labelLinkStyle = PieLabelLinkStyle.CUBIC_CURVE;
        this.axisOffset = new RectangleInsets(4.0, 4.0, 4.0, 4.0);
        this.domainGridlinePaint = Color.white;
        this.rangeGridlinePaint = Color.white;
        this.baselinePaint = Color.black;
        this.crosshairPaint = Color.blue;
        this.axisLabelPaint = Color.darkGray;
        this.tickLabelPaint = Color.darkGray;
        this.barPainter = new GradientBarPainter();
        this.xyBarPainter = new GradientXYBarPainter();
        this.shadowVisible = false;
        this.shadowPaint = Color.gray;
        this.itemLabelPaint = Color.black;
        this.thermometerPaint = Color.white;
        this.wallPaint = BarRenderer3D.DEFAULT_WALL_PAINT;
        this.errorIndicatorPaint = Color.black;
        this.shadowGenerator = bl ? new DefaultShadowGenerator() : null;
    }

    public Font getExtraLargeFont() {
        return this.extraLargeFont;
    }

    public void setExtraLargeFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.extraLargeFont = font;
    }

    public Font getLargeFont() {
        return this.largeFont;
    }

    public void setLargeFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.largeFont = font;
    }

    public Font getRegularFont() {
        return this.regularFont;
    }

    public void setRegularFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.regularFont = font;
    }

    public Font getSmallFont() {
        return this.smallFont;
    }

    public void setSmallFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.smallFont = font;
    }

    public Paint getTitlePaint() {
        return this.titlePaint;
    }

    public void setTitlePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.titlePaint = paint;
    }

    public Paint getSubtitlePaint() {
        return this.subtitlePaint;
    }

    public void setSubtitlePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.subtitlePaint = paint;
    }

    public Paint getChartBackgroundPaint() {
        return this.chartBackgroundPaint;
    }

    public void setChartBackgroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.chartBackgroundPaint = paint;
    }

    public Paint getLegendBackgroundPaint() {
        return this.legendBackgroundPaint;
    }

    public void setLegendBackgroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.legendBackgroundPaint = paint;
    }

    public Paint getLegendItemPaint() {
        return this.legendItemPaint;
    }

    public void setLegendItemPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.legendItemPaint = paint;
    }

    public Paint getPlotBackgroundPaint() {
        return this.plotBackgroundPaint;
    }

    public void setPlotBackgroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.plotBackgroundPaint = paint;
    }

    public Paint getPlotOutlinePaint() {
        return this.plotOutlinePaint;
    }

    public void setPlotOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.plotOutlinePaint = paint;
    }

    public PieLabelLinkStyle getLabelLinkStyle() {
        return this.labelLinkStyle;
    }

    public void setLabelLinkStyle(PieLabelLinkStyle pieLabelLinkStyle) {
        if (pieLabelLinkStyle == null) {
            throw new IllegalArgumentException("Null 'style' argument.");
        }
        this.labelLinkStyle = pieLabelLinkStyle;
    }

    public Paint getLabelLinkPaint() {
        return this.labelLinkPaint;
    }

    public void setLabelLinkPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelLinkPaint = paint;
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainGridlinePaint = paint;
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeGridlinePaint = paint;
    }

    public Paint getBaselinePaint() {
        return this.baselinePaint;
    }

    public void setBaselinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baselinePaint = paint;
    }

    public Paint getCrosshairPaint() {
        return this.crosshairPaint;
    }

    public void setCrosshairPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.crosshairPaint = paint;
    }

    public RectangleInsets getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(RectangleInsets rectangleInsets) {
        if (rectangleInsets == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.axisOffset = rectangleInsets;
    }

    public Paint getAxisLabelPaint() {
        return this.axisLabelPaint;
    }

    public void setAxisLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.axisLabelPaint = paint;
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.tickLabelPaint = paint;
    }

    public Paint getItemLabelPaint() {
        return this.itemLabelPaint;
    }

    public void setItemLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.itemLabelPaint = paint;
    }

    public boolean isShadowVisible() {
        return this.shadowVisible;
    }

    public void setShadowVisible(boolean bl) {
        this.shadowVisible = bl;
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.shadowPaint = paint;
    }

    public BarPainter getBarPainter() {
        return this.barPainter;
    }

    public void setBarPainter(BarPainter barPainter) {
        if (barPainter == null) {
            throw new IllegalArgumentException("Null 'painter' argument.");
        }
        this.barPainter = barPainter;
    }

    public XYBarPainter getXYBarPainter() {
        return this.xyBarPainter;
    }

    public void setXYBarPainter(XYBarPainter xYBarPainter) {
        if (xYBarPainter == null) {
            throw new IllegalArgumentException("Null 'painter' argument.");
        }
        this.xyBarPainter = xYBarPainter;
    }

    public Paint getThermometerPaint() {
        return this.thermometerPaint;
    }

    public void setThermometerPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.thermometerPaint = paint;
    }

    public Paint getWallPaint() {
        return this.wallPaint;
    }

    public void setWallPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.wallPaint = paint;
    }

    public Paint getErrorIndicatorPaint() {
        return this.errorIndicatorPaint;
    }

    public void setErrorIndicatorPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.errorIndicatorPaint = paint;
    }

    public Paint getGridBandPaint() {
        return this.gridBandPaint;
    }

    public void setGridBandPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.gridBandPaint = paint;
    }

    public Paint getGridBandAlternatePaint() {
        return this.gridBandAlternatePaint;
    }

    public void setGridBandAlternatePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.gridBandAlternatePaint = paint;
    }

    public String getName() {
        return this.name;
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        if (this.drawingSupplier instanceof PublicCloneable) {
            PublicCloneable publicCloneable = (PublicCloneable)((Object)this.drawingSupplier);
            try {
                drawingSupplier = (DrawingSupplier)publicCloneable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        return drawingSupplier;
    }

    public void setDrawingSupplier(DrawingSupplier drawingSupplier) {
        if (drawingSupplier == null) {
            throw new IllegalArgumentException("Null 'supplier' argument.");
        }
        this.drawingSupplier = drawingSupplier;
    }

    public void apply(JFreeChart jFreeChart) {
        if (jFreeChart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        TextTitle textTitle = jFreeChart.getTitle();
        if (textTitle != null) {
            textTitle.setFont(this.extraLargeFont);
            textTitle.setPaint(this.titlePaint);
        }
        int n = jFreeChart.getSubtitleCount();
        for (int i = 0; i < n; ++i) {
            this.applyToTitle(jFreeChart.getSubtitle(i));
        }
        jFreeChart.setBackgroundPaint(this.chartBackgroundPaint);
        Plot plot = jFreeChart.getPlot();
        if (plot != null) {
            this.applyToPlot(plot);
        }
    }

    protected void applyToTitle(Title title) {
        if (title instanceof TextTitle) {
            TextTitle textTitle = (TextTitle)title;
            textTitle.setFont(this.largeFont);
            textTitle.setPaint(this.subtitlePaint);
        } else if (title instanceof LegendTitle) {
            LegendTitle legendTitle = (LegendTitle)title;
            if (legendTitle.getBackgroundPaint() != null) {
                legendTitle.setBackgroundPaint(this.legendBackgroundPaint);
            }
            legendTitle.setItemFont(this.regularFont);
            legendTitle.setItemPaint(this.legendItemPaint);
            if (legendTitle.getWrapper() != null) {
                this.applyToBlockContainer(legendTitle.getWrapper());
            }
        } else if (title instanceof PaintScaleLegend) {
            PaintScaleLegend paintScaleLegend = (PaintScaleLegend)title;
            paintScaleLegend.setBackgroundPaint(this.legendBackgroundPaint);
            ValueAxis valueAxis = paintScaleLegend.getAxis();
            if (valueAxis != null) {
                this.applyToValueAxis(valueAxis);
            }
        } else if (title instanceof CompositeTitle) {
            CompositeTitle compositeTitle = (CompositeTitle)title;
            BlockContainer blockContainer = compositeTitle.getContainer();
            List list = blockContainer.getBlocks();
            for (Block block : list) {
                if (!(block instanceof Title)) continue;
                this.applyToTitle((Title)block);
            }
        }
    }

    protected void applyToBlockContainer(BlockContainer blockContainer) {
        for (Block block : blockContainer.getBlocks()) {
            this.applyToBlock(block);
        }
    }

    protected void applyToBlock(Block block) {
        if (block instanceof Title) {
            this.applyToTitle((Title)block);
        } else if (block instanceof LabelBlock) {
            LabelBlock labelBlock = (LabelBlock)block;
            labelBlock.setFont(this.regularFont);
            labelBlock.setPaint(this.legendItemPaint);
        }
    }

    protected void applyToPlot(Plot plot) {
        if (plot == null) {
            throw new IllegalArgumentException("Null 'plot' argument.");
        }
        if (plot.getDrawingSupplier() != null) {
            plot.setDrawingSupplier(this.getDrawingSupplier());
        }
        if (plot.getBackgroundPaint() != null) {
            plot.setBackgroundPaint(this.plotBackgroundPaint);
        }
        plot.setOutlinePaint(this.plotOutlinePaint);
        if (plot instanceof PiePlot) {
            this.applyToPiePlot((PiePlot)plot);
        } else if (plot instanceof MultiplePiePlot) {
            this.applyToMultiplePiePlot((MultiplePiePlot)plot);
        } else if (plot instanceof CategoryPlot) {
            this.applyToCategoryPlot((CategoryPlot)plot);
        } else if (plot instanceof XYPlot) {
            this.applyToXYPlot((XYPlot)plot);
        } else if (plot instanceof FastScatterPlot) {
            this.applyToFastScatterPlot((FastScatterPlot)plot);
        } else if (plot instanceof MeterPlot) {
            this.applyToMeterPlot((MeterPlot)plot);
        } else if (plot instanceof ThermometerPlot) {
            this.applyToThermometerPlot((ThermometerPlot)plot);
        } else if (plot instanceof SpiderWebPlot) {
            this.applyToSpiderWebPlot((SpiderWebPlot)plot);
        } else if (plot instanceof PolarPlot) {
            this.applyToPolarPlot((PolarPlot)plot);
        }
    }

    protected void applyToPiePlot(PiePlot piePlot) {
        piePlot.setLabelLinkPaint(this.labelLinkPaint);
        piePlot.setLabelLinkStyle(this.labelLinkStyle);
        piePlot.setLabelFont(this.regularFont);
        piePlot.setShadowGenerator(this.shadowGenerator);
        if (piePlot.getAutoPopulateSectionPaint()) {
            piePlot.clearSectionPaints(false);
        }
        if (piePlot.getAutoPopulateSectionOutlinePaint()) {
            piePlot.clearSectionOutlinePaints(false);
        }
        if (piePlot.getAutoPopulateSectionOutlineStroke()) {
            piePlot.clearSectionOutlineStrokes(false);
        }
    }

    protected void applyToMultiplePiePlot(MultiplePiePlot multiplePiePlot) {
        this.apply(multiplePiePlot.getPieChart());
    }

    protected void applyToCategoryPlot(CategoryPlot categoryPlot) {
        int n;
        int n2;
        categoryPlot.setAxisOffset(this.axisOffset);
        categoryPlot.setDomainGridlinePaint(this.domainGridlinePaint);
        categoryPlot.setRangeGridlinePaint(this.rangeGridlinePaint);
        categoryPlot.setRangeZeroBaselinePaint(this.baselinePaint);
        categoryPlot.setShadowGenerator(this.shadowGenerator);
        int n3 = categoryPlot.getDomainAxisCount();
        for (n2 = 0; n2 < n3; ++n2) {
            CategoryAxis categoryAxis = categoryPlot.getDomainAxis(n2);
            if (categoryAxis == null) continue;
            this.applyToCategoryAxis(categoryAxis);
        }
        n2 = categoryPlot.getRangeAxisCount();
        for (n = 0; n < n2; ++n) {
            ValueAxis valueAxis = categoryPlot.getRangeAxis(n);
            if (valueAxis == null) continue;
            this.applyToValueAxis(valueAxis);
        }
        n = categoryPlot.getRendererCount();
        for (int i = 0; i < n; ++i) {
            CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer(i);
            if (categoryItemRenderer == null) continue;
            this.applyToCategoryItemRenderer(categoryItemRenderer);
        }
        if (categoryPlot instanceof CombinedDomainCategoryPlot) {
            CombinedDomainCategoryPlot combinedDomainCategoryPlot = (CombinedDomainCategoryPlot)categoryPlot;
            for (CategoryPlot categoryPlot2 : combinedDomainCategoryPlot.getSubplots()) {
                if (categoryPlot2 == null) continue;
                this.applyToPlot(categoryPlot2);
            }
        }
        if (categoryPlot instanceof CombinedRangeCategoryPlot) {
            CombinedRangeCategoryPlot combinedRangeCategoryPlot = (CombinedRangeCategoryPlot)categoryPlot;
            for (CategoryPlot categoryPlot2 : combinedRangeCategoryPlot.getSubplots()) {
                if (categoryPlot2 == null) continue;
                this.applyToPlot(categoryPlot2);
            }
        }
    }

    protected void applyToXYPlot(XYPlot xYPlot) {
        Object object2;
        int n;
        int n2;
        xYPlot.setAxisOffset(this.axisOffset);
        xYPlot.setDomainZeroBaselinePaint(this.baselinePaint);
        xYPlot.setRangeZeroBaselinePaint(this.baselinePaint);
        xYPlot.setDomainGridlinePaint(this.domainGridlinePaint);
        xYPlot.setRangeGridlinePaint(this.rangeGridlinePaint);
        xYPlot.setDomainCrosshairPaint(this.crosshairPaint);
        xYPlot.setRangeCrosshairPaint(this.crosshairPaint);
        xYPlot.setShadowGenerator(this.shadowGenerator);
        int n3 = xYPlot.getDomainAxisCount();
        for (n2 = 0; n2 < n3; ++n2) {
            ValueAxis valueAxis = xYPlot.getDomainAxis(n2);
            if (valueAxis == null) continue;
            this.applyToValueAxis(valueAxis);
        }
        n2 = xYPlot.getRangeAxisCount();
        for (n = 0; n < n2; ++n) {
            ValueAxis valueAxis = xYPlot.getRangeAxis(n);
            if (valueAxis == null) continue;
            this.applyToValueAxis(valueAxis);
        }
        n = xYPlot.getRendererCount();
        for (int i = 0; i < n; ++i) {
            object2 = xYPlot.getRenderer(i);
            if (object2 == null) continue;
            this.applyToXYItemRenderer((XYItemRenderer)object2);
        }
        for (Object object2 : xYPlot.getAnnotations()) {
            this.applyToXYAnnotation((XYAnnotation)object2);
        }
        if (xYPlot instanceof CombinedDomainXYPlot) {
            object2 = (CombinedDomainXYPlot)xYPlot;
            for (XYPlot xYPlot2 : ((CombinedDomainXYPlot)object2).getSubplots()) {
                if (xYPlot2 == null) continue;
                this.applyToPlot(xYPlot2);
            }
        }
        if (xYPlot instanceof CombinedRangeXYPlot) {
            object2 = (CombinedRangeXYPlot)xYPlot;
            for (XYPlot xYPlot2 : ((CombinedRangeXYPlot)object2).getSubplots()) {
                if (xYPlot2 == null) continue;
                this.applyToPlot(xYPlot2);
            }
        }
    }

    protected void applyToFastScatterPlot(FastScatterPlot fastScatterPlot) {
        ValueAxis valueAxis;
        fastScatterPlot.setDomainGridlinePaint(this.domainGridlinePaint);
        fastScatterPlot.setRangeGridlinePaint(this.rangeGridlinePaint);
        ValueAxis valueAxis2 = fastScatterPlot.getDomainAxis();
        if (valueAxis2 != null) {
            this.applyToValueAxis(valueAxis2);
        }
        if ((valueAxis = fastScatterPlot.getRangeAxis()) != null) {
            this.applyToValueAxis(valueAxis);
        }
    }

    protected void applyToPolarPlot(PolarPlot polarPlot) {
        polarPlot.setAngleLabelFont(this.regularFont);
        polarPlot.setAngleLabelPaint(this.tickLabelPaint);
        polarPlot.setAngleGridlinePaint(this.domainGridlinePaint);
        polarPlot.setRadiusGridlinePaint(this.rangeGridlinePaint);
        ValueAxis valueAxis = polarPlot.getAxis();
        if (valueAxis != null) {
            this.applyToValueAxis(valueAxis);
        }
    }

    protected void applyToSpiderWebPlot(SpiderWebPlot spiderWebPlot) {
        spiderWebPlot.setLabelFont(this.regularFont);
        spiderWebPlot.setLabelPaint(this.axisLabelPaint);
        spiderWebPlot.setAxisLinePaint(this.axisLabelPaint);
    }

    protected void applyToMeterPlot(MeterPlot meterPlot) {
        meterPlot.setDialBackgroundPaint(this.plotBackgroundPaint);
        meterPlot.setValueFont(this.largeFont);
        meterPlot.setValuePaint(this.axisLabelPaint);
        meterPlot.setDialOutlinePaint(this.plotOutlinePaint);
        meterPlot.setNeedlePaint(this.thermometerPaint);
        meterPlot.setTickLabelFont(this.regularFont);
        meterPlot.setTickLabelPaint(this.tickLabelPaint);
    }

    protected void applyToThermometerPlot(ThermometerPlot thermometerPlot) {
        thermometerPlot.setValueFont(this.largeFont);
        thermometerPlot.setThermometerPaint(this.thermometerPaint);
        ValueAxis valueAxis = thermometerPlot.getRangeAxis();
        if (valueAxis != null) {
            this.applyToValueAxis(valueAxis);
        }
    }

    protected void applyToCategoryAxis(CategoryAxis categoryAxis) {
        categoryAxis.setLabelFont(this.largeFont);
        categoryAxis.setLabelPaint(this.axisLabelPaint);
        categoryAxis.setTickLabelFont(this.regularFont);
        categoryAxis.setTickLabelPaint(this.tickLabelPaint);
        if (categoryAxis instanceof SubCategoryAxis) {
            SubCategoryAxis subCategoryAxis = (SubCategoryAxis)categoryAxis;
            subCategoryAxis.setSubLabelFont(this.regularFont);
            subCategoryAxis.setSubLabelPaint(this.tickLabelPaint);
        }
    }

    protected void applyToValueAxis(ValueAxis valueAxis) {
        valueAxis.setLabelFont(this.largeFont);
        valueAxis.setLabelPaint(this.axisLabelPaint);
        valueAxis.setTickLabelFont(this.regularFont);
        valueAxis.setTickLabelPaint(this.tickLabelPaint);
        if (valueAxis instanceof SymbolAxis) {
            this.applyToSymbolAxis((SymbolAxis)valueAxis);
        }
        if (valueAxis instanceof PeriodAxis) {
            this.applyToPeriodAxis((PeriodAxis)valueAxis);
        }
    }

    protected void applyToSymbolAxis(SymbolAxis symbolAxis) {
        symbolAxis.setGridBandPaint(this.gridBandPaint);
        symbolAxis.setGridBandAlternatePaint(this.gridBandAlternatePaint);
    }

    protected void applyToPeriodAxis(PeriodAxis periodAxis) {
        PeriodAxisLabelInfo[] periodAxisLabelInfoArray = periodAxis.getLabelInfo();
        for (int i = 0; i < periodAxisLabelInfoArray.length; ++i) {
            PeriodAxisLabelInfo periodAxisLabelInfo;
            PeriodAxisLabelInfo periodAxisLabelInfo2 = periodAxisLabelInfoArray[i];
            periodAxisLabelInfoArray[i] = periodAxisLabelInfo = new PeriodAxisLabelInfo(periodAxisLabelInfo2.getPeriodClass(), periodAxisLabelInfo2.getDateFormat(), periodAxisLabelInfo2.getPadding(), this.regularFont, this.tickLabelPaint, periodAxisLabelInfo2.getDrawDividers(), periodAxisLabelInfo2.getDividerStroke(), periodAxisLabelInfo2.getDividerPaint());
        }
        periodAxis.setLabelInfo(periodAxisLabelInfoArray);
    }

    protected void applyToAbstractRenderer(AbstractRenderer abstractRenderer) {
        if (abstractRenderer.getAutoPopulateSeriesPaint()) {
            abstractRenderer.clearSeriesPaints(false);
        }
        if (abstractRenderer.getAutoPopulateSeriesStroke()) {
            abstractRenderer.clearSeriesStrokes(false);
        }
    }

    protected void applyToCategoryItemRenderer(CategoryItemRenderer categoryItemRenderer) {
        AbstractCategoryItemRenderer abstractCategoryItemRenderer;
        if (categoryItemRenderer == null) {
            throw new IllegalArgumentException("Null 'renderer' argument.");
        }
        if (categoryItemRenderer instanceof AbstractRenderer) {
            this.applyToAbstractRenderer((AbstractRenderer)((Object)categoryItemRenderer));
        }
        categoryItemRenderer.setBaseItemLabelFont(this.regularFont);
        categoryItemRenderer.setBaseItemLabelPaint(this.itemLabelPaint);
        if (categoryItemRenderer instanceof BarRenderer) {
            abstractCategoryItemRenderer = (BarRenderer)categoryItemRenderer;
            ((BarRenderer)abstractCategoryItemRenderer).setBarPainter(this.barPainter);
            ((BarRenderer)abstractCategoryItemRenderer).setShadowVisible(this.shadowVisible);
            ((BarRenderer)abstractCategoryItemRenderer).setShadowPaint(this.shadowPaint);
        }
        if (categoryItemRenderer instanceof BarRenderer3D) {
            abstractCategoryItemRenderer = (BarRenderer3D)categoryItemRenderer;
            ((BarRenderer3D)abstractCategoryItemRenderer).setWallPaint(this.wallPaint);
        }
        if (categoryItemRenderer instanceof LineRenderer3D) {
            abstractCategoryItemRenderer = (LineRenderer3D)categoryItemRenderer;
            ((LineRenderer3D)abstractCategoryItemRenderer).setWallPaint(this.wallPaint);
        }
        if (categoryItemRenderer instanceof StatisticalBarRenderer) {
            abstractCategoryItemRenderer = (StatisticalBarRenderer)categoryItemRenderer;
            ((StatisticalBarRenderer)abstractCategoryItemRenderer).setErrorIndicatorPaint(this.errorIndicatorPaint);
        }
        if (categoryItemRenderer instanceof MinMaxCategoryRenderer) {
            abstractCategoryItemRenderer = (MinMaxCategoryRenderer)categoryItemRenderer;
            ((MinMaxCategoryRenderer)abstractCategoryItemRenderer).setGroupPaint(this.errorIndicatorPaint);
        }
    }

    protected void applyToXYItemRenderer(XYItemRenderer xYItemRenderer) {
        if (xYItemRenderer == null) {
            throw new IllegalArgumentException("Null 'renderer' argument.");
        }
        if (xYItemRenderer instanceof AbstractRenderer) {
            this.applyToAbstractRenderer((AbstractRenderer)((Object)xYItemRenderer));
        }
        xYItemRenderer.setBaseItemLabelFont(this.regularFont);
        xYItemRenderer.setBaseItemLabelPaint(this.itemLabelPaint);
        if (xYItemRenderer instanceof XYBarRenderer) {
            XYBarRenderer xYBarRenderer = (XYBarRenderer)xYItemRenderer;
            xYBarRenderer.setBarPainter(this.xyBarPainter);
            xYBarRenderer.setShadowVisible(this.shadowVisible);
        }
    }

    protected void applyToXYAnnotation(XYAnnotation xYAnnotation) {
        if (xYAnnotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        if (xYAnnotation instanceof XYTextAnnotation) {
            XYTextAnnotation xYTextAnnotation = (XYTextAnnotation)xYAnnotation;
            xYTextAnnotation.setFont(this.smallFont);
            xYTextAnnotation.setPaint(this.itemLabelPaint);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardChartTheme)) {
            return false;
        }
        StandardChartTheme standardChartTheme = (StandardChartTheme)object;
        if (!this.name.equals(standardChartTheme.name)) {
            return false;
        }
        if (!this.extraLargeFont.equals(standardChartTheme.extraLargeFont)) {
            return false;
        }
        if (!this.largeFont.equals(standardChartTheme.largeFont)) {
            return false;
        }
        if (!this.regularFont.equals(standardChartTheme.regularFont)) {
            return false;
        }
        if (!this.smallFont.equals(standardChartTheme.smallFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.titlePaint, standardChartTheme.titlePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.subtitlePaint, standardChartTheme.subtitlePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.chartBackgroundPaint, standardChartTheme.chartBackgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.legendBackgroundPaint, standardChartTheme.legendBackgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.legendItemPaint, standardChartTheme.legendItemPaint)) {
            return false;
        }
        if (!this.drawingSupplier.equals(standardChartTheme.drawingSupplier)) {
            return false;
        }
        if (!PaintUtilities.equal(this.plotBackgroundPaint, standardChartTheme.plotBackgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.plotOutlinePaint, standardChartTheme.plotOutlinePaint)) {
            return false;
        }
        if (!this.labelLinkStyle.equals(standardChartTheme.labelLinkStyle)) {
            return false;
        }
        if (!PaintUtilities.equal(this.labelLinkPaint, standardChartTheme.labelLinkPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainGridlinePaint, standardChartTheme.domainGridlinePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeGridlinePaint, standardChartTheme.rangeGridlinePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.crosshairPaint, standardChartTheme.crosshairPaint)) {
            return false;
        }
        if (!this.axisOffset.equals(standardChartTheme.axisOffset)) {
            return false;
        }
        if (!PaintUtilities.equal(this.axisLabelPaint, standardChartTheme.axisLabelPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.tickLabelPaint, standardChartTheme.tickLabelPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.itemLabelPaint, standardChartTheme.itemLabelPaint)) {
            return false;
        }
        if (this.shadowVisible != standardChartTheme.shadowVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.shadowPaint, standardChartTheme.shadowPaint)) {
            return false;
        }
        if (!this.barPainter.equals(standardChartTheme.barPainter)) {
            return false;
        }
        if (!this.xyBarPainter.equals(standardChartTheme.xyBarPainter)) {
            return false;
        }
        if (!PaintUtilities.equal(this.thermometerPaint, standardChartTheme.thermometerPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.wallPaint, standardChartTheme.wallPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.errorIndicatorPaint, standardChartTheme.errorIndicatorPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.gridBandPaint, standardChartTheme.gridBandPaint)) {
            return false;
        }
        return PaintUtilities.equal(this.gridBandAlternatePaint, standardChartTheme.gridBandAlternatePaint);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.titlePaint, objectOutputStream);
        SerialUtilities.writePaint(this.subtitlePaint, objectOutputStream);
        SerialUtilities.writePaint(this.chartBackgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.legendBackgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.legendItemPaint, objectOutputStream);
        SerialUtilities.writePaint(this.plotBackgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.plotOutlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.labelLinkPaint, objectOutputStream);
        SerialUtilities.writePaint(this.baselinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.domainGridlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.rangeGridlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.crosshairPaint, objectOutputStream);
        SerialUtilities.writePaint(this.axisLabelPaint, objectOutputStream);
        SerialUtilities.writePaint(this.tickLabelPaint, objectOutputStream);
        SerialUtilities.writePaint(this.itemLabelPaint, objectOutputStream);
        SerialUtilities.writePaint(this.shadowPaint, objectOutputStream);
        SerialUtilities.writePaint(this.thermometerPaint, objectOutputStream);
        SerialUtilities.writePaint(this.wallPaint, objectOutputStream);
        SerialUtilities.writePaint(this.errorIndicatorPaint, objectOutputStream);
        SerialUtilities.writePaint(this.gridBandPaint, objectOutputStream);
        SerialUtilities.writePaint(this.gridBandAlternatePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.titlePaint = SerialUtilities.readPaint(objectInputStream);
        this.subtitlePaint = SerialUtilities.readPaint(objectInputStream);
        this.chartBackgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.legendBackgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.legendItemPaint = SerialUtilities.readPaint(objectInputStream);
        this.plotBackgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.plotOutlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.labelLinkPaint = SerialUtilities.readPaint(objectInputStream);
        this.baselinePaint = SerialUtilities.readPaint(objectInputStream);
        this.domainGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.crosshairPaint = SerialUtilities.readPaint(objectInputStream);
        this.axisLabelPaint = SerialUtilities.readPaint(objectInputStream);
        this.tickLabelPaint = SerialUtilities.readPaint(objectInputStream);
        this.itemLabelPaint = SerialUtilities.readPaint(objectInputStream);
        this.shadowPaint = SerialUtilities.readPaint(objectInputStream);
        this.thermometerPaint = SerialUtilities.readPaint(objectInputStream);
        this.wallPaint = SerialUtilities.readPaint(objectInputStream);
        this.errorIndicatorPaint = SerialUtilities.readPaint(objectInputStream);
        this.gridBandPaint = SerialUtilities.readPaint(objectInputStream);
        this.gridBandAlternatePaint = SerialUtilities.readPaint(objectInputStream);
    }
}

