/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart;

import ai.org.jfree.chart.ChartPanel;
import ai.org.jfree.chart.ChartRenderingInfo;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.plot.PiePlot;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.Zoomable;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.io.Serializable;

class MouseWheelHandler
implements MouseWheelListener,
Serializable {
    private ChartPanel chartPanel;
    double zoomFactor;

    public MouseWheelHandler(ChartPanel chartPanel) {
        this.chartPanel = chartPanel;
        this.zoomFactor = 0.1;
        this.chartPanel.addMouseWheelListener(this);
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double d) {
        this.zoomFactor = d;
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        JFreeChart jFreeChart = this.chartPanel.getChart();
        if (jFreeChart == null) {
            return;
        }
        Plot plot = jFreeChart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable zoomable = (Zoomable)((Object)plot);
            this.handleZoomable(zoomable, mouseWheelEvent);
        } else if (plot instanceof PiePlot) {
            PiePlot piePlot = (PiePlot)plot;
            piePlot.handleMouseWheelRotation(mouseWheelEvent.getWheelRotation());
        }
    }

    private void handleZoomable(Zoomable zoomable, MouseWheelEvent mouseWheelEvent) {
        ChartRenderingInfo chartRenderingInfo = this.chartPanel.getChartRenderingInfo();
        PlotRenderingInfo plotRenderingInfo = chartRenderingInfo.getPlotInfo();
        Point2D point2D = this.chartPanel.translateScreenToJava2D(mouseWheelEvent.getPoint());
        if (!plotRenderingInfo.getDataArea().contains(point2D)) {
            return;
        }
        Plot plot = (Plot)((Object)zoomable);
        boolean bl = plot.isNotify();
        plot.setNotify(false);
        int n = mouseWheelEvent.getWheelRotation();
        double d = 1.0 + this.zoomFactor;
        if (n < 0) {
            d = 1.0 / d;
        }
        if (this.chartPanel.isDomainZoomable()) {
            zoomable.zoomDomainAxes(d, plotRenderingInfo, point2D, true);
        }
        if (this.chartPanel.isRangeZoomable()) {
            zoomable.zoomRangeAxes(d, plotRenderingInfo, point2D, true);
        }
        plot.setNotify(bl);
    }
}

