/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.beans.editors;

import ai.org.jfree.chart.ChartFactory;
import ai.org.jfree.chart.ChartPanel;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.data.general.DefaultPieDataset;
import ai.org.jfree.data.general.PieDataset;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class PieDatasetGUI
extends JPanel
implements TableModelListener {
    public PieDatasetGUI(DefaultPieDataset defaultPieDataset) {
        super(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        JTable jTable = new JTable();
        jTable.setModel(new MyPieDatasetTableModel(defaultPieDataset));
        jTable.getModel().addTableModelListener(this);
        this.add(new JScrollPane(jTable));
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        System.out.println(tableModelEvent.toString());
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("PieDataset Editor");
        JSplitPane jSplitPane = new JSplitPane();
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"A"), 1.0);
        defaultPieDataset.setValue((Comparable)((Object)"B"), 3.0);
        defaultPieDataset.setValue((Comparable)((Object)"C"), 3.0);
        defaultPieDataset.setValue((Comparable)((Object)"D"), 3.0);
        defaultPieDataset.setValue((Comparable)((Object)"E"), 3.0);
        defaultPieDataset.setValue((Comparable)((Object)"F"), 3.0);
        defaultPieDataset.setValue((Comparable)((Object)"G"), 3.0);
        defaultPieDataset.setValue((Comparable)((Object)"H"), 3.0);
        defaultPieDataset.setValue((Comparable)((Object)"I"), 3.0);
        defaultPieDataset.setValue((Comparable)((Object)"J"), 3.0);
        JFreeChart jFreeChart = ChartFactory.createPieChart("Pie Chart", (PieDataset)defaultPieDataset, true, true, false);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        PieDatasetGUI pieDatasetGUI = new PieDatasetGUI(defaultPieDataset);
        jSplitPane.add((Component)chartPanel, "top");
        jSplitPane.add((Component)pieDatasetGUI, "bottom");
        jFrame.getContentPane().add(jSplitPane);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class MyPieDatasetTableModel
    extends AbstractTableModel
    implements TableModel {
        private DefaultPieDataset dataset;
        private int editingRow;
        private Comparable newKey;
        private Number newValue;

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                if (object == null) {
                    throw new IllegalArgumentException("'aValue' is null.");
                }
                String string = object.toString();
                int n3 = this.dataset.getIndex((Comparable)((Object)string));
                Comparable comparable = this.dataset.getKey(n);
                if (n3 == n) {
                    return;
                }
                if (n3 >= 0) {
                    throw new IllegalArgumentException("Key already exists!");
                }
                Number number = this.dataset.getValue(n);
                this.dataset.insertValue(n, (Comparable)((Object)string), number);
                this.dataset.remove(comparable);
                this.fireTableCellUpdated(n, n2);
            } else if (n2 == 1) {
                Comparable comparable = this.dataset.getKey(n);
                Double d = Double.valueOf(object.toString());
                this.dataset.insertValue(n, comparable, d);
                this.fireTableCellUpdated(n, n2);
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public MyPieDatasetTableModel(DefaultPieDataset defaultPieDataset) {
            this.dataset = defaultPieDataset;
            this.editingRow = -1;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            int n = this.dataset.getItemCount();
            if (this.editingRow >= 0) {
                ++n;
            }
            return n;
        }

        public Object getValueAt(int n, int n2) {
            if (this.editingRow < 0 || n < this.editingRow) {
                if (n2 == 0) {
                    return this.dataset.getKey(n);
                }
                if (n2 == 1) {
                    return this.dataset.getValue(n);
                }
            } else if (n == this.editingRow) {
                if (n2 == 0) {
                    return this.newKey;
                }
                if (n2 == 1) {
                    return this.newValue;
                }
            } else {
                if (n2 == 0) {
                    return this.dataset.getKey(n - 1);
                }
                if (n2 == 1) {
                    return this.dataset.getValue(n - 1);
                }
            }
            return null;
        }
    }
}

