/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.beans.editors;

import ai.org.jfree.beans.editors.PaintEditorGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;

public class PaintEditor
extends PropertyEditorSupport
implements PropertyChangeListener {
    PaintEditorGUI customEditor = new PaintEditorGUI();

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.firePropertyChange();
    }

    public PaintEditor() {
        this.customEditor.addPropertyChangeListener(this);
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = this.customEditor.getPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            int n = (int)rectangle.getCenterY();
            int n2 = (int)rectangle.getMinX() + 2;
            Rectangle rectangle2 = new Rectangle(n2, n - 4, 8, 8);
            graphics2D.fill(rectangle2);
            graphics2D.setPaint(Color.black);
            graphics2D.draw(rectangle2);
        }
    }

    public Object getValue() {
        return this.customEditor.getPaint();
    }

    public void setValue(Object object) {
        this.customEditor.setPaint((Paint)object);
    }

    public String getJavaInitializationString() {
        Paint paint = (Paint)this.getValue();
        if (paint == null) {
            return "null";
        }
        if (paint instanceof Color) {
            Color color = (Color)paint;
            return "new java.awt.Color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha() + ")";
        }
        return "new java.awt.GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.blue);";
    }

    public Component getCustomEditor() {
        return this.customEditor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

