/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.beans;

import ai.org.jfree.beans.AbstractXYChart;
import ai.org.jfree.chart.ChartFactory;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import ai.org.jfree.data.time.Day;
import ai.org.jfree.data.time.RegularTimePeriod;
import ai.org.jfree.data.time.TimeSeries;
import ai.org.jfree.data.time.TimeSeriesCollection;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.ui.RectangleInsets;
import java.awt.Color;

public class JTimeSeriesChart
extends AbstractXYChart {
    protected JFreeChart createDefaultChart() {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)"Series 1"));
        RegularTimePeriod regularTimePeriod = new Day();
        double d = 100.0;
        for (int i = 0; i < 20; ++i) {
            timeSeries.add(regularTimePeriod, d);
            regularTimePeriod = ((RegularTimePeriod)regularTimePeriod).next();
            d *= 1.0 + Math.random() / 45.0;
        }
        timeSeriesCollection.addSeries(timeSeries);
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("JTimeSeriesChart - Title", "Date/Time", "Value", timeSeriesCollection, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        xYPlot.setAxisOffset(new RectangleInsets(4.0, 4.0, 4.0, 4.0));
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYPlot.getRenderer();
        xYLineAndShapeRenderer.setUseFillPaint(true);
        xYLineAndShapeRenderer.setBaseFillPaint(Color.white);
        return jFreeChart;
    }

    public XYDataset getDataset() {
        XYDataset xYDataset = null;
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            xYDataset = xYPlot.getDataset();
        }
        return xYDataset;
    }

    public void setDataset(XYDataset xYDataset) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            XYDataset xYDataset2 = xYPlot.getDataset();
            xYPlot.setDataset(xYDataset);
            this.firePropertyChange("dataset", xYDataset2, xYDataset);
        }
    }

    public boolean getShapesVisible() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot == null) {
            return false;
        }
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYPlot.getRenderer();
        if (xYLineAndShapeRenderer == null) {
            return false;
        }
        return xYLineAndShapeRenderer.getBaseShapesVisible();
    }

    public void setShapesVisible(boolean bl) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot == null) {
            return;
        }
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYPlot.getRenderer();
        if (xYLineAndShapeRenderer == null) {
            return;
        }
        boolean bl2 = xYLineAndShapeRenderer.getBaseShapesVisible();
        xYLineAndShapeRenderer.setBaseShapesVisible(bl);
        this.firePropertyChange("shapesVisible", bl2, bl);
    }
}

